/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.internaltrigger;

import com.oceanoptics.omnidriver.features.internaltrigger.InternalTriggerGUIProvider;
import com.oceanoptics.omnidriver.features.internaltrigger.TriggerSource;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;
import java.net.Socket;

public abstract class InternalTriggerImpl_Jaz
implements InternalTriggerGUIProvider {
    private static double countsToMicros = 12.0;
    private static final int INTERNAL_TRIGGER_MIN = 0;
    private static final int INTERNAL_TRIGGER_MAX = 0x15555555;
    private static final int INTERNAL_TRIGGER_STEP = 1;
    private Integer triggerPeriod = null;
    private TriggerSource triggerSource = null;
    protected byte[] in;
    protected byte[] out;
    protected String featurePath = "internaltrigger.InternalTriggerPanel";
    protected String panelPath = "com.oceanoptics.omnidriver.guisupport.features";
    private static String __extern__ = "__extern__\n<init>,()V\nsetInternalTriggerPeriodMicros,(I)V\ngetInternalTriggerPeriodMicros,()Ljava/lang/Integer;\ngetInternalTriggerPeriodMinimum,()I\ngetInternalTriggerPeriodMaximum,()I\ngetInternalTriggerPeriodIncrement,()I\nsetTriggerSource,(Lcom/oceanoptics/omnidriver/features/internaltrigger/TriggerSource;)V\ngetTriggerSource,()Lcom/oceanoptics/omnidriver/features/internaltrigger/TriggerSource;\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public void setInternalTriggerPeriodMicros(int micros) throws IOException {
        this.triggerPeriod = new Integer(micros);
    }

    public Integer getInternalTriggerPeriodMicros() {
        return this.triggerPeriod;
    }

    public int getInternalTriggerPeriodMinimum() {
        return 0;
    }

    public int getInternalTriggerPeriodMaximum() {
        return 0x15555555;
    }

    public int getInternalTriggerPeriodIncrement() {
        return 1;
    }

    public void setTriggerSource(TriggerSource source) throws IOException {
        this.triggerSource = source;
    }

    public TriggerSource getTriggerSource() {
        return this.triggerSource;
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }

    protected int setupSetPeriodMessage(int periodMicros) {
        for (int i = 0; i < this.out.length; ++i) {
            this.out[i] = 0;
        }
        int counts = (int)Math.rint((double)periodMicros * countsToMicros);
        this.out[0] = -57;
        this.out[1] = 98;
        this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)counts));
        this.out[3] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)counts));
        this.out[4] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)counts));
        this.out[5] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)counts));
        return 17;
    }

    protected int setupSetSourceMessage(TriggerSource source) {
        for (int i = 0; i < this.out.length; ++i) {
            this.out[i] = 0;
        }
        this.out[0] = -57;
        this.out[1] = 97;
        this.out[2] = 0;
        this.out[3] = (byte)source.getMode();
        return 17;
    }

    public static class Network
    extends InternalTriggerImpl_Jaz {
        private Socket socket;

        public Network(Socket sock, byte[] inputBuffer, byte[] outputBuffer) {
            this.socket = sock;
            this.in = inputBuffer;
            this.out = outputBuffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setInternalTriggerPeriodMicros(int delayMicros) throws IOException {
            super.setInternalTriggerPeriodMicros(delayMicros);
            byte[] byArray = this.out;
            synchronized (this.out) {
                int length = this.setupSetPeriodMessage(delayMicros);
                this.socket.getOutputStream().write(this.out, 0, length);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTriggerSource(TriggerSource source) throws IOException {
            super.setTriggerSource(source);
            byte[] byArray = this.out;
            synchronized (this.out) {
                int length = this.setupSetSourceMessage(source);
                this.socket.getOutputStream().write(this.out, 0, length);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }

    public static class USB
    extends InternalTriggerImpl_Jaz {
        private USBInterface usb;
        private static final short DATA_OUT = 1;
        private static final short LOW_SPEED_DATA_IN = 129;
        private static final short MAX_PACKET_SIZE = 512;
        private USBEndpointDescriptor dataOutEndPoint = new USBEndpointDescriptor(7, 5, 1, 2, 512, 0);
        private USBEndpointDescriptor lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 129, 2, 512, 0);

        public USB(USBInterface usbInt) {
            this.usb = usbInt;
            this.in = this.usb.getInputBuffer();
            this.out = this.usb.getOutputBuffer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setInternalTriggerPeriodMicros(int delayMicros) throws IOException {
            super.setInternalTriggerPeriodMicros(delayMicros);
            byte[] byArray = this.out;
            synchronized (this.out) {
                int length = this.setupSetPeriodMessage(delayMicros);
                this.usb.bulkOut(this.dataOutEndPoint, this.out, length);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTriggerSource(TriggerSource source) throws IOException {
            super.setTriggerSource(source);
            byte[] byArray = this.out;
            synchronized (this.out) {
                int length = this.setupSetSourceMessage(source);
                this.usb.bulkOut(this.dataOutEndPoint, this.out, length);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }
}

