/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.ls450functions;

import com.oceanoptics.omnidriver.features.USBFeature;
import com.oceanoptics.omnidriver.features.ls450functions.LS450_FunctionsGUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.plugin.LS450Coefficients;
import com.oceanoptics.omnidriver.plugin.SpectrometerPlugIn;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public abstract class LS450_FunctionsImpl
extends USBFeature
implements LS450_FunctionsGUIProvider {
    protected USBEndpointDescriptor dataOutEndPoint = null;
    protected USBEndpointDescriptor lowSpeedInEndPoint = null;
    private LS450Coefficients ls450Coefficients;
    private SpectrometerPlugIn plugin;
    protected String featurePath = "ls450functions.LS450_FunctionsPanel";
    protected String featurePath1 = "ls450functions.LS450CalibrationPanel";
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;Lcom/oceanoptics/omnidriver/plugin/SpectrometerPlugIn;)V\ngetLS450Coefficients,()Lcom/oceanoptics/omnidriver/plugin/LS450Coefficients;\nsetLS450Coefficients,(Lcom/oceanoptics/omnidriver/plugin/LS450Coefficients;)V\nloadInfo,()V\nsaveInfo,()V\ngetLS450Info,(I)Ljava/lang/String;\nsetAllLS450Info,(Lcom/oceanoptics/omnidriver/plugin/LS450Coefficients;)V\ngetAllLS450Info,()Lcom/oceanoptics/omnidriver/plugin/LS450Coefficients;\nsetLS450Info,(ILjava/lang/String;)V\nsetLEDMode,(Z)V\nloadLS450CoefficientsFromEEPROM,()V\ngetO2ProbeCalibrationCoefficients,()[D\nsetO2ProbeCalibrationCoefficients,([D)V\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public LS450_FunctionsImpl(USBInterface usbInt, SpectrometerPlugIn plugin) throws IOException {
        super(usbInt);
        this.plugin = plugin;
    }

    public LS450Coefficients getLS450Coefficients() {
        return this.ls450Coefficients;
    }

    public void setLS450Coefficients(LS450Coefficients ls450Coefficients) {
        this.ls450Coefficients = ls450Coefficients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadInfo() throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.out[0] = 38;
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 1);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveInfo() throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.out[0] = 39;
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 1);
            try {
                Thread.sleep(35000L);
            }
            catch (InterruptedException e) {
                this.logger.warning("EEPROM not written. Please retry");
                e.printStackTrace();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLS450Info(int index) throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                String strRet = "";
                this.out[0] = 35;
                this.out[1] = (byte)index;
                this.out[2] = 0;
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 3);
                this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 17);
                for (int i = 2; this.in[i] != 0 && i < 17; ++i) {
                    strRet = strRet + (char)this.in[i];
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return strRet;
            }
        }
    }

    public void setAllLS450Info(LS450Coefficients coef) throws IOException {
        this.ls450Coefficients = coef;
        String[] str = new String[19];
        str[1] = String.valueOf(coef.temperatureCalibrationConstant1);
        str[2] = String.valueOf(coef.temperatureCalibrationConstant0);
        str[3] = String.valueOf(coef.o2_IO_No);
        str[4] = String.valueOf(coef.o2_IO_0);
        str[5] = String.valueOf(coef.o2_IO_1);
        str[6] = String.valueOf(coef.o2_IO_2);
        str[7] = String.valueOf(coef.o2_K_No);
        str[8] = String.valueOf(coef.o2_K_0);
        str[9] = String.valueOf(coef.o2_K_1);
        str[10] = String.valueOf(coef.o2_K_2);
        str[11] = String.valueOf(coef.o2_K1_No);
        str[12] = String.valueOf(coef.o2_K1_0);
        str[13] = String.valueOf(coef.o2_K1_1);
        str[14] = String.valueOf(coef.o2_K1_2);
        str[15] = String.valueOf(coef.o2_K2_No);
        str[16] = String.valueOf(coef.o2_K2_0);
        str[17] = String.valueOf(coef.o2_K2_1);
        str[18] = String.valueOf(coef.o2_K2_2);
        for (int i = 1; i < 19; ++i) {
            this.setLS450Info(i, str[i]);
        }
    }

    public LS450Coefficients getAllLS450Info() throws IOException {
        this.ls450Coefficients = new LS450Coefficients();
        String[] str = new String[19];
        for (int i = 1; i < 19; ++i) {
            str[i] = this.getLS450Info(i);
        }
        try {
            this.ls450Coefficients.temperatureCalibrationConstant1 = Double.parseDouble(str[1]);
            this.ls450Coefficients.temperatureCalibrationConstant0 = Double.parseDouble(str[2]);
        }
        catch (NumberFormatException nfe) {
            this.ls450Coefficients.temperatureCalibrationConstant1 = 0.0;
            this.ls450Coefficients.temperatureCalibrationConstant0 = 0.0;
        }
        try {
            this.ls450Coefficients.o2_IO_No = Double.parseDouble(str[3]);
            this.ls450Coefficients.o2_IO_0 = Double.parseDouble(str[4]);
            this.ls450Coefficients.o2_IO_1 = Double.parseDouble(str[5]);
            this.ls450Coefficients.o2_IO_2 = Double.parseDouble(str[6]);
        }
        catch (NumberFormatException nfe) {
            this.ls450Coefficients.o2_IO_No = 0.0;
            this.ls450Coefficients.o2_IO_0 = 0.0;
            this.ls450Coefficients.o2_IO_1 = 0.0;
            this.ls450Coefficients.o2_IO_2 = 0.0;
        }
        try {
            this.ls450Coefficients.o2_K_No = Double.parseDouble(str[7]);
            this.ls450Coefficients.o2_K_0 = Double.parseDouble(str[8]);
            this.ls450Coefficients.o2_K_1 = Double.parseDouble(str[9]);
            this.ls450Coefficients.o2_K_2 = Double.parseDouble(str[10]);
        }
        catch (NumberFormatException nfe) {
            this.ls450Coefficients.o2_K_No = 0.0;
            this.ls450Coefficients.o2_K_0 = 0.0;
            this.ls450Coefficients.o2_K_1 = 0.0;
            this.ls450Coefficients.o2_K_2 = 0.0;
        }
        try {
            this.ls450Coefficients.o2_K1_No = Double.parseDouble(str[11]);
            this.ls450Coefficients.o2_K1_0 = Double.parseDouble(str[12]);
            this.ls450Coefficients.o2_K1_1 = Double.parseDouble(str[13]);
            this.ls450Coefficients.o2_K1_2 = Double.parseDouble(str[14]);
        }
        catch (NumberFormatException nfe) {
            this.ls450Coefficients.o2_K1_No = 0.0;
            this.ls450Coefficients.o2_K1_0 = 0.0;
            this.ls450Coefficients.o2_K1_1 = 0.0;
            this.ls450Coefficients.o2_K1_2 = 0.0;
        }
        try {
            this.ls450Coefficients.o2_K2_No = Double.parseDouble(str[15]);
            this.ls450Coefficients.o2_K2_0 = Double.parseDouble(str[16]);
            this.ls450Coefficients.o2_K2_1 = Double.parseDouble(str[17]);
            this.ls450Coefficients.o2_K2_2 = Double.parseDouble(str[18]);
        }
        catch (NumberFormatException nfe) {
            this.ls450Coefficients.o2_K2_No = 0.0;
            this.ls450Coefficients.o2_K2_0 = 0.0;
            this.ls450Coefficients.o2_K2_1 = 0.0;
            this.ls450Coefficients.o2_K2_2 = 0.0;
        }
        return this.ls450Coefficients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLS450Info(int index, String str) throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            byte[] info = new byte[17];
            info[0] = 36;
            info[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)index));
            try {
                byte[] bytes = str.getBytes("US-ASCII");
                for (int i = 0; i < bytes.length; ++i) {
                    info[2 + i] = bytes[i];
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new IOException("Error encoding configuration variables: " + e.getMessage());
            }
            this.usb.bulkOut(this.dataOutEndPoint, info, 17);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                throw new IOException("EEPROM write might not have completed. Please verify.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLEDMode(boolean pulsed) throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            int mode = !pulsed ? 0 : 1;
            this.out[0] = 33;
            this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)mode));
            this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)mode));
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 3);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void loadLS450CoefficientsFromEEPROM() throws IOException {
        this.ls450Coefficients = new LS450Coefficients();
        this.loadInfo();
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ls450Coefficients = this.getAllLS450Info();
    }

    public double[] getO2ProbeCalibrationCoefficients() {
        return this.ls450Coefficients.getO2ProbeCalibrationCoefficients();
    }

    public void setO2ProbeCalibrationCoefficients(double[] coefficients) {
        this.ls450Coefficients.setO2ProbeCalibrationCoefficients(coefficients);
    }

    public String[] getFeatureGUIClassnames() {
        Vector<String> features = new Vector<String>();
        features.add(this.panelPath + "." + this.featurePath);
        features.add(this.panelPath + "." + this.featurePath1);
        return features.toArray(new String[0]);
    }
}

