/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.masterclockrate;

import com.oceanoptics.omnidriver.features.masterclockrate.MasterClockRateImpl;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;

public class MasterClockRateImpl_ADC
extends MasterClockRateImpl {
    private static final short DATA_OUT = 2;
    private static final short MAX_PACKET_SIZE = 64;
    private USBEndpointDescriptor dataOutEndPoint = new USBEndpointDescriptor(7, 5, 2, 2, 64, 0);
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;)V\nsetMasterClock,(I)V\n";

    public MasterClockRateImpl_ADC(USBInterface usbInt) {
        super(usbInt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMasterClock(int rate) throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            if (rate < 8 || rate > 1000) {
                this.logger.severe("Invalid clock rate. Master Clock rate must be between 8 - 1000KHz.");
                throw new IllegalArgumentException("Invalid clock rate. Master Clock rate must be between 8 - 1000KHz.");
            }
            this.out[0] = 28;
            this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)rate));
            this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)rate));
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 3);
            this.logger.fine("Set master clock to : " + rate);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

