/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.singlestrobe;

import com.oceanoptics.omnidriver.features.FPGAImpl;
import com.oceanoptics.omnidriver.features.singlestrobe.SingleStrobeGUIProvider;
import com.oceanoptics.omnidriver.interfaces.MasterClockDivisorListener;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import java.io.IOException;

public class SingleStrobeImpl
extends FPGAImpl
implements SingleStrobeGUIProvider,
MasterClockDivisorListener {
    private double countsToMicros = 2.0;
    private final int SINGLE_STROBE_MIN = 0;
    private final int SINGLE_STROBE_MAX = 65535;
    private final int SINGLE_STROBE_STEP = 1;
    protected String featurePath = "singlestrobe.SingleStrobeTimingPanel";
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;)V\ngetSingleStrobeHigh,()I\ngetSingleStrobeLow,()I\nsetSingleStrobeHigh,(I)V\nsetSingleStrobeLow,(I)V\ngetSingleStrobeCountsToMicros,(I)D\ngetSingleStrobeIncrement,()I\ngetSingleStrobeMaximum,()I\ngetSingleStrobeMinimum,()I\nmasterClockChanged,(J)V\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public SingleStrobeImpl(USBInterface usbInt) {
        super(usbInt);
    }

    public int getSingleStrobeHigh() throws IOException {
        return this.getFPGA((byte)56);
    }

    public int getSingleStrobeLow() throws IOException {
        return this.getFPGA((byte)60);
    }

    public void setSingleStrobeHigh(int value) throws IOException {
        if (value > 65535 || value < 0) {
            this.logger.severe("Single strobe high clock transition must be between 0-65535");
            throw new IllegalArgumentException("Single strobe high clock transition must be between 0-65535");
        }
        this.setFPGA((byte)56, value);
        this.logger.fine("Single strobe high set to " + value);
    }

    public void setSingleStrobeLow(int value) throws IOException {
        if (value > 65535 || value < 0) {
            this.logger.severe("Single strobe low clock transition must be between 0-65535");
            throw new IllegalArgumentException("Single strobe low clock transition must be between 0-65535");
        }
        this.setFPGA((byte)60, value);
        this.logger.fine("Single strobe low set to " + value);
    }

    public double getSingleStrobeCountsToMicros(int counts) {
        return (double)counts / this.countsToMicros;
    }

    public int getSingleStrobeIncrement() {
        return 1;
    }

    public int getSingleStrobeMaximum() {
        return 65535;
    }

    public int getSingleStrobeMinimum() {
        return 0;
    }

    public void masterClockChanged(long newValue) {
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }
}

