/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.singlestrobe;

import com.oceanoptics.omnidriver.features.singlestrobe.SingleStrobeGUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;
import java.net.Socket;

public abstract class SingleStrobeImpl_Jaz
implements SingleStrobeGUIProvider {
    private static int countsToMicros = 2;
    private static final int SINGLE_STROBE_MIN = 0;
    private static final int SINGLE_STROBE_MAX = 65535;
    private static final int SINGLE_STROBE_STEP = 1;
    protected byte[] in;
    protected byte[] out;
    protected String featurePath = "singlestrobe.SingleStrobeTimingPanel";
    protected String panelPath = "com.oceanoptics.omnidriver.guisupport.features";
    private static String __extern__ = "__extern__\ngetSingleStrobeMinimum,()I\ngetSingleStrobeMaximum,()I\ngetSingleStrobeIncrement,()I\ngetSingleStrobeCountsToMicros,(I)D\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    protected SingleStrobeImpl_Jaz() {
    }

    public int getSingleStrobeMinimum() {
        return 0;
    }

    public int getSingleStrobeMaximum() {
        return 65535;
    }

    public int getSingleStrobeIncrement() {
        return 1;
    }

    public double getSingleStrobeCountsToMicros(int counts) {
        return counts / countsToMicros;
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }

    protected int setupSetStrobeHigh(int counts) {
        for (int i = 0; i < this.out.length; ++i) {
            this.out[i] = 0;
        }
        this.out[0] = -57;
        this.out[1] = 100;
        this.out[2] = ByteRoutines.getHighByte((short)((short)counts));
        this.out[3] = ByteRoutines.getLowByte((short)((short)counts));
        return 17;
    }

    protected int setupSetStrobeLow(int counts) {
        for (int i = 0; i < this.out.length; ++i) {
            this.out[i] = 0;
        }
        this.out[0] = -57;
        this.out[1] = 101;
        this.out[2] = ByteRoutines.getHighByte((short)((short)counts));
        this.out[3] = ByteRoutines.getLowByte((short)((short)counts));
        return 17;
    }

    protected int setupGetStrobeHigh() {
        for (int i = 0; i < this.out.length; ++i) {
            this.out[i] = 0;
        }
        this.out[0] = -58;
        this.out[1] = 100;
        return 2;
    }

    protected int setupGetStrobeLow() {
        for (int i = 0; i < this.out.length; ++i) {
            this.out[i] = 0;
        }
        this.out[0] = -58;
        this.out[1] = 101;
        return 2;
    }

    public static class Network
    extends SingleStrobeImpl_Jaz {
        private Socket socket;

        public Network(Socket sock, byte[] inputBuffer, byte[] outputBuffer) {
            this.socket = sock;
            this.in = inputBuffer;
            this.out = outputBuffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getSingleStrobeHigh() throws IOException {
            byte[] byArray = this.in;
            synchronized (this.in) {
                byte[] byArray2 = this.out;
                synchronized (this.out) {
                    int length = this.setupGetStrobeHigh();
                    this.socket.getOutputStream().write(this.out, 0, length);
                    this.socket.getInputStream().read(this.in, 0, 17);
                    int counts = ByteRoutines.makeDWord((byte)0, (byte)0, (byte)this.in[2], (byte)this.in[3]);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return counts;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSingleStrobeHigh(int counts) throws IOException {
            byte[] byArray = this.out;
            synchronized (this.out) {
                int length = this.setupSetStrobeHigh(counts);
                this.socket.getOutputStream().write(this.out, 0, length);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getSingleStrobeLow() throws IOException {
            byte[] byArray = this.in;
            synchronized (this.in) {
                byte[] byArray2 = this.out;
                synchronized (this.out) {
                    int length = this.setupGetStrobeLow();
                    this.socket.getOutputStream().write(this.out, 0, length);
                    this.socket.getInputStream().read(this.in, 0, 17);
                    int counts = ByteRoutines.makeDWord((byte)0, (byte)0, (byte)this.in[2], (byte)this.in[3]);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return counts;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSingleStrobeLow(int counts) throws IOException {
            byte[] byArray = this.out;
            synchronized (this.out) {
                int length = this.setupSetStrobeLow(counts);
                this.socket.getOutputStream().write(this.out, 0, length);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }

    public static class USB
    extends SingleStrobeImpl_Jaz {
        private USBInterface usb;
        private static final short DATA_OUT = 1;
        private static final short LOW_SPEED_DATA_IN = 129;
        private static final short MAX_PACKET_SIZE = 512;
        private USBEndpointDescriptor dataOutEndPoint = new USBEndpointDescriptor(7, 5, 1, 2, 512, 0);
        private USBEndpointDescriptor lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 129, 2, 512, 0);

        public USB(USBInterface usbInt) {
            this.usb = usbInt;
            this.in = this.usb.getInputBuffer();
            this.out = this.usb.getOutputBuffer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getSingleStrobeHigh() throws IOException {
            byte[] byArray = this.in;
            synchronized (this.in) {
                byte[] byArray2 = this.out;
                synchronized (this.out) {
                    int length = this.setupGetStrobeHigh();
                    this.usb.bulkOut(this.dataOutEndPoint, this.out, length);
                    this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 17);
                    int counts = ByteRoutines.makeDWord((byte)0, (byte)0, (byte)this.in[2], (byte)this.in[3]);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return counts;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSingleStrobeHigh(int counts) throws IOException {
            byte[] byArray = this.out;
            synchronized (this.out) {
                int length = this.setupSetStrobeHigh(counts);
                this.usb.bulkOut(this.dataOutEndPoint, this.out, length);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getSingleStrobeLow() throws IOException {
            byte[] byArray = this.in;
            synchronized (this.in) {
                byte[] byArray2 = this.out;
                synchronized (this.out) {
                    int length = this.setupGetStrobeLow();
                    this.usb.bulkOut(this.dataOutEndPoint, this.out, length);
                    this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 17);
                    int counts = ByteRoutines.makeDWord((byte)0, (byte)0, (byte)this.in[2], (byte)this.in[3]);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return counts;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSingleStrobeLow(int counts) throws IOException {
            byte[] byArray = this.out;
            synchronized (this.out) {
                int length = this.setupSetStrobeLow(counts);
                this.usb.bulkOut(this.dataOutEndPoint, this.out, length);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }
}

