/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.singlestrobe;

import com.oceanoptics.omnidriver.features.singlestrobe.SingleStrobeImpl;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectrometer.sts.STS;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;

public class SingleStrobeImpl_STS
extends SingleStrobeImpl {
    private int highDelay_usec = 10;
    private int lowDelay_usec = 20;
    private static final int DELAY_MINIMUM_USEC = 5;
    private static final int DELAY_MAXIMUM_USEC = 335500;
    private static final int DELAY_INCREMENT_USEC = 1;
    private static final int COUNTS_PER_USEC = 1;
    protected STS spectrometer;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/spectrometer/sts/STS;Lcom/oceanoptics/omnidriver/interfaces/USBInterface;)V\ngetSingleStrobeHigh,()I\nsetSingleStrobeHigh,(I)V\ngetSingleStrobeLow,()I\nsetSingleStrobeLow,(I)V\ngetSingleStrobeMinimum,()I\ngetSingleStrobeMaximum,()I\ngetSingleStrobeIncrement,()I\ngetSingleStrobeCountsToMicros,(I)D\n";

    public SingleStrobeImpl_STS(STS sts, USBInterface usbInt) {
        super(usbInt);
        this.spectrometer = sts;
    }

    private void writePulseDelay(int usec) throws IOException {
        byte[] data = new byte[]{ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)usec)), ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)usec)), ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)usec)), ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)usec))};
        boolean success = this.spectrometer.sendCommandToDevice(0x300010, data);
        if (!success) {
            throw new IOException("Failed to write single strobe pulse delay.");
        }
    }

    private void writePulseWidth(int usec) throws IOException {
        byte[] data = new byte[]{ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)usec)), ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)usec)), ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)usec)), ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)usec))};
        boolean success = this.spectrometer.sendCommandToDevice(0x300011, data);
        if (!success) {
            throw new IOException("Failed to write single strobe pulse width.");
        }
    }

    public int getSingleStrobeHigh() throws IOException {
        return this.highDelay_usec;
    }

    public void setSingleStrobeHigh(int counts) throws IOException {
        if (counts / 1 > this.lowDelay_usec) {
            return;
        }
        this.highDelay_usec = counts / 1;
        this.writePulseDelay(this.highDelay_usec);
        this.writePulseWidth(this.lowDelay_usec - this.highDelay_usec);
    }

    public int getSingleStrobeLow() throws IOException {
        return this.lowDelay_usec;
    }

    public void setSingleStrobeLow(int counts) throws IOException {
        if (counts / 1 < this.highDelay_usec) {
            return;
        }
        this.lowDelay_usec = counts / 1;
        int width_usec = this.lowDelay_usec - this.highDelay_usec;
        this.writePulseWidth(width_usec);
    }

    public int getSingleStrobeMinimum() {
        return 5;
    }

    public int getSingleStrobeMaximum() {
        return 335500;
    }

    public int getSingleStrobeIncrement() {
        return 1;
    }

    public double getSingleStrobeCountsToMicros(int counts) {
        return counts / 1;
    }
}

