/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.spectralhyperadapter;

import com.oceanoptics.omnidriver.features.USBFeature;
import com.oceanoptics.omnidriver.features.spectralhyperadapter.SHAGUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.hr4000.HR4000;
import com.oceanoptics.omnidriver.spectrometer.sha.SHAChannel;
import com.oceanoptics.omnidriver.spectrometer.sha.SHACoefficients;
import com.oceanoptics.omnidriver.spectrometer.sha.SHAConstants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

public class SHAImpl
extends USBFeature
implements SHAGUIProvider {
    private SHAChannel shaChannel;
    private HR4000 spectrometer;
    private SHACoefficients shaCoefficients;
    private SHAConstants consts = new SHAConstants();
    private int numberVoltageSteps;
    private double voltageStart = 0.0;
    private double voltageEnd = 5.0;
    private double voltageStep;
    private boolean calibrate;
    private double calibrationTime = 0.0;
    protected String featurePath = "spectralhyperadapter.SHAPanel";
    protected String featurePath2 = "spectralhyperadapter.SHACalibrationPanel";
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;Lcom/oceanoptics/omnidriver/spectrometer/Spectrometer;)V\nisHyperAdapterPresent,()Z\ninitSHA,(Lcom/oceanoptics/omnidriver/spectrometer/sha/SHAChannel;)V\nsetHyperAdapterDAC,(D)I\nreadHyperAdapterEEPROM,([BII)I\nwriteHyperAdapterEEPROM,([BII)I\ngetCalibrationData,(Ljava/io/File;)V\nsetCalibrationData,(Ljava/io/File;)V\ncalibrate,()V\nrestoreCalibration,()V\ngetCalibrationTime,()D\ngetSHAChannel,()Lcom/oceanoptics/omnidriver/spectrometer/sha/SHAChannel;\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public SHAImpl(USBInterface usbInt, Spectrometer spectrometer) {
        super(usbInt);
        this.spectrometer = (HR4000)spectrometer;
    }

    public boolean isHyperAdapterPresent() throws IOException {
        byte[] data = new byte[]{0, 0};
        this.spectrometer.setSHAI2CBytes((byte)-104, (byte)2, data);
        data[0] = 17;
        data[1] = 0;
        int result = 8;
        byte[] startAddress = new byte[]{15, -1};
        result = this.writeToShaEeprom(-88, startAddress, 2);
        if (result != 8) {
            return false;
        }
        result = this.readShaEeprom(169, data, 1);
        return result == 1;
    }

    public void initSHA(SHAChannel channel) {
        this.shaChannel = channel;
        this.shaCoefficients = this.shaChannel.getSHACoefficients();
        this.numberVoltageSteps = this.shaChannel.getNumberOfVoltageSteps();
        this.voltageStep = (this.voltageEnd - this.voltageStart) / ((double)this.numberVoltageSteps - 1.0);
    }

    private int writeToShaEeprom(int address, byte[] data, int length) {
        int result = 0;
        try {
            result = this.spectrometer.setSHAI2CBytes((byte)(address >> 1), (byte)length, data);
            if (result != 8) {
                return -1;
            }
            result = -1;
            long start = System.currentTimeMillis();
            while (result != 8) {
                result = this.spectrometer.setSHAI2CBytes((byte)(address >> 1), (byte)2, data);
                if (System.currentTimeMillis() - start <= 5000L) continue;
                return -1;
            }
        }
        catch (IOException e) {
            return -1;
        }
        return result;
    }

    private int readShaEeprom(int address, byte[] data, int length) {
        try {
            byte[] response = this.spectrometer.getSHAI2CBytes((byte)(address >> 1), (byte)length);
        }
        catch (IOException e) {
            return -1;
        }
        return length;
    }

    public int setHyperAdapterDAC(double voltage) {
        byte[] data = new byte[2];
        if (voltage > 5.0) {
            voltage = 5.0;
        }
        if (voltage < 0.0) {
            voltage = 0.0;
        }
        short d = (short)(4095.0 * voltage / 5.0);
        short msb = (short)((d & 0xFF00) >> 8);
        short lsb = (short)(d & 0xFF);
        data[0] = (byte)msb;
        data[1] = (byte)lsb;
        int result = this.writeI2C(152, data, 2);
        return result;
    }

    public int readHyperAdapterEEPROM(byte[] data, int start, int length) {
        if (start == 0 && length == 1) {
            data[0] = 17;
        }
        int result = 8;
        byte[] startAddress = new byte[]{(byte)((start & 0xF00) >> 8), (byte)(start & 0xFF)};
        result = this.writeI2C(168, startAddress, 2);
        if (result != 8) {
            return -1;
        }
        result = this.readI2C(169, data, length);
        return result;
    }

    public int writeHyperAdapterEEPROM(byte[] data, int start, int length) {
        byte[] i2c_out = new byte[3];
        int result = -1;
        for (int addr = start; addr < start + length; ++addr) {
            i2c_out[0] = (byte)((addr & 0xF00) >> 8);
            i2c_out[1] = (byte)(addr & 0xFF);
            i2c_out[2] = data[addr - start];
            result = this.writeI2C(168, i2c_out, 3);
        }
        return result;
    }

    protected int readI2C(int address, byte[] data, int length) {
        byte[] bdata = new byte[]{};
        try {
            bdata = this.spectrometer.getSHAI2CBytes((byte)(address >> 1), (byte)length);
        }
        catch (IOException e) {
            // empty catch block
        }
        System.arraycopy(bdata, 0, data, 0, length);
        return length;
    }

    protected int writeI2C(int address, byte[] data, int length) {
        int result = length;
        byte[] bdata = new byte[length];
        for (int i = 0; i < length; ++i) {
            bdata[i] = data[i];
        }
        try {
            result = this.spectrometer.setSHAI2CBytes((byte)(address >> 1), (byte)length, bdata);
            if (result != 8) {
                return -1;
            }
            result = -1;
            while (result != 8) {
                result = this.spectrometer.setSHAI2CBytes((byte)(address >> 1), (byte)2, bdata);
            }
        }
        catch (IOException e) {
            return -1;
        }
        return result;
    }

    public void getCalibrationData(File file) {
        if (file != null) {
            boolean i = false;
            try {
                FileReader infile = new FileReader(file);
                String num = null;
                BufferedReader br = new BufferedReader(infile);
                num = br.readLine();
                if (num == null) {
                    i = true;
                } else {
                    this.shaCoefficients.setLenIntercept(Double.parseDouble(num));
                }
                num = br.readLine();
                if (num == null) {
                    i = true;
                } else {
                    this.shaCoefficients.setLenFirst(Double.parseDouble(num));
                }
                num = br.readLine();
                if (num == null) {
                    i = true;
                } else {
                    this.shaCoefficients.setLenSecond(Double.parseDouble(num));
                }
                br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (i) {
                this.shaCoefficients.setLenIntercept(this.shaCoefficients.getDefaultIntercept());
                this.shaCoefficients.setLenFirst(this.shaCoefficients.getDefaultFirst());
                this.shaCoefficients.setLenSecond(this.shaCoefficients.getDefaultSecond());
            }
            this.shaCoefficients.setIntercept(this.shaCoefficients.getLenIntercept());
            this.shaCoefficients.setFirst(this.shaCoefficients.getLenFirst());
            this.shaCoefficients.setSecond(this.shaCoefficients.getLenSecond());
        }
    }

    public void setCalibrationData(File file) {
        if (file != null) {
            try {
                FileWriter outfile = new FileWriter(file);
                String num = null;
                BufferedWriter bw = new BufferedWriter(outfile);
                num = Double.toString(this.shaCoefficients.getLenIntercept());
                bw.write(num);
                bw.newLine();
                num = Double.toString(this.shaCoefficients.getLenFirst());
                bw.write(num);
                bw.newLine();
                num = Double.toString(this.shaCoefficients.getLenSecond());
                bw.write(num);
                bw.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calibrate() {
        HR4000 hR4000 = this.spectrometer;
        synchronized (hR4000) {
            int intTime = this.adjustIntegrationTime();
            this.calibrationTime = (double)(intTime * this.shaChannel.getNumberOfVoltageSteps()) / 1000000.0;
            try {
                this.spectrometer.setIntegrationTime(intTime);
                this.shaCoefficients.setPhaseInterceptOut(this.shaCoefficients.getPhaseIntercept());
                this.shaCoefficients.setPhaseFirstOut(this.shaCoefficients.getPhaseFirst());
                this.shaCoefficients.setPhaseSecondOut(this.shaCoefficients.getPhaseSecond());
                double std_err = this.shaChannel.getCalibrationConstants(this.shaChannel.getScans(this.numberVoltageSteps, null));
                if (this.calibrate) {
                    this.shaCoefficients.setLenIntercept(this.shaCoefficients.getIntercept());
                    this.shaCoefficients.setLenFirst(this.shaCoefficients.getFirst());
                    this.shaCoefficients.setLenSecond(this.shaCoefficients.getSecond());
                    this.shaChannel.saveSHACoefficients();
                } else {
                    this.shaCoefficients.setPhaseIntercept(this.shaCoefficients.getPhaseInterceptOut());
                    this.shaCoefficients.setPhaseFirst(this.shaCoefficients.getPhaseFirstOut());
                    this.shaCoefficients.setPhaseSecond(this.shaCoefficients.getPhaseSecondOut());
                    this.shaCoefficients.setIntercept(this.shaCoefficients.getLenIntercept());
                    this.shaCoefficients.setFirst(this.shaCoefficients.getLenFirst());
                    this.shaCoefficients.setSecond(this.shaCoefficients.getLenSecond());
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private int adjustIntegrationTime() {
        double maxCounts;
        this.setHyperAdapterDAC(this.voltageStart);
        double maxVal = maxCounts = (double)this.shaChannel.getMaxNumberOfCounts();
        int intTime = 100000;
        int maxIntTime = intTime * 17;
        int k = 0;
        while (maxVal > maxCounts * 0.75 && intTime < maxIntTime && k < 10) {
            try {
                this.spectrometer.setIntegrationTime(intTime);
                double[][] temp = this.shaChannel.getScans(1, null);
                maxVal = this.getMax(temp[0]);
                if (maxVal > maxCounts * 0.8) {
                    intTime = 2 * intTime / 3;
                }
                if (maxVal < maxCounts * 0.4) {
                    intTime = 3 * intTime / 2;
                    maxVal = maxCounts;
                }
                ++k;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (intTime > maxIntTime) {
            intTime = maxIntTime;
        }
        return intTime;
    }

    public void restoreCalibration() {
        this.shaCoefficients.setLenIntercept(this.shaCoefficients.getDefaultIntercept());
        this.shaCoefficients.setLenFirst(this.shaCoefficients.getDefaultFirst());
        this.shaCoefficients.setLenSecond(this.shaCoefficients.getDefaultSecond());
        this.shaCoefficients.setIntercept(this.shaCoefficients.getDefaultIntercept());
        this.shaCoefficients.setFirst(this.shaCoefficients.getDefaultFirst());
        this.shaCoefficients.setSecond(this.shaCoefficients.getDefaultSecond());
        this.shaChannel.saveSHACoefficients();
    }

    private double getMax(double[] data) {
        double maxdata = 0.0;
        for (int i = 0; i < data.length; ++i) {
            if (!(maxdata < data[i])) continue;
            maxdata = data[i];
        }
        return maxdata;
    }

    public double getCalibrationTime() {
        if (this.calibrationTime == 0.0) {
            int intTime = this.spectrometer.getActualIntegrationTime();
            this.calibrationTime = (double)(intTime * this.shaChannel.getNumberOfVoltageSteps()) / 1000000.0;
        }
        return this.calibrationTime;
    }

    public SHAChannel getSHAChannel() {
        return this.shaChannel;
    }

    public String[] getFeatureGUIClassnames() {
        Vector<String> features = new Vector<String>();
        features.add(this.panelPath + "." + this.featurePath);
        features.add(this.panelPath + "." + this.featurePath2);
        return features.toArray(new String[0]);
    }
}

