/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.thermoelectric;

import com.oceanoptics.omnidriver.features.thermoelectric.ThermoElectricImpl;
import com.oceanoptics.omnidriver.features.thermoelectric.ThermoElectricShowFanControl;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;

public class ThermoElectricImpl_QE65000
extends ThermoElectricImpl
implements ThermoElectricShowFanControl {
    protected Boolean tecEnabled = null;
    protected Boolean fanEnabled = null;
    protected Double setPoint = new Double(-10.0);
    private final double SETPOINT_MIN_DEGREES_C = -40.0;
    private final double SETPOINT_MAX_DEGREES_C = 25.0;
    private final double SETPOINT_INCREMENT = 0.1;
    private final int COUNTS_PER_DEGREE_C = 10;
    protected final int TEC_STATE_SLOT = 17;
    protected boolean saveTECStateEnabled = true;
    private static final short DATA_OUT = 1;
    private static final short LOW_SPEED_DATA_IN = 129;
    private static final short MAX_PACKET_SIZE = 512;
    protected String featurePath = "thermoelectric.ThermoElectricPanel";
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;)V\nsetTECEnable,(Z)V\nsetTECEnable,(ZZ)V\ngetTECEnable,()Ljava/lang/Boolean;\nsetFanEnable,(Z)V\ngetFanEnable,()Ljava/lang/Boolean;\ngetDetectorTemperatureCelsius,()D\ngetDetectorTemperatureSetPointCelsius,()D\nsetDetectorSetPointCelsius,(D)V\ngetDetectorSetPointCelsius,()Ljava/lang/Double;\ngetSetPointMinimumCelsius,()D\ngetSetPointMaximumCelsius,()D\ngetSetPointIncrementCelsius,()D\nisSaveTECStateEnabled,()Z\nsaveTECState,()V\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public ThermoElectricImpl_QE65000(USBInterface usbInt) throws IOException {
        super(usbInt);
        this.dataOutEndPoint = new USBEndpointDescriptor(7, 5, 1, 2, 512, 0);
        this.lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 129, 2, 512, 0);
        this.init();
        this.initTECState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.out[0] = -2;
                byte[] sb = new byte[16];
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 1);
                this.usb.bulkIn(this.lowSpeedInEndPoint, sb, 16);
                this.tecEnabled = new Boolean(false);
                this.fanEnabled = new Boolean((sb[13] & 1) != 0);
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
            return;
        }
    }

    public void setTECEnable(boolean enable) throws IOException {
        this.setTECEnable(enable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTECEnable(boolean enable, boolean setTemperature) throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            int byteOn = enable ? 1 : 0;
            this.out[0] = 113;
            this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)byteOn));
            this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)byteOn));
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 3);
            this.logger.fine("TEC controller set to (0:Disabled, 1:Enabled): " + byteOn);
            this.tecEnabled = new Boolean(enable);
            if (setTemperature && enable && null != this.setPoint) {
                this.setDetectorSetPointCelsius(this.setPoint);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public Boolean getTECEnable() {
        return this.tecEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFanEnable(boolean enable) throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            int byteOn = enable ? 1 : 0;
            this.out[0] = 112;
            this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)byteOn));
            this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)byteOn));
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 3);
            this.logger.fine("Fan set to (0:Off, 1:On): " + byteOn);
            this.fanEnabled = new Boolean(enable);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public Boolean getFanEnable() {
        return this.fanEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDetectorTemperatureCelsius() throws IOException {
        short counts = 0;
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.out[0] = 114;
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 1);
                this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 2);
                counts = ByteRoutines.makeWord((byte)this.in[1], (byte)this.in[0]);
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            return this.countsToDegreesCelsius(counts);
        }
    }

    public double getDetectorTemperatureSetPointCelsius() throws IOException {
        if (null == this.setPoint) {
            return Double.NaN;
        }
        return this.setPoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetectorSetPointCelsius(double tempCelsius) throws IOException {
        short temp = (short)(tempCelsius * 10.0);
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.out[0] = 115;
            this.out[1] = ByteRoutines.getLowByte((short)temp);
            this.out[2] = ByteRoutines.getHighByte((short)temp);
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 3);
            this.setPoint = new Double(tempCelsius);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            this.logger.fine("Detector's set-point temperature set to " + temp);
            return;
        }
    }

    public Double getDetectorSetPointCelsius() {
        return this.setPoint;
    }

    public double getSetPointMinimumCelsius() {
        return -40.0;
    }

    public double getSetPointMaximumCelsius() {
        return 25.0;
    }

    public double getSetPointIncrementCelsius() {
        return 0.1;
    }

    private double countsToDegreesCelsius(int counts) {
        return (double)counts / 10.0;
    }

    public boolean isSaveTECStateEnabled() {
        return this.saveTECStateEnabled;
    }

    public void saveTECState() throws IOException {
        if (!this.saveTECStateEnabled) {
            return;
        }
        this.persistTECState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistTECState() throws IOException {
        byte[] tecState = new byte[15];
        short sp = (short)(this.setPoint * 10.0);
        tecState[0] = this.tecEnabled != false ? (byte)1 : 0;
        tecState[1] = this.fanEnabled != false ? (byte)1 : 0;
        tecState[2] = ByteRoutines.getLowByte((short)sp);
        tecState[3] = ByteRoutines.getHighByte((short)sp);
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.out[0] = 6;
            this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)17));
            for (int i = 0; i < tecState.length; ++i) {
                this.out[2 + i] = tecState[i];
            }
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 17);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                this.logger.severe("EEPROM write might not have completed. Please verify.");
                throw new IOException("EEPROM write might not have completed. Please verify.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initTECState() throws IOException {
        byte[] tecState = new byte[15];
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.out[0] = 5;
                this.out[1] = 17;
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 2);
                this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 17);
                if (this.in[2] != 0 && this.in[2] != 1 || this.in[3] != 0 && this.in[3] != 1) {
                    // ** MonitorExit[var3_5] (shouldn't be in output)
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                for (int i = 2; i < 17; ++i) {
                    tecState[i - 2] = this.in[i];
                }
                // ** MonitorExit[var3_5] (shouldn't be in output)
            }
            {
                try {
                    this.tecEnabled = new Boolean((tecState[0] & 1) != 0);
                    this.fanEnabled = new Boolean((tecState[1] & 1) != 0);
                    double sp = ByteRoutines.makeWord((byte)tecState[3], (byte)tecState[2]);
                    if (sp != 0.0) {
                        sp /= 10.0;
                    }
                    this.setPoint = new Double(sp);
                    this.setTECEnable(this.tecEnabled);
                    this.setFanEnable(this.fanEnabled);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
                return;
            }
        }
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }
}

