/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.thermoelectric;

import com.oceanoptics.omnidriver.features.thermoelectric.ThermoElectricImpl;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;
import java.net.Socket;

public class ThermoElectricImpl_Remora
extends ThermoElectricImpl {
    Socket dataSocket = null;
    private Boolean tecEnabled = null;
    private Boolean fanEnabled = null;
    private Double setPoint = new Double(-10.0);
    private final double SETPOINT_MIN_DEGREES_C = -40.0;
    private final double SETPOINT_MAX_DEGREES_C = 25.0;
    private final double SETPOINT_INCREMENT = 0.1;
    private final int COUNTS_PER_DEGREE_C = 10;
    private final int TEC_STATE_SLOT = 17;
    protected boolean saveTECStateEnabled = true;
    protected String featurePath = "thermoelectric.ThermoElectricPanel";
    private int productID = 0;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;Ljava/net/Socket;I)V\nsetTECEnable,(Z)V\ngetTECEnable,()Ljava/lang/Boolean;\nsetFanEnable,(Z)V\ngetFanEnable,()Ljava/lang/Boolean;\ngetDetectorTemperatureCelsius,()D\ngetDetectorTemperatureSetPointCelsius,()D\nsetDetectorSetPointCelsius,(D)V\ngetDetectorSetPointCelsius,()Ljava/lang/Double;\ngetSetPointMinimumCelsius,()D\ngetSetPointMaximumCelsius,()D\ngetSetPointIncrementCelsius,()D\nisSaveTECStateEnabled,()Z\nsaveTECState,()V\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public ThermoElectricImpl_Remora(USBInterface usbInt, Socket dataSocket, int productID) throws IOException {
        super(usbInt);
        this.productID = productID;
        this.dataSocket = dataSocket;
        this.fanEnabled = new Boolean(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTECEnable(boolean enable) throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            int byteOn = enable ? 1 : 0;
            this.out[0] = 113;
            this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)byteOn));
            this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)byteOn));
            this.dataSocket.getOutputStream().write(this.out, 0, 3);
            this.logger.fine("TEC controller set to (0:Disabled, 1:Enabled): " + byteOn);
            this.tecEnabled = new Boolean(enable);
            if (enable && null != this.setPoint) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                this.setDetectorSetPointCelsius(this.setPoint);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public Boolean getTECEnable() {
        return this.tecEnabled;
    }

    public void setFanEnable(boolean enable) throws IOException {
    }

    public Boolean getFanEnable() {
        return this.fanEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDetectorTemperatureCelsius() throws IOException {
        short counts = 0;
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.out[0] = 114;
                this.dataSocket.getOutputStream().write(this.out, 0, 1);
                this.dataSocket.getInputStream().read(this.in, 0, 2);
                counts = ByteRoutines.makeWord((byte)this.in[1], (byte)this.in[0]);
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            return this.countsToDegreesCelsius(counts);
        }
    }

    public double getDetectorTemperatureSetPointCelsius() throws IOException {
        if (null == this.setPoint) {
            return Double.NaN;
        }
        return this.setPoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetectorSetPointCelsius(double tempCelsius) throws IOException {
        short temp = (short)(tempCelsius * 10.0);
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.out[0] = 115;
            this.out[1] = ByteRoutines.getLowByte((short)temp);
            this.out[2] = ByteRoutines.getHighByte((short)temp);
            this.dataSocket.getOutputStream().write(this.out, 0, 3);
            this.setPoint = new Double(tempCelsius);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            this.logger.fine("Detector's set-point temperature set to " + temp);
            return;
        }
    }

    public Double getDetectorSetPointCelsius() {
        return this.setPoint;
    }

    public double getSetPointMinimumCelsius() {
        return -40.0;
    }

    public double getSetPointMaximumCelsius() {
        return 25.0;
    }

    public double getSetPointIncrementCelsius() {
        return 0.1;
    }

    private double countsToDegreesCelsius(int counts) {
        return (double)counts / 10.0;
    }

    public boolean isSaveTECStateEnabled() {
        return this.saveTECStateEnabled;
    }

    public void saveTECState() throws IOException {
        if (!this.saveTECStateEnabled || this.productID != 4120) {
            return;
        }
        this.persistTECState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void persistTECState() throws IOException {
        if (this.productID != 4120) return;
        byte[] tecState = new byte[15];
        short sp = (short)(this.setPoint * 10.0);
        tecState[0] = this.tecEnabled != false ? (byte)1 : 0;
        tecState[1] = this.fanEnabled != false ? (byte)1 : 0;
        tecState[2] = ByteRoutines.getLowByte((short)sp);
        tecState[3] = ByteRoutines.getHighByte((short)sp);
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.out[0] = 6;
            this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)17));
            for (int i = 0; i < tecState.length; ++i) {
                this.out[2 + i] = tecState[i];
            }
            this.dataSocket.getOutputStream().write(this.out, 0, 17);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                this.logger.severe("EEPROM write might not have completed. Please verify.");
                throw new IOException("EEPROM write might not have completed. Please verify.");
            }
            return;
        }
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }
}

