/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.gramsspc;

import com.oceanoptics.omnidriver.gramsspc.GramsSPCLogBlockHeader;
import com.oceanoptics.omnidriver.gramsspc.GramsSPCUtils;

public class GramsSPCLog {
    private byte[] binaryLogBlock;
    private byte[] diskLogBlock;
    private byte[] textLog;
    private GramsSPCLogBlockHeader header;
    private static String __extern__ = "__extern__\n<init>,(B)V\nsetTextLog,(Ljava/lang/String;)V\nsetPrivateMemoryBlock,([B)V\nsetPrivateDiskBlock,([B)V\ngetByteStream,()[B\n";

    public GramsSPCLog(byte version) {
        this.header = new GramsSPCLogBlockHeader(version);
        this.binaryLogBlock = new byte[0];
        this.diskLogBlock = new byte[0];
        this.textLog = new byte[0];
    }

    public void setTextLog(String log) {
        this.textLog = GramsSPCUtils.encodeString(log);
        if (null != this.textLog) {
            this.header.setLogTextSizeBytes(this.textLog.length);
        } else {
            this.header.setLogTextSizeBytes(0);
        }
    }

    public void setPrivateMemoryBlock(byte[] block) {
        this.binaryLogBlock = block;
        if (null != block) {
            this.header.setLogBinaryScratchSize(block.length);
        } else {
            this.header.setLogBinaryScratchSize(0);
        }
    }

    public void setPrivateDiskBlock(byte[] block) {
        this.diskLogBlock = block;
        if (null != block) {
            this.header.setLogDiskScratchSize(block.length);
        } else {
            this.header.setLogDiskScratchSize(0);
        }
    }

    public byte[] getByteStream() {
        byte[] headerBytes = this.header.getByteStream();
        int len = headerBytes.length + this.textLog.length + this.binaryLogBlock.length + this.diskLogBlock.length;
        byte[] bs = new byte[len];
        int offset = 0;
        offset = GramsSPCUtils.addToStream(headerBytes, bs, offset);
        offset = GramsSPCUtils.addToStream(this.binaryLogBlock, bs, offset);
        offset = GramsSPCUtils.addToStream(this.diskLogBlock, bs, offset);
        offset = GramsSPCUtils.addToStream(this.textLog, bs, offset);
        return bs;
    }
}

