/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.gramsspc;

import com.oceanoptics.omnidriver.gramsspc.GramsSPCUtils;

public class GramsSPCLogBlockHeader {
    private byte fileVersion;
    private static final int BASE_LOGSTC_SIZE = 64;
    private int textLengthBytes = 0;
    private byte[] logsizd;
    private byte[] logsizm;
    private byte[] logtxto;
    private byte[] logbins;
    private byte[] logdsks;
    private byte[] logspar;
    private static String __extern__ = "__extern__\n<init>,(B)V\nsetLogTextSizeBytes,(I)V\ngetLogSizeOnDisk,()I\ngetLogSizeInMemory,()I\ngetLogTextOffset,()I\ngetLogBinaryScratchSize,()I\nsetLogBinaryScratchSize,(I)V\ngetLogDiskScratchSize,()I\nsetLogDiskScratchSize,(I)V\ngetByteStream,()[B\n";

    public GramsSPCLogBlockHeader(byte version) {
        this.fileVersion = version;
        this.logsizd = new byte[4];
        this.logsizm = new byte[4];
        this.logtxto = new byte[4];
        this.logbins = new byte[4];
        this.logdsks = new byte[4];
        this.logspar = new byte[44];
    }

    public void setLogTextSizeBytes(int bytes) {
        this.textLengthBytes = bytes;
        this.updateOffsets();
    }

    protected void updateOffsets() {
        int totalBytes = 64 + this.getLogBinaryScratchSize() + this.getLogDiskScratchSize() + this.textLengthBytes;
        this.setLogSizeOnDisk(totalBytes);
        int pages = totalBytes / 4096;
        this.setLogSizeInMemory((pages + 1) * 4096);
        this.setLogTextOffset(64 + this.getLogBinaryScratchSize() + this.getLogDiskScratchSize());
    }

    public int getLogSizeOnDisk() {
        return GramsSPCUtils.decodeInteger32(this.logsizd, this.fileVersion);
    }

    protected void setLogSizeOnDisk(int size) {
        this.logsizd = GramsSPCUtils.encodeInteger32(size, this.fileVersion);
    }

    public int getLogSizeInMemory() {
        return GramsSPCUtils.decodeInteger32(this.logsizm, this.fileVersion);
    }

    protected void setLogSizeInMemory(int size) {
        this.logsizm = GramsSPCUtils.encodeInteger32(size, this.fileVersion);
    }

    public int getLogTextOffset() {
        return GramsSPCUtils.decodeInteger32(this.logtxto, this.fileVersion);
    }

    protected void setLogTextOffset(int offset) {
        this.logtxto = GramsSPCUtils.encodeInteger32(offset, this.fileVersion);
    }

    public int getLogBinaryScratchSize() {
        return GramsSPCUtils.decodeInteger32(this.logbins, this.fileVersion);
    }

    public void setLogBinaryScratchSize(int size) {
        this.logbins = GramsSPCUtils.encodeInteger32(size, this.fileVersion);
        this.updateOffsets();
    }

    public int getLogDiskScratchSize() {
        return GramsSPCUtils.decodeInteger32(this.logdsks, this.fileVersion);
    }

    public void setLogDiskScratchSize(int size) {
        this.logdsks = GramsSPCUtils.encodeInteger32(size, this.fileVersion);
        this.updateOffsets();
    }

    public byte[] getByteStream() {
        byte[] bs = new byte[64];
        int offset = 0;
        offset = GramsSPCUtils.addToStream(this.logsizd, bs, offset);
        offset = GramsSPCUtils.addToStream(this.logsizm, bs, offset);
        offset = GramsSPCUtils.addToStream(this.logtxto, bs, offset);
        offset = GramsSPCUtils.addToStream(this.logbins, bs, offset);
        offset = GramsSPCUtils.addToStream(this.logdsks, bs, offset);
        offset = GramsSPCUtils.addToStream(this.logspar, bs, offset);
        return bs;
    }
}

