/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.plugin;

import com.oceanoptics.omnidriver.features.currentout.CurrentOut;
import com.oceanoptics.omnidriver.features.currentout.CurrentOutGUIProvider;
import com.oceanoptics.omnidriver.features.currentout.CurrentOutImpl_LS450;
import com.oceanoptics.omnidriver.features.externaltemperature.ExternalTemperature;
import com.oceanoptics.omnidriver.features.externaltemperature.ExternalTemperatureGUIProvider;
import com.oceanoptics.omnidriver.features.externaltemperature.ExternalTemperatureImpl_LS450;
import com.oceanoptics.omnidriver.features.externaltemperature.ExternalTemperatureImpl_LS450_2000;
import com.oceanoptics.omnidriver.features.externaltemperature.ExternalTemperatureImpl_LS450_4000;
import com.oceanoptics.omnidriver.features.ls450functions.LS450_Functions;
import com.oceanoptics.omnidriver.features.ls450functions.LS450_FunctionsGUIProvider;
import com.oceanoptics.omnidriver.features.ls450functions.LS450_FunctionsImpl_2000;
import com.oceanoptics.omnidriver.features.ls450functions.LS450_FunctionsImpl_4000;
import com.oceanoptics.omnidriver.interfaces.FeatureProvider;
import com.oceanoptics.omnidriver.interfaces.GUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.plugin.LS450Coefficients;
import com.oceanoptics.omnidriver.plugin.SpectrometerPlugIn;
import com.oceanoptics.omnidriver.spectrometer.USBSpectrometer;
import com.oceanoptics.omnidriver.spectrometer.usb2000.USB2000;
import com.oceanoptics.omnidriver.spectrometer.usb2000plus.USB2000Plus;
import com.oceanoptics.omnidriver.spectrometer.usb4000.USB4000;
import com.oceanoptics.omnidriver.spectrometer.usb650.USB650;
import java.io.IOException;

public class USB_LS450
extends SpectrometerPlugIn
implements CurrentOut,
ExternalTemperature,
FeatureProvider,
LS450_Functions {
    private LS450Coefficients ls450Coefficients;
    private LS450_FunctionsGUIProvider ls450Functions;
    private CurrentOutGUIProvider currentOut;
    private ExternalTemperatureGUIProvider extTemp;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/spectrometer/USBSpectrometer;Lcom/oceanoptics/omnidriver/interfaces/USBInterface;)V\ngetGUIFeatures,()[Lcom/oceanoptics/omnidriver/interfaces/GUIProvider;\ntoString,()Ljava/lang/String;\nsetLEDMode,(Z)V\ngetLS450Coefficients,()Lcom/oceanoptics/omnidriver/plugin/LS450Coefficients;\nsetLS450Coefficients,(Lcom/oceanoptics/omnidriver/plugin/LS450Coefficients;)V\nsetLS450Info,(ILjava/lang/String;)V\ngetLS450Info,(I)Ljava/lang/String;\nsaveInfo,()V\nloadInfo,()V\nsetAllLS450Info,(Lcom/oceanoptics/omnidriver/plugin/LS450Coefficients;)V\ngetAllLS450Info,()Lcom/oceanoptics/omnidriver/plugin/LS450Coefficients;\nloadLS450CoefficientsFromEEPROM,()V\ngetO2ProbeCalibrationCoefficients,()[D\nsetO2ProbeCalibrationCoefficients,([D)V\nsetDACCounts,(I)V\nanalogOutCountsToMilliamps,(I)D\ngetDACMinimum,()I\ngetDACMaximum,()I\ngetDACIncrement,()I\ngetDACCounts,()Ljava/lang/Integer;\ngetExternalTemperatureCelsius,()D\n";

    public USB_LS450(USBSpectrometer spectrometer, USBInterface usbInt) throws IOException {
        super(spectrometer, 2);
        if (spectrometer instanceof USB2000 && spectrometer.getFirmwareVersionNumber() < this.makeVersion(2, 0, 0)) {
            throw new UnsupportedOperationException("Firmware must be greater than 2.00.00");
        }
        this.initFeatures(usbInt, spectrometer);
        this.ls450Coefficients = new LS450Coefficients();
    }

    private void initFeatures(USBInterface usb, USBSpectrometer spectrometer) throws IOException {
        if (spectrometer instanceof USB2000 || spectrometer instanceof USB650) {
            this.ls450Functions = new LS450_FunctionsImpl_2000(usb, this);
            this.extTemp = new ExternalTemperatureImpl_LS450_2000(usb, this.ls450Functions);
            this.currentOut = new CurrentOutImpl_LS450(usb, ((ExternalTemperatureImpl_LS450)this.extTemp).getDataOutEndPoint());
        } else if (spectrometer instanceof USB4000 || spectrometer instanceof USB2000Plus) {
            this.ls450Functions = new LS450_FunctionsImpl_4000(usb, this);
            this.extTemp = new ExternalTemperatureImpl_LS450_4000(usb, this.ls450Functions);
            this.currentOut = new CurrentOutImpl_LS450(usb, ((ExternalTemperatureImpl_LS450)this.extTemp).getDataOutEndPoint());
        }
    }

    public GUIProvider[] getGUIFeatures() {
        return new GUIProvider[]{this.ls450Functions, this.currentOut, this.extTemp};
    }

    public String toString() {
        return "USB-LS450\n\n\tLS-450 Coefficients: " + this.ls450Coefficients;
    }

    public void setLEDMode(boolean pulsed) throws IOException {
        this.ls450Functions.setLEDMode(pulsed);
    }

    public LS450Coefficients getLS450Coefficients() {
        return this.ls450Functions.getLS450Coefficients();
    }

    public void setLS450Coefficients(LS450Coefficients coeffs) {
        this.ls450Functions.setLS450Coefficients(coeffs);
    }

    public void setLS450Info(int index, String str) throws IOException {
        this.ls450Functions.setLS450Info(index, str);
    }

    public String getLS450Info(int index) throws IOException {
        return this.ls450Functions.getLS450Info(index);
    }

    public void saveInfo() throws IOException {
        this.ls450Functions.saveInfo();
    }

    public void loadInfo() throws IOException {
        this.ls450Functions.loadInfo();
    }

    public void setAllLS450Info(LS450Coefficients ls450Coefficients) throws IOException {
        this.ls450Functions.setAllLS450Info(ls450Coefficients);
    }

    public LS450Coefficients getAllLS450Info() throws IOException {
        return this.ls450Functions.getAllLS450Info();
    }

    public void loadLS450CoefficientsFromEEPROM() throws IOException {
        this.ls450Functions.loadLS450CoefficientsFromEEPROM();
    }

    public double[] getO2ProbeCalibrationCoefficients() {
        return this.ls450Functions.getO2ProbeCalibrationCoefficients();
    }

    public void setO2ProbeCalibrationCoefficients(double[] coefficients) {
        this.ls450Functions.setO2ProbeCalibrationCoefficients(coefficients);
    }

    public void setDACCounts(int counts) throws IOException {
        this.currentOut.setDACCounts(counts);
    }

    public double analogOutCountsToMilliamps(int counts) {
        return this.currentOut.analogOutCountsToMilliamps(counts);
    }

    public int getDACMinimum() {
        return this.currentOut.getDACMinimum();
    }

    public int getDACMaximum() {
        return this.currentOut.getDACMaximum();
    }

    public int getDACIncrement() {
        return this.currentOut.getDACIncrement();
    }

    public Integer getDACCounts() {
        return this.currentOut.getDACCounts();
    }

    public double getExternalTemperatureCelsius() throws IOException {
        return this.extTemp.getExternalTemperatureCelsius();
    }
}

