/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectra;

import com.oceanoptics.highrestiming.HighResTimeStamp;

public class AnnotatedSpectrum {
    private double[] pixels;
    private double[] wavelengths;
    private boolean isSaturated;
    private int integrationTime;
    private boolean isStrobeEnabled;
    private HighResTimeStamp timestamp;
    private int boxcarWidth;
    private int scansToAverage;
    private boolean correctForElectricalDark;
    private boolean correctForNonLinearity;
    private boolean correctForStrayLight;
    private boolean rotationEnabled;
    private String spectrometerSerialNumber;
    private int channelNumber;
    private String userName;
    private static String __extern__ = "__extern__\n<init>,([D[DZIZLcom/oceanoptics/highrestiming/HighResTimeStamp;IIZZZZLjava/lang/String;ILjava/lang/String;)V\ngetBoxcarWidth,()I\ngetChannelNumber,()I\ngetChannelWavelengths,()[D\ngetCorrectForElectricalDark,()Z\ngetCorrectForNonLinearity,()Z\ngetCorrectForStrayLight,()Z\nisSaturated,()Z\nisStrobeEnabled,()Z\ngetPixelValues,()[D\ngetAcquisitionTime,()Lcom/oceanoptics/highrestiming/HighResTimeStamp;\ngetIntegrationTime,()I\ngetScansToAverage,()I\ngetSpectrometerSerialNumber,()Ljava/lang/String;\ngetUserName,()Ljava/lang/String;\n";

    public AnnotatedSpectrum(double[] pixelArrayArgument, double[] wavelengthArrayArgument, boolean isSaturatedArgument, int integrationTimeArgument, boolean isStrobeEnabledArgument, HighResTimeStamp timestampArgument, int boxcarWidthArgument, int scansToAverageArgument, boolean correctForElectricalDarkArgument, boolean correctForNonLinearityArgument, boolean correctForStrayLightArgument, boolean rotationEnabledArgument, String spectrometerSerialNumberArgument, int channelNumberArgument, String userNameArgument) {
        int index;
        this.pixels = new double[pixelArrayArgument.length];
        for (index = 0; index < this.pixels.length; ++index) {
            this.pixels[index] = pixelArrayArgument[index];
        }
        this.wavelengths = new double[wavelengthArrayArgument.length];
        for (index = 0; index < this.wavelengths.length; ++index) {
            this.wavelengths[index] = wavelengthArrayArgument[index];
        }
        this.isSaturated = isSaturatedArgument;
        this.integrationTime = integrationTimeArgument;
        this.isStrobeEnabled = isStrobeEnabledArgument;
        this.timestamp = new HighResTimeStamp(timestampArgument);
        this.boxcarWidth = boxcarWidthArgument;
        this.scansToAverage = scansToAverageArgument;
        this.correctForElectricalDark = correctForElectricalDarkArgument;
        this.correctForNonLinearity = correctForNonLinearityArgument;
        this.correctForStrayLight = correctForStrayLightArgument;
        this.rotationEnabled = rotationEnabledArgument;
        this.spectrometerSerialNumber = new String(spectrometerSerialNumberArgument);
        this.channelNumber = channelNumberArgument;
        this.userName = new String(userNameArgument);
    }

    public int getBoxcarWidth() {
        return this.boxcarWidth;
    }

    public int getChannelNumber() {
        return this.channelNumber;
    }

    public double[] getChannelWavelengths() {
        return this.wavelengths;
    }

    public boolean getCorrectForElectricalDark() {
        return this.correctForElectricalDark;
    }

    public boolean getCorrectForNonLinearity() {
        return this.correctForNonLinearity;
    }

    public boolean getCorrectForStrayLight() {
        return this.correctForStrayLight;
    }

    public boolean isSaturated() {
        return this.isSaturated;
    }

    public boolean isStrobeEnabled() {
        return this.isStrobeEnabled;
    }

    public double[] getPixelValues() {
        return this.pixels;
    }

    public HighResTimeStamp getAcquisitionTime() {
        return this.timestamp;
    }

    public int getIntegrationTime() {
        return this.integrationTime;
    }

    public int getScansToAverage() {
        return this.scansToAverage;
    }

    public String getSpectrometerSerialNumber() {
        return this.spectrometerSerialNumber;
    }

    public String getUserName() {
        return this.userName;
    }
}

