/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer;

import com.oceanoptics.omnidriver.interfaces.BaseSpecFunctionality;
import com.oceanoptics.omnidriver.interfaces.FeatureProvider;
import com.oceanoptics.omnidriver.interfaces.SpectrumProducer;
import com.oceanoptics.omnidriver.spectra.SpectrometerInfo;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.Configuration;
import com.oceanoptics.omnidriver.spectrometer.RawData;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerChannel;
import com.oceanoptics.omnidriver.spectrometer.SpectrumProducerBase;
import com.oceanoptics.utilities.FileVersion;
import java.io.IOException;
import java.util.LinkedList;
import java.util.logging.Logger;

public abstract class Spectrometer
extends SpectrumProducerBase
implements SpectrumProducer,
BaseSpecFunctionality,
FeatureProvider {
    protected int integrationTimeMinimum = 0;
    protected int integrationTimeMaximum = 0;
    protected int integrationTimeIncrement = 0;
    protected int integrationTimeBase = 0;
    protected int integrationTime = -1;
    protected Boolean strobeOn = Boolean.FALSE;
    protected boolean stabilityScan = true;
    protected SpectrometerInfo spectrumBase = null;
    protected int numberOfCCDPixels = -1;
    protected int numberOfDarkCCDPixels;
    protected byte[] rawData;
    protected Spectrum tempSpectrum;
    protected Spectrum tempRawSpectrum;
    protected int maxIntensity;
    protected int pipeSize;
    protected int benchSlot = -1;
    protected int spectrometerConfigSlot = -1;
    protected int detectorSerialNumberSlot = -1;
    protected int cpldVersionSlot = -1;
    protected String firmwareVersion;
    protected int firmwareVersionNumber;
    protected String firmwareVersionString = null;
    protected Logger logger;
    protected Configuration configuration;
    public SpectrometerChannel[] channels;
    protected int numChannels = 1;
    protected int enabledChannels = 1;
    protected int channelIndex = 0;
    protected boolean strobeDelayEnabled = false;
    protected int[] channelIndices = new int[this.numChannels];
    public boolean rotatorEnabled;
    protected LinkedList formattingQueue = new LinkedList();
    FormattingThread formattingThread;
    private static String __extern__ = "__extern__\nopenSpectrometer,(I)V\n<init>,()V\ngetSpectrumReadThrottleMilliseconds,()I\nsetSpectrumReadThrottleMilliseconds,(I)V\ngetSocketTimeoutMilliseconds,()I\nsetSocketTimeoutMilliseconds,(I)V\nisCheckForBytesAvailableEnabled,()Z\nsetCheckForBytesAvailable,(Z)V\ngetReadSpectrumRetryLimit,()I\nsetReadSpectrumRetryLimit,(I)V\nallowWriteToEEPROM,(II)Z\ngetSpectrumBase,()Lcom/oceanoptics/omnidriver/spectra/SpectrometerInfo;\nsetStabilityScan,(Z)V\nisStabilityScan,()Z\ngetIntegrationTimeMinimum,()I\ngetIntegrationTimeMaximum,()I\ngetIntegrationTimeIncrement,()I\ngetIntegrationTimeBase,()I\ngetActualIntegrationTime,()I\ngetChannels,()[Lcom/oceanoptics/omnidriver/spectrometer/SpectrometerChannel;\ngetNumberOfChannels,()I\ngetNumberOfEnabledChannels,()I\ngetChannelIndices,()[I\nisNetworkSpectrometer,()Z\nisRotatorEnabled,()Z\nsetRotatorEnabled,(Z)V\ngetBenchSlot,()I\ngetSpectrometerConfigSlot,()I\ngetDetectorSerialNumberSlot,()I\ngetCPLDVersionSlot,()I\ngetConfiguration,()Lcom/oceanoptics/omnidriver/spectrometer/Configuration;\ngetConfiguration,(I)Lcom/oceanoptics/omnidriver/spectrometer/Configuration;\ngetConfigurationFromSpectrometer,()V\nsetConfiguration,()V\ngetNewCoefficients,(I)Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\ngetCoefficientsFromSpectrometer,()V\nsetCoefficients,()V\ngetFirmwareVersionNumber,()I\ngetCodeVersion,(Ljava/lang/String;)Ljava/lang/String;\ngetMaxIntensity,()I\nisStrobeDelayEnabled,()Z\nclose,()V\n";

    public abstract void openSpectrometer(int var1) throws IOException;

    public Spectrometer() throws IOException {
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    public int getSpectrumReadThrottleMilliseconds() {
        return 0;
    }

    public void setSpectrumReadThrottleMilliseconds(int value) {
    }

    public int getSocketTimeoutMilliseconds() {
        return 0;
    }

    public void setSocketTimeoutMilliseconds(int value) {
    }

    public boolean isCheckForBytesAvailableEnabled() {
        return false;
    }

    public void setCheckForBytesAvailable(boolean value) {
    }

    public int getReadSpectrumRetryLimit() {
        return 0;
    }

    public void setReadSpectrumRetryLimit(int value) {
    }

    public boolean allowWriteToEEPROM(int privilegeLevel, int slot) {
        if (slot < 0) {
            return false;
        }
        if (privilegeLevel == 0) {
            return true;
        }
        if (privilegeLevel == 1) {
            if (slot == 0) {
                return false;
            }
            return slot <= 14;
        }
        return false;
    }

    protected void finishConstruction() throws IOException {
        if (this.numberOfPixels < 0) {
            this.numberOfPixels = this.numberOfCCDPixels;
            this.numberOfDarkPixels = this.numberOfDarkCCDPixels;
        }
    }

    public SpectrometerInfo getSpectrumBase() {
        return this.spectrumBase;
    }

    public void setStabilityScan(boolean on) {
        this.stabilityScan = on;
    }

    public boolean isStabilityScan() {
        return this.stabilityScan;
    }

    public int getIntegrationTimeMinimum() {
        return this.integrationTimeMinimum;
    }

    public int getIntegrationTimeMaximum() {
        return this.integrationTimeMaximum;
    }

    public int getIntegrationTimeIncrement() {
        return this.integrationTimeIncrement;
    }

    public int getIntegrationTimeBase() {
        return this.integrationTimeBase;
    }

    public int getActualIntegrationTime() {
        return this.integrationTime;
    }

    public SpectrometerChannel[] getChannels() {
        this.logger.fine("Channels: " + this.channels);
        return this.channels;
    }

    public int getNumberOfChannels() {
        this.logger.fine("Number of Channels: " + this.numChannels);
        return this.numChannels;
    }

    public int getNumberOfEnabledChannels() {
        this.logger.fine("Number of enabled Channels: " + this.enabledChannels);
        return this.enabledChannels;
    }

    public int[] getChannelIndices() {
        if (1 == this.numChannels) {
            this.channelIndices[0] = 0;
        }
        return this.channelIndices;
    }

    public boolean isNetworkSpectrometer() {
        return false;
    }

    public boolean isRotatorEnabled() {
        return this.rotatorEnabled;
    }

    public void setRotatorEnabled(boolean rotator) {
        this.rotatorEnabled = rotator;
    }

    public int getBenchSlot() {
        this.logger.fine("Bench slot: " + this.benchSlot);
        return this.benchSlot;
    }

    public int getSpectrometerConfigSlot() {
        this.logger.fine("Spectrometer configuration slot: " + this.spectrometerConfigSlot);
        return this.spectrometerConfigSlot;
    }

    public int getDetectorSerialNumberSlot() {
        this.logger.fine("Detector serial number: " + this.detectorSerialNumberSlot);
        return this.detectorSerialNumberSlot;
    }

    public int getCPLDVersionSlot() {
        this.logger.fine("CPLD version slot: " + this.cpldVersionSlot);
        return this.cpldVersionSlot;
    }

    public Configuration getConfiguration() throws IOException {
        return this.configuration;
    }

    public Configuration getConfiguration(int channelIndex) {
        return this.configuration;
    }

    protected void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void getConfigurationFromSpectrometer() throws IOException {
        this.configuration.getConfigurationFromSpectrometer();
    }

    public void setConfiguration() throws IOException {
        this.configuration.setConfigurationToSpectrometer();
    }

    public Coefficients getNewCoefficients(int index) {
        return new Coefficients();
    }

    public void getCoefficientsFromSpectrometer() throws IOException {
        for (int i = 0; i < this.channels.length; ++i) {
            if (null == this.channels[i]) continue;
            this.channels[i].getCoefficientsFromSpectrometer();
        }
    }

    public void setCoefficients() throws IOException {
        for (int i = 0; i < this.channels.length; ++i) {
            this.channels[i].setCoefficients();
        }
    }

    public int getFirmwareVersionNumber() {
        this.logger.finer("Firmware version number: " + this.firmwareVersionNumber);
        return this.firmwareVersionNumber;
    }

    private String getFirmwareVersionString() {
        this.logger.finer("Firmware version string: " + this.firmwareVersionString);
        return this.firmwareVersionString;
    }

    protected void parseFirmwareVersion(String fw) {
        this.logger.finest("Parsing firmware...");
        int v1 = 0;
        int v2 = 0;
        int v3 = 0;
        String v4 = null;
        String temp = fw.substring(this.firmwareVersion.indexOf(" ") + 1).trim();
        String[] strArr = temp.split("[.]", 3);
        if (strArr.length == 3) {
            try {
                v1 = Integer.parseInt(strArr[0]);
                v2 = Integer.parseInt(strArr[1]);
            }
            catch (NumberFormatException ne) {
                // empty catch block
            }
            for (int i = 0; i < strArr[2].length(); ++i) {
                try {
                    v3 += Integer.parseInt(strArr[2].substring(i, i + 1));
                    continue;
                }
                catch (NumberFormatException ne) {
                    v4 = v4 + strArr[2].substring(i, i + 1);
                }
            }
        }
        this.firmwareVersionNumber = this.makeVersionNumber(v1, v2, v3);
        if (this.firmwareVersionString != null) {
            this.firmwareVersionString = this.makeVersionString(v1, v2, v3, v4);
        }
    }

    protected int makeVersionNumber(int v1, int v2, int v3) {
        this.logger.finest("Making version number...");
        return v1 * 1000000 + v2 * 1000 + v3;
    }

    protected String makeVersionString(int v1, int v2, int v3, String v4) {
        this.logger.finest("Making version string.");
        String version = String.valueOf(v1 * 1000000 + v2 * 1000 + v3) + v4;
        return version;
    }

    public String getCodeVersion(String fileName) {
        this.logger.finer("Code version: " + FileVersion.getFileVersion((String)fileName));
        return FileVersion.getFileVersion((String)fileName);
    }

    public int getMaxIntensity() {
        return this.maxIntensity;
    }

    public boolean isStrobeDelayEnabled() {
        return this.strobeDelayEnabled;
    }

    public void close() throws IOException {
    }

    protected abstract Spectrum formatData(byte[] var1, Spectrum var2) throws IOException;

    protected void fireSpectrumToChannel(int channel, Spectrum spectrum) {
        this.channels[channel].newSpectrum(spectrum);
    }

    protected class FormattingThread
    extends Thread {
        public volatile boolean quit;

        public FormattingThread(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            RawData rawData = null;
            Spectrum spectrum = null;
            while (!this.quit) {
                LinkedList linkedList = Spectrometer.this.formattingQueue;
                synchronized (linkedList) {
                    while (Spectrometer.this.formattingQueue.isEmpty()) {
                        try {
                            Spectrometer.this.formattingQueue.wait();
                            if (!this.quit) continue;
                            break;
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                }
                if (this.quit || (rawData = (RawData)Spectrometer.this.formattingQueue.removeFirst()) == null) continue;
                spectrum = Spectrometer.this.getUnfilledSpectrum();
                try {
                    Spectrometer.this.formatData(rawData.getData(), spectrum);
                }
                catch (IOException e) {
                    Spectrometer.this.logger.fine("Lost sync");
                }
                int channel = rawData.getRequestingChannel();
                Spectrometer.this.fireSpectrumToChannel(channel, spectrum);
                rawData = null;
            }
            Spectrometer.this.logger.fine("Formatting thread stopped.");
        }

        public void quit() {
            this.quit = true;
            try {
                this.interrupt();
                Spectrometer.this.formattingQueue.notifyAll();
                this.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

