/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer;

import com.oceanoptics.omnidriver.features.multichannelprovider.MultiChannelProvider;
import com.oceanoptics.omnidriver.interfaces.SpectrumProducer;
import com.oceanoptics.omnidriver.spectra.SpectrometerChannelInfo;
import com.oceanoptics.omnidriver.spectra.SpectrometerInfo;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrumHandler;
import com.oceanoptics.omnidriver.spectrometer.USBSpectrometer;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SpectrometerChannel
extends SpectrumHandler
implements SpectrumProducer {
    protected Spectrometer spectrometer;
    protected Coefficients coefficients;
    protected long pollingInterval;
    protected double[] wavelengths;
    protected SpectrometerChannelInfo spectrometerChannelInfo;
    protected int channelIndex;
    protected double laserWavelength;
    protected boolean interlock = true;
    protected Logger logger;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/spectrometer/Spectrometer;Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;I)V\ngenerateMetadata,(Lcom/oceanoptics/omnidriver/spectra/SpectrometerInfo;I)V\ngetCoefficients,()Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetCoefficients,(Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetChannelIndex,()I\nforceCoefficientsForArcoptix,()V\ngetCoefficientsFromSpectrometer,()V\nsetCoefficients,()V\nsetWavelengthCalibration,()V\nsetStrayLightCorrection,()V\nsetNonlinearityCoefficients,()V\ngetWavelength,(I)D\ngetAllWavelengths,()[D\ngetAllStoredWavelengths,()[D\ngetNumberOfRawPixels,()I\ngetPixel,(D)I\ngetStartingWavelength,()D\ngetEndingWavelength,()D\ngetSpectrometer,()Lcom/oceanoptics/omnidriver/spectrometer/Spectrometer;\ngetSpectrum,()Lcom/oceanoptics/omnidriver/spectra/Spectrum;\ngetSpectrumRaw,()Lcom/oceanoptics/omnidriver/spectra/Spectrum;\ngetSpectrum,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)Lcom/oceanoptics/omnidriver/spectra/Spectrum;\ngetSpectrumRaw,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)Lcom/oceanoptics/omnidriver/spectra/Spectrum;\ngetMaxIntensity,()I\ngetLaserWavelength,()D\nsetLaserWavelength,(D)V\nisInterlock,()Z\nsetInterlock,(Z)V\nnewSpectrum,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)V\ngetSpectrometerChannelInfo,()Lcom/oceanoptics/omnidriver/spectra/SpectrometerChannelInfo;\nsetSpectrometerChannelInfoCoefficients,(Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetPollingInterval,()J\nsetPollingInterval,(J)V\nisPolling,()Z\nsetPolling,(Z)V\n";

    public SpectrometerChannel(Spectrometer spectrometer, Coefficients coefficients, int index) throws IOException {
        this.spectrometer = spectrometer;
        this.coefficients = coefficients;
        this.channelIndex = index;
        this.setSource(spectrometer);
        this.setPixels();
        this.logger = Logger.getLogger("com.oceanoptics");
        this.logger.setLevel(Level.WARNING);
    }

    protected void setPixels() {
        if (this.numberOfPixels < 0) {
            this.numberOfPixels = this.spectrometer.numberOfCCDPixels;
            this.numberOfDarkPixels = this.spectrometer.numberOfDarkCCDPixels;
        }
    }

    public void generateMetadata(SpectrometerInfo sb, int index) {
        this.wavelengths = this.getAllWavelengths();
        this.spectrometerChannelInfo = new SpectrometerChannelInfo(sb, this.wavelengths, index, false, this.getCoefficients(), this.getLaserWavelength(), this.isInterlock(), this.numberOfPixels, this.numberOfDarkPixels);
    }

    public Coefficients getCoefficients() {
        return this.coefficients;
    }

    public void setCoefficients(Coefficients c) {
        this.coefficients = c;
    }

    public int getChannelIndex() {
        return this.channelIndex;
    }

    public void forceCoefficientsForArcoptix() {
        this.coefficients.setWlIntercept(0.0);
        this.coefficients.setWlFirst(1.0);
        this.coefficients.setWlSecond(0.0);
        this.coefficients.setWlThird(0.0);
        this.coefficients.setStrayLight(0.0);
        this.coefficients.setNlCoef0(0.0);
        this.coefficients.setNlCoef1(0.0);
        this.coefficients.setNlCoef2(0.0);
        this.coefficients.setNlCoef3(0.0);
        this.coefficients.setNlCoef4(0.0);
        this.coefficients.setNlCoef5(0.0);
        this.coefficients.setNlCoef6(0.0);
        this.coefficients.setNlCoef7(0.0);
        this.coefficients.setNlOrder(0);
    }

    public void getCoefficientsFromSpectrometer() throws IOException {
        this.checkMux();
        try {
            this.coefficients.setWlIntercept(Double.parseDouble(this.spectrometer.getInfo(1)));
            this.coefficients.setWlFirst(Double.parseDouble(this.spectrometer.getInfo(2)));
            this.coefficients.setWlSecond(Double.parseDouble(this.spectrometer.getInfo(3)));
            this.coefficients.setWlThird(Double.parseDouble(this.spectrometer.getInfo(4)));
        }
        catch (NumberFormatException nfe) {
            this.coefficients.setWlIntercept(0.0);
            this.coefficients.setWlFirst(1.0);
            this.coefficients.setWlSecond(0.0);
            this.coefficients.setWlThird(0.0);
            this.logger.warning("ERROR: " + nfe.getMessage());
            this.logger.warning("ERROR: cannot read wavelength coefficients from spectrometer. Setting to pixel indices.");
            this.logger.warning("Intercept was [" + this.spectrometer.getInfo(1) + "]");
            this.logger.warning("First was [" + this.spectrometer.getInfo(2) + "]");
            this.logger.warning("Second was [" + this.spectrometer.getInfo(3) + "]");
            this.logger.warning("Third was [" + this.spectrometer.getInfo(4) + "]");
        }
        try {
            if (this.spectrometer instanceof USBSpectrometer) {
                int i;
                USBSpectrometer usbSpec = (USBSpectrometer)this.spectrometer;
                byte[] bytes = usbSpec.getInfoBytes(5);
                String str = new String();
                for (i = 0; i < bytes.length && 0 != bytes[i]; ++i) {
                    str = str + (char)bytes[i];
                }
                if (i < bytes.length - 1 && 0 == bytes[i] && bytes[i + 1] != 0 && bytes[i + 1] != 255) {
                    ++i;
                    str = str + " ";
                    while (i < bytes.length && bytes[i] != 0) {
                        str = str + (char)bytes[i];
                        ++i;
                    }
                }
                if (str.indexOf(32) < 0) {
                    this.coefficients.setStrayLight(Double.parseDouble(str));
                } else {
                    String[] terms = str.split("\\s");
                    this.coefficients.setStrayLight(Double.parseDouble(terms[0]), Double.parseDouble(terms[1]));
                }
            } else {
                String str = this.spectrometer.getInfo(5);
                this.coefficients.setStrayLight(Double.parseDouble(str));
            }
        }
        catch (NumberFormatException nfe) {
            this.logger.info("ERROR: cannot read stray light coefficient from spectrometer. Setting to zero.");
            this.logger.info("Value was [" + this.spectrometer.getInfo(5) + "]");
            this.coefficients.setStrayLight(0.0);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.logger.info("ERROR: cannot read stray light coefficient from spectrometer. Setting to zero.");
            this.logger.info("Value was [" + this.spectrometer.getInfo(5) + "]");
            this.coefficients.setStrayLight(0.0);
        }
        try {
            this.coefficients.setNlCoef0(Double.parseDouble(this.spectrometer.getInfo(6)));
            this.coefficients.setNlCoef1(Double.parseDouble(this.spectrometer.getInfo(7)));
            this.coefficients.setNlCoef2(Double.parseDouble(this.spectrometer.getInfo(8)));
            this.coefficients.setNlCoef3(Double.parseDouble(this.spectrometer.getInfo(9)));
            this.coefficients.setNlCoef4(Double.parseDouble(this.spectrometer.getInfo(10)));
            this.coefficients.setNlCoef5(Double.parseDouble(this.spectrometer.getInfo(11)));
            this.coefficients.setNlCoef6(Double.parseDouble(this.spectrometer.getInfo(12)));
            this.coefficients.setNlCoef7(Double.parseDouble(this.spectrometer.getInfo(13)));
            this.coefficients.setNlOrder(Integer.parseInt(this.spectrometer.getInfo(14)));
        }
        catch (NumberFormatException nfe) {
            System.out.println("ERROR: cannot read nonlinearity coefficients from spectrometer. Setting to zero.");
            System.out.println("Values were: [" + this.spectrometer.getInfo(6) + "] " + "[" + this.spectrometer.getInfo(7) + "] " + "[" + this.spectrometer.getInfo(8) + "] " + "[" + this.spectrometer.getInfo(9) + "] " + "[" + this.spectrometer.getInfo(10) + "] " + "[" + this.spectrometer.getInfo(11) + "] " + "[" + this.spectrometer.getInfo(12) + "] " + "[" + this.spectrometer.getInfo(13) + "] " + "[" + this.spectrometer.getInfo(14) + "]");
            this.coefficients.setNlCoef0(0.0);
            this.coefficients.setNlCoef1(0.0);
            this.coefficients.setNlCoef2(0.0);
            this.coefficients.setNlCoef3(0.0);
            this.coefficients.setNlCoef4(0.0);
            this.coefficients.setNlCoef5(0.0);
            this.coefficients.setNlCoef6(0.0);
            this.coefficients.setNlCoef7(0.0);
            this.coefficients.setNlOrder(0);
        }
    }

    public void setCoefficients() throws IOException {
        this.checkMux();
        this.setWavelengthCalibration();
        this.setStrayLightCorrection();
        this.setNonlinearityCoefficients();
    }

    public void setWavelengthCalibration() throws IOException {
        this.checkMux();
        DecimalFormat format = new DecimalFormat("0.000000E000");
        this.spectrometer.setInfo(1, format.format(this.coefficients.getWlIntercept()));
        this.spectrometer.setInfo(2, format.format(this.coefficients.getWlFirst()));
        this.spectrometer.setInfo(3, format.format(this.coefficients.getWlSecond()));
        this.spectrometer.setInfo(4, format.format(this.coefficients.getWlThird()));
    }

    public void setStrayLightCorrection() throws IOException {
        if (this.coefficients.getStrayLightSlope() == 0.0) {
            DecimalFormat format = new DecimalFormat("0.0########E00");
            this.spectrometer.setInfo(5, format.format(this.coefficients.getStrayLight()));
        } else {
            DecimalFormat format = new DecimalFormat("0.0##E0");
            String intercept = format.format(this.coefficients.getStrayLight());
            String slope = format.format(this.coefficients.getStrayLightSlope());
            String str = intercept + "\u0000" + slope;
            if (str.length() > 16) {
                format = new DecimalFormat("####0");
                intercept = format.format(this.coefficients.getStrayLight());
                str = intercept + "\u0000" + slope;
            }
            this.spectrometer.setInfo(5, str);
        }
    }

    public void setNonlinearityCoefficients() throws IOException {
        this.checkMux();
        this.spectrometer.setInfo(6, Double.toString(this.coefficients.getNlCoef0()));
        this.spectrometer.setInfo(7, Double.toString(this.coefficients.getNlCoef1()));
        this.spectrometer.setInfo(8, Double.toString(this.coefficients.getNlCoef2()));
        this.spectrometer.setInfo(9, Double.toString(this.coefficients.getNlCoef3()));
        this.spectrometer.setInfo(10, Double.toString(this.coefficients.getNlCoef4()));
        this.spectrometer.setInfo(11, Double.toString(this.coefficients.getNlCoef5()));
        this.spectrometer.setInfo(12, Double.toString(this.coefficients.getNlCoef6()));
        this.spectrometer.setInfo(13, Double.toString(this.coefficients.getNlCoef7()));
        this.spectrometer.setInfo(14, Integer.toString(this.coefficients.getNlOrder()));
    }

    public double getWavelength(int pixel) {
        if (pixel < 0 || pixel > this.numberOfPixels) {
            throw new IllegalArgumentException("Pixel must betwen 0 and " + this.numberOfPixels + "; argument was: " + pixel);
        }
        double dp = pixel;
        return this.coefficients.getWlIntercept() + dp * this.coefficients.getWlFirst() + dp * dp * this.coefficients.getWlSecond() + dp * dp * dp * this.coefficients.getWlThird();
    }

    public double[] getAllWavelengths() {
        this.wavelengths = new double[this.numberOfPixels];
        for (int i = 0; i < this.numberOfPixels; ++i) {
            this.wavelengths[i] = this.getWavelength(i);
        }
        return this.wavelengths;
    }

    public double[] getAllStoredWavelengths() {
        return this.wavelengths;
    }

    public int getNumberOfRawPixels() {
        return this.spectrometer.getNumberOfRawPixels();
    }

    public int getPixel(double wl) {
        int i;
        if (wl < this.getWavelength(0) || wl > this.getWavelength(this.spectrometer.getNumberOfPixels() - 1)) {
            throw new IllegalArgumentException("Wavelength must be between 0 and " + this.getWavelength(this.spectrometer.getNumberOfPixels()));
        }
        for (i = 0; this.getWavelength(i) < wl && i < this.spectrometer.getNumberOfPixels(); ++i) {
        }
        return i;
    }

    public double getStartingWavelength() {
        return this.getWavelength(0);
    }

    public double getEndingWavelength() {
        return this.getWavelength(this.numberOfPixels - 1);
    }

    public Spectrometer getSpectrometer() {
        return this.spectrometer;
    }

    public Spectrum getSpectrum() throws IOException {
        this.checkMux();
        return this.pollSourceForSpectrum();
    }

    public Spectrum getSpectrumRaw() throws IOException {
        this.checkMux();
        Spectrum spec = this.pollSourceForSpectrumRaw();
        return spec;
    }

    public Spectrum getSpectrum(Spectrum spectrum) throws IOException {
        this.checkMux();
        return this.pollSourceForSpectrum(spectrum);
    }

    public Spectrum getSpectrumRaw(Spectrum spectrum) throws IOException {
        this.checkMux();
        return this.pollSourceForSpectrumRaw(spectrum);
    }

    public int getMaxIntensity() {
        return this.spectrometer.getMaxIntensity();
    }

    public double getLaserWavelength() {
        return this.laserWavelength;
    }

    public void setLaserWavelength(double laserWavelength) {
        this.laserWavelength = laserWavelength;
    }

    public boolean isInterlock() {
        return this.interlock;
    }

    public void setInterlock(boolean interlock) {
        this.interlock = interlock;
    }

    public void newSpectrum(Spectrum spectrum) {
        this.fireSpectrumToAllListeners(spectrum);
    }

    public SpectrometerChannelInfo getSpectrometerChannelInfo() {
        return this.spectrometerChannelInfo;
    }

    public void setSpectrometerChannelInfoCoefficients(Coefficients coefficients) {
        this.spectrometerChannelInfo.setChannelCoefficients(new Coefficients(coefficients));
        this.spectrometerChannelInfo.setChannelWavelengths(this.getAllWavelengths());
    }

    protected void fixNumberOfPixels() {
        super.fixNumberOfPixels();
    }

    public long getPollingInterval() {
        USBSpectrometer s = (USBSpectrometer)this.spectrometer;
        return s.getPollingInterval(this.channelIndex);
    }

    public void setPollingInterval(long pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    public synchronized boolean isPolling() {
        USBSpectrometer s = (USBSpectrometer)this.spectrometer;
        return s.getPollingInterval(this.channelIndex) >= 0L;
    }

    public synchronized void setPolling(boolean polling) {
        USBSpectrometer s = (USBSpectrometer)this.spectrometer;
        if (polling) {
            s.setPollingInterval(this.channelIndex, this.pollingInterval);
        } else {
            s.setPollingInterval(this.channelIndex, -1L);
        }
    }

    protected void checkMux() throws IOException {
        if (this.spectrometer instanceof MultiChannelProvider) {
            ((MultiChannelProvider)((Object)this.spectrometer)).setChannelMux(this.channelIndex);
        }
    }
}

