/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer;

import com.oceanoptics.omnidriver.interfaces.SpectrumConsumer;
import com.oceanoptics.omnidriver.interfaces.SpectrumProducer;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.SpectrumProducerBase;
import java.io.IOException;
import java.util.Vector;

public abstract class SpectrumHandler
extends SpectrumProducerBase
implements SpectrumConsumer {
    public static final int PROCESS_ALL = 0;
    public static final int PROCESS_ONLY_LATEST = 1;
    public static final int BOUNDED_QUEUE = 2;
    protected transient Vector unprocessedDoubleQueue = new Vector();
    private int maximumQueueSize = 1;
    private int processingMode = 1;
    protected SpectrumProducer doubleSource;
    private static String __extern__ = "__extern__\n<init>,()V\n<init>,(II)V\ngetMaximumQueueSize,()I\nsetMaximumQueueSize,(I)V\ngetProcessingMode,()I\nsetProcessingMode,(I)V\nnewSpectrum,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)V\nsetSource,(Lcom/oceanoptics/omnidriver/interfaces/SpectrumProducer;)V\nremoveSource,(Lcom/oceanoptics/omnidriver/interfaces/SpectrumProducer;)V\n";

    public SpectrumHandler() {
    }

    public SpectrumHandler(int numLightPixels, int numDarkPixels) {
        super(numLightPixels, numDarkPixels);
    }

    public int getMaximumQueueSize() {
        return this.maximumQueueSize;
    }

    public void setMaximumQueueSize(int maximumQueueSize) {
        if (maximumQueueSize < 1) {
            throw new IllegalArgumentException("Maximum queue size must be >= 1.");
        }
        this.maximumQueueSize = maximumQueueSize;
    }

    public int getProcessingMode() {
        return this.processingMode;
    }

    public void setProcessingMode(int processingMode) {
        this.processingMode = processingMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newSpectrum(Spectrum spectrum) {
        Vector vector = this.unprocessedDoubleQueue;
        synchronized (vector) {
            if (this.processingMode == 1) {
                while (!this.unprocessedDoubleQueue.isEmpty()) {
                    this.unprocessedDoubleQueue.remove(0);
                }
            } else if (this.processingMode == 2) {
                Vector vector2 = this.unprocessedDoubleQueue;
                synchronized (vector2) {
                    while (this.unprocessedDoubleQueue.size() >= this.maximumQueueSize) {
                        this.unprocessedDoubleQueue.remove(0);
                    }
                }
            }
            this.unprocessedDoubleQueue.add(spectrum);
            this.unprocessedDoubleQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Spectrum getNextUnprocessedDoubleSpectrum() {
        Spectrum result;
        Vector vector = this.unprocessedDoubleQueue;
        synchronized (vector) {
            while (this.unprocessedDoubleQueue.isEmpty()) {
                try {
                    this.unprocessedDoubleQueue.wait();
                }
                catch (InterruptedException e) {
                    return null;
                }
            }
            result = (Spectrum)this.unprocessedDoubleQueue.remove(0);
        }
        if (!result.isOfSize(this.numberOfPixels, this.numberOfDarkPixels)) {
            this.numberOfPixels = result.getSpectrum().length;
        }
        return result;
    }

    public void setSource(SpectrumProducer producer) {
        if (producer instanceof SpectrumProducer && this instanceof SpectrumConsumer) {
            this.doubleSource = producer;
            this.doubleSource.addSpectrumListener(this);
        } else {
            this.doubleSource = null;
        }
    }

    public void removeSource(SpectrumProducer producer) {
        if (null == producer) {
            return;
        }
        if (producer instanceof SpectrumProducer && this instanceof SpectrumConsumer) {
            producer.removeSpectrumListener(this);
        }
    }

    protected Spectrum pollSourceForSpectrum(Spectrum spectrum) throws IOException {
        return this.doubleSource.getSpectrum(spectrum);
    }

    protected Spectrum pollSourceForSpectrumRaw(Spectrum spectrum) throws IOException {
        return this.doubleSource.getSpectrumRaw(spectrum);
    }

    protected Spectrum pollSourceForSpectrum() throws IOException {
        if (this.doubleSource == null) {
            throw new IllegalStateException("A source for Spectra has not been set.");
        }
        return this.doubleSource.getSpectrum(this.getUnfilledSpectrum());
    }

    protected Spectrum pollSourceForSpectrumRaw() throws IOException {
        if (this.doubleSource == null) {
            throw new IllegalStateException("A source for Spectra has not been set.");
        }
        Spectrum spec = new Spectrum(this.getNumberOfRawPixels(), this.numberOfDarkPixels);
        Spectrum spectrum = this.doubleSource.getSpectrumRaw(spec);
        return spectrum;
    }
}

