/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer;

import com.oceanoptics.omnidriver.interfaces.SpectrumListener;
import com.oceanoptics.omnidriver.interfaces.SpectrumProducer;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import java.util.ArrayList;

public abstract class SpectrumProducerBase
implements SpectrumProducer {
    protected int numberOfPixels = -1;
    protected int numberOfDarkPixels = 0;
    protected transient ArrayList spectrumListenerList;
    private static String __extern__ = "__extern__\n<init>,()V\n<init>,(II)V\naddSpectrumListener,(Lcom/oceanoptics/omnidriver/interfaces/SpectrumListener;)V\nremoveSpectrumListener,(Lcom/oceanoptics/omnidriver/interfaces/SpectrumListener;)V\ngetUnfilledSpectrum,()Lcom/oceanoptics/omnidriver/spectra/Spectrum;\ngetUnfilledSpectrumRaw,()Lcom/oceanoptics/omnidriver/spectra/Spectrum;\ngetUnfilledSpectrum,(II)Lcom/oceanoptics/omnidriver/spectra/Spectrum;\ngetNumberOfPixels,()I\ngetNumberOfRawPixels,()I\ngetNumberOfDarkPixels,()I\n";

    public SpectrumProducerBase() {
    }

    public SpectrumProducerBase(int numPixels, int numDarkPixels) {
        this.numberOfPixels = numPixels;
        this.numberOfDarkPixels = numDarkPixels;
    }

    public synchronized void addSpectrumListener(SpectrumListener listener) {
        if (this.spectrumListenerList == null) {
            this.spectrumListenerList = new ArrayList();
        }
        this.spectrumListenerList.add(listener);
    }

    public synchronized void removeSpectrumListener(SpectrumListener listener) {
        if (this.spectrumListenerList != null) {
            this.spectrumListenerList.remove(listener);
        }
    }

    protected synchronized void fireSpectrumListenerNewSpectrum(Spectrum event) {
        if (this.spectrumListenerList != null) {
            for (int i = 0; i < this.spectrumListenerList.size(); ++i) {
                ((SpectrumListener)this.spectrumListenerList.get(i)).newSpectrum(event);
            }
        }
    }

    protected void fireSpectrumToAllListeners(Spectrum spectrum) {
        this.fireSpectrumListenerNewSpectrum(spectrum);
    }

    public Spectrum getUnfilledSpectrum() {
        return new Spectrum(this.numberOfPixels, this.numberOfDarkPixels);
    }

    public Spectrum getUnfilledSpectrumRaw() {
        return new Spectrum(this.getNumberOfRawPixels(), this.numberOfDarkPixels);
    }

    public Spectrum getUnfilledSpectrum(int pixels, int dark) {
        return new Spectrum(pixels, dark);
    }

    protected void fixNumberOfPixels() {
    }

    public int getNumberOfPixels() {
        return this.numberOfPixels;
    }

    public int getNumberOfRawPixels() {
        return -1;
    }

    public int getNumberOfDarkPixels() {
        return this.numberOfDarkPixels;
    }
}

