/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.adc1000usb;

import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerChannel;
import com.oceanoptics.omnidriver.spectrometer.adc1000usb.ADC1000USB;
import java.io.IOException;

public class ADC1000Channel
extends SpectrometerChannel {
    ADC1000USB adc1000;
    private boolean enabled = true;
    private boolean interpolated;
    private boolean master = false;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/spectrometer/Spectrometer;Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;I)V\ngetCoefficientsFromSpectrometer,()V\nsetCoefficients,()V\nsetWavelengthCalibration,()V\nsetNonlinearityCoefficients,()V\ngetAllWavelengths,()[D\ngetWavelength,(I)D\ngetDeepWellWavelength,(I)D\ngetSpectrum,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)Lcom/oceanoptics/omnidriver/spectra/Spectrum;\ngetSpectrum,()Lcom/oceanoptics/omnidriver/spectra/Spectrum;\nfixNumberOfPixels,()V\nisMaster,()Z\nisEnabled,()Z\nsetEnabled,(Z)V\nisInterpolated,()Z\nsetInterpolated,(Z)V\n";

    public ADC1000Channel(Spectrometer spectrometer, Coefficients coefficients, int channel) throws IOException {
        super(spectrometer, coefficients, channel);
        this.channelIndex = channel;
        this.adc1000 = (ADC1000USB)spectrometer;
        this.setPixels();
        this.fixNumberOfPixels();
        if (0 == this.channelIndex) {
            this.master = true;
        }
    }

    public void getCoefficientsFromSpectrometer() throws IOException {
        try {
            this.coefficients.setWlIntercept(Double.parseDouble(this.spectrometer.getInfo(1 + 1 + this.channelIndex * 4)));
            this.coefficients.setWlFirst(Double.parseDouble(this.spectrometer.getInfo(2 + 1 + this.channelIndex * 4)));
            this.coefficients.setWlSecond(Double.parseDouble(this.spectrometer.getInfo(3 + 1 + this.channelIndex * 4)));
            this.coefficients.setWlThird(Double.parseDouble(this.spectrometer.getInfo(4 + 1 + this.channelIndex * 4)));
        }
        catch (Exception e) {
            this.coefficients.setWlIntercept(0.0);
            this.coefficients.setWlFirst(1.0);
            this.coefficients.setWlSecond(0.0);
            this.coefficients.setWlThird(0.0);
            this.logger.warning("ERROR: " + e.getMessage());
            this.logger.warning("ERROR: cannot read wavelength coefficients from spectrometer. Setting to pixel indices.");
            this.logger.warning("Intercept was [" + this.spectrometer.getInfo(1 + 1 + this.channelIndex * 4) + "]");
            this.logger.warning("First was [" + this.spectrometer.getInfo(2 + 1 + this.channelIndex * 4) + "]");
            this.logger.warning("Second was [" + this.spectrometer.getInfo(3 + 1 + this.channelIndex * 4) + "]");
            this.logger.warning("Third was [" + this.spectrometer.getInfo(4 + 1 + this.channelIndex * 4) + "]");
        }
        this.coefficients.setStrayLight(0.0);
        this.coefficients.setNlCoef0(0.0);
        this.coefficients.setNlCoef1(0.0);
        this.coefficients.setNlCoef2(0.0);
        this.coefficients.setNlCoef3(0.0);
        this.coefficients.setNlCoef4(0.0);
        this.coefficients.setNlCoef5(0.0);
        this.coefficients.setNlCoef6(0.0);
        this.coefficients.setNlCoef7(0.0);
        this.coefficients.setNlOrder(7);
    }

    public void setCoefficients() throws IOException {
        this.setWavelengthCalibration();
    }

    public void setWavelengthCalibration() throws IOException {
        this.spectrometer.setInfo(1 + 1 + this.channelIndex * 4, Double.toString(this.coefficients.getWlIntercept()));
        this.spectrometer.setInfo(2 + 1 + this.channelIndex * 4, Double.toString(this.coefficients.getWlFirst()));
        this.spectrometer.setInfo(3 + 1 + this.channelIndex * 4, Double.toString(this.coefficients.getWlSecond()));
        this.spectrometer.setInfo(4 + 1 + this.channelIndex * 4, Double.toString(this.coefficients.getWlThird()));
    }

    public void setNonlinearityCoefficients() throws IOException {
    }

    public double[] getAllWavelengths() {
        this.wavelengths = new double[this.numberOfPixels];
        if (!this.adc1000.isDeepWell()) {
            for (int i = 0; i < this.numberOfPixels; ++i) {
                this.wavelengths[i] = this.getWavelength(i);
            }
        } else {
            for (int i = 0; i < this.numberOfPixels; ++i) {
                this.wavelengths[i] = this.getDeepWellWavelength(i);
            }
        }
        return this.wavelengths;
    }

    public double getWavelength(int pixel) {
        if (!this.adc1000.isDeepWell()) {
            if (pixel < 0 || pixel > this.numberOfPixels) {
                throw new IllegalArgumentException("Pixel must betwen 0 and " + this.numberOfPixels);
            }
            double dp = pixel;
            if (!this.interpolated && this.adc1000.isRotatorEnabled()) {
                dp *= (double)this.adc1000.getNumberOfEnabledChannels();
            }
            return this.coefficients.getWlIntercept() + dp * this.coefficients.getWlFirst() + dp * dp * this.coefficients.getWlSecond() + dp * dp * dp * this.coefficients.getWlThird();
        }
        return this.getDeepWellWavelength(pixel);
    }

    public double getDeepWellWavelength(int pixel) {
        double dp = pixel * 2;
        if (!this.interpolated && this.adc1000.isRotatorEnabled()) {
            dp *= (double)this.adc1000.getNumberOfEnabledChannels();
        }
        return this.coefficients.getWlIntercept() + dp * this.coefficients.getWlFirst() + dp * dp * this.coefficients.getWlSecond() + dp * dp * dp * this.coefficients.getWlThird();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Spectrum getSpectrum(Spectrum spectrum) throws IOException {
        ADC1000USB aDC1000USB = this.adc1000;
        synchronized (aDC1000USB) {
            if (!this.adc1000.isRotatorEnabled()) {
                this.adc1000.setChannelMux(this.channelIndex);
            }
            return super.getSpectrum(spectrum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Spectrum getSpectrum() throws IOException {
        ADC1000USB aDC1000USB = this.adc1000;
        synchronized (aDC1000USB) {
            if (!this.adc1000.isRotatorEnabled()) {
                this.adc1000.setChannelMux(this.channelIndex);
            }
            return super.getSpectrum(this.getUnfilledSpectrum());
        }
    }

    public void fixNumberOfPixels() {
        int pix = this.adc1000.getNumberOfPixels();
        int dark = this.adc1000.getNumberOfDarkPixels();
        if (!(this.interpolated || this.adc1000.isRotatorEnabled() || this.adc1000.isDeepWell())) {
            this.numberOfPixels = pix;
            this.numberOfDarkPixels = dark;
        } else if (!this.interpolated && !this.adc1000.isRotatorEnabled() && this.adc1000.isDeepWell()) {
            this.numberOfPixels = 1024;
            this.numberOfDarkPixels = 0;
        } else if (!this.interpolated && this.adc1000.isRotatorEnabled() && !this.adc1000.isDeepWell()) {
            pix /= this.adc1000.getNumberOfEnabledChannels();
            dark /= this.adc1000.getNumberOfEnabledChannels();
        } else if (!(this.interpolated && this.adc1000.isRotatorEnabled() && this.adc1000.isDeepWell())) {
            // empty if block
        }
    }

    public boolean isMaster() {
        return this.master;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) throws IOException {
        if (enabled == this.enabled) {
            return;
        }
        this.enabled = enabled;
    }

    public boolean isInterpolated() {
        return this.interpolated;
    }

    public void setInterpolated(boolean interpolated) {
        if (interpolated == this.interpolated) {
            return;
        }
        this.interpolated = interpolated;
        this.fixNumberOfPixels();
    }
}

