/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.arcoptix;

import com.oceanoptics.omnidriver.features.gain.GainGUIProvider;
import com.oceanoptics.omnidriver.features.gain.GainImpl;
import com.oceanoptics.omnidriver.features.gain.GainInterface;
import com.oceanoptics.omnidriver.features.networksource.NetworkSourceGUIProvider;
import com.oceanoptics.omnidriver.features.networksource.NetworkSourceImpl;
import com.oceanoptics.omnidriver.interfaces.GUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectra.SpectrometerInfo;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.Configuration;
import com.oceanoptics.omnidriver.spectrometer.NetworkSpectrometer;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.arcoptix.ArcoptixTransport;
import com.oceanoptics.omnidriver.spectrometer.arcoptix.SpectrometerChannelArcoptix;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;
import java.net.Socket;
import java.util.Vector;

public class ArcoptixNetwork
extends NetworkSpectrometer
implements GainInterface {
    double _saturationRatio;
    static Spectrometer[] scoreboard = new Spectrometer[64];
    private GainGUIProvider gainGUIProvider;
    private NetworkSourceGUIProvider network;
    private ArcoptixTransport _transport;
    private Configuration[] configurations = null;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/spectrometer/arcoptix/ArcoptixTransport;Ljava/lang/String;)V\nopenSpectrometer,(I)V\ngetAddress,()Ljava/lang/String;\ngetPort,()I\nisConnected,()Z\nconnectToSource,(Ljava/lang/String;I)V\ndisconnect,()V\ngetGUIFeatures,()[Lcom/oceanoptics/omnidriver/interfaces/GUIProvider;\ngetDataSocket,()Ljava/net/Socket;\ngetSerialNumber,()Ljava/lang/String;\ngetFirmwareVersion,()Ljava/lang/String;\ngetGain,()I\nsetGain,(I)V\ncloseSpectrometer,()V\ngetInfo,(I)Ljava/lang/String;\ngetName,()Ljava/lang/String;\ngetNumberOfChannels,()I\ngetNumberOfEnabledChannels,()I\nsetStrobeEnable,(Z)V\nsetIntegrationTime,(I)V\ngetSpectrum,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)Lcom/oceanoptics/omnidriver/spectra/Spectrum;\nreconnect,()V\ngetChannelConfigurations,()[Lcom/oceanoptics/omnidriver/spectrometer/Configuration;\ngetConfiguration,(I)Lcom/oceanoptics/omnidriver/spectrometer/Configuration;\n";

    public ArcoptixNetwork(ArcoptixTransport transport, String serialNumber) throws IOException {
        this._transport = transport;
        if (!this._transport.isConnected()) {
            throw new IOException("Socket is not connected");
        }
        this.address = this._transport.getIPAddress();
        this.port = this._transport.getPort();
        boolean success = this.claimSpectrometerBySerialNumber(serialNumber);
        if (!success) {
            throw new IOException("Unable to claim spectrometer");
        }
        this.openSpectrometer(0);
    }

    protected Spectrometer[] getScoreboard() {
        return scoreboard;
    }

    public void openSpectrometer(int indexNotUsed) throws IOException {
        this.integrationTimeMinimum = 3000;
        this.integrationTimeMaximum = 65535000;
        this.integrationTimeIncrement = 1000;
        this.integrationTimeBase = 1;
        this.numberOfCCDPixels = this._transport.getTotalNumberOfPixels();
        this.numberOfDarkCCDPixels = 0;
        this.maxIntensity = this._transport.getMaximumIntensity();
        this.rawData = new byte[this.numberOfCCDPixels * 2];
        this.channels = new SpectrometerChannelArcoptix[1];
        this.channels[this.channelIndex] = new SpectrometerChannelArcoptix(this, this._transport, new Coefficients(), this.channelIndex);
        this.numChannels = this.channels.length;
        this.logger.fine("Arcoptix network spectrometer has been opened at index " + indexNotUsed);
        this.initFeatures(this.usb);
        this.finishConstruction();
    }

    protected void initFeatures(USBInterface usb) throws IOException {
        this.network = new NetworkSourceImpl(usb, this);
        this.gainGUIProvider = new GainImpl(usb, this);
        this.reInitFeatures(usb);
    }

    protected void reInitFeatures(USBInterface usb) throws IOException {
    }

    protected void finishConstruction() throws IOException {
        int i;
        this.numberOfPixels = this.numberOfCCDPixels;
        this.numberOfDarkPixels = this.numberOfDarkCCDPixels;
        this.benchSlot = 15;
        this.spectrometerConfigSlot = 16;
        if (this.isConnected()) {
            this.logger.finest("Serial number: " + this._transport.getSerialNumberOfClaimedSpectrometer());
            this.configurations = new Configuration[this.channels.length];
            for (int i2 = 0; i2 < this.channels.length; ++i2) {
                this.configurations[i2] = new Configuration(this);
            }
            this.configuration = this.configurations[0];
        }
        double[] wavelengthArray = this._transport.getWavelengths();
        double range = wavelengthArray[wavelengthArray.length - 1] - wavelengthArray[0];
        for (i = 0; i < this.channels.length; ++i) {
            this.channels[i].forceCoefficientsForArcoptix();
            Coefficients coefficients = this.channels[i].getCoefficients();
            coefficients.setWlIntercept(wavelengthArray[0]);
            coefficients.setWlFirst(range / (double)(this.numberOfPixels - 1));
            coefficients.setWlSecond(0.0);
            coefficients.setWlThird(0.0);
        }
        this.spectrumBase = new SpectrometerInfo(this.getSerialNumber(), this.getFirmwareVersion(), this.getClass(), null, this.numChannels, this.getNumberOfCCDPixels(), this.getNumberOfDarkCCDPixels(), this.getMaxIntensity(), this.getIntegrationTimeMinimum(), this.getIntegrationTimeMaximum(), this.getIntegrationTimeIncrement(), this.getIntegrationTimeBase());
        for (i = 0; i < this.channels.length; ++i) {
            this.channels[i].generateMetadata(this.spectrumBase, i);
        }
        this.reInitFeatures(this.usb);
    }

    public String getAddress() {
        return this._transport.getIPAddress();
    }

    public int getPort() {
        return this._transport.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        ArcoptixNetwork arcoptixNetwork = this;
        synchronized (arcoptixNetwork) {
            return this._transport.isConnected();
        }
    }

    private boolean claimSpectrometerBySerialNumber(String serialNumber) {
        return this._transport.claimSpectrometer(serialNumber);
    }

    private boolean claimSpectrometer(int spectrometerSelector) {
        int numberOfDiscoveredSpectrometers = this._transport.getNumberOfDiscoveredSpectrometers();
        if (spectrometerSelector >= numberOfDiscoveredSpectrometers) {
            return false;
        }
        String serialNumber = this._transport.getSerialNumber(0);
        return this._transport.claimSpectrometer(serialNumber);
    }

    public void connectToSource(String ipAddress, int port) {
        if (this._transport == null) {
            return;
        }
        this._transport.reconnectToHub(ipAddress, port);
        boolean success = this.claimSpectrometer(0);
        if (!success) {
            return;
        }
        try {
            this.finishConstruction();
        }
        catch (IOException exception) {
            return;
        }
    }

    public void disconnect() {
        this._transport.disconnect();
    }

    public GUIProvider[] getGUIFeatures() {
        Vector<GUIProvider> features = new Vector<GUIProvider>();
        features.add(this.network);
        features.add(this.gainGUIProvider);
        return features.toArray(new GUIProvider[0]);
    }

    public Socket getDataSocket() {
        return this._transport.getSocket();
    }

    public String getSerialNumber() throws IOException {
        return this._transport.getSerialNumberOfClaimedSpectrometer();
    }

    public String getFirmwareVersion() throws IOException {
        return this._transport.getFirmwareVersion();
    }

    public int getGain() {
        return this._transport.getGain();
    }

    public void setGain(int gainValue) {
        this._transport.setGain(gainValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStabilityScan(int numScans) throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                if (this._transport.isConnected()) {
                    this.readSpectrum();
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            return;
        }
    }

    public void closeSpectrometer() throws IOException {
        this.disconnect();
    }

    protected void finalize() {
    }

    public String getInfo(int slot) throws IOException {
        System.out.println("reading info slot " + slot + " at " + System.currentTimeMillis());
        String strRet = "arcoptix-getinfo";
        return strRet;
    }

    public String getName() {
        return "Arcoptix-(Network)";
    }

    public int getNumberOfChannels() {
        return 1;
    }

    public int getNumberOfEnabledChannels() {
        return 1;
    }

    private Spectrum formatData(double[] rawPixels, Spectrum outputSpectrum, boolean isSaturated) throws IOException {
        double[] internalPixelArray = outputSpectrum.getSpectrum();
        this.logger.finest("Formatting arcoptix data");
        outputSpectrum.setSaturated(isSaturated);
        for (int index = 0; index < this.numberOfCCDPixels; ++index) {
            internalPixelArray[index] = rawPixels[index];
        }
        return outputSpectrum;
    }

    protected Spectrum formatData(byte[] data, Spectrum doubleSpectrum) throws IOException {
        byte zero = 0;
        double[] internalPixelArray = doubleSpectrum.getSpectrum();
        this.logger.finest("Formatting data");
        boolean isSaturated = this._saturationRatio >= 0.9;
        doubleSpectrum.setSaturated(isSaturated);
        for (int i = 0; i < this.numberOfCCDPixels; ++i) {
            byte LSB = data[2 * i];
            byte MSB = data[2 * i + 1];
            int pixel = ByteRoutines.makeDWord((byte)zero, (byte)zero, (byte)MSB, (byte)LSB);
            internalPixelArray[i] = pixel;
        }
        return doubleSpectrum;
    }

    public void setStrobeEnable(boolean strobe) throws IOException {
    }

    public void setIntegrationTime(int intTime) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Spectrum getSpectrum(Spectrum spectrum) throws IOException {
        this.logger.finest("Getting spectrum...");
        this.timeoutOccurredFlag = false;
        if (!this._transport.isConnected()) {
            throw new IOException("Network spectrometer not connected!");
        }
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                if (this._transport.isConnected()) {
                    this.readSpectrum();
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            {
                this.formatData(this.rawData, spectrum);
                return spectrum;
            }
        }
    }

    protected void requestSpectrum() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readSpectrum() throws IOException {
        if (!this._transport.isConnected()) {
            throw new IOException("Cannot read spectrum when socket is closed");
        }
        byte[] byArray = this.rawData;
        synchronized (this.rawData) {
            try {
                double[] rawPixelArray = this._transport.getSpectrum();
                this._saturationRatio = this._transport.getSaturationRatio();
                for (int index = 0; index < rawPixelArray.length; ++index) {
                    if (rawPixelArray[index] > (double)this.maxIntensity) {
                        rawPixelArray[index] = this.maxIntensity;
                    }
                    short pixel = (short)(rawPixelArray[index] + 0.5);
                    this.rawData[index * 2] = ByteRoutines.getLowByte((short)pixel);
                    this.rawData[index * 2 + 1] = ByteRoutines.getHighByte((short)pixel);
                }
            }
            catch (Exception e) {
                this.reconnect();
                throw new IOException("Failed to read from device, attempting to reconnect");
            }
            return;
        }
    }

    public void reconnect() {
        this.network.reconnect();
    }

    public Configuration[] getChannelConfigurations() {
        return this.configurations;
    }

    public Configuration getConfiguration(int channelIndex) {
        if (channelIndex >= this.configurations.length) {
            return null;
        }
        return this.configurations[channelIndex];
    }
}

