/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.arcoptix;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ArcoptixTransport {
    private static final int MAXIMUM_SEND_BUFFER_SIZE = 256;
    private static final int MAXIMUM_RECEIVE_BUFFER_SIZE = 4096;
    private static final int PROTOCOL_IDENTIFIER = 1;
    private static final int OPCODE_NOP = 0;
    private static final int OPCODE_DISCOVER_ALL_SPECTROMETERS = 2;
    private static final int OPCODE_GET_SPECTRUM = 5;
    private static final int OPCODE_CLAIM_SPECTROMETER_BY_SERIAL_NUMBER = 6;
    private static final int OPCODE_GET_SATURATION_RATIO = 7;
    private static final int OPCODE_GET_GAIN = 8;
    private static final int OPCODE_SET_GAIN = 9;
    private static final int OPCODE_GET_SPECTROMETER_DESCRIPTOR = 10;
    private static final int OPCODE_GET_WAVELENGTHS = 11;
    BufferedReader _bufferedReader;
    ArrayList _discoveredSpectrometers;
    String _firmwareVersion;
    boolean _isSpectrometerDescriptorAvailable;
    int _maximumIntensity;
    OutputStream _outputStream;
    byte[] _receiveBuffer;
    double _saturationRatio;
    byte[] _sendBuffer;
    String _serialNumber;
    int _spectrometerIndexServerSide;
    Socket _socket;
    int _totalNumberOfPixels;
    private static String __extern__ = "__extern__\n<init>,()V\n<init>,(Ljava/net/Socket;)V\nisClaimed,()Z\nclaimSpectrometer,(Ljava/lang/String;)Z\nreconnectToHub,(Ljava/lang/String;I)Z\nconnectToHub,(Ljava/lang/String;I)Z\ndisconnect,()V\ndiscoverAllSpectrometers,()I\ngetIPAddress,()Ljava/lang/String;\ngetPort,()I\ngetMaximumIntensity,()I\ngetNumberOfDiscoveredSpectrometers,()I\ngetSerialNumberOfClaimedSpectrometer,()Ljava/lang/String;\ngetSerialNumber,(I)Ljava/lang/String;\ngetTotalNumberOfPixels,()I\ngetWavelengths,()[D\ngetFirmwareVersion,()Ljava/lang/String;\ngetGain,()I\nsetGain,(I)Z\ngetSaturationFromSpectrometer,()D\ngetSaturationRatio,()D\ngetSocket,()Ljava/net/Socket;\ngetSpectrum,()[D\nisConnected,()Z\nnop,()Z\n";

    public ArcoptixTransport() {
        this.initialize();
    }

    private void initialize() {
        this._socket = null;
        this._sendBuffer = new byte[256];
        this._receiveBuffer = new byte[4096];
        this._bufferedReader = null;
        this._outputStream = null;
        this._discoveredSpectrometers = new ArrayList();
        this._serialNumber = null;
        this._spectrometerIndexServerSide = -1;
        this._isSpectrometerDescriptorAvailable = false;
    }

    public ArcoptixTransport(Socket alreadyConnectedSocket) throws IOException {
        this.initialize();
        this._socket = alreadyConnectedSocket;
        boolean success = this.initializeSocketStreams();
        if (!success) {
            this._socket = null;
            throw new IOException("Unable to initialize socket's streams");
        }
        this.discoverAllSpectrometers();
    }

    public boolean isClaimed() {
        if (!this.isConnected()) {
            return false;
        }
        return this._serialNumber != null;
    }

    public boolean claimSpectrometer(String serialNumber) {
        StringTokenizer tokenizer;
        int numberOfDiscoveredSpectrometers;
        if (this.isClaimed()) {
            return false;
        }
        this._isSpectrometerDescriptorAvailable = false;
        if (serialNumber == null) {
            return false;
        }
        if (this._discoveredSpectrometers.size() == 0 && (numberOfDiscoveredSpectrometers = this.discoverAllSpectrometers()) == -1) {
            return false;
        }
        if (this._discoveredSpectrometers.size() == 0) {
            return false;
        }
        try {
            String sendMessage = Integer.toString(1) + "|" + Integer.toString(6) + "|" + serialNumber + "\r\n";
            this._outputStream.write(sendMessage.getBytes("UTF-8"));
            this._outputStream.flush();
            String reply = this._bufferedReader.readLine();
            tokenizer = new StringTokenizer(reply, "|");
            if (!tokenizer.hasMoreTokens()) {
                return false;
            }
            if (tokenizer.nextToken().compareTo("1") != 0) {
                return false;
            }
            if (!tokenizer.hasMoreTokens()) {
                return false;
            }
        }
        catch (IOException exception) {
            return false;
        }
        this._spectrometerIndexServerSide = Integer.parseInt(tokenizer.nextToken());
        this._serialNumber = serialNumber;
        return true;
    }

    public boolean reconnectToHub(String ipAddress, int portNumber) {
        this.disconnect();
        return this.connectToHub(ipAddress, portNumber);
    }

    public boolean connectToHub(String ipAddress, int portNumber) {
        if (this._socket != null) {
            this.discoverAllSpectrometers();
            return true;
        }
        try {
            this._socket = new Socket(ipAddress, portNumber);
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
            return false;
        }
        catch (ConnectException exception) {
            exception.printStackTrace();
            return false;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
        boolean success = this.initializeSocketStreams();
        if (!success) {
            return false;
        }
        this.discoverAllSpectrometers();
        return true;
    }

    private boolean initializeSocketStreams() {
        if (this._socket == null) {
            return false;
        }
        if (!this._socket.isConnected()) {
            return false;
        }
        try {
            this._outputStream = this._socket.getOutputStream();
            InputStreamReader isr = new InputStreamReader(this._socket.getInputStream());
            this._bufferedReader = new BufferedReader(isr);
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
            return false;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public void disconnect() {
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this._socket = null;
        }
        this.initialize();
    }

    public int discoverAllSpectrometers() {
        int numberOfDiscoveredSpectrometers;
        try {
            String sendMessage = Integer.toString(1) + "|" + Integer.toString(2) + "\r\n";
            byte[] byteArray = sendMessage.getBytes("UTF-8");
            this._outputStream.write(byteArray);
            this._outputStream.flush();
            String reply = this._bufferedReader.readLine();
            StringTokenizer tokenizer = new StringTokenizer(reply, "|");
            if (!tokenizer.hasMoreElements()) {
                return -1;
            }
            if (tokenizer.nextToken().compareTo("0") == 0) {
                return -1;
            }
            numberOfDiscoveredSpectrometers = Integer.parseInt(tokenizer.nextToken());
            this._discoveredSpectrometers = new ArrayList();
            while (tokenizer.hasMoreTokens()) {
                this._discoveredSpectrometers.add(tokenizer.nextToken());
            }
        }
        catch (IOException exception) {
            return -1;
        }
        return numberOfDiscoveredSpectrometers;
    }

    public String getIPAddress() {
        return this._socket.getInetAddress().toString().substring(1);
    }

    public int getPort() {
        return this._socket.getPort();
    }

    public int getMaximumIntensity() {
        if (!this.isSpectrometerDescriptorAvailable()) {
            this.getSpectrometerDescriptor();
        }
        if (!this.isSpectrometerDescriptorAvailable()) {
            return -1;
        }
        return this._maximumIntensity;
    }

    private void getSpectrometerDescriptor() {
        try {
            String mystring = Integer.toString(1) + "|" + Integer.toString(10) + "|" + Integer.toString(this._spectrometerIndexServerSide) + "\r\n";
            this._outputStream.write(mystring.getBytes("UTF-8"));
            this._outputStream.flush();
            String reply = this._bufferedReader.readLine();
            StringTokenizer tokenizer = new StringTokenizer(reply, "|");
            if (!tokenizer.hasMoreTokens()) {
                return;
            }
            if (tokenizer.nextToken().compareTo("0") == 0) {
                return;
            }
            if (!tokenizer.hasMoreTokens()) {
                return;
            }
            this._totalNumberOfPixels = Integer.parseInt(tokenizer.nextToken());
            if (!tokenizer.hasMoreTokens()) {
                return;
            }
            this._maximumIntensity = Integer.parseInt(tokenizer.nextToken());
            if (!tokenizer.hasMoreTokens()) {
                return;
            }
            this._serialNumber = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) {
                return;
            }
            this._firmwareVersion = tokenizer.nextToken();
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return;
        }
        catch (IOException ex) {
            return;
        }
        this._isSpectrometerDescriptorAvailable = true;
    }

    public int getNumberOfDiscoveredSpectrometers() {
        return this._discoveredSpectrometers.size();
    }

    public String getSerialNumberOfClaimedSpectrometer() {
        return this._serialNumber;
    }

    public String getSerialNumber(int indexPosition) {
        if (indexPosition >= this._discoveredSpectrometers.size() || indexPosition < 0) {
            return null;
        }
        return (String)this._discoveredSpectrometers.get(indexPosition);
    }

    public int getTotalNumberOfPixels() {
        if (!this.isSpectrometerDescriptorAvailable()) {
            this.getSpectrometerDescriptor();
        }
        if (!this.isSpectrometerDescriptorAvailable()) {
            return -1;
        }
        return this._totalNumberOfPixels;
    }

    public double[] getWavelengths() {
        double[] wavelengthArray;
        try {
            String mystring = Integer.toString(1) + "|" + Integer.toString(11) + "|" + Integer.toString(this._spectrometerIndexServerSide) + "\r\n";
            this._outputStream.write(mystring.getBytes("UTF-8"));
            this._outputStream.flush();
            String reply = this._bufferedReader.readLine();
            StringTokenizer tokenizer = new StringTokenizer(reply, "|");
            if (!tokenizer.hasMoreTokens()) {
                return null;
            }
            if (tokenizer.nextToken().compareTo("0") == 0) {
                return null;
            }
            if (!tokenizer.hasMoreTokens()) {
                return null;
            }
            int numberOfPixels = Integer.parseInt(tokenizer.nextToken());
            if (!tokenizer.hasMoreTokens()) {
                return null;
            }
            String wavelengthString = tokenizer.nextToken();
            tokenizer = new StringTokenizer(wavelengthString, ",");
            wavelengthArray = new double[numberOfPixels];
            for (int index = 0; index < numberOfPixels; ++index) {
                if (!tokenizer.hasMoreTokens()) {
                    return null;
                }
                wavelengthArray[index] = Double.parseDouble(tokenizer.nextToken());
            }
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (IOException ex) {
            return null;
        }
        return wavelengthArray;
    }

    public String getFirmwareVersion() {
        if (!this.isSpectrometerDescriptorAvailable()) {
            this.getSpectrometerDescriptor();
        }
        if (!this.isSpectrometerDescriptorAvailable()) {
            return null;
        }
        return this._firmwareVersion;
    }

    public int getGain() {
        int gain;
        try {
            String mystring = Integer.toString(1) + "|" + Integer.toString(8) + "|" + Integer.toString(this._spectrometerIndexServerSide) + "\r\n";
            this._outputStream.write(mystring.getBytes("UTF-8"));
            this._outputStream.flush();
            String reply = this._bufferedReader.readLine();
            StringTokenizer tokenizer = new StringTokenizer(reply, "|");
            if (!tokenizer.hasMoreTokens()) {
                return -1;
            }
            if (tokenizer.nextToken().compareTo("0") == 0) {
                return -1;
            }
            if (!tokenizer.hasMoreTokens()) {
                return -1;
            }
            gain = Integer.parseInt(tokenizer.nextToken());
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return -1;
        }
        catch (IOException ex) {
            return -1;
        }
        return gain;
    }

    public boolean setGain(int gainValue) {
        try {
            String mystring = Integer.toString(1) + "|" + Integer.toString(9) + "|" + Integer.toString(this._spectrometerIndexServerSide) + "|" + Integer.toString(gainValue) + "\r\n";
            this._outputStream.write(mystring.getBytes("UTF-8"));
            this._outputStream.flush();
            String reply = this._bufferedReader.readLine();
            StringTokenizer tokenizer = new StringTokenizer(reply, "|");
            if (!tokenizer.hasMoreTokens()) {
                return false;
            }
            if (tokenizer.nextToken().compareTo("0") == 0) {
                return false;
            }
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public double getSaturationFromSpectrometer() {
        double saturation;
        try {
            String mystring = Integer.toString(1) + "|" + Integer.toString(7) + "|" + Integer.toString(this._spectrometerIndexServerSide) + "\r\n";
            this._outputStream.write(mystring.getBytes("UTF-8"));
            this._outputStream.flush();
            String reply = this._bufferedReader.readLine();
            StringTokenizer tokenizer = new StringTokenizer(reply, "|");
            if (!tokenizer.hasMoreTokens()) {
                return -1.0;
            }
            if (tokenizer.nextToken().compareTo("0") == 0) {
                return -1.0;
            }
            if (!tokenizer.hasMoreTokens()) {
                return -1.0;
            }
            saturation = Double.parseDouble(tokenizer.nextToken());
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return -1.0;
        }
        catch (IOException ex) {
            return -1.0;
        }
        return saturation;
    }

    public double getSaturationRatio() {
        return this._saturationRatio;
    }

    public Socket getSocket() {
        return this._socket;
    }

    public double[] getSpectrum() {
        double[] spectrumPixelArray = null;
        if (!this.isClaimed()) {
            return null;
        }
        try {
            String mystring = Integer.toString(1) + "|" + Integer.toString(5) + "|" + Integer.toString(this._spectrometerIndexServerSide) + "\r\n";
            byte[] byteArray = mystring.getBytes("UTF-8");
            this._outputStream.write(byteArray);
            this._outputStream.flush();
            String reply = this._bufferedReader.readLine();
            StringTokenizer tokenizer = new StringTokenizer(reply, "|");
            if (!tokenizer.hasMoreTokens()) {
                return null;
            }
            if (tokenizer.nextToken().compareTo("0") == 0) {
                return null;
            }
            if (!tokenizer.hasMoreTokens()) {
                return null;
            }
            int numberOfPixels = Integer.parseInt(tokenizer.nextToken());
            if (!tokenizer.hasMoreTokens()) {
                return null;
            }
            this._saturationRatio = Double.parseDouble(tokenizer.nextToken());
            if (!tokenizer.hasMoreTokens()) {
                return null;
            }
            String spectrumString = tokenizer.nextToken();
            tokenizer = new StringTokenizer(spectrumString, ",");
            spectrumPixelArray = new double[numberOfPixels];
            for (int index = 0; index < numberOfPixels; ++index) {
                if (!tokenizer.hasMoreTokens()) {
                    return null;
                }
                spectrumPixelArray[index] = Double.parseDouble(tokenizer.nextToken());
            }
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (IOException ex) {
            return null;
        }
        return spectrumPixelArray;
    }

    public boolean isConnected() {
        if (this._socket == null) {
            return false;
        }
        return this._socket.isConnected();
    }

    private boolean isSpectrometerDescriptorAvailable() {
        return this._isSpectrometerDescriptorAvailable;
    }

    public boolean nop() {
        try {
            String mystring = Integer.toString(1) + "|" + Integer.toString(0) + "\r\n";
            byte[] byteArray = mystring.getBytes("UTF-8");
            this._outputStream.write(byteArray);
            this._outputStream.flush();
            String reply = this._bufferedReader.readLine();
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return false;
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }
}

