/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.hr2000plus;

import com.oceanoptics.omnidriver.constants.ExternalTriggerMode;
import com.oceanoptics.omnidriver.features.advancedintegrationclock.AdvancedIntegrationClock;
import com.oceanoptics.omnidriver.features.advancedintegrationclock.AdvancedIntegrationClockImpl;
import com.oceanoptics.omnidriver.features.advancedversion.AdvancedVersion;
import com.oceanoptics.omnidriver.features.advancedversion.AdvancedVersionImpl;
import com.oceanoptics.omnidriver.features.analogin.AnalogIn;
import com.oceanoptics.omnidriver.features.analogin.AnalogInGUIProvider;
import com.oceanoptics.omnidriver.features.analogin.AnalogInImpl;
import com.oceanoptics.omnidriver.features.analogout.AnalogOut;
import com.oceanoptics.omnidriver.features.analogout.AnalogOutGUIProvider;
import com.oceanoptics.omnidriver.features.analogout.AnalogOutImpl;
import com.oceanoptics.omnidriver.features.analogout.AnalogOutImpl_PSOC;
import com.oceanoptics.omnidriver.features.boardtemperature.BoardTemperature;
import com.oceanoptics.omnidriver.features.boardtemperature.BoardTemperatureGUIProvider;
import com.oceanoptics.omnidriver.features.boardtemperature.BoardTemperatureImpl;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobe;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobeGUIProvider;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobeImpl;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobeImpl_FPGA;
import com.oceanoptics.omnidriver.features.externaltriggerdelay.ExternalTriggerDelay;
import com.oceanoptics.omnidriver.features.externaltriggerdelay.ExternalTriggerDelayGUIProvider;
import com.oceanoptics.omnidriver.features.externaltriggerdelay.ExternalTriggerDelayImpl;
import com.oceanoptics.omnidriver.features.externaltriggerdelay.ExternalTriggerDelayImpl_HR2kp;
import com.oceanoptics.omnidriver.features.gpio.GPIO;
import com.oceanoptics.omnidriver.features.gpio.GPIOGUIProvider;
import com.oceanoptics.omnidriver.features.gpio.GPIOImpl;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTrigger;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTriggerImpl;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTriggerImplFPGA;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBus;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBusGUIProvider;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBusImpl;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBusImplFPGA;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactor;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactorGUIProvider;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactorImpl;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactorImplFPGA;
import com.oceanoptics.omnidriver.features.masterclockdivisor.MasterClockDivisor;
import com.oceanoptics.omnidriver.features.masterclockdivisor.MasterClockDivisorImpl;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionImpl;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionProvider;
import com.oceanoptics.omnidriver.features.pluginprovider.PlugInProvider;
import com.oceanoptics.omnidriver.features.pluginprovider.PlugInProviderImpl;
import com.oceanoptics.omnidriver.features.pluginprovider.PlugInProviderImplFPGA;
import com.oceanoptics.omnidriver.features.shutterclock.ShutterClock;
import com.oceanoptics.omnidriver.features.shutterclock.ShutterClockImpl;
import com.oceanoptics.omnidriver.features.singlestrobe.SingleStrobe;
import com.oceanoptics.omnidriver.features.singlestrobe.SingleStrobeGUIProvider;
import com.oceanoptics.omnidriver.features.singlestrobe.SingleStrobeImpl;
import com.oceanoptics.omnidriver.features.spibus.SPIBus;
import com.oceanoptics.omnidriver.features.spibus.SPIBusGUIProvider;
import com.oceanoptics.omnidriver.features.spibus.SPIBusImpl;
import com.oceanoptics.omnidriver.features.spibus.SPIBusImplFPGA;
import com.oceanoptics.omnidriver.features.statusprovider.StatusProvider;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrection;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionImpl;
import com.oceanoptics.omnidriver.features.version.Version;
import com.oceanoptics.omnidriver.features.version.VersionGUIProvider;
import com.oceanoptics.omnidriver.features.version.VersionImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationGUIProvider;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationProvider;
import com.oceanoptics.omnidriver.interfaces.AcquisitionListener;
import com.oceanoptics.omnidriver.interfaces.GUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBEndpointDevice;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.plugin.SpectrometerPlugIn;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.Configuration;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerChannel;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerStatus;
import com.oceanoptics.omnidriver.spectrometer.USBSpectrometer;
import com.oceanoptics.omnidriver.spectrometer.hr2000plus.HR2000PlusStatus;
import com.oceanoptics.omnidriver.spectrometer.hr2000plus.HR2000PlusTriggerMode;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;

public class HR2000Plus
extends USBSpectrometer
implements PlugInProvider,
I2CBus,
SPIBus,
AdvancedVersion,
StatusProvider,
ContinuousStrobe,
AdvancedIntegrationClock,
HardwareTrigger,
ShutterClock,
SingleStrobe,
GPIO,
BoardTemperature,
AnalogIn,
AnalogOut,
IrradianceCalibrationFactor,
MasterClockDivisor,
ExternalTriggerDelay,
NonlinearityCorrectionProvider,
WavelengthCalibrationProvider,
StrayLightCorrection,
Version,
USBEndpointDevice {
    static Spectrometer[] scoreboard = new Spectrometer[64];
    private PlugInProvider plugInProvider = null;
    private AdvancedVersion advancedVersion = null;
    private AdvancedIntegrationClock advancedIntegrationClock = null;
    private ShutterClock shutterClock = null;
    private MasterClockDivisor masterClockDivisor = null;
    private StrayLightCorrectionGUIProvider straylight = null;
    private I2CBusGUIProvider i2cBus = null;
    private SPIBusGUIProvider spiBus = null;
    private GPIOGUIProvider gpio = null;
    private SingleStrobeGUIProvider singleStrobe = null;
    private HardwareTriggerImpl hardwareTrigger = null;
    private ContinuousStrobeGUIProvider continuousStrobe = null;
    private BoardTemperatureGUIProvider boardTemperature = null;
    private AnalogInGUIProvider analogIn = null;
    private AnalogOutGUIProvider analogOut = null;
    private IrradianceCalibrationFactorGUIProvider irradianceCalibrationFactor = null;
    private ExternalTriggerDelayGUIProvider triggerDelay = null;
    private NonlinearityCorrectionGUIProvider nonlinearity = null;
    private WavelengthCalibrationGUIProvider wavelength = null;
    private VersionGUIProvider version;
    private int NUMBER_GPIO_PINS = 10;
    private static final short DATA_OUT = 1;
    private static final short HIGH_SPEED_DATA_IN_1 = 130;
    private static final short HIGH_SPEED_DATA_IN_2 = 134;
    private static final short LOW_SPEED_DATA_IN = 129;
    private static final short MAX_PACKET_SIZE = 512;
    private static String __extern__ = "__extern__\n<init>,()V\n<init>,(I)V\nsetEndpoints,()V\ngetEndpoint,(I)Lcom/oceanoptics/uniusb/USBEndpointDescriptor;\nallowWriteToEEPROM,(II)Z\nopenSpectrometer,(I)V\ngetGUIFeatures,()[Lcom/oceanoptics/omnidriver/interfaces/GUIProvider;\ngetStatus,()Lcom/oceanoptics/omnidriver/spectrometer/SpectrometerStatus;\nreadIntegrationTime,()I\nsetStrobeDelay,(I)V\ntoString,()Ljava/lang/String;\ngetPlugIns,()[Lcom/oceanoptics/omnidriver/plugin/SpectrometerPlugIn;\ngetNumberOfPlugIns,()I\nisPlugInDetected,(I)Z\ninitializePlugIns,()[B\ndetectPlugIns,()V\nsetI2CBytes,(BB[B)I\ngetI2CBytes,(BB)[B\ngetSPIBytes,([BI)[B\ngetPSOCVersion,()Ljava/lang/String;\ngetFPGAFirmwareVersion,()Ljava/lang/String;\ncontinuousStrobeCountsToMicros,(I)D\nsetContinuousStrobeDelay,(I)V\ngetContinuousStrobeDelay,()Ljava/lang/Integer;\ngetContinuousStrobeDelayMinimum,()I\ngetContinuousStrobeDelayMaximum,()I\ngetContinuousStrobeDelayIncrement,(I)I\nsetAdvancedIntegrationTime,(J)V\ngetIntegrationTimeBaseClock,()I\ngetIntegrationClockTimer,()I\ngetAdvancedIntegrationTimeMinimum,()J\ngetAdvancedIntegrationTimeMaximum,()J\ngetAdvancedIntegrationTimeIncrement,()J\nsetExternalTriggerMode,(I)V\ngetExternalTriggerModes,()[Lcom/oceanoptics/omnidriver/constants/ExternalTriggerMode;\ngetExternalTriggerMode,()Ljava/lang/Integer;\nsetShutterClock,(I)V\ngetShutterClock,()I\nsetSingleStrobeLow,(I)V\nsetSingleStrobeHigh,(I)V\ngetSingleStrobeCountsToMicros,(I)D\ngetSingleStrobeLow,()I\ngetSingleStrobeHigh,()I\ngetSingleStrobeMinimum,()I\ngetSingleStrobeMaximum,()I\ngetSingleStrobeIncrement,()I\nsetDirectionAllBits,(Ljava/util/BitSet;)V\nsetMuxAllBits,(Ljava/util/BitSet;)V\nsetValueAllBits,(Ljava/util/BitSet;)V\nsetDirectionBitmask,(S)V\nsetMuxBitmask,(S)V\nsetValueBitmask,(S)V\nsetDirectionBit,(IZ)V\nsetMuxBit,(IZ)V\nsetValueBit,(IZ)V\ngetTotalGPIOBits,()I\ngetDirectionBits,()Ljava/util/BitSet;\ngetMuxBits,()Ljava/util/BitSet;\ngetValueBit,(I)I\ngetValueBits,()Ljava/util/BitSet;\ngetNumberOfPins,()I\ngetBoardTemperatureCelsius,()D\ngetVoltageIn,()D\nsetDACCounts,(II)V\nanalogOutCountsToVolts,(I)D\ngetDACMinimum,()I\ngetDACMaximum,()I\ngetDACIncrement,()I\ngetDACCounts,(I)Ljava/lang/Integer;\nisDACPresent,()Z\ngetDACPins,()I\ngetIrradianceCalibrationFactors,()[D\nsetIrradianceCalibrationFactors,([D)V\ngetCollectionArea,()D\nhasCollectionArea,()Z\nsetCollectionArea,(D)V\nsetMasterClockDivisor,(I)V\ngetMasterClockDivisor,()I\nsetExternalTriggerDelay,(I)V\ntriggerDelayCountsToMicroseconds,(I)D\ngetExternalTriggerDelay,()Ljava/lang/Integer;\ngetExternalTriggerDelayMinimum,()I\ngetExternalTriggerDelayMaximum,()I\ngetExternalTriggerDelayIncrement,()I\nreadNonlinearityCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteNonlinearityCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetNonlinearityCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficientsSingleChannel,(I)[D\nsetNonlinearityCoefficientsSingleChannel,([DI)V\nreadWavelengthCalibrationCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteWavelengthCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengthCalibrationCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetWavelengthCalibrationCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengths,(I)[D\nsetWavelengths,([DI)V\nreadStrayLightCorrectionCoefficientFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteStrayLightCoefficientToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\nsetStrayLightCorrectionCoefficient,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetStrayLightCorrectionCoefficient,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetStrayLight,(DI)V\ngetStrayLight,(I)D\nisAdvancedVersion,()Z\nuploadFirmware,(Ljava/io/File;J)V\nuploadFPGA,(Ljava/io/File;J)V\naddAcquisitionListener,(Lcom/oceanoptics/omnidriver/interfaces/AcquisitionListener;)V\nremoveAcquisitionListener,(Lcom/oceanoptics/omnidriver/interfaces/AcquisitionListener;)V\n";

    public HR2000Plus() throws IOException {
        try {
            this.setEndpoints();
            this.openNextUnclaimedUSB();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public HR2000Plus(int i) throws IOException {
        this.setEndpoints();
        this.openSpectrometer(i);
    }

    protected Spectrometer[] getScoreboard() {
        return scoreboard;
    }

    public void setEndpoints() {
        this.dataOutEndPoint = new USBEndpointDescriptor(7, 5, 1, 2, 512, 0);
        this.highSpeedInEndPoint1 = new USBEndpointDescriptor(7, 5, 130, 2, 512, 0);
        this.highSpeedInEndPoint2 = new USBEndpointDescriptor(7, 5, 134, 2, 512, 0);
        this.lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 129, 2, 512, 0);
    }

    public USBEndpointDescriptor getEndpoint(int endPoint) throws IllegalArgumentException {
        switch (endPoint) {
            case 0: {
                return this.dataOutEndPoint;
            }
            case 1: {
                return this.highSpeedInEndPoint1;
            }
            case 2: {
                return this.highSpeedInEndPoint2;
            }
            case 3: {
                return this.lowSpeedInEndPoint;
            }
        }
        throw new IllegalArgumentException("End Point number invalid.");
    }

    public boolean allowWriteToEEPROM(int privilegeLevel, int slot) {
        if (slot < 0) {
            return false;
        }
        if (privilegeLevel == 0) {
            return true;
        }
        if (privilegeLevel == 1) {
            if (slot == 0) {
                return false;
            }
            if (slot == 17 || slot == 18 || slot == 19) {
                return true;
            }
            return slot <= 14;
        }
        return false;
    }

    private boolean parseFPGAFirmwareVersion() {
        double FX2 = 0.0;
        double FPGA2 = 0.0;
        try {
            String fpgaVersion = this.getFPGAFirmwareVersion();
            int index1 = this.firmwareVersion.indexOf(32);
            int index2 = this.firmwareVersion.lastIndexOf(46);
            FX2 = Double.parseDouble(this.firmwareVersion.substring(index1 + 1, index2));
            int index3 = fpgaVersion.lastIndexOf(46);
            FPGA2 = Double.parseDouble(fpgaVersion.substring(0, index3));
            return FPGA2 >= 3.0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void openSpectrometer(int index) throws IOException {
        this.integrationTimeMinimum = 1000;
        this.integrationTimeMaximum = 65535000;
        this.integrationTimeIncrement = 10;
        this.integrationTimeBase = 1;
        this.numberOfCCDPixels = 2048;
        this.numberOfDarkCCDPixels = 24;
        this.maxIntensity = 16383;
        this.pipeSize = this.numberOfCCDPixels * 2 + 1;
        this.rawData = new byte[this.pipeSize];
        this.benchSlot = 15;
        this.spectrometerConfigSlot = 16;
        this.productID = 4118;
        this.usb.openDevice(this.vendorID, this.productID, index);
        this.deviceIndex = index;
        this.initialize();
        this.getFirmwareVersion();
        this.channels = new SpectrometerChannel[1];
        this.channels[this.channelIndex] = new SpectrometerChannel(this, new Coefficients(), this.channelIndex);
        this.logger.fine("HR2000+ has been opened at index " + index);
        this.initFeatures(this.usb);
        this.finishConstruction();
        this.configuration = new Configuration(this);
    }

    private void initFeatures(USBInterface usb) throws IOException {
        this.plugInProvider = new PlugInProviderImplFPGA(usb, this);
        this.advancedVersion = new AdvancedVersionImpl(usb);
        this.advancedIntegrationClock = new AdvancedIntegrationClockImpl(usb);
        this.shutterClock = new ShutterClockImpl(usb);
        this.masterClockDivisor = new MasterClockDivisorImpl(usb);
        this.i2cBus = new I2CBusImplFPGA(usb);
        this.spiBus = new SPIBusImplFPGA(usb);
        this.gpio = new GPIOImpl(usb, this.NUMBER_GPIO_PINS);
        this.singleStrobe = new SingleStrobeImpl(usb);
        if (this.parseFPGAFirmwareVersion()) {
            this.hardwareTrigger = new HardwareTriggerImplFPGA(usb, new HR2000PlusTriggerMode[]{new HR2000PlusTriggerMode(0), new HR2000PlusTriggerMode(1), new HR2000PlusTriggerMode(2), new HR2000PlusTriggerMode(3), new HR2000PlusTriggerMode(4)});
            this.triggerDelay = new ExternalTriggerDelayImpl_HR2kp(usb);
            this.featureMap.put(ExternalTriggerDelayImpl_HR2kp.class, (ExternalTriggerDelayImpl_HR2kp)this.triggerDelay);
        } else {
            this.hardwareTrigger = new HardwareTriggerImplFPGA(usb, new ExternalTriggerMode[]{new ExternalTriggerMode(0), new ExternalTriggerMode(1), new ExternalTriggerMode(2), new ExternalTriggerMode(3)});
            this.triggerDelay = new ExternalTriggerDelayImpl(usb);
            this.featureMap.put(ExternalTriggerDelayImpl.class, (ExternalTriggerDelayImpl)this.triggerDelay);
        }
        this.continuousStrobe = new ContinuousStrobeImpl_FPGA(usb);
        this.boardTemperature = new BoardTemperatureImpl(usb);
        this.analogIn = new AnalogInImpl(usb);
        this.analogOut = new AnalogOutImpl_PSOC(usb);
        this.irradianceCalibrationFactor = new IrradianceCalibrationFactorImplFPGA(usb, this.numberOfCCDPixels);
        this.nonlinearity = new NonlinearityCorrectionImpl(usb, this);
        this.wavelength = new WavelengthCalibrationImpl(usb, this);
        this.straylight = new StrayLightCorrectionImpl(usb, this);
        this.version = new VersionImpl(usb, this);
        this.featureMap.put(PlugInProviderImpl.class, (PlugInProviderImpl)this.plugInProvider);
        this.featureMap.put(AdvancedVersionImpl.class, (AdvancedVersionImpl)this.advancedVersion);
        this.featureMap.put(AdvancedIntegrationClockImpl.class, (AdvancedIntegrationClockImpl)this.advancedIntegrationClock);
        this.featureMap.put(ShutterClockImpl.class, (ShutterClockImpl)this.shutterClock);
        this.featureMap.put(MasterClockDivisorImpl.class, (MasterClockDivisorImpl)this.masterClockDivisor);
        this.featureMap.put(I2CBusImpl.class, (I2CBusImpl)this.i2cBus);
        this.featureMap.put(SPIBusImpl.class, (SPIBusImpl)this.spiBus);
        this.featureMap.put(GPIOImpl.class, (GPIOImpl)this.gpio);
        this.featureMap.put(SingleStrobeImpl.class, (SingleStrobeImpl)this.singleStrobe);
        this.featureMap.put(HardwareTriggerImpl.class, this.hardwareTrigger);
        this.featureMap.put(ContinuousStrobeImpl.class, (ContinuousStrobeImpl)this.continuousStrobe);
        this.featureMap.put(BoardTemperatureImpl.class, (BoardTemperatureImpl)this.boardTemperature);
        this.featureMap.put(AnalogInImpl.class, (AnalogInImpl)this.analogIn);
        this.featureMap.put(AnalogOutImpl.class, (AnalogOutImpl)this.analogOut);
        this.featureMap.put(IrradianceCalibrationFactorImpl.class, (IrradianceCalibrationFactorImpl)this.irradianceCalibrationFactor);
        this.featureMap.put(NonlinearityCorrectionImpl.class, (NonlinearityCorrectionImpl)this.nonlinearity);
        this.featureMap.put(WavelengthCalibrationImpl.class, (WavelengthCalibrationImpl)this.wavelength);
        this.featureMap.put(StrayLightCorrectionImpl.class, (StrayLightCorrectionImpl)this.straylight);
        this.featureMap.put(VersionImpl.class, (VersionImpl)this.version);
    }

    public GUIProvider[] getGUIFeatures() {
        return new GUIProvider[]{this.wavelength, this.straylight, this.nonlinearity, this.singleStrobe, this.continuousStrobe, this.triggerDelay, this.i2cBus, this.spiBus, this.gpio, this.boardTemperature, this.analogIn, this.analogOut, this.irradianceCalibrationFactor, this.version};
    }

    protected Spectrum formatData(byte[] data, Spectrum doubleSpectrum) throws IOException {
        byte zero = 0;
        double[] spectrum = doubleSpectrum.getSpectrum();
        this.logger.finest("Formatting data");
        doubleSpectrum.setSaturated(false);
        if (data[this.numberOfCCDPixels * 2] != 105) {
            this.logger.severe("Lost synchroniztion");
            throw new IOException("Lost synchronization");
        }
        for (int i = 0; i < this.numberOfCCDPixels; ++i) {
            byte MSB = data[2 * i + 1];
            byte LSB = data[2 * i];
            int pixel = ByteRoutines.makeDWord((byte)zero, (byte)zero, (byte)MSB, (byte)LSB) ^ 0x2000;
            if (pixel >= this.maxIntensity) {
                doubleSpectrum.setSaturated(true);
            }
            spectrum[i] = pixel;
        }
        return doubleSpectrum;
    }

    public SpectrometerStatus getStatus() throws IOException {
        this.logger.finest("HR2000+ Status.");
        byte[] sb = super.getStatusArray();
        HR2000PlusStatus stat = new HR2000PlusStatus();
        stat.numPixels = ByteRoutines.makeWord((byte)sb[1], (byte)sb[0]);
        stat.integrationTime = ByteRoutines.makeDWord((byte)sb[5], (byte)sb[4], (byte)sb[3], (byte)sb[2]);
        stat.lampEnabled = sb[6] != 0;
        stat.externalTriggerMode = sb[7];
        stat.takingScan = sb[8] != 0;
        stat.numPacketsInSpectra = sb[9];
        stat.powerDownFlag = sb[10];
        stat.packetCount = sb[11];
        if (Math.abs(sb[14]) == 128) {
            stat.usbSpeed = 480;
        } else if (Math.abs(sb[14]) == 0) {
            stat.usbSpeed = 12;
        } else {
            stat.usbSpeed = 0;
            this.logger.severe("Error determining USB Communication Speed.");
            throw new IOException("Error determining USB Communication Speed.");
        }
        return stat;
    }

    public int readIntegrationTime() throws IOException {
        HR2000PlusStatus stat = (HR2000PlusStatus)this.getStatus();
        return stat.integrationTime;
    }

    public void setStrobeDelay(int delay) throws IOException {
        this.setContinuousStrobeDelay(delay);
    }

    public String toString() {
        try {
            return super.toString() + "\n" + this.getStatus();
        }
        catch (IOException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public SpectrometerPlugIn[] getPlugIns() throws IOException {
        return this.plugInProvider.getPlugIns();
    }

    public int getNumberOfPlugIns() throws IOException {
        return this.plugInProvider.getNumberOfPlugIns();
    }

    public boolean isPlugInDetected(int id) throws IOException {
        return this.plugInProvider.isPlugInDetected(id);
    }

    public byte[] initializePlugIns() throws IOException {
        return this.plugInProvider.initializePlugIns();
    }

    public void detectPlugIns() throws IOException {
        this.plugInProvider.detectPlugIns();
    }

    public int setI2CBytes(byte address, byte numBytes, byte[] i2C) throws IOException {
        return this.i2cBus.setI2CBytes(address, numBytes, i2C);
    }

    public byte[] getI2CBytes(byte address, byte numBytes) throws IOException {
        return this.i2cBus.getI2CBytes(address, numBytes);
    }

    public byte[] getSPIBytes(byte[] message, int length) throws IOException {
        return this.spiBus.getSPIBytes(message, length);
    }

    public String getPSOCVersion() throws IOException {
        return this.advancedVersion.getPSOCVersion();
    }

    public String getFPGAFirmwareVersion() throws IOException {
        return this.advancedVersion.getFPGAFirmwareVersion();
    }

    public double continuousStrobeCountsToMicros(int counts) {
        return this.continuousStrobe.continuousStrobeCountsToMicros(counts);
    }

    public void setContinuousStrobeDelay(int delayMicros) throws IOException {
        this.continuousStrobe.setContinuousStrobeDelay(delayMicros);
    }

    public Integer getContinuousStrobeDelay() {
        return this.continuousStrobe.getContinuousStrobeDelay();
    }

    public int getContinuousStrobeDelayMinimum() {
        return this.continuousStrobe.getContinuousStrobeDelayMinimum();
    }

    public int getContinuousStrobeDelayMaximum() {
        return this.continuousStrobe.getContinuousStrobeDelayMaximum();
    }

    public int getContinuousStrobeDelayIncrement(int magnitude) {
        return this.continuousStrobe.getContinuousStrobeDelayIncrement(magnitude);
    }

    public void setAdvancedIntegrationTime(long delayMicros) throws IOException {
        this.advancedIntegrationClock.setAdvancedIntegrationTime(delayMicros);
    }

    public int getIntegrationTimeBaseClock() throws IOException {
        return this.advancedIntegrationClock.getIntegrationTimeBaseClock();
    }

    public int getIntegrationClockTimer() throws IOException {
        return this.advancedIntegrationClock.getIntegrationClockTimer();
    }

    public long getAdvancedIntegrationTimeMinimum() {
        return this.advancedIntegrationClock.getAdvancedIntegrationTimeMinimum();
    }

    public long getAdvancedIntegrationTimeMaximum() {
        return this.advancedIntegrationClock.getAdvancedIntegrationTimeMaximum();
    }

    public long getAdvancedIntegrationTimeIncrement() {
        return this.advancedIntegrationClock.getAdvancedIntegrationTimeIncrement();
    }

    public void setExternalTriggerMode(int mode) throws IOException {
        this.hardwareTrigger.setExternalTriggerMode(mode);
    }

    public ExternalTriggerMode[] getExternalTriggerModes() {
        return this.hardwareTrigger.getExternalTriggerModes();
    }

    public Integer getExternalTriggerMode() {
        return this.hardwareTrigger.getExternalTriggerMode();
    }

    public void setShutterClock(int value) throws IOException {
        this.shutterClock.setShutterClock(value);
    }

    public int getShutterClock() throws IOException {
        return this.shutterClock.getShutterClock();
    }

    public void setSingleStrobeLow(int value) throws IOException {
        this.singleStrobe.setSingleStrobeLow(value);
    }

    public void setSingleStrobeHigh(int value) throws IOException {
        this.singleStrobe.setSingleStrobeHigh(value);
    }

    public double getSingleStrobeCountsToMicros(int counts) {
        return this.singleStrobe.getSingleStrobeCountsToMicros(counts);
    }

    public int getSingleStrobeLow() throws IOException {
        return this.singleStrobe.getSingleStrobeLow();
    }

    public int getSingleStrobeHigh() throws IOException {
        return this.singleStrobe.getSingleStrobeHigh();
    }

    public int getSingleStrobeMinimum() {
        return this.singleStrobe.getSingleStrobeMinimum();
    }

    public int getSingleStrobeMaximum() {
        return this.singleStrobe.getSingleStrobeMaximum();
    }

    public int getSingleStrobeIncrement() {
        return this.singleStrobe.getSingleStrobeIncrement();
    }

    public void setDirectionAllBits(BitSet bitSet) throws IOException {
        this.gpio.setDirectionAllBits(bitSet);
    }

    public void setMuxAllBits(BitSet bitSet) throws IOException {
        this.gpio.setMuxAllBits(bitSet);
    }

    public void setValueAllBits(BitSet bitSet) throws IOException {
        this.gpio.setValueAllBits(bitSet);
    }

    public void setDirectionBitmask(short bitmask) throws IOException {
        this.gpio.setDirectionBitmask(bitmask);
    }

    public void setMuxBitmask(short bitmask) throws IOException {
        this.gpio.setMuxBitmask(bitmask);
    }

    public void setValueBitmask(short bitmask) throws IOException {
        this.gpio.setValueBitmask(bitmask);
    }

    public void setDirectionBit(int bit, boolean value) throws IOException {
        this.gpio.setDirectionBit(bit, value);
    }

    public void setMuxBit(int bit, boolean value) throws IOException {
        this.gpio.setMuxBit(bit, value);
    }

    public void setValueBit(int bit, boolean value) throws IOException {
        this.gpio.setValueBit(bit, value);
    }

    public int getTotalGPIOBits() {
        return this.gpio.getTotalGPIOBits();
    }

    public BitSet getDirectionBits() throws IOException {
        return this.gpio.getDirectionBits();
    }

    public BitSet getMuxBits() throws IOException {
        return this.gpio.getMuxBits();
    }

    public int getValueBit(int bitNumber) throws IOException {
        return this.gpio.getValueBit(bitNumber);
    }

    public BitSet getValueBits() throws IOException {
        return this.gpio.getValueBits();
    }

    public int getNumberOfPins() {
        return this.gpio.getNumberOfPins();
    }

    public double getBoardTemperatureCelsius() throws IOException {
        return this.boardTemperature.getBoardTemperatureCelsius();
    }

    public double getVoltageIn() throws IOException {
        return this.analogIn.getVoltageIn();
    }

    public void setDACCounts(int counts, int channelIndex) throws IOException {
        this.analogOut.setDACCounts(counts, channelIndex);
    }

    public double analogOutCountsToVolts(int counts) {
        return this.analogOut.analogOutCountsToVolts(counts);
    }

    public int getDACMinimum() {
        return this.analogOut.getDACMinimum();
    }

    public int getDACMaximum() {
        return this.analogOut.getDACMaximum();
    }

    public int getDACIncrement() {
        return this.analogOut.getDACIncrement();
    }

    public Integer getDACCounts(int channel) {
        return this.analogOut.getDACCounts(0);
    }

    public boolean isDACPresent() throws IOException {
        return this.analogOut.isDACPresent();
    }

    public int getDACPins() {
        return this.analogOut.getDACPins();
    }

    public double[] getIrradianceCalibrationFactors() throws IOException {
        return this.irradianceCalibrationFactor.getIrradianceCalibrationFactors();
    }

    public void setIrradianceCalibrationFactors(double[] data) throws IOException {
        this.irradianceCalibrationFactor.setIrradianceCalibrationFactors(data);
    }

    public double getCollectionArea() throws IOException {
        return this.irradianceCalibrationFactor.getCollectionArea();
    }

    public boolean hasCollectionArea() {
        return this.irradianceCalibrationFactor.hasCollectionArea();
    }

    public void setCollectionArea(double area) throws IOException {
        this.irradianceCalibrationFactor.setCollectionArea(area);
    }

    public void setMasterClockDivisor(int value) throws IOException {
        this.masterClockDivisor.setMasterClockDivisor(value);
    }

    public int getMasterClockDivisor() throws IOException {
        return this.masterClockDivisor.getMasterClockDivisor();
    }

    public void setExternalTriggerDelay(int counts) throws IOException {
        this.triggerDelay.setExternalTriggerDelay(counts);
    }

    public double triggerDelayCountsToMicroseconds(int counts) {
        return this.triggerDelay.triggerDelayCountsToMicroseconds(counts);
    }

    public Integer getExternalTriggerDelay() {
        return this.triggerDelay.getExternalTriggerDelay();
    }

    public int getExternalTriggerDelayMinimum() {
        return this.triggerDelay.getExternalTriggerDelayMinimum();
    }

    public int getExternalTriggerDelayMaximum() {
        return this.triggerDelay.getExternalTriggerDelayMaximum();
    }

    public int getExternalTriggerDelayIncrement() {
        return this.triggerDelay.getExternalTriggerDelayIncrement();
    }

    public Coefficients[] readNonlinearityCoefficientsFromSpectrometer() {
        return this.nonlinearity.readNonlinearityCoefficientsFromSpectrometer();
    }

    public void writeNonlinearityCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.nonlinearity.writeNonlinearityCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getNonlinearityCoefficients() {
        return this.nonlinearity.getNonlinearityCoefficients();
    }

    public void setNonlinearityCoefficients(Coefficients[] coefficients) {
        this.nonlinearity.setNonlinearityCoefficients(coefficients);
    }

    public double[] getNonlinearityCoefficientsSingleChannel(int index) {
        return this.nonlinearity.getNonlinearityCoefficientsSingleChannel(index);
    }

    public void setNonlinearityCoefficientsSingleChannel(double[] nl, int index) {
        this.nonlinearity.setNonlinearityCoefficientsSingleChannel(nl, index);
    }

    public Coefficients[] readWavelengthCalibrationCoefficientsFromSpectrometer() {
        return this.wavelength.readWavelengthCalibrationCoefficientsFromSpectrometer();
    }

    public void writeWavelengthCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.wavelength.writeWavelengthCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getWavelengthCalibrationCoefficients() {
        return this.wavelength.getWavelengthCalibrationCoefficients();
    }

    public void setWavelengthCalibrationCoefficients(Coefficients[] coefficients) {
        this.wavelength.setWavelengthCalibrationCoefficients(coefficients);
    }

    public double[] getWavelengths(int index) {
        return this.wavelength.getWavelengths(index);
    }

    public void setWavelengths(double[] wl, int index) {
        this.wavelength.setWavelengths(wl, index);
    }

    public Coefficients[] readStrayLightCorrectionCoefficientFromSpectrometer() {
        return this.straylight.readStrayLightCorrectionCoefficientFromSpectrometer();
    }

    public void writeStrayLightCoefficientToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.straylight.writeStrayLightCoefficientToSpectrometer(coefficients);
    }

    public void setStrayLightCorrectionCoefficient(Coefficients[] coefficients) {
        this.straylight.setStrayLightCorrectionCoefficient(coefficients);
    }

    public Coefficients[] getStrayLightCorrectionCoefficient() {
        return this.straylight.getStrayLightCorrectionCoefficient();
    }

    public void setStrayLight(double strayLight, int index) {
        this.straylight.setStrayLight(strayLight, index);
    }

    public double getStrayLight(int index) {
        return this.straylight.getStrayLight(index);
    }

    public boolean isAdvancedVersion() {
        return this instanceof AdvancedVersion;
    }

    public void uploadFirmware(File file, long fileSize) throws IOException {
        this.version.uploadFirmware(file, fileSize);
    }

    public void uploadFPGA(File file, long fileSize) throws IOException {
        this.version.uploadFPGA(file, fileSize);
    }

    public void addAcquisitionListener(AcquisitionListener listener) {
        this.version.addAcquisitionListener(listener);
    }

    public void removeAcquisitionListener(AcquisitionListener listener) {
        this.version.removeAcquisitionListener(listener);
    }
}

