/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.jaz;

import com.oceanoptics.omnidriver.constants.ExternalTriggerMode;
import com.oceanoptics.omnidriver.features.autonulling.Autonulling;
import com.oceanoptics.omnidriver.features.autonulling.AutonullingConfiguration;
import com.oceanoptics.omnidriver.features.autonulling.AutonullingGUIProvider;
import com.oceanoptics.omnidriver.features.autonulling.AutonullingImpl_Jaz;
import com.oceanoptics.omnidriver.features.autonulling.AutonullingImpl_JazNetwork;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobe;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobeGUIProvider;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobeImpl_Jaz;
import com.oceanoptics.omnidriver.features.externaltriggerdelay.ExternalTriggerDelay;
import com.oceanoptics.omnidriver.features.externaltriggerdelay.ExternalTriggerDelayGUIProvider;
import com.oceanoptics.omnidriver.features.externaltriggerdelay.ExternalTriggerDelayImpl_Jaz;
import com.oceanoptics.omnidriver.features.gpio.GPIO;
import com.oceanoptics.omnidriver.features.gpio.GPIOGUIProvider;
import com.oceanoptics.omnidriver.features.gpio.GPIOImpl_Jaz;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTrigger;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTriggerGUIProvider;
import com.oceanoptics.omnidriver.features.indy.Indy;
import com.oceanoptics.omnidriver.features.indy.IndyCurrentSample;
import com.oceanoptics.omnidriver.features.indy.IndyGUIProvider;
import com.oceanoptics.omnidriver.features.indy.IndyImpl;
import com.oceanoptics.omnidriver.features.indy.IndyVoltageSample;
import com.oceanoptics.omnidriver.features.internaltrigger.InternalTrigger;
import com.oceanoptics.omnidriver.features.internaltrigger.InternalTriggerGUIProvider;
import com.oceanoptics.omnidriver.features.internaltrigger.InternalTriggerImpl_Jaz;
import com.oceanoptics.omnidriver.features.internaltrigger.TriggerSource;
import com.oceanoptics.omnidriver.features.multichannelprovider.MultiChannelGUIProvider;
import com.oceanoptics.omnidriver.features.multichannelprovider.MultiChannelImpl_JazNetwork;
import com.oceanoptics.omnidriver.features.multichannelprovider.MultiChannelListener;
import com.oceanoptics.omnidriver.features.multichannelprovider.MultiChannelProvider;
import com.oceanoptics.omnidriver.features.networksource.NetworkSourceGUIProvider;
import com.oceanoptics.omnidriver.features.networksource.NetworkSourceImpl;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionImpl;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionProvider;
import com.oceanoptics.omnidriver.features.singlestrobe.SingleStrobe;
import com.oceanoptics.omnidriver.features.singlestrobe.SingleStrobeGUIProvider;
import com.oceanoptics.omnidriver.features.singlestrobe.SingleStrobeImpl_Jaz;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrection;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionImpl;
import com.oceanoptics.omnidriver.features.uvvislightsource.UV_VIS_LightSourceGUIProvider;
import com.oceanoptics.omnidriver.features.uvvislightsource.UV_VIS_LightSourceImpl_JAZ;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationGUIProvider;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationProvider;
import com.oceanoptics.omnidriver.interfaces.GUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.interfaces.UV_VIS_LightSourceJAZCompatible;
import com.oceanoptics.omnidriver.jwrappers.JSocket;
import com.oceanoptics.omnidriver.spectra.SpectrometerInfo;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.Configuration;
import com.oceanoptics.omnidriver.spectrometer.NetworkSpectrometer;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerChannel;
import com.oceanoptics.omnidriver.spectrometer.jaz.SpectrometerChannelJaz;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;
import java.net.Socket;
import java.util.BitSet;
import java.util.Vector;

public class JazNetwork
extends NetworkSpectrometer
implements WavelengthCalibrationProvider,
NonlinearityCorrectionProvider,
StrayLightCorrection,
SingleStrobe,
ContinuousStrobe,
InternalTrigger,
GPIO,
Autonulling,
ExternalTriggerDelay,
MultiChannelProvider,
HardwareTrigger,
Indy,
UV_VIS_LightSourceJAZCompatible {
    protected int spectrumReadThrottleMilliseconds = 0;
    protected int socketTimeoutMilliseconds = 0;
    protected boolean checkForBytesAvailable = false;
    protected int readSpectrumRetryLimit = 0;
    static Spectrometer[] scoreboard = new Spectrometer[64];
    private NetworkSourceGUIProvider network;
    private WavelengthCalibrationGUIProvider wavelength;
    private NonlinearityCorrectionGUIProvider nonlinearity;
    private StrayLightCorrectionGUIProvider straylight;
    private AutonullingGUIProvider autonulling;
    private HardwareTriggerGUIProvider hardwareTrigger;
    private AutonullingConfiguration[] autonullingConfiguration = null;
    private MultiChannelGUIProvider multiChannel;
    private ExternalTriggerDelayGUIProvider triggerDelay;
    private UV_VIS_LightSourceGUIProvider uv_vis_lampModule;
    private SingleStrobeGUIProvider singleStrobe;
    private GPIOGUIProvider gpio;
    private ContinuousStrobeGUIProvider continuousStrobe;
    private InternalTriggerGUIProvider internalTrigger;
    private IndyGUIProvider indy = null;
    private Socket dataSocket = new Socket();
    private Socket messagingSocket = new Socket();
    private byte[] out = new byte[256];
    private String serialNumber = new String();
    private Configuration[] configurations = null;
    private int DPUFPGAVersion = 0;
    private int minimumSpecFPGAVersion = 0;
    private int numberOfEnabledChannels;
    private int lastSelectedChannel;
    private int lastTriggerMode = 0;
    private boolean hasIndy = false;
    private boolean pushingParameters = false;
    private int uvIntensity = 255;
    private int visIntensity = 255;
    private static String __extern__ = "__extern__\n<init>,(I)V\n<init>,(Ljava/net/Socket;)V\n<init>,(Lcom/oceanoptics/omnidriver/jwrappers/JSocket;)V\ngetSpectrumReadThrottleMilliseconds,()I\nsetSpectrumReadThrottleMilliseconds,(I)V\ngetSocketTimeoutMilliseconds,()I\nsetSocketTimeoutMilliseconds,(I)V\nisCheckForBytesAvailableEnabled,()Z\nsetCheckForBytesAvailable,(Z)V\ngetReadSpectrumRetryLimit,()I\nsetReadSpectrumRetryLimit,(I)V\nopenSpectrometer,(I)V\ngetGUIFeatures,()[Lcom/oceanoptics/omnidriver/interfaces/GUIProvider;\ngetDataSocket,()Ljava/net/Socket;\ngetSerialNumber,()Ljava/lang/String;\ngetFirmwareVersion,()Ljava/lang/String;\ncloseSpectrometer,()V\ngetJazInfo,(I)Ljava/lang/String;\ngetJazInfoBytes,(I)[B\ngetInfo,(I)Ljava/lang/String;\ngetInfoBytes,(I)[B\nreadWavelengthCalibrationCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteWavelengthCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengthCalibrationCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetWavelengthCalibrationCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengths,(I)[D\nsetWavelengths,([DI)V\nconnectToSource,(Ljava/lang/String;I)V\nisConnected,()Z\ngetName,()Ljava/lang/String;\ngetNumberOfChannels,()I\ngetNumberOfEnabledChannels,()I\ndisconnect,()V\nsetStrobeEnable,(Z)V\nsetIntegrationTime,(I)V\ngetSpectrum,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)Lcom/oceanoptics/omnidriver/spectra/Spectrum;\nreconnect,()V\nsetAutonullingConfiguration,(Lcom/oceanoptics/omnidriver/features/autonulling/AutonullingConfiguration;)V\nsetAutonullingScanValue,(I)V\nsetAutonullingScanStatus,(I)V\nwriteAutonullingConfigurationToSpectrometer,()V\nreadAutonullingConfigurationFromSpectrometer,()Lcom/oceanoptics/omnidriver/features/autonulling/AutonullingConfiguration;\ngetAutonullingScanValue,()I\ngetAutonullingScanStatus,()I\ngetAutonullingConfiguration,()Lcom/oceanoptics/omnidriver/features/autonulling/AutonullingConfiguration;\nsetSingleStrobeLow,(I)V\nsetSingleStrobeHigh,(I)V\ngetSingleStrobeCountsToMicros,(I)D\ngetSingleStrobeMinimum,()I\ngetSingleStrobeMaximum,()I\ngetSingleStrobeLow,()I\ngetSingleStrobeIncrement,()I\ngetSingleStrobeHigh,()I\ngetChannelsPresent,()[Z\nisChannelPresent,(I)Z\nsetChannels,([Lcom/oceanoptics/omnidriver/spectrometer/SpectrometerChannel;)V\nsetChannelMux,(I)V\nsetChannelStatus,(IZ)V\nsetDeepWellStatus,(Z)V\nsetChannelPresent,(IZ)V\nisDeepWell,()Z\nisInterpolationEnabled,()Z\nsetInterpolationEnabled,(Z)V\naddChannelListener,(Lcom/oceanoptics/omnidriver/features/multichannelprovider/MultiChannelListener;)V\nremoveChannelListener,(Lcom/oceanoptics/omnidriver/features/multichannelprovider/MultiChannelListener;)V\nreadNumberOfChannels,()I\nwriteChannelMux,(I)V\ngetChannelConfigurations,()[Lcom/oceanoptics/omnidriver/spectrometer/Configuration;\ngetConfiguration,(I)Lcom/oceanoptics/omnidriver/spectrometer/Configuration;\nsetExternalTriggerDelay,(I)V\ngetExternalTriggerDelay,()Ljava/lang/Integer;\ntriggerDelayCountsToMicroseconds,(I)D\ngetExternalTriggerDelayMinimum,()I\ngetExternalTriggerDelayMaximum,()I\ngetExternalTriggerDelayIncrement,()I\nsetPowerUpPOTValues,()V\ngetPOTValues,()[S\nsetPOTValue,(II)V\nreadNonlinearityCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteNonlinearityCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetNonlinearityCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficientsSingleChannel,(I)[D\nsetNonlinearityCoefficientsSingleChannel,([DI)V\nreadStrayLightCorrectionCoefficientFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteStrayLightCoefficientToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\nsetStrayLightCorrectionCoefficient,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetStrayLightCorrectionCoefficient,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetStrayLight,(DI)V\ngetStrayLight,(I)D\nsetExternalTriggerMode,(I)V\ngetExternalTriggerMode,()Ljava/lang/Integer;\ngetExternalTriggerModes,()[Lcom/oceanoptics/omnidriver/constants/ExternalTriggerMode;\ngetValueBits,()Ljava/util/BitSet;\ngetValueBit,(I)I\nsetValueAllBits,(Ljava/util/BitSet;)V\nsetValueBitmask,(S)V\nsetValueBit,(IZ)V\ngetDirectionBits,()Ljava/util/BitSet;\nsetDirectionAllBits,(Ljava/util/BitSet;)V\nsetDirectionBitmask,(S)V\nsetDirectionBit,(IZ)V\ngetMuxBits,()Ljava/util/BitSet;\ngetNumberOfPins,()I\nsetMuxAllBits,(Ljava/util/BitSet;)V\nsetMuxBitmask,(S)V\nsetMuxBit,(IZ)V\ngetTotalGPIOBits,()I\nsetContinuousStrobeDelay,(I)V\ngetContinuousStrobeDelayIncrement,(I)I\ncontinuousStrobeCountsToMicros,(I)D\ngetContinuousStrobeDelayMinimum,()I\ngetContinuousStrobeDelayMaximum,()I\ngetContinuousStrobeDelay,()Ljava/lang/Integer;\nsetTriggerSource,(Lcom/oceanoptics/omnidriver/features/internaltrigger/TriggerSource;)V\nsetInternalTriggerPeriodMicros,(I)V\ngetTriggerSource,()Lcom/oceanoptics/omnidriver/features/internaltrigger/TriggerSource;\ngetInternalTriggerPeriodMinimum,()I\ngetInternalTriggerPeriodMicros,()Ljava/lang/Integer;\ngetInternalTriggerPeriodMaximum,()I\ngetInternalTriggerPeriodIncrement,()I\ngetNumberOfIndyModules,()I\ngetNumberOfVoltageOutputs,(I)I\ngetNumberOfVoltageInputs,(I)I\ngetNumberOfCurrentOutputs,(I)I\ngetNumberOfCurrentInputs,(I)I\ngetNumberOfIndyGPIO,(I)I\ngetVoltageOutputMaximumCounts,(II)I\ngetCurrentOutputMaximumCounts,(II)I\nsampleVoltageInputs,(I)[Lcom/oceanoptics/omnidriver/features/indy/IndyVoltageSample;\ngetVoltageOutputs,(I)[Lcom/oceanoptics/omnidriver/features/indy/IndyVoltageSample;\nsampleCurrentInputs,(I)[Lcom/oceanoptics/omnidriver/features/indy/IndyCurrentSample;\ngetCurrentOutputs,(I)[Lcom/oceanoptics/omnidriver/features/indy/IndyCurrentSample;\ngetCurrentOutputEnables,(I)[Z\ngetCurrentOutputEnergized,(I)[Z\ngetIndyGPIOInputValues,(I)I\ngetIndyGPIOOutputValues,(I)I\ngetIndyGPIOOutputEnables,(I)I\ngetExcitationEnable,(II)Z\ngetExcitationVoltage,(II)F\ngetExcitationVoltageOptions,(II)[F\ngetCurrentOutputCalibration4mA,(II)I\ngetCurrentOutputCalibration20mA,(II)I\nsetVoltageOutputVolts,(IIF)V\nsetVoltageOutputCounts,(III)V\nsetCurrentOutputMilliamps,(IIF)V\nsetCurrentOutputCounts,(III)V\nsetIndyGPIOConfiguration,(IIII)V\nsetIndyGPIOOutputValues,(III)V\nsetCurrentOutputEnable,(IIZ)V\nsetExcitationVoltage,(IIF)V\nsetExcitationEnable,(IIZ)V\nsetCurrentOutputCalibration4mA,(III)V\nsetCurrentOutputCalibration20mA,(III)V\n";

    public JazNetwork(int i) throws IOException {
        this.openSpectrometer(i);
    }

    public JazNetwork(Socket socket) throws IOException {
        if (!socket.isConnected()) {
            throw new IOException("Socket is not connected.");
        }
        this.dataSocket = socket;
        this.address = socket.getInetAddress().toString().substring(1);
        this.port = socket.getPort();
        this.messagingSocket = new Socket(this.dataSocket.getInetAddress(), this.port + 1);
        this.openSpectrometer(0);
    }

    public JazNetwork(JSocket jSocket) throws IOException {
        this(jSocket.getEmbeddedSocket());
    }

    protected Spectrometer[] getScoreboard() {
        return scoreboard;
    }

    public int getSpectrumReadThrottleMilliseconds() {
        return this.spectrumReadThrottleMilliseconds;
    }

    public void setSpectrumReadThrottleMilliseconds(int value) {
        this.spectrumReadThrottleMilliseconds = value;
    }

    public int getSocketTimeoutMilliseconds() {
        return this.socketTimeoutMilliseconds;
    }

    public void setSocketTimeoutMilliseconds(int value) {
        this.socketTimeoutMilliseconds = value;
    }

    public boolean isCheckForBytesAvailableEnabled() {
        return this.checkForBytesAvailable;
    }

    public void setCheckForBytesAvailable(boolean value) {
        this.checkForBytesAvailable = value;
    }

    public int getReadSpectrumRetryLimit() {
        return this.readSpectrumRetryLimit;
    }

    public void setReadSpectrumRetryLimit(int value) {
        this.readSpectrumRetryLimit = value;
    }

    public void openSpectrometer(int index) throws IOException {
        this.integrationTimeMinimum = 3000;
        this.integrationTimeMaximum = 65535000;
        this.integrationTimeIncrement = 1000;
        this.integrationTimeBase = 1;
        this.numberOfCCDPixels = 2048;
        this.numberOfDarkCCDPixels = 13;
        this.maxIntensity = 65535;
        this.rawData = new byte[this.numberOfCCDPixels * 2];
        this.multiChannel = new MultiChannelImpl_JazNetwork(this);
        this.setChannelMux(0);
        this.channels = new SpectrometerChannel[this.multiChannel.getNumberOfChannels()];
        for (int i = 0; i < this.channels.length; ++i) {
            this.channels[i] = new SpectrometerChannel(this, new Coefficients(), i);
        }
        this.numChannels = this.channels.length;
        this.logger.fine("Simple network spectrometer has been opened at index " + index);
        this.initFeatures(this.usb);
        this.finishConstruction();
    }

    protected void initFeatures(USBInterface usb) throws IOException {
        this.network = new NetworkSourceImpl(usb, this);
        this.reInitFeatures(usb);
    }

    protected void reInitFeatures(USBInterface usb) throws IOException {
        this.probeJazStack();
        this.wavelength = new WavelengthCalibrationImpl(this.usb, this);
        this.nonlinearity = new NonlinearityCorrectionImpl(this.usb, this);
        this.straylight = new StrayLightCorrectionImpl(this.usb, this);
        this.autonulling = new AutonullingImpl_JazNetwork(this.usb, this.getNumberOfChannels(), this);
        this.autonullingConfiguration = new AutonullingConfiguration[this.getNumberOfChannels()];
        for (int i = 0; i < this.channels.length; ++i) {
            ((AutonullingImpl_Jaz)this.autonulling).setSelectedChannel(i);
            this.autonullingConfiguration[i] = ((AutonullingImpl_Jaz)this.autonulling).readAutonullingConfigurationFromSpectrometer();
        }
        this.uv_vis_lampModule = new UV_VIS_LightSourceImpl_JAZ(this.usb, this);
        if (this.minimumSpecFPGAVersion >= 147) {
            this.triggerDelay = new ExternalTriggerDelayImpl_Jaz.Network(this.dataSocket, this.out);
            this.hardwareTrigger = new HardwareTriggerProvider(new ExternalTriggerMode[]{new ExternalTriggerMode(0), new ExternalTriggerMode(1), new ExternalTriggerMode(2), new ExternalTriggerMode(3)});
        } else {
            this.hardwareTrigger = new HardwareTriggerProvider(new ExternalTriggerMode[]{new ExternalTriggerMode(0)});
        }
        if (this.DPUFPGAVersion >= 133) {
            this.singleStrobe = new SingleStrobeImpl_Jaz.Network(this.dataSocket, this.in, this.out);
            this.continuousStrobe = new ContinuousStrobeImpl_Jaz.Network(this.dataSocket, this.in, this.out);
            this.gpio = new GPIOImpl_Jaz.Network(this.dataSocket, this.in, this.out);
            this.internalTrigger = new InternalTriggerImpl_Jaz.Network(this.dataSocket, this.in, this.out);
        }
        if (this.hasIndy) {
            this.indy = new IndyImpl.Network(this.messagingSocket, this.in, this.out);
        }
    }

    protected void finishConstruction() throws IOException {
        int i;
        this.numberOfPixels = this.numberOfCCDPixels;
        this.numberOfDarkPixels = this.numberOfDarkCCDPixels;
        this.benchSlot = 15;
        this.spectrometerConfigSlot = 16;
        if (this.isConnected()) {
            this.serialNumber = this.getJazInfo(1);
            this.logger.finest("Serial number: " + this.serialNumber);
            this.channels = new SpectrometerChannel[this.multiChannel.getNumberOfChannels()];
            for (i = 0; i < this.channels.length; ++i) {
                this.multiChannel.setChannelMux(i);
                String channelSerialNumber = this.getInfo(0);
                this.channels[i] = new SpectrometerChannelJaz(this, new Coefficients(), channelSerialNumber, i);
            }
            this.configurations = new Configuration[this.channels.length];
            for (i = 0; i < this.channels.length; ++i) {
                this.multiChannel.setChannelMux(i);
                this.configurations[i] = new Configuration(this);
            }
            this.configuration = this.configurations[0];
        }
        for (i = 0; i < this.channels.length; ++i) {
            this.channels[i].getCoefficientsFromSpectrometer();
        }
        this.spectrumBase = new SpectrometerInfo(this.getSerialNumber(), this.getFirmwareVersion(), this.getClass(), null, this.numChannels, this.getNumberOfCCDPixels(), this.getNumberOfDarkCCDPixels(), this.getMaxIntensity(), this.getIntegrationTimeMinimum(), this.getIntegrationTimeMaximum(), this.getIntegrationTimeIncrement(), this.getIntegrationTimeBase());
        for (i = 0; i < this.channels.length; ++i) {
            this.channels[i].generateMetadata(this.spectrumBase, i);
        }
        this.reInitFeatures(this.usb);
    }

    private void probeJazStack() {
        try {
            byte[] fpgaVersionBytes = this.getJazInfoBytes(176);
            this.DPUFPGAVersion = ByteRoutines.makeDWord((byte)0, (byte)0, (byte)fpgaVersionBytes[0], (byte)fpgaVersionBytes[1]);
            int minSpecVersion = 0;
            byte[] countBytes = this.getJazInfoBytes(192);
            int numberModules = countBytes[0];
            for (int i = 0; i < numberModules && i < 15; ++i) {
                byte[] moduleBytes = this.getJazInfoBytes(193 + i);
                if (moduleBytes[0] == -80) {
                    int version = ByteRoutines.makeDWord((byte)0, (byte)0, (byte)moduleBytes[2], (byte)moduleBytes[3]);
                    if (version >= minSpecVersion && minSpecVersion != 0) continue;
                    minSpecVersion = version;
                    continue;
                }
                if (moduleBytes[0] != 113) continue;
                this.hasIndy = true;
            }
            this.minimumSpecFPGAVersion = minSpecVersion;
            if (this.minimumSpecFPGAVersion >= 147) {
                this.integrationTimeMinimum = 1000;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public GUIProvider[] getGUIFeatures() {
        Vector<GUIProvider> features = new Vector<GUIProvider>();
        features.add(this.network);
        features.add(this.wavelength);
        features.add(this.nonlinearity);
        features.add(this.straylight);
        features.add(this.autonulling);
        features.add(this.multiChannel);
        if (this.DPUFPGAVersion >= 133) {
            features.add(this.singleStrobe);
            features.add(this.continuousStrobe);
            features.add(this.internalTrigger);
            features.add(this.gpio);
        }
        if (this.minimumSpecFPGAVersion >= 147) {
            features.add(this.triggerDelay);
        }
        if (this.hasIndy && null != this.indy) {
            features.add(this.indy);
        }
        return features.toArray(new GUIProvider[0]);
    }

    public Socket getDataSocket() {
        return this.dataSocket;
    }

    public String getSerialNumber() throws IOException {
        return this.serialNumber;
    }

    public String getFirmwareVersion() throws IOException {
        this.firmwareVersion = "Unknown";
        return this.firmwareVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStabilityScan(int numScans) throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                if (this.dataSocket.isConnected()) {
                    this.requestSpectrum();
                    this.readSpectrum();
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            return;
        }
    }

    public void closeSpectrometer() throws IOException {
        this.disconnect();
    }

    protected void finalize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJazInfo(int slot) throws IOException {
        String retval = new String();
        byte[] byArray = this.out;
        synchronized (this.out) {
            byte[] byArray2 = this.in;
            synchronized (this.in) {
                this.out[0] = -58;
                this.out[1] = (byte)slot;
                this.dataSocket.getOutputStream().write(this.out, 0, 2);
                this.dataSocket.getInputStream().read(this.in, 0, 17);
                for (int i = 2; this.in[i] != 0 && i < 17; ++i) {
                    retval = retval + (char)this.in[i];
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getJazInfoBytes(int slot) throws IOException {
        byte[] retval = new byte[15];
        byte[] byArray = this.out;
        synchronized (this.out) {
            byte[] byArray2 = this.in;
            synchronized (this.in) {
                this.out[0] = -58;
                this.out[1] = (byte)slot;
                this.dataSocket.getOutputStream().write(this.out, 0, 2);
                this.dataSocket.getInputStream().read(this.in, 0, 17);
                for (int i = 0; i < 15; ++i) {
                    retval[i] = this.in[i + 2];
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInfo(int slot) throws IOException {
        if (this.dataSocket.isClosed() || !this.dataSocket.isConnected()) {
            throw new IOException("Cannot read info when socket is closed");
        }
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                int i;
                this.out[0] = 5;
                this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)slot));
                String strRet = "";
                try {
                    this.dataSocket.getOutputStream().write(this.out, 0, 2);
                }
                catch (Exception e) {
                    this.reconnect();
                    this.pushAcquisitionParameters();
                    throw new IOException("Failed to write to device, attempting to reconnect");
                }
                int len = 0;
                try {
                    len = this.dataSocket.getInputStream().read(this.in, 0, 17);
                }
                catch (Exception e) {
                    this.reconnect();
                    this.pushAcquisitionParameters();
                    throw new IOException("Failed to read from device, attempting to reconnect");
                }
                for (i = 2; this.in[i] != 0 && i < 17; ++i) {
                    strRet = strRet + (char)this.in[i];
                }
                if (5 == slot && i < 16 && this.in[i] == 0 && this.in[i + 1] != 0) {
                    ++i;
                    strRet = strRet + " ";
                    while (this.in[i] != 0 && i < 17) {
                        strRet = strRet + (char)this.in[i];
                        ++i;
                    }
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return strRet;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getInfoBytes(int slot) throws IOException {
        if (this.dataSocket.isClosed() || !this.dataSocket.isConnected()) {
            throw new IOException("Cannot read info when socket is closed");
        }
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                byte[] byteArray = new byte[15];
                this.out[0] = 5;
                this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)slot));
                String strRet = "";
                try {
                    this.dataSocket.getOutputStream().write(this.out, 0, 2);
                }
                catch (Exception e) {
                    this.reconnect();
                    this.pushAcquisitionParameters();
                    throw new IOException("Failed to write to device, attempting to reconnect");
                }
                int len = 0;
                try {
                    len = this.dataSocket.getInputStream().read(this.in, 0, 17);
                }
                catch (Exception e) {
                    this.reconnect();
                    this.pushAcquisitionParameters();
                    throw new IOException("Failed to read from device, attempting to reconnect");
                }
                for (int i = 0; i < 15; ++i) {
                    byteArray[i] = this.in[i + 2];
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return byteArray;
            }
        }
    }

    public Coefficients[] readWavelengthCalibrationCoefficientsFromSpectrometer() {
        return this.wavelength.readWavelengthCalibrationCoefficientsFromSpectrometer();
    }

    public void writeWavelengthCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.wavelength.writeWavelengthCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getWavelengthCalibrationCoefficients() {
        return this.wavelength.getWavelengthCalibrationCoefficients();
    }

    public void setWavelengthCalibrationCoefficients(Coefficients[] coefficients) {
        this.wavelength.setWavelengthCalibrationCoefficients(coefficients);
    }

    public double[] getWavelengths(int index) {
        return this.wavelength.getWavelengths(index);
    }

    public void setWavelengths(double[] wl, int index) {
        this.wavelength.setWavelengths(wl, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectToSource(String address, int port) {
        JazNetwork jazNetwork = this;
        synchronized (jazNetwork) {
            try {
                if (this.dataSocket.isConnected()) {
                    this.dataSocket.close();
                }
                this.dataSocket = new Socket(address, port);
                this.dataSocket.setSoTimeout(0);
                this.dataSocket.setSoLinger(false, 1);
                this.messagingSocket = new Socket(address, port + 1);
                this.dataSocket.setSoTimeout(0);
                this.dataSocket.setSoLinger(false, 1);
                this.finishConstruction();
            }
            catch (Exception e) {
                this.dataSocket = new Socket();
                this.messagingSocket = new Socket();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        JazNetwork jazNetwork = this;
        synchronized (jazNetwork) {
            return this.dataSocket.isConnected();
        }
    }

    public String getName() {
        return "Jaz-(Network)";
    }

    public int getNumberOfChannels() {
        return this.multiChannel.getNumberOfChannels();
    }

    public int getNumberOfEnabledChannels() {
        this.numberOfEnabledChannels = this.multiChannel.getNumberOfEnabledChannels();
        return this.numberOfEnabledChannels;
    }

    public void disconnect() {
        try {
            this.dataSocket.close();
            this.messagingSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dataSocket = new Socket();
        this.messagingSocket = new Socket();
    }

    protected Spectrum formatData(byte[] data, Spectrum doubleSpectrum) throws IOException {
        byte zero = 0;
        double[] spectrum = doubleSpectrum.getSpectrum();
        this.logger.finest("Formatting data");
        double saturationValue = this.autonullingConfiguration[this.lastSelectedChannel].getSaturationValue();
        doubleSpectrum.setSaturated(false);
        for (int i = 0; i < this.numberOfCCDPixels; ++i) {
            byte MSB = data[2 * i + 1];
            byte LSB = data[2 * i];
            int pixel = ByteRoutines.makeDWord((byte)zero, (byte)zero, (byte)MSB, (byte)LSB);
            if ((double)pixel >= saturationValue) {
                doubleSpectrum.setSaturated(true);
                pixel = (int)saturationValue;
            }
            spectrum[i] = (double)pixel * (double)this.maxIntensity / saturationValue;
        }
        ((AutonullingImpl_Jaz)this.autonulling).setAutonullingScanStatus((int)spectrum[0], this.lastSelectedChannel);
        ((AutonullingImpl_Jaz)this.autonulling).setAutonullingScanValue((int)spectrum[1], this.lastSelectedChannel);
        spectrum[0] = spectrum[2];
        spectrum[1] = spectrum[2];
        return doubleSpectrum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrobeEnable(boolean strobe) throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            if (this.dataSocket.isClosed() || !this.dataSocket.isConnected()) {
                throw new IOException("Cannot control strobe when socket is closed");
            }
            if (this.strobeOn == null) {
                this.strobeOn = new Boolean(strobe);
            } else if (this.strobeOn == strobe) {
                this.logger.fine("Desired strobe enable state already set, not pushing to spectrometer");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int on = !strobe ? 0 : 1;
            this.out[0] = 3;
            this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)on));
            this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)on));
            try {
                this.dataSocket.getOutputStream().write(this.out, 0, 3);
            }
            catch (Exception e) {
                this.reconnect();
                this.pushAcquisitionParameters();
                throw new IOException("Failed to write to device, attempting to reconnect");
            }
            if (strobe != this.strobeOn && this.isStabilityScan()) {
                this.doStabilityScan(1);
            }
            this.strobeOn = strobe ? Boolean.TRUE : Boolean.FALSE;
            this.logger.fine("Strobe enabled: " + strobe);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIntegrationTime(int intTime) throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            boolean needStabilityScan;
            if (this.dataSocket.isClosed() || !this.dataSocket.isConnected()) {
                throw new IOException("Cannot set integration time when socket is closed");
            }
            boolean bl = needStabilityScan = this.integrationTime != intTime;
            if (!needStabilityScan && !this.pushingParameters) {
                this.logger.fine("Desired integration time already set, not pushing to spectrometer");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int maxTime = this.getIntegrationTimeMaximum();
            int minTime = this.getIntegrationTimeMinimum();
            if (intTime < minTime) {
                intTime = minTime;
            } else if (intTime > maxTime) {
                intTime = maxTime;
            }
            this.integrationTime = intTime;
            this.out[0] = 2;
            this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)(intTime /= this.getIntegrationTimeBase())));
            this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)intTime));
            this.out[3] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)intTime));
            this.out[4] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)intTime));
            try {
                this.dataSocket.getOutputStream().write(this.out, 0, 5);
            }
            catch (Exception e) {
                this.reconnect();
                this.pushAcquisitionParameters();
                throw new IOException("Failed to write to device, attempting to reconnect");
            }
            this.logger.fine("Integration time set to: " + intTime);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Spectrum getSpectrum(Spectrum spectrum) throws IOException {
        this.logger.finest("Getting spectrum...");
        this.timeoutOccurredFlag = false;
        if (!this.dataSocket.isConnected()) {
            throw new IOException("Network spectrometer not connected!");
        }
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                if (this.dataSocket.isConnected()) {
                    this.requestSpectrum();
                    this.readSpectrum();
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            {
                spectrum.setSaturated(false);
                this.formatData(this.rawData, spectrum);
                return spectrum;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestSpectrum() throws IOException {
        if (this.dataSocket.isClosed() || !this.dataSocket.isConnected()) {
            throw new IOException("Cannot request spectrum when socket is closed");
        }
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.logger.finer("Spectrum requested.");
            this.out[0] = 9;
            try {
                this.dataSocket.getOutputStream().write(this.out, 0, 1);
            }
            catch (Exception e) {
                this.reconnect();
                this.pushAcquisitionParameters();
                throw new IOException("Failed to write to device, attempting to reconnect");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readSpectrum() throws IOException {
        if (this.dataSocket.isClosed() || !this.dataSocket.isConnected()) {
            throw new IOException("Cannot read spectrum when socket is closed");
        }
        byte[] byArray = this.rawData;
        synchronized (this.rawData) {
            int numberOfBytesAvailable = 0;
            int len = 0;
            try {
                int retryCount = 0;
                while (len < this.numberOfCCDPixels * 2) {
                    if (this.getReadSpectrumRetryLimit() > 0 && retryCount > this.getReadSpectrumRetryLimit()) {
                        throw new IOException("Failed to read from device.  Retry count exceeded.");
                    }
                    if (this.getSpectrumReadThrottleMilliseconds() > 0) {
                        Thread.sleep(this.getSpectrumReadThrottleMilliseconds());
                    }
                    if (this.isCheckForBytesAvailableEnabled()) {
                        numberOfBytesAvailable = this.dataSocket.getInputStream().available();
                    }
                    if (!this.isCheckForBytesAvailableEnabled() || numberOfBytesAvailable > 0) {
                        len += this.dataSocket.getInputStream().read(this.rawData, len, this.numberOfCCDPixels * 2 - len);
                    }
                    ++retryCount;
                }
            }
            catch (Exception e) {
                this.reconnect();
                this.pushAcquisitionParameters();
                throw new IOException("Failed to read from device, attempting to reconnect");
            }
            if (len < this.getNumberOfPixels() * 2) {
                throw new IOException("Got a short read (" + len + " bytes)");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void reconnect() {
        this.network.reconnect();
    }

    protected void pushAcquisitionParameters() {
        try {
            if (this.network.isConnected()) {
                this.pushingParameters = true;
                this.setChannelMux(this.lastSelectedChannel);
                this.setIntegrationTime(this.integrationTime);
                this.setExternalTriggerMode(this.lastTriggerMode);
                if (null != this.strobeOn) {
                    this.setStrobeEnable(this.strobeOn);
                } else {
                    this.setStrobeEnable(false);
                }
                this.pushingParameters = false;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.pushingParameters = false;
        }
    }

    public void setAutonullingConfiguration(AutonullingConfiguration configuration) {
        this.autonulling.setAutonullingConfiguration(configuration);
    }

    public void setAutonullingScanValue(int value) {
        this.autonulling.setAutonullingScanValue(value);
    }

    public void setAutonullingScanStatus(int value) {
        this.autonulling.setAutonullingScanStatus(value);
    }

    public void writeAutonullingConfigurationToSpectrometer() throws IOException {
        this.autonulling.writeAutonullingConfigurationToSpectrometer();
    }

    public AutonullingConfiguration readAutonullingConfigurationFromSpectrometer() throws IOException {
        if (!this.isConnected()) {
            return new AutonullingConfiguration(0, 0, 0, this.maxIntensity);
        }
        byte[] bytes = this.getInfoBytes(17);
        byte enabled = bytes[0];
        byte temperature = bytes[1];
        short dark = ByteRoutines.makeWord((byte)bytes[3], (byte)bytes[2]);
        long saturation = ByteRoutines.makeDWord((byte)0, (byte)0, (byte)bytes[5], (byte)bytes[4]);
        AutonullingConfiguration cfg = new AutonullingConfiguration(enabled, temperature, dark, saturation);
        return cfg;
    }

    public int getAutonullingScanValue() {
        return this.autonulling.getAutonullingScanValue();
    }

    public int getAutonullingScanStatus() {
        return this.autonulling.getAutonullingScanStatus();
    }

    public AutonullingConfiguration getAutonullingConfiguration() {
        return this.autonulling.getAutonullingConfiguration();
    }

    public void setSingleStrobeLow(int counts) throws IOException {
        this.singleStrobe.setSingleStrobeLow(counts);
    }

    public void setSingleStrobeHigh(int counts) throws IOException {
        this.singleStrobe.setSingleStrobeHigh(counts);
    }

    public double getSingleStrobeCountsToMicros(int counts) {
        return this.singleStrobe.getSingleStrobeCountsToMicros(counts);
    }

    public int getSingleStrobeMinimum() {
        return this.singleStrobe.getSingleStrobeMinimum();
    }

    public int getSingleStrobeMaximum() {
        return this.singleStrobe.getSingleStrobeMaximum();
    }

    public int getSingleStrobeLow() throws IOException {
        return this.singleStrobe.getSingleStrobeLow();
    }

    public int getSingleStrobeIncrement() {
        return this.singleStrobe.getSingleStrobeIncrement();
    }

    public int getSingleStrobeHigh() throws IOException {
        return this.singleStrobe.getSingleStrobeHigh();
    }

    public boolean[] getChannelsPresent() {
        return this.multiChannel.getChannelsPresent();
    }

    public boolean isChannelPresent(int index) {
        return this.multiChannel.isChannelPresent(index);
    }

    public void setChannels(SpectrometerChannel[] channels) {
        this.multiChannel.setChannels(channels);
    }

    public void setChannelMux(int index) throws IOException {
        this.multiChannel.setChannelMux(index);
        this.lastSelectedChannel = index;
    }

    public void setChannelStatus(int index, boolean status) {
        this.multiChannel.setChannelStatus(index, status);
    }

    public void setDeepWellStatus(boolean status) throws IOException {
        this.multiChannel.setDeepWellStatus(status);
    }

    public void setChannelPresent(int index, boolean present) throws IOException {
        this.multiChannel.setChannelPresent(index, present);
    }

    public boolean isDeepWell() {
        return this.multiChannel.isDeepWell();
    }

    public boolean isInterpolationEnabled() {
        return this.multiChannel.isInterpolationEnabled();
    }

    public void setInterpolationEnabled(boolean enabled) {
        this.multiChannel.setInterpolationEnabled(enabled);
    }

    public void addChannelListener(MultiChannelListener listener) {
        this.multiChannel.addChannelListener(listener);
    }

    public void removeChannelListener(MultiChannelListener listener) {
        this.multiChannel.removeChannelListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readNumberOfChannels() throws IOException {
        if (!this.isConnected()) {
            throw new IOException("Cannot read number of channels if not connected to device");
        }
        byte numberOfChannels = 0;
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.out[0] = -64;
                this.dataSocket.getOutputStream().write(this.out, 0, 1);
                this.dataSocket.getInputStream().read(this.in, 0, 1);
                numberOfChannels = this.in[0];
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            return numberOfChannels;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeChannelMux(int channel) throws IOException {
        if (!this.isConnected()) {
            throw new IOException("Cannot set channel number if not connected");
        }
        if (channel > this.getNumberOfChannels() || channel < 0) {
            throw new IllegalArgumentException("Channel " + channel + " out of bounds [" + 0 + ", " + (this.getNumberOfChannels() - 1) + "]");
        }
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.out[0] = -63;
                this.out[1] = (byte)channel;
                this.dataSocket.getOutputStream().write(this.out, 0, 2);
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            return;
        }
    }

    public Configuration[] getChannelConfigurations() {
        return this.configurations;
    }

    public Configuration getConfiguration(int channelIndex) {
        if (channelIndex >= this.configurations.length) {
            return null;
        }
        return this.configurations[channelIndex];
    }

    public void setExternalTriggerDelay(int counts) throws IOException {
        this.triggerDelay.setExternalTriggerDelay(counts);
    }

    public Integer getExternalTriggerDelay() {
        return this.triggerDelay.getExternalTriggerDelay();
    }

    public double triggerDelayCountsToMicroseconds(int counts) {
        return this.triggerDelay.triggerDelayCountsToMicroseconds(counts);
    }

    public int getExternalTriggerDelayMinimum() {
        return this.triggerDelay.getExternalTriggerDelayMinimum();
    }

    public int getExternalTriggerDelayMaximum() {
        return this.triggerDelay.getExternalTriggerDelayMaximum();
    }

    public int getExternalTriggerDelayIncrement() {
        return this.triggerDelay.getExternalTriggerDelayIncrement();
    }

    public void setPowerUpPOTValues() throws IOException {
    }

    public short[] getPOTValues() throws IOException {
        short[] values = new short[]{(short)this.visIntensity, (short)this.uvIntensity, this.visIntensity > 0 ? (short)0 : -1, this.uvIntensity > 0 ? (short)0 : -1};
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPOTValue(int pot, int value) throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            if (pot > 0 || pot < 3) {
                if (pot == 0) {
                    this.visIntensity = value;
                } else if (pot == 1) {
                    this.uvIntensity = value;
                }
                this.out[0] = 64;
                this.out[1] = (byte)pot;
                this.out[2] = (byte)value;
                try {
                    this.dataSocket.getOutputStream().write(this.out, 0, 3);
                }
                catch (Exception e) {
                    this.reconnect();
                    throw new IOException("Failed to write to device, attempting to reconnect");
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                throw new IllegalArgumentException("Invaild POT value. Must be between 0-3.");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public Coefficients[] readNonlinearityCoefficientsFromSpectrometer() {
        return this.nonlinearity.readNonlinearityCoefficientsFromSpectrometer();
    }

    public void writeNonlinearityCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.nonlinearity.writeNonlinearityCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getNonlinearityCoefficients() {
        return this.nonlinearity.getNonlinearityCoefficients();
    }

    public void setNonlinearityCoefficients(Coefficients[] coefficients) {
        this.nonlinearity.setNonlinearityCoefficients(coefficients);
    }

    public double[] getNonlinearityCoefficientsSingleChannel(int index) {
        return this.nonlinearity.getNonlinearityCoefficientsSingleChannel(index);
    }

    public void setNonlinearityCoefficientsSingleChannel(double[] nl, int index) {
        this.nonlinearity.setNonlinearityCoefficientsSingleChannel(nl, index);
    }

    public Coefficients[] readStrayLightCorrectionCoefficientFromSpectrometer() {
        return this.straylight.readStrayLightCorrectionCoefficientFromSpectrometer();
    }

    public void writeStrayLightCoefficientToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.straylight.writeStrayLightCoefficientToSpectrometer(coefficients);
    }

    public void setStrayLightCorrectionCoefficient(Coefficients[] coefficients) {
        this.straylight.setStrayLightCorrectionCoefficient(coefficients);
    }

    public Coefficients[] getStrayLightCorrectionCoefficient() {
        return this.straylight.getStrayLightCorrectionCoefficient();
    }

    public void setStrayLight(double strayLight, int index) {
        this.straylight.setStrayLight(strayLight, index);
    }

    public double getStrayLight(int index) {
        return this.straylight.getStrayLight(index);
    }

    public void setExternalTriggerMode(int mode) throws IOException {
        this.lastTriggerMode = mode;
        this.hardwareTrigger.setExternalTriggerMode(mode);
    }

    public Integer getExternalTriggerMode() {
        return this.hardwareTrigger.getExternalTriggerMode();
    }

    public ExternalTriggerMode[] getExternalTriggerModes() {
        return this.hardwareTrigger.getExternalTriggerModes();
    }

    public BitSet getValueBits() throws IOException {
        return this.gpio.getValueBits();
    }

    public int getValueBit(int bitNumber) throws IOException {
        return this.gpio.getValueBit(bitNumber);
    }

    public void setValueAllBits(BitSet bitSet) throws IOException {
        this.gpio.setValueAllBits(bitSet);
    }

    public void setValueBitmask(short bitmask) throws IOException {
        this.gpio.setValueBitmask(bitmask);
    }

    public void setValueBit(int bit, boolean value) throws IOException {
        this.gpio.setValueBit(bit, value);
    }

    public BitSet getDirectionBits() throws IOException {
        return this.gpio.getDirectionBits();
    }

    public void setDirectionAllBits(BitSet bitSet) throws IOException {
        this.gpio.setDirectionAllBits(bitSet);
    }

    public void setDirectionBitmask(short bitmask) throws IOException {
        this.gpio.setDirectionBitmask(bitmask);
    }

    public void setDirectionBit(int bit, boolean value) throws IOException {
        this.gpio.setDirectionBit(bit, value);
    }

    public BitSet getMuxBits() throws IOException {
        return this.gpio.getMuxBits();
    }

    public int getNumberOfPins() {
        return this.gpio.getNumberOfPins();
    }

    public void setMuxAllBits(BitSet bitSet) throws IOException {
        this.gpio.setMuxAllBits(bitSet);
    }

    public void setMuxBitmask(short bitmask) throws IOException {
        this.gpio.setMuxBitmask(bitmask);
    }

    public void setMuxBit(int bit, boolean value) throws IOException {
        this.gpio.setMuxBit(bit, value);
    }

    public int getTotalGPIOBits() {
        return this.gpio.getTotalGPIOBits();
    }

    public void setContinuousStrobeDelay(int durationOfPhase) throws IOException {
        this.continuousStrobe.setContinuousStrobeDelay(durationOfPhase);
    }

    public int getContinuousStrobeDelayIncrement(int magnitude) {
        return this.continuousStrobe.getContinuousStrobeDelayIncrement(magnitude);
    }

    public double continuousStrobeCountsToMicros(int counts) {
        return this.continuousStrobe.continuousStrobeCountsToMicros(counts);
    }

    public int getContinuousStrobeDelayMinimum() {
        return this.continuousStrobe.getContinuousStrobeDelayMinimum();
    }

    public int getContinuousStrobeDelayMaximum() {
        return this.continuousStrobe.getContinuousStrobeDelayMaximum();
    }

    public Integer getContinuousStrobeDelay() {
        return this.continuousStrobe.getContinuousStrobeDelay();
    }

    public void setTriggerSource(TriggerSource source) throws IOException {
        this.internalTrigger.setTriggerSource(source);
    }

    public void setInternalTriggerPeriodMicros(int micros) throws IOException {
        this.internalTrigger.setInternalTriggerPeriodMicros(micros);
    }

    public TriggerSource getTriggerSource() {
        return this.internalTrigger.getTriggerSource();
    }

    public int getInternalTriggerPeriodMinimum() {
        return this.internalTrigger.getInternalTriggerPeriodMinimum();
    }

    public Integer getInternalTriggerPeriodMicros() {
        return this.internalTrigger.getInternalTriggerPeriodMicros();
    }

    public int getInternalTriggerPeriodMaximum() {
        return this.internalTrigger.getInternalTriggerPeriodMaximum();
    }

    public int getInternalTriggerPeriodIncrement() {
        return this.internalTrigger.getInternalTriggerPeriodIncrement();
    }

    public int getNumberOfIndyModules() throws IOException {
        if (!this.hasIndy) {
            return 0;
        }
        return this.indy.getNumberOfIndyModules();
    }

    public int getNumberOfVoltageOutputs(int moduleIndex) throws IOException {
        if (!this.hasIndy) {
            return 0;
        }
        return this.indy.getNumberOfVoltageOutputs(moduleIndex);
    }

    public int getNumberOfVoltageInputs(int moduleIndex) throws IOException {
        if (!this.hasIndy) {
            return 0;
        }
        return this.indy.getNumberOfVoltageInputs(moduleIndex);
    }

    public int getNumberOfCurrentOutputs(int moduleIndex) throws IOException {
        if (!this.hasIndy) {
            return 0;
        }
        return this.indy.getNumberOfCurrentOutputs(moduleIndex);
    }

    public int getNumberOfCurrentInputs(int moduleIndex) throws IOException {
        if (!this.hasIndy) {
            return 0;
        }
        return this.indy.getNumberOfCurrentInputs(moduleIndex);
    }

    public int getNumberOfIndyGPIO(int moduleIndex) throws IOException {
        if (!this.hasIndy) {
            return 0;
        }
        return this.indy.getNumberOfIndyGPIO(moduleIndex);
    }

    public int getVoltageOutputMaximumCounts(int moduleIndex, int channel) {
        if (!this.hasIndy) {
            return 0;
        }
        return this.indy.getVoltageOutputMaximumCounts(moduleIndex, channel);
    }

    public int getCurrentOutputMaximumCounts(int moduleIndex, int channel) {
        if (!this.hasIndy) {
            return 0;
        }
        return this.indy.getCurrentOutputMaximumCounts(moduleIndex, channel);
    }

    public IndyVoltageSample[] sampleVoltageInputs(int moduleIndex) throws IOException {
        return this.indy.sampleVoltageInputs(moduleIndex);
    }

    public IndyVoltageSample[] getVoltageOutputs(int moduleIndex) throws IOException {
        return this.indy.getVoltageOutputs(moduleIndex);
    }

    public IndyCurrentSample[] sampleCurrentInputs(int moduleIndex) throws IOException {
        return this.indy.sampleCurrentInputs(moduleIndex);
    }

    public IndyCurrentSample[] getCurrentOutputs(int moduleIndex) throws IOException {
        return this.indy.getCurrentOutputs(moduleIndex);
    }

    public boolean[] getCurrentOutputEnables(int moduleIndex) throws IOException {
        return this.indy.getCurrentOutputEnables(moduleIndex);
    }

    public boolean[] getCurrentOutputEnergized(int moduleIndex) throws IOException {
        return this.indy.getCurrentOutputEnergized(moduleIndex);
    }

    public int getIndyGPIOInputValues(int moduleIndex) throws IOException {
        return this.indy.getIndyGPIOInputValues(moduleIndex);
    }

    public int getIndyGPIOOutputValues(int moduleIndex) throws IOException {
        return this.indy.getIndyGPIOOutputValues(moduleIndex);
    }

    public int getIndyGPIOOutputEnables(int moduleIndex) throws IOException {
        return this.indy.getIndyGPIOOutputEnables(moduleIndex);
    }

    public boolean getExcitationEnable(int moduleIndex, int channel) throws IOException {
        return this.indy.getExcitationEnable(moduleIndex, channel);
    }

    public float getExcitationVoltage(int moduleIndex, int channel) throws IOException {
        return this.indy.getExcitationVoltage(moduleIndex, channel);
    }

    public float[] getExcitationVoltageOptions(int moduleIndex, int channel) {
        return this.indy.getExcitationVoltageOptions(moduleIndex, channel);
    }

    public int getCurrentOutputCalibration4mA(int moduleIndex, int channel) throws IOException {
        return this.indy.getCurrentOutputCalibration4mA(moduleIndex, channel);
    }

    public int getCurrentOutputCalibration20mA(int moduleIndex, int channel) throws IOException {
        return this.indy.getCurrentOutputCalibration20mA(moduleIndex, channel);
    }

    public void setVoltageOutputVolts(int moduleIndex, int channel, float volts) throws IOException {
        this.indy.setVoltageOutputVolts(moduleIndex, channel, volts);
    }

    public void setVoltageOutputCounts(int moduleIndex, int channel, int counts) throws IOException {
        this.indy.setVoltageOutputCounts(moduleIndex, channel, counts);
    }

    public void setCurrentOutputMilliamps(int moduleIndex, int channel, float milliamps) throws IOException {
        this.indy.setCurrentOutputMilliamps(moduleIndex, channel, milliamps);
    }

    public void setCurrentOutputCounts(int moduleIndex, int channel, int counts) throws IOException {
        this.indy.setCurrentOutputCounts(moduleIndex, channel, counts);
    }

    public void setIndyGPIOConfiguration(int moduleIndex, int outputValueVector, int enableVector, int mask) throws IOException {
        this.indy.setIndyGPIOConfiguration(moduleIndex, outputValueVector, enableVector, mask);
    }

    public void setIndyGPIOOutputValues(int moduleIndex, int valueVector, int mask) throws IOException {
        this.indy.setIndyGPIOOutputValues(moduleIndex, valueVector, mask);
    }

    public void setCurrentOutputEnable(int moduleIndex, int channel, boolean enabled) throws IOException {
        this.indy.setCurrentOutputEnable(moduleIndex, channel, enabled);
    }

    public void setExcitationVoltage(int moduleIndex, int channel, float volts) throws IOException {
        this.indy.setExcitationVoltage(moduleIndex, channel, volts);
    }

    public void setExcitationEnable(int moduleIndex, int channel, boolean enabled) throws IOException {
        this.indy.setExcitationEnable(moduleIndex, channel, enabled);
    }

    public void setCurrentOutputCalibration4mA(int moduleIndex, int channel, int counts) throws IOException {
        this.indy.setCurrentOutputCalibration4mA(moduleIndex, channel, counts);
    }

    public void setCurrentOutputCalibration20mA(int moduleIndex, int channel, int counts) throws IOException {
        this.indy.setCurrentOutputCalibration20mA(moduleIndex, channel, counts);
    }

    private class HardwareTriggerProvider
    implements HardwareTriggerGUIProvider {
        protected String featurePath = "hardwaretrigger.HardwareTriggerPanel";
        protected String panelPath = "com.oceanoptics.omnidriver.guisupport.features";
        private ExternalTriggerMode[] triggerModes = null;
        private Integer currentMode = null;

        public HardwareTriggerProvider(ExternalTriggerMode[] modes) {
            this.triggerModes = modes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setExternalTriggerMode(int mode) throws IOException {
            if (null != this.currentMode && this.currentMode == mode) {
                JazNetwork.this.logger.finest("Trigger mode already set, not pushing to device");
                return;
            }
            byte[] byArray = JazNetwork.this.in;
            synchronized (byArray) {
                byte[] byArray2 = JazNetwork.this.out;
                synchronized (byArray2) {
                    ((JazNetwork)JazNetwork.this).out[0] = 10;
                    ((JazNetwork)JazNetwork.this).out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)mode));
                    ((JazNetwork)JazNetwork.this).out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)mode));
                    JazNetwork.this.dataSocket.getOutputStream().write(JazNetwork.this.out, 0, 3);
                }
            }
            this.currentMode = new Integer(mode);
            JazNetwork.this.logger.fine("Set external trigger mode (0: Normal, 1:Software, 2:External Synchronization, 4:External Hardware): " + mode);
        }

        public String[] getFeatureGUIClassnames() {
            return new String[]{this.panelPath + "." + this.featurePath};
        }

        public ExternalTriggerMode[] getExternalTriggerModes() {
            return this.triggerModes;
        }

        public Integer getExternalTriggerMode() {
            return this.currentMode;
        }
    }
}

