/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.jaz;

import com.oceanoptics.omnidriver.constants.ExternalTriggerMode;
import com.oceanoptics.omnidriver.features.autonulling.Autonulling;
import com.oceanoptics.omnidriver.features.autonulling.AutonullingConfiguration;
import com.oceanoptics.omnidriver.features.autonulling.AutonullingGUIProvider;
import com.oceanoptics.omnidriver.features.autonulling.AutonullingImpl_Jaz;
import com.oceanoptics.omnidriver.features.autonulling.AutonullingImpl_JazUSB;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobe;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobeGUIProvider;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobeImpl_Jaz;
import com.oceanoptics.omnidriver.features.externaltriggerdelay.ExternalTriggerDelay;
import com.oceanoptics.omnidriver.features.externaltriggerdelay.ExternalTriggerDelayGUIProvider;
import com.oceanoptics.omnidriver.features.externaltriggerdelay.ExternalTriggerDelayImpl_Jaz;
import com.oceanoptics.omnidriver.features.gpio.GPIO;
import com.oceanoptics.omnidriver.features.gpio.GPIOGUIProvider;
import com.oceanoptics.omnidriver.features.gpio.GPIOImpl_Jaz;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTrigger;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTriggerImpl;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTriggerImplFPGA;
import com.oceanoptics.omnidriver.features.indy.Indy;
import com.oceanoptics.omnidriver.features.indy.IndyCurrentSample;
import com.oceanoptics.omnidriver.features.indy.IndyGUIProvider;
import com.oceanoptics.omnidriver.features.indy.IndyImpl;
import com.oceanoptics.omnidriver.features.indy.IndyVoltageSample;
import com.oceanoptics.omnidriver.features.internaltrigger.InternalTrigger;
import com.oceanoptics.omnidriver.features.internaltrigger.InternalTriggerGUIProvider;
import com.oceanoptics.omnidriver.features.internaltrigger.InternalTriggerImpl_Jaz;
import com.oceanoptics.omnidriver.features.internaltrigger.TriggerSource;
import com.oceanoptics.omnidriver.features.multichannelprovider.MultiChannelGUIProvider;
import com.oceanoptics.omnidriver.features.multichannelprovider.MultiChannelImpl_JazUSB;
import com.oceanoptics.omnidriver.features.multichannelprovider.MultiChannelListener;
import com.oceanoptics.omnidriver.features.multichannelprovider.MultiChannelProvider;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionImpl;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionProvider;
import com.oceanoptics.omnidriver.features.singlestrobe.SingleStrobe;
import com.oceanoptics.omnidriver.features.singlestrobe.SingleStrobeGUIProvider;
import com.oceanoptics.omnidriver.features.singlestrobe.SingleStrobeImpl_Jaz;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrection;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionImpl;
import com.oceanoptics.omnidriver.features.uvvislightsource.UV_VIS_LightSourceGUIProvider;
import com.oceanoptics.omnidriver.features.uvvislightsource.UV_VIS_LightSourceImpl_JAZ;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationGUIProvider;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationProvider;
import com.oceanoptics.omnidriver.interfaces.GUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBEndpointDevice;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.interfaces.UV_VIS_LightSourceJAZCompatible;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.Configuration;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerChannel;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerStatus;
import com.oceanoptics.omnidriver.spectrometer.USBSpectrometer;
import com.oceanoptics.omnidriver.spectrometer.jaz.JazStatus;
import com.oceanoptics.omnidriver.spectrometer.jaz.SpectrometerChannelJaz;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;
import java.util.BitSet;
import java.util.Vector;

public class JazUSB
extends USBSpectrometer
implements Autonulling,
ExternalTriggerDelay,
GPIO,
HardwareTrigger,
MultiChannelProvider,
NonlinearityCorrectionProvider,
WavelengthCalibrationProvider,
SingleStrobe,
ContinuousStrobe,
InternalTrigger,
StrayLightCorrection,
USBEndpointDevice,
Indy,
UV_VIS_LightSourceJAZCompatible {
    static Spectrometer[] scoreboard = new Spectrometer[64];
    private HardwareTriggerImpl hardwareTrigger;
    private ExternalTriggerDelayGUIProvider triggerDelay;
    private GPIOGUIProvider gpio;
    private NonlinearityCorrectionGUIProvider nonlinearity;
    private WavelengthCalibrationGUIProvider wavelength;
    private StrayLightCorrectionGUIProvider straylight;
    private AutonullingGUIProvider autonulling;
    private AutonullingConfiguration[] autonullingConfiguration;
    private MultiChannelGUIProvider multiChannel;
    private UV_VIS_LightSourceGUIProvider uv_vis_lampModule;
    private SingleStrobeGUIProvider singleStrobe;
    private ContinuousStrobeGUIProvider continuousStrobe;
    private InternalTriggerGUIProvider internalTrigger;
    private IndyGUIProvider indy = null;
    private Configuration[] configurations = null;
    private int numberOfEnabledChannels;
    private int lastSelectedChannel = 0;
    private int DPUFPGAVersion = 0;
    private int minimumSpecFPGAVersion = 0;
    private boolean hasIndy = false;
    private static final short DATA_OUT = 1;
    private static final short HIGH_SPEED_DATA_IN = 130;
    private static final short UNUSED_DATA_OUT = 8;
    private static final short LOW_SPEED_DATA_IN = 129;
    private static final short MAX_PACKET_SIZE = 512;
    private int uvIntensity = 255;
    private int visIntensity = 255;
    private static String __extern__ = "__extern__\n<init>,()V\n<init>,(I)V\nsetEndpoints,()V\ngetEndpoint,(I)Lcom/oceanoptics/uniusb/USBEndpointDescriptor;\ngetDataOutEndPoint,()Lcom/oceanoptics/uniusb/USBEndpointDescriptor;\ngetLowSpeedInEndPoint,()Lcom/oceanoptics/uniusb/USBEndpointDescriptor;\nopenSpectrometer,(I)V\ngetJazInfoBytes,(I)[B\ngetGUIFeatures,()[Lcom/oceanoptics/omnidriver/interfaces/GUIProvider;\ngetStatus,()Lcom/oceanoptics/omnidriver/spectrometer/SpectrometerStatus;\nreadIntegrationTime,()I\ngetSerialNumber,()Ljava/lang/String;\ngetChannelConfigurations,()[Lcom/oceanoptics/omnidriver/spectrometer/Configuration;\ngetConfiguration,(I)Lcom/oceanoptics/omnidriver/spectrometer/Configuration;\ntoString,()Ljava/lang/String;\nsetExternalTriggerMode,(I)V\ngetExternalTriggerMode,()Ljava/lang/Integer;\ngetExternalTriggerModes,()[Lcom/oceanoptics/omnidriver/constants/ExternalTriggerMode;\nreadNonlinearityCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteNonlinearityCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetNonlinearityCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficientsSingleChannel,(I)[D\nsetNonlinearityCoefficientsSingleChannel,([DI)V\ngetNumberOfChannels,()I\ngetNumberOfEnabledChannels,()I\nreadWavelengthCalibrationCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteWavelengthCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengthCalibrationCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetWavelengthCalibrationCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengths,(I)[D\nsetWavelengths,([DI)V\nreadStrayLightCorrectionCoefficientFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteStrayLightCoefficientToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\nsetStrayLightCorrectionCoefficient,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetStrayLightCorrectionCoefficient,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetStrayLight,(DI)V\ngetStrayLight,(I)D\nsetAutonullingConfiguration,(Lcom/oceanoptics/omnidriver/features/autonulling/AutonullingConfiguration;)V\nsetAutonullingScanValue,(I)V\nsetAutonullingScanStatus,(I)V\nwriteAutonullingConfigurationToSpectrometer,()V\nreadAutonullingConfigurationFromSpectrometer,()Lcom/oceanoptics/omnidriver/features/autonulling/AutonullingConfiguration;\ngetAutonullingScanValue,()I\ngetAutonullingScanStatus,()I\ngetAutonullingConfiguration,()Lcom/oceanoptics/omnidriver/features/autonulling/AutonullingConfiguration;\nsetSingleStrobeLow,(I)V\nsetSingleStrobeHigh,(I)V\ngetSingleStrobeCountsToMicros,(I)D\ngetSingleStrobeMinimum,()I\ngetSingleStrobeMaximum,()I\ngetSingleStrobeLow,()I\ngetSingleStrobeIncrement,()I\ngetSingleStrobeHigh,()I\ngetChannelsPresent,()[Z\nisChannelPresent,(I)Z\nsetChannels,([Lcom/oceanoptics/omnidriver/spectrometer/SpectrometerChannel;)V\nsetChannelMux,(I)V\nsetChannelStatus,(IZ)V\nsetDeepWellStatus,(Z)V\nsetChannelPresent,(IZ)V\nisDeepWell,()Z\nisInterpolationEnabled,()Z\nsetInterpolationEnabled,(Z)V\naddChannelListener,(Lcom/oceanoptics/omnidriver/features/multichannelprovider/MultiChannelListener;)V\nremoveChannelListener,(Lcom/oceanoptics/omnidriver/features/multichannelprovider/MultiChannelListener;)V\nsetExternalTriggerDelay,(I)V\ngetExternalTriggerDelay,()Ljava/lang/Integer;\ntriggerDelayCountsToMicroseconds,(I)D\ngetExternalTriggerDelayMinimum,()I\ngetExternalTriggerDelayMaximum,()I\ngetExternalTriggerDelayIncrement,()I\nsetPowerUpPOTValues,()V\ngetPOTValues,()[S\nsetPOTValue,(II)V\ngetValueBits,()Ljava/util/BitSet;\ngetValueBit,(I)I\nsetValueAllBits,(Ljava/util/BitSet;)V\nsetValueBitmask,(S)V\nsetValueBit,(IZ)V\ngetDirectionBits,()Ljava/util/BitSet;\nsetDirectionAllBits,(Ljava/util/BitSet;)V\nsetDirectionBitmask,(S)V\nsetDirectionBit,(IZ)V\ngetMuxBits,()Ljava/util/BitSet;\ngetNumberOfPins,()I\nsetMuxAllBits,(Ljava/util/BitSet;)V\nsetMuxBitmask,(S)V\nsetMuxBit,(IZ)V\ngetTotalGPIOBits,()I\nsetContinuousStrobeDelay,(I)V\ngetContinuousStrobeDelayIncrement,(I)I\ncontinuousStrobeCountsToMicros,(I)D\ngetContinuousStrobeDelayMinimum,()I\ngetContinuousStrobeDelayMaximum,()I\ngetContinuousStrobeDelay,()Ljava/lang/Integer;\nsetTriggerSource,(Lcom/oceanoptics/omnidriver/features/internaltrigger/TriggerSource;)V\nsetInternalTriggerPeriodMicros,(I)V\ngetTriggerSource,()Lcom/oceanoptics/omnidriver/features/internaltrigger/TriggerSource;\ngetInternalTriggerPeriodMinimum,()I\ngetInternalTriggerPeriodMicros,()Ljava/lang/Integer;\ngetInternalTriggerPeriodMaximum,()I\ngetInternalTriggerPeriodIncrement,()I\ngetNumberOfIndyModules,()I\ngetNumberOfVoltageOutputs,(I)I\ngetNumberOfVoltageInputs,(I)I\ngetNumberOfCurrentOutputs,(I)I\ngetNumberOfCurrentInputs,(I)I\ngetNumberOfIndyGPIO,(I)I\ngetVoltageOutputMaximumCounts,(II)I\ngetCurrentOutputMaximumCounts,(II)I\nsampleVoltageInputs,(I)[Lcom/oceanoptics/omnidriver/features/indy/IndyVoltageSample;\ngetVoltageOutputs,(I)[Lcom/oceanoptics/omnidriver/features/indy/IndyVoltageSample;\nsampleCurrentInputs,(I)[Lcom/oceanoptics/omnidriver/features/indy/IndyCurrentSample;\ngetCurrentOutputs,(I)[Lcom/oceanoptics/omnidriver/features/indy/IndyCurrentSample;\ngetCurrentOutputEnables,(I)[Z\ngetCurrentOutputEnergized,(I)[Z\ngetIndyGPIOInputValues,(I)I\ngetIndyGPIOOutputValues,(I)I\ngetIndyGPIOOutputEnables,(I)I\ngetExcitationEnable,(II)Z\ngetExcitationVoltage,(II)F\ngetExcitationVoltageOptions,(II)[F\ngetCurrentOutputCalibration4mA,(II)I\ngetCurrentOutputCalibration20mA,(II)I\nsetVoltageOutputVolts,(IIF)V\nsetVoltageOutputCounts,(III)V\nsetCurrentOutputMilliamps,(IIF)V\nsetCurrentOutputCounts,(III)V\nsetIndyGPIOConfiguration,(IIII)V\nsetIndyGPIOOutputValues,(III)V\nsetCurrentOutputEnable,(IIZ)V\nsetExcitationVoltage,(IIF)V\nsetExcitationEnable,(IIZ)V\nsetCurrentOutputCalibration4mA,(III)V\nsetCurrentOutputCalibration20mA,(III)V\n";

    public JazUSB() throws IOException {
        try {
            this.setEndpoints();
            this.openNextUnclaimedUSB();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JazUSB(int i) throws IOException {
        this.setEndpoints();
        this.openSpectrometer(i);
    }

    protected Spectrometer[] getScoreboard() {
        return scoreboard;
    }

    public void setEndpoints() {
        this.dataOutEndPoint = new USBEndpointDescriptor(7, 5, 1, 2, 512, 0);
        this.highSpeedInEndPoint1 = new USBEndpointDescriptor(7, 5, 130, 2, 512, 0);
        this.highSpeedInEndPoint2 = new USBEndpointDescriptor(7, 5, 8, 2, 512, 0);
        this.lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 129, 2, 512, 0);
    }

    public USBEndpointDescriptor getEndpoint(int endPoint) throws IllegalArgumentException {
        switch (endPoint) {
            case 0: {
                return this.dataOutEndPoint;
            }
            case 1: {
                return this.highSpeedInEndPoint1;
            }
            case 2: {
                return this.highSpeedInEndPoint2;
            }
            case 3: {
                return this.lowSpeedInEndPoint;
            }
        }
        throw new IllegalArgumentException("End Point number invalid.");
    }

    public USBEndpointDescriptor getDataOutEndPoint() {
        return this.dataOutEndPoint;
    }

    public USBEndpointDescriptor getLowSpeedInEndPoint() {
        return this.lowSpeedInEndPoint;
    }

    public void openSpectrometer(int index) throws IOException {
        int i;
        this.integrationTimeMinimum = 3000;
        this.integrationTimeMaximum = 65535000;
        this.integrationTimeIncrement = 1000;
        this.integrationTimeBase = 1;
        this.numberOfCCDPixels = 2048;
        this.numberOfDarkCCDPixels = 24;
        this.maxIntensity = 65535;
        this.pipeSize = this.numberOfCCDPixels * 2;
        this.rawData = new byte[this.pipeSize];
        this.benchSlot = 15;
        this.spectrometerConfigSlot = 16;
        this.productID = 8192;
        this.stabilityScan = false;
        this.usb.openDevice(this.vendorID, this.productID, index);
        this.deviceIndex = index;
        this.getFirmwareVersion();
        this.multiChannel = new MultiChannelImpl_JazUSB(this.usb, this);
        this.setChannelMux(0);
        this.channels = new SpectrometerChannel[this.multiChannel.getNumberOfChannels()];
        for (i = 0; i < this.channels.length; ++i) {
            this.setChannelMux(i);
            String serialNumber = this.getInfo(0);
            this.channels[i] = new SpectrometerChannelJaz(this, new Coefficients(), serialNumber, i);
        }
        this.numChannels = this.channels.length;
        this.logger.fine("Jaz has been opened at index " + index);
        this.initFeatures(this.usb);
        this.finishConstruction();
        this.configurations = new Configuration[this.channels.length];
        for (i = 0; i < this.channels.length; ++i) {
            this.multiChannel.setChannelMux(i);
            this.configurations[i] = new Configuration(this);
        }
        this.configuration = this.configurations[0];
        for (i = 0; i < this.channels.length; ++i) {
            this.channels[i].getCoefficientsFromSpectrometer();
        }
    }

    private void initFeatures(USBInterface usb) throws IOException {
        this.probeJazStack();
        if (this.minimumSpecFPGAVersion >= 147) {
            this.hardwareTrigger = new HardwareTriggerImplFPGA(usb, new ExternalTriggerMode[]{new ExternalTriggerMode(0), new ExternalTriggerMode(1), new ExternalTriggerMode(2), new ExternalTriggerMode(3)});
            this.featureMap.put(HardwareTriggerImpl.class, this.hardwareTrigger);
            this.triggerDelay = new ExternalTriggerDelayImpl_Jaz.USB(usb);
            this.featureMap.put(ExternalTriggerDelayImpl_Jaz.class, (ExternalTriggerDelayImpl_Jaz)this.triggerDelay);
        } else {
            this.hardwareTrigger = new HardwareTriggerImplFPGA(usb, new ExternalTriggerMode[]{new ExternalTriggerMode(0)});
            this.featureMap.put(HardwareTriggerImpl.class, this.hardwareTrigger);
        }
        if (this.DPUFPGAVersion >= 133) {
            this.gpio = new GPIOImpl_Jaz.USB(usb);
            this.featureMap.put(GPIOImpl_Jaz.class, (GPIOImpl_Jaz)this.gpio);
            this.internalTrigger = new InternalTriggerImpl_Jaz.USB(usb);
            this.featureMap.put(InternalTriggerImpl_Jaz.class, (InternalTriggerImpl_Jaz)this.internalTrigger);
            this.singleStrobe = new SingleStrobeImpl_Jaz.USB(usb);
            this.featureMap.put(SingleStrobeImpl_Jaz.class, (SingleStrobeImpl_Jaz)this.singleStrobe);
            this.continuousStrobe = new ContinuousStrobeImpl_Jaz.USB(usb);
            this.featureMap.put(ContinuousStrobeImpl_Jaz.class, (ContinuousStrobeImpl_Jaz)this.continuousStrobe);
        }
        this.nonlinearity = new NonlinearityCorrectionImpl(usb, this);
        this.featureMap.put(NonlinearityCorrectionImpl.class, (NonlinearityCorrectionImpl)this.nonlinearity);
        this.wavelength = new WavelengthCalibrationImpl(usb, this);
        this.featureMap.put(WavelengthCalibrationImpl.class, (WavelengthCalibrationImpl)this.wavelength);
        this.straylight = new StrayLightCorrectionImpl(usb, this);
        this.featureMap.put(StrayLightCorrectionImpl.class, (StrayLightCorrectionImpl)this.straylight);
        this.autonulling = new AutonullingImpl_JazUSB(usb, this.getNumberOfChannels(), this);
        this.autonullingConfiguration = new AutonullingConfiguration[this.getNumberOfChannels()];
        for (int i = 0; i < this.channels.length; ++i) {
            ((AutonullingImpl_Jaz)this.autonulling).setSelectedChannel(i);
            this.autonullingConfiguration[i] = ((AutonullingImpl_Jaz)this.autonulling).readAutonullingConfigurationFromSpectrometer();
        }
        this.uv_vis_lampModule = new UV_VIS_LightSourceImpl_JAZ(usb, this);
        if (this.hasIndy) {
            this.indy = new IndyImpl.USB(usb);
            this.featureMap.put(IndyImpl.class, (IndyImpl)this.indy);
        }
    }

    private void probeJazStack() {
        try {
            byte[] fpgaVersionBytes = this.getJazInfoBytes(176);
            this.DPUFPGAVersion = ByteRoutines.makeDWord((byte)0, (byte)0, (byte)fpgaVersionBytes[0], (byte)fpgaVersionBytes[1]);
            int minSpecVersion = 0;
            byte[] countBytes = this.getJazInfoBytes(192);
            int numberModules = countBytes[0];
            for (int i = 0; i < numberModules && i < 15; ++i) {
                byte[] moduleBytes = this.getJazInfoBytes(193 + i);
                if (moduleBytes[0] == -80) {
                    int version = ByteRoutines.makeDWord((byte)0, (byte)0, (byte)moduleBytes[2], (byte)moduleBytes[3]);
                    if (version >= minSpecVersion && minSpecVersion != 0) continue;
                    minSpecVersion = version;
                    continue;
                }
                if (moduleBytes[0] != 113) continue;
                this.hasIndy = true;
            }
            this.minimumSpecFPGAVersion = minSpecVersion;
            if (this.minimumSpecFPGAVersion >= 147) {
                this.integrationTimeMinimum = 1000;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getJazInfoBytes(int slot) throws IOException {
        byte[] retval = new byte[15];
        byte[] byArray = this.out;
        synchronized (this.out) {
            byte[] byArray2 = this.in;
            synchronized (this.in) {
                this.out[0] = -58;
                this.out[1] = (byte)slot;
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 2);
                this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 17);
                for (int i = 0; i < 15; ++i) {
                    retval[i] = this.in[i + 2];
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
            return retval;
        }
    }

    public GUIProvider[] getGUIFeatures() {
        Vector<GUIProvider> features = new Vector<GUIProvider>();
        features.add(this.wavelength);
        features.add(this.straylight);
        features.add(this.nonlinearity);
        features.add(this.autonulling);
        features.add(this.multiChannel);
        if (this.DPUFPGAVersion >= 133) {
            features.add(this.gpio);
            features.add(this.singleStrobe);
            features.add(this.continuousStrobe);
            features.add(this.internalTrigger);
        }
        if (this.minimumSpecFPGAVersion >= 147) {
            features.add(this.triggerDelay);
        }
        if (this.hasIndy && null != this.indy) {
            features.add(this.indy);
        }
        return features.toArray(new GUIProvider[0]);
    }

    protected Spectrum formatData(byte[] data, Spectrum doubleSpectrum) throws IOException {
        byte zero = 0;
        double[] spectrum = doubleSpectrum.getSpectrum();
        this.logger.finest("Formatting data");
        double saturationValue = this.autonullingConfiguration[this.lastSelectedChannel].getSaturationValue();
        doubleSpectrum.setSaturated(false);
        for (int i = 0; i < this.numberOfCCDPixels; ++i) {
            byte LSB = data[2 * i];
            byte MSB = data[2 * i + 1];
            int pixel = ByteRoutines.makeDWord((byte)zero, (byte)zero, (byte)MSB, (byte)LSB);
            spectrum[i] = pixel;
            if ((double)pixel >= saturationValue) {
                doubleSpectrum.setSaturated(true);
                pixel = (int)saturationValue;
            }
            spectrum[i] = (double)pixel * (double)this.maxIntensity / saturationValue;
        }
        ((AutonullingImpl_Jaz)this.autonulling).setAutonullingScanStatus((int)spectrum[0], this.lastSelectedChannel);
        ((AutonullingImpl_Jaz)this.autonulling).setAutonullingScanValue((int)spectrum[1], this.lastSelectedChannel);
        spectrum[0] = spectrum[2];
        spectrum[1] = spectrum[2];
        return doubleSpectrum;
    }

    public SpectrometerStatus getStatus() throws IOException {
        this.logger.finest("Jaz Status.");
        byte[] sb = super.getStatusArray();
        JazStatus stat = new JazStatus();
        stat.numPixels = ByteRoutines.makeWord((byte)sb[1], (byte)sb[0]);
        stat.integrationTime = ByteRoutines.makeDWord((byte)sb[5], (byte)sb[4], (byte)sb[3], (byte)sb[2]);
        stat.lampEnabled = sb[6] != 0;
        stat.externalTriggerMode = sb[7];
        stat.takingScan = sb[8] != 0;
        stat.numPacketsInSpectra = sb[9];
        stat.powerDownFlag = sb[10];
        stat.packetCount = sb[11];
        if (Math.abs(sb[14]) == 128) {
            stat.usbSpeed = 480;
        } else if (Math.abs(sb[14]) == 0) {
            stat.usbSpeed = 12;
        } else {
            stat.usbSpeed = 0;
            this.logger.severe("Error determining USB Communication Speed.");
            throw new IOException("Error determining USB Communication Speed.");
        }
        return stat;
    }

    public int readIntegrationTime() throws IOException {
        JazStatus stat = (JazStatus)this.getStatus();
        return stat.integrationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSerialNumber() throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            byte[] byArray2 = this.in;
            synchronized (this.in) {
                this.out[0] = -58;
                this.out[1] = 1;
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 2);
                this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 17);
                String serialNumber = "";
                for (int i = 2; this.in[i] != 0 && i < 17; ++i) {
                    serialNumber = serialNumber + (char)this.in[i];
                }
                this.logger.finest("Serial number: " + serialNumber);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return serialNumber;
            }
        }
    }

    public Configuration[] getChannelConfigurations() {
        return this.configurations;
    }

    public Configuration getConfiguration(int channelIndex) {
        if (channelIndex >= this.configurations.length) {
            return null;
        }
        return this.configurations[channelIndex];
    }

    public String toString() {
        try {
            return super.toString() + "\n" + this.getStatus();
        }
        catch (IOException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public void setExternalTriggerMode(int mode) throws IOException {
        this.hardwareTrigger.setExternalTriggerMode(mode);
    }

    public Integer getExternalTriggerMode() {
        return this.hardwareTrigger.getExternalTriggerMode();
    }

    public ExternalTriggerMode[] getExternalTriggerModes() {
        return this.hardwareTrigger.getExternalTriggerModes();
    }

    public Coefficients[] readNonlinearityCoefficientsFromSpectrometer() {
        return this.nonlinearity.readNonlinearityCoefficientsFromSpectrometer();
    }

    public void writeNonlinearityCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.nonlinearity.writeNonlinearityCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getNonlinearityCoefficients() {
        return this.nonlinearity.getNonlinearityCoefficients();
    }

    public void setNonlinearityCoefficients(Coefficients[] coefficients) {
        this.nonlinearity.setNonlinearityCoefficients(coefficients);
    }

    public double[] getNonlinearityCoefficientsSingleChannel(int index) {
        return this.nonlinearity.getNonlinearityCoefficientsSingleChannel(index);
    }

    public void setNonlinearityCoefficientsSingleChannel(double[] nl, int index) {
        this.nonlinearity.setNonlinearityCoefficientsSingleChannel(nl, index);
    }

    public int getNumberOfChannels() {
        return this.multiChannel.getNumberOfChannels();
    }

    public int getNumberOfEnabledChannels() {
        this.numberOfEnabledChannels = this.multiChannel.getNumberOfEnabledChannels();
        return this.numberOfEnabledChannels;
    }

    public Coefficients[] readWavelengthCalibrationCoefficientsFromSpectrometer() {
        return this.wavelength.readWavelengthCalibrationCoefficientsFromSpectrometer();
    }

    public void writeWavelengthCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.wavelength.writeWavelengthCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getWavelengthCalibrationCoefficients() {
        return this.wavelength.getWavelengthCalibrationCoefficients();
    }

    public void setWavelengthCalibrationCoefficients(Coefficients[] coefficients) {
        this.wavelength.setWavelengthCalibrationCoefficients(coefficients);
    }

    public double[] getWavelengths(int index) {
        return this.wavelength.getWavelengths(index);
    }

    public void setWavelengths(double[] wl, int index) {
        this.wavelength.setWavelengths(wl, index);
    }

    public Coefficients[] readStrayLightCorrectionCoefficientFromSpectrometer() {
        return this.straylight.readStrayLightCorrectionCoefficientFromSpectrometer();
    }

    public void writeStrayLightCoefficientToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.straylight.writeStrayLightCoefficientToSpectrometer(coefficients);
    }

    public void setStrayLightCorrectionCoefficient(Coefficients[] coefficients) {
        this.straylight.setStrayLightCorrectionCoefficient(coefficients);
    }

    public Coefficients[] getStrayLightCorrectionCoefficient() {
        return this.straylight.getStrayLightCorrectionCoefficient();
    }

    public void setStrayLight(double strayLight, int index) {
        this.straylight.setStrayLight(strayLight, index);
    }

    public double getStrayLight(int index) {
        return this.straylight.getStrayLight(index);
    }

    public void setAutonullingConfiguration(AutonullingConfiguration configuration) {
        this.autonulling.setAutonullingConfiguration(configuration);
    }

    public void setAutonullingScanValue(int value) {
        this.autonulling.setAutonullingScanValue(value);
    }

    public void setAutonullingScanStatus(int value) {
        this.autonulling.setAutonullingScanStatus(value);
    }

    public void writeAutonullingConfigurationToSpectrometer() throws IOException {
        this.autonulling.writeAutonullingConfigurationToSpectrometer();
    }

    public AutonullingConfiguration readAutonullingConfigurationFromSpectrometer() throws IOException {
        return this.autonulling.readAutonullingConfigurationFromSpectrometer();
    }

    public int getAutonullingScanValue() {
        return this.autonulling.getAutonullingScanValue();
    }

    public int getAutonullingScanStatus() {
        return this.autonulling.getAutonullingScanStatus();
    }

    public AutonullingConfiguration getAutonullingConfiguration() {
        return this.autonulling.getAutonullingConfiguration();
    }

    public void setSingleStrobeLow(int counts) throws IOException {
        this.singleStrobe.setSingleStrobeLow(counts);
    }

    public void setSingleStrobeHigh(int counts) throws IOException {
        this.singleStrobe.setSingleStrobeHigh(counts);
    }

    public double getSingleStrobeCountsToMicros(int counts) {
        return this.singleStrobe.getSingleStrobeCountsToMicros(counts);
    }

    public int getSingleStrobeMinimum() {
        return this.singleStrobe.getSingleStrobeMinimum();
    }

    public int getSingleStrobeMaximum() {
        return this.singleStrobe.getSingleStrobeMaximum();
    }

    public int getSingleStrobeLow() throws IOException {
        return this.singleStrobe.getSingleStrobeLow();
    }

    public int getSingleStrobeIncrement() {
        return this.singleStrobe.getSingleStrobeIncrement();
    }

    public int getSingleStrobeHigh() throws IOException {
        return this.singleStrobe.getSingleStrobeHigh();
    }

    public boolean[] getChannelsPresent() {
        return this.multiChannel.getChannelsPresent();
    }

    public boolean isChannelPresent(int index) {
        return this.multiChannel.isChannelPresent(index);
    }

    public void setChannels(SpectrometerChannel[] channels) {
        this.multiChannel.setChannels(channels);
    }

    public void setChannelMux(int index) throws IOException {
        this.multiChannel.setChannelMux(index);
        this.lastSelectedChannel = index;
    }

    public void setChannelStatus(int index, boolean status) {
        this.multiChannel.setChannelStatus(index, status);
    }

    public void setDeepWellStatus(boolean status) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setChannelPresent(int index, boolean present) throws IOException {
        this.multiChannel.setChannelPresent(index, present);
    }

    public boolean isDeepWell() {
        return this.multiChannel.isDeepWell();
    }

    public boolean isInterpolationEnabled() {
        return this.multiChannel.isInterpolationEnabled();
    }

    public void setInterpolationEnabled(boolean enabled) {
        this.multiChannel.setInterpolationEnabled(enabled);
    }

    public void addChannelListener(MultiChannelListener listener) {
        this.multiChannel.addChannelListener(listener);
    }

    public void removeChannelListener(MultiChannelListener listener) {
        this.multiChannel.removeChannelListener(listener);
    }

    public void setExternalTriggerDelay(int counts) throws IOException {
        this.triggerDelay.setExternalTriggerDelay(counts);
    }

    public Integer getExternalTriggerDelay() {
        return this.triggerDelay.getExternalTriggerDelay();
    }

    public double triggerDelayCountsToMicroseconds(int counts) {
        return this.triggerDelay.triggerDelayCountsToMicroseconds(counts);
    }

    public int getExternalTriggerDelayMinimum() {
        return this.triggerDelay.getExternalTriggerDelayMinimum();
    }

    public int getExternalTriggerDelayMaximum() {
        return this.triggerDelay.getExternalTriggerDelayMaximum();
    }

    public int getExternalTriggerDelayIncrement() {
        return this.triggerDelay.getExternalTriggerDelayIncrement();
    }

    public void setPowerUpPOTValues() throws IOException {
    }

    public short[] getPOTValues() throws IOException {
        short[] values = new short[]{(short)this.visIntensity, (short)this.uvIntensity, this.visIntensity > 0 ? (short)0 : -1, this.uvIntensity > 0 ? (short)0 : -1};
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPOTValue(int pot, int value) throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            if (pot > 0 || pot < 3) {
                if (pot == 0) {
                    this.visIntensity = value;
                } else if (pot == 1) {
                    this.uvIntensity = value;
                }
                this.out[0] = 64;
                this.out[1] = (byte)pot;
                this.out[2] = (byte)value;
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 3);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                throw new IllegalArgumentException("Invaild POT value. Must be between 0-3.");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public BitSet getValueBits() throws IOException {
        return this.gpio.getValueBits();
    }

    public int getValueBit(int bitNumber) throws IOException {
        return this.gpio.getValueBit(bitNumber);
    }

    public void setValueAllBits(BitSet bitSet) throws IOException {
        this.gpio.setValueAllBits(bitSet);
    }

    public void setValueBitmask(short bitmask) throws IOException {
        this.gpio.setValueBitmask(bitmask);
    }

    public void setValueBit(int bit, boolean value) throws IOException {
        this.gpio.setValueBit(bit, value);
    }

    public BitSet getDirectionBits() throws IOException {
        return this.gpio.getDirectionBits();
    }

    public void setDirectionAllBits(BitSet bitSet) throws IOException {
        this.gpio.setDirectionAllBits(bitSet);
    }

    public void setDirectionBitmask(short bitmask) throws IOException {
        this.gpio.setDirectionBitmask(bitmask);
    }

    public void setDirectionBit(int bit, boolean value) throws IOException {
        this.gpio.setDirectionBit(bit, value);
    }

    public BitSet getMuxBits() throws IOException {
        return this.gpio.getMuxBits();
    }

    public int getNumberOfPins() {
        return this.gpio.getNumberOfPins();
    }

    public void setMuxAllBits(BitSet bitSet) throws IOException {
        this.gpio.setMuxAllBits(bitSet);
    }

    public void setMuxBitmask(short bitmask) throws IOException {
        this.gpio.setMuxBitmask(bitmask);
    }

    public void setMuxBit(int bit, boolean value) throws IOException {
        this.gpio.setMuxBit(bit, value);
    }

    public int getTotalGPIOBits() {
        return this.gpio.getTotalGPIOBits();
    }

    public void setContinuousStrobeDelay(int durationOfPhase) throws IOException {
        this.continuousStrobe.setContinuousStrobeDelay(durationOfPhase);
    }

    public int getContinuousStrobeDelayIncrement(int magnitude) {
        return this.continuousStrobe.getContinuousStrobeDelayIncrement(magnitude);
    }

    public double continuousStrobeCountsToMicros(int counts) {
        return this.continuousStrobe.continuousStrobeCountsToMicros(counts);
    }

    public int getContinuousStrobeDelayMinimum() {
        return this.continuousStrobe.getContinuousStrobeDelayMinimum();
    }

    public int getContinuousStrobeDelayMaximum() {
        return this.continuousStrobe.getContinuousStrobeDelayMaximum();
    }

    public Integer getContinuousStrobeDelay() {
        return this.continuousStrobe.getContinuousStrobeDelay();
    }

    public void setTriggerSource(TriggerSource source) throws IOException {
        this.internalTrigger.setTriggerSource(source);
    }

    public void setInternalTriggerPeriodMicros(int micros) throws IOException {
        this.internalTrigger.setInternalTriggerPeriodMicros(micros);
    }

    public TriggerSource getTriggerSource() {
        return this.internalTrigger.getTriggerSource();
    }

    public int getInternalTriggerPeriodMinimum() {
        return this.internalTrigger.getInternalTriggerPeriodMinimum();
    }

    public Integer getInternalTriggerPeriodMicros() {
        return this.internalTrigger.getInternalTriggerPeriodMicros();
    }

    public int getInternalTriggerPeriodMaximum() {
        return this.internalTrigger.getInternalTriggerPeriodMaximum();
    }

    public int getInternalTriggerPeriodIncrement() {
        return this.internalTrigger.getInternalTriggerPeriodIncrement();
    }

    public int getNumberOfIndyModules() throws IOException {
        if (!this.hasIndy) {
            return 0;
        }
        return this.indy.getNumberOfIndyModules();
    }

    public int getNumberOfVoltageOutputs(int moduleIndex) throws IOException {
        if (!this.hasIndy) {
            return 0;
        }
        return this.indy.getNumberOfVoltageOutputs(moduleIndex);
    }

    public int getNumberOfVoltageInputs(int moduleIndex) throws IOException {
        if (!this.hasIndy) {
            return 0;
        }
        return this.indy.getNumberOfVoltageInputs(moduleIndex);
    }

    public int getNumberOfCurrentOutputs(int moduleIndex) throws IOException {
        if (!this.hasIndy) {
            return 0;
        }
        return this.indy.getNumberOfCurrentOutputs(moduleIndex);
    }

    public int getNumberOfCurrentInputs(int moduleIndex) throws IOException {
        if (!this.hasIndy) {
            return 0;
        }
        return this.indy.getNumberOfCurrentInputs(moduleIndex);
    }

    public int getNumberOfIndyGPIO(int moduleIndex) throws IOException {
        if (!this.hasIndy) {
            return 0;
        }
        return this.indy.getNumberOfIndyGPIO(moduleIndex);
    }

    public int getVoltageOutputMaximumCounts(int moduleIndex, int channel) {
        if (!this.hasIndy) {
            return 0;
        }
        return this.indy.getVoltageOutputMaximumCounts(moduleIndex, channel);
    }

    public int getCurrentOutputMaximumCounts(int moduleIndex, int channel) {
        if (!this.hasIndy) {
            return 0;
        }
        return this.indy.getCurrentOutputMaximumCounts(moduleIndex, channel);
    }

    public IndyVoltageSample[] sampleVoltageInputs(int moduleIndex) throws IOException {
        return this.indy.sampleVoltageInputs(moduleIndex);
    }

    public IndyVoltageSample[] getVoltageOutputs(int moduleIndex) throws IOException {
        return this.indy.getVoltageOutputs(moduleIndex);
    }

    public IndyCurrentSample[] sampleCurrentInputs(int moduleIndex) throws IOException {
        return this.indy.sampleCurrentInputs(moduleIndex);
    }

    public IndyCurrentSample[] getCurrentOutputs(int moduleIndex) throws IOException {
        return this.indy.getCurrentOutputs(moduleIndex);
    }

    public boolean[] getCurrentOutputEnables(int moduleIndex) throws IOException {
        return this.indy.getCurrentOutputEnables(moduleIndex);
    }

    public boolean[] getCurrentOutputEnergized(int moduleIndex) throws IOException {
        return this.indy.getCurrentOutputEnergized(moduleIndex);
    }

    public int getIndyGPIOInputValues(int moduleIndex) throws IOException {
        return this.indy.getIndyGPIOInputValues(moduleIndex);
    }

    public int getIndyGPIOOutputValues(int moduleIndex) throws IOException {
        return this.indy.getIndyGPIOOutputValues(moduleIndex);
    }

    public int getIndyGPIOOutputEnables(int moduleIndex) throws IOException {
        return this.indy.getIndyGPIOOutputEnables(moduleIndex);
    }

    public boolean getExcitationEnable(int moduleIndex, int channel) throws IOException {
        return this.indy.getExcitationEnable(moduleIndex, channel);
    }

    public float getExcitationVoltage(int moduleIndex, int channel) throws IOException {
        return this.indy.getExcitationVoltage(moduleIndex, channel);
    }

    public float[] getExcitationVoltageOptions(int moduleIndex, int channel) {
        return this.indy.getExcitationVoltageOptions(moduleIndex, channel);
    }

    public int getCurrentOutputCalibration4mA(int moduleIndex, int channel) throws IOException {
        return this.indy.getCurrentOutputCalibration4mA(moduleIndex, channel);
    }

    public int getCurrentOutputCalibration20mA(int moduleIndex, int channel) throws IOException {
        return this.indy.getCurrentOutputCalibration20mA(moduleIndex, channel);
    }

    public void setVoltageOutputVolts(int moduleIndex, int channel, float volts) throws IOException {
        this.indy.setVoltageOutputVolts(moduleIndex, channel, volts);
    }

    public void setVoltageOutputCounts(int moduleIndex, int channel, int counts) throws IOException {
        this.indy.setVoltageOutputCounts(moduleIndex, channel, counts);
    }

    public void setCurrentOutputMilliamps(int moduleIndex, int channel, float milliamps) throws IOException {
        this.indy.setCurrentOutputMilliamps(moduleIndex, channel, milliamps);
    }

    public void setCurrentOutputCounts(int moduleIndex, int channel, int counts) throws IOException {
        this.indy.setCurrentOutputCounts(moduleIndex, channel, counts);
    }

    public void setIndyGPIOConfiguration(int moduleIndex, int outputValueVector, int enableVector, int mask) throws IOException {
        this.indy.setIndyGPIOConfiguration(moduleIndex, outputValueVector, enableVector, mask);
    }

    public void setIndyGPIOOutputValues(int moduleIndex, int valueVector, int mask) throws IOException {
        this.indy.setIndyGPIOOutputValues(moduleIndex, valueVector, mask);
    }

    public void setCurrentOutputEnable(int moduleIndex, int channel, boolean enabled) throws IOException {
        this.indy.setCurrentOutputEnable(moduleIndex, channel, enabled);
    }

    public void setExcitationVoltage(int moduleIndex, int channel, float volts) throws IOException {
        this.indy.setExcitationVoltage(moduleIndex, channel, volts);
    }

    public void setExcitationEnable(int moduleIndex, int channel, boolean enabled) throws IOException {
        this.indy.setExcitationEnable(moduleIndex, channel, enabled);
    }

    public void setCurrentOutputCalibration4mA(int moduleIndex, int channel, int counts) throws IOException {
        this.indy.setCurrentOutputCalibration4mA(moduleIndex, channel, counts);
    }

    public void setCurrentOutputCalibration20mA(int moduleIndex, int channel, int counts) throws IOException {
        this.indy.setCurrentOutputCalibration20mA(moduleIndex, channel, counts);
    }
}

