/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.mmsraman.features.ccdtemperature;

import com.oceanoptics.omnidriver.features.USBFeature;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.features.ccdtemperature.CCDTemperatureGUIProvider;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.ramanspectrometer.MMSRamanSpectrometer;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;

public class CCDTemperatureImpl
extends USBFeature
implements CCDTemperatureGUIProvider {
    private MMSRamanSpectrometer spectrometer;
    protected boolean temperatureRegulation;
    protected float ccdSetpoint;
    protected float thermistor;
    protected boolean thermFault;
    protected boolean tempLock;
    protected String featurePath = "mmsraman.ccdtemperature.CCDTemperaturePanel";
    protected int minimumCCDSetpoint;
    protected int maximumCCDSetpoint;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;Lcom/oceanoptics/omnidriver/spectrometer/mmsraman/ramanspectrometer/MMSRamanSpectrometer;)V\ngetCCDTemperatureInfo,()V\nsetCCDTemperatureInfo,(ZF)V\nsetTemperatureRegulation,(Z)V\nisTemperatureRegulation,()Z\ngetCCDSetpoint,()F\nsetCCDSetpoint,(F)V\ngetMinimumCCDSetpoint,()I\nsetMinimumCCDSetpoint,(I)V\ngetMaximumCCDSetpoint,()I\nsetMaximumCCDSetpoint,(I)V\ngetThermistor,()F\nisThermFault,()Z\nisTempLock,()Z\ntoString,()Ljava/lang/String;\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public CCDTemperatureImpl(USBInterface usbInt, MMSRamanSpectrometer spec) throws IOException {
        super(usbInt);
        this.spectrometer = spec;
        this.getCCDTemperatureInfo();
        if (this.temperatureRegulation) {
            this.setCCDTemperatureInfo(true, 0.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCCDTemperatureInfo() throws IOException {
        int size = 6;
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                boolean response;
                this.out[0] = 3;
                this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)size));
                this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)size));
                this.out[3] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)size));
                this.out[4] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)size));
                this.out[5] = 1;
                this.usb.bulkOut(this.spectrometer.getEndpoint(1), this.out, size);
                this.usb.bulkIn(this.spectrometer.getEndpoint(3), this.in, 64);
                boolean bl = response = this.in[6] == 1;
                if (response) {
                    this.temperatureRegulation = this.in[7] == 1;
                    this.ccdSetpoint = Float.intBitsToFloat(ByteRoutines.makeDWordLE((byte)this.in[8], (byte)this.in[9], (byte)this.in[10], (byte)this.in[11]));
                    this.thermistor = Float.intBitsToFloat(ByteRoutines.makeDWordLE((byte)this.in[12], (byte)this.in[13], (byte)this.in[14], (byte)this.in[15]));
                    this.thermFault = this.in[16] == 1;
                    this.tempLock = this.in[17] == 1;
                } else {
                    System.err.println("Error reading CCD temperature information from spectrometer.");
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCCDTemperatureInfo(boolean regulation, float setpoint) throws IOException {
        this.setTemperatureRegulation(regulation);
        this.setCCDSetpoint(setpoint);
        int size = 11;
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                boolean response;
                this.out[0] = 4;
                this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)size));
                this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)size));
                this.out[3] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)size));
                this.out[4] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)size));
                this.out[5] = 1;
                this.out[6] = regulation ? (byte)1 : 0;
                this.out[7] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)Float.floatToIntBits(setpoint)));
                this.out[8] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)Float.floatToIntBits(setpoint)));
                this.out[9] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)Float.floatToIntBits(setpoint)));
                this.out[10] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)Float.floatToIntBits(setpoint)));
                this.usb.bulkOut(this.spectrometer.getEndpoint(1), this.out, size);
                this.usb.bulkIn(this.spectrometer.getEndpoint(3), this.in, 64);
                boolean bl = response = this.in[6] == 1;
                if (response) {
                    this.logger.fine("CCD temperature information successfully set.");
                } else {
                    this.logger.warning("Error reading CCD temperature information from spectrometer.");
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
            }
            return;
        }
    }

    public void setTemperatureRegulation(boolean regulation) {
        this.temperatureRegulation = regulation;
    }

    public boolean isTemperatureRegulation() {
        return this.temperatureRegulation;
    }

    public float getCCDSetpoint() {
        return this.ccdSetpoint;
    }

    public void setCCDSetpoint(float setpoint) {
        this.ccdSetpoint = setpoint;
    }

    public int getMinimumCCDSetpoint() {
        return this.minimumCCDSetpoint;
    }

    public void setMinimumCCDSetpoint(int min) {
        this.minimumCCDSetpoint = min;
    }

    public int getMaximumCCDSetpoint() {
        return this.maximumCCDSetpoint;
    }

    public void setMaximumCCDSetpoint(int max) {
        this.maximumCCDSetpoint = max;
    }

    public float getThermistor() {
        return this.thermistor;
    }

    public boolean isThermFault() {
        return this.thermFault;
    }

    public boolean isTempLock() {
        return this.tempLock;
    }

    public String toString() {
        return "\nCCD Temperature Information:\n\tTemperature Regulation: " + this.temperatureRegulation + "\n\tCCD Set point: " + this.ccdSetpoint + "\n\tMinimum CCD Temperature set point: " + this.minimumCCDSetpoint + "\n\tMaximum CCD Temperature set point: " + this.maximumCCDSetpoint + "\n\tThermistor: " + this.thermistor + "\n\tThermistor Fault: " + this.thermFault + "\n\tTemp Lock: " + this.tempLock;
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }
}

