/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.mmsraman.features.firmware;

import com.oceanoptics.omnidriver.features.USBFeature;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.features.firmware.FirmwareGUIProvider;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.ramanspectrometer.MMSRaman;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FirmwareImpl
extends USBFeature
implements FirmwareGUIProvider {
    private MMSRaman spectrometer;
    private String firmwareVersion;
    private String dspFirmwareVersion;
    private String fpgaFirmwareVersion;
    private String usbFirmwareVersion;
    protected String featurePath = "mmsraman.firmware.FirmwarePanel";
    private static String __extern__;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FirmwareImpl(USBInterface usbInt, MMSRaman spec) {
        super(usbInt);
        this.spectrometer = spec;
    }

    public void updateFX2(File file, long size) throws IOException {
        this.uploadFirmware(file, size, (byte)23);
        this.refreshFirmwareVersions();
    }

    public void updateDSP(File file, long size) throws IOException {
        this.uploadFirmware(file, size, (byte)24);
        this.logger.info("Firmware successfully updated.");
        this.refreshFirmwareVersions();
    }

    public void updateFPGA(File file, long size) throws IOException {
        this.uploadFirmware(file, size, (byte)25);
        this.refreshFirmwareVersions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void uploadFirmware(File file, long size, byte opCode) {
        if (this.spectrometer.isExposureInProgress()) {
            throw new IllegalStateException("Exposure in progress. Please stop acquisition.");
        }
        System.out.println("Updating firmware. Please wait...");
        this.logger.severe("Updating firmware. Please wait...");
        try {
            if (!$assertionsDisabled && size >= Integer.MAX_VALUE) {
                throw new AssertionError();
            }
            int length = (int)size;
            byte[] data = new byte[length];
            FileInputStream is = new FileInputStream(file);
            int offset = 0;
            int numRead = 0;
            byte[] byArray = this.in;
            synchronized (this.in) {
                byte[] byArray2 = this.out;
                synchronized (this.out) {
                    this.out[6] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)length));
                    this.out[7] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)length));
                    this.out[8] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)length));
                    this.out[9] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)length));
                    for (int i = 10; i < 64; ++i) {
                        this.out[i] = 0;
                    }
                    while (offset < data.length && (numRead = ((InputStream)is).read(data, offset, data.length - offset)) >= 0) {
                        offset += numRead;
                    }
                    if (offset < data.length) {
                        throw new IOException("Could not completely read file " + file.getName());
                    }
                    ((InputStream)is).close();
                    this.spectrometer.process(opCode, length + 64, data, (byte)1, (byte)1);
                    // ** MonitorExit[var11_11] (shouldn't be in output)
                    return;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void refreshFirmwareVersions() throws IOException {
        this.spectrometer.getSpectrometerInfo();
    }

    public String getFirmwareVersion() throws IOException {
        this.firmwareVersion = "DSP: " + this.dspFirmwareVersion + " \nFPGA: " + this.fpgaFirmwareVersion + " \nUSB: " + this.usbFirmwareVersion;
        this.logger.fine("Firmware version: " + this.firmwareVersion);
        return this.firmwareVersion;
    }

    public void setDSPFirmwareVersion(String dsp) {
        this.dspFirmwareVersion = dsp;
    }

    public String getDSPFirmwareVersion() {
        return this.dspFirmwareVersion;
    }

    public void setFPGAFirmwareVersion(String fpga) {
        this.fpgaFirmwareVersion = fpga;
    }

    public String getFPGAFirmwareVersion() {
        return this.fpgaFirmwareVersion;
    }

    public void setUSBFirmwareVersion(String usb) {
        this.usbFirmwareVersion = usb;
    }

    public String getUSBFirmwareVersion() {
        return this.usbFirmwareVersion;
    }

    public MMSRaman getSpectrometer() {
        return this.spectrometer;
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }

    static {
        $assertionsDisabled = !FirmwareImpl.class.desiredAssertionStatus();
        __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;Lcom/oceanoptics/omnidriver/spectrometer/mmsraman/ramanspectrometer/MMSRaman;)V\nupdateFX2,(Ljava/io/File;J)V\nupdateDSP,(Ljava/io/File;J)V\nupdateFPGA,(Ljava/io/File;J)V\ngetFirmwareVersion,()Ljava/lang/String;\nsetDSPFirmwareVersion,(Ljava/lang/String;)V\ngetDSPFirmwareVersion,()Ljava/lang/String;\nsetFPGAFirmwareVersion,(Ljava/lang/String;)V\ngetFPGAFirmwareVersion,()Ljava/lang/String;\nsetUSBFirmwareVersion,(Ljava/lang/String;)V\ngetUSBFirmwareVersion,()Ljava/lang/String;\ngetSpectrometer,()Lcom/oceanoptics/omnidriver/spectrometer/mmsraman/ramanspectrometer/MMSRaman;\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";
    }
}

