/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.mmsraman.ramanspectrometer;

import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerChannel;

public class Laser {
    protected Spectrometer spectrometer;
    protected int laserIndex;
    private float laserWavelength;
    private boolean remoteEnabled;
    private boolean safetyKeyOn;
    private boolean laserPresent;
    private boolean laserFault;
    private boolean laserTemperatureLock;
    private boolean laserPowered;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/spectrometer/Spectrometer;I)V\ngetLaserIndex,()I\nisRemoteEnabled,()Z\nsetRemoteEnabled,(Z)V\ngetLaserWavelength,()F\nsetLaserWavelength,(FI)V\nsetLaserWavelengthForAllChannels,(F)V\nisSafetyKeyOn,()Z\nsetSafetyKeyOn,(Z)V\nisLaserPresent,()Z\nsetLaserPresent,(Z)V\nisLaserFault,()Z\nsetLaserFault,(Z)V\nisLaserTemperatureLock,()Z\nsetLaserTemperatureLock,(Z)V\nisLaserPowered,()Z\nsetLaserPowered,(Z)V\ntoString,()Ljava/lang/String;\n";

    public Laser(Spectrometer spectrometer, int laserIndex) {
        this.spectrometer = spectrometer;
        this.laserIndex = laserIndex;
    }

    public int getLaserIndex() {
        return this.laserIndex;
    }

    public boolean isRemoteEnabled() {
        return this.remoteEnabled;
    }

    public void setRemoteEnabled(boolean remoteEnabled) {
        this.remoteEnabled = remoteEnabled;
    }

    public float getLaserWavelength() {
        return this.laserWavelength;
    }

    public void setLaserWavelength(float laserWavelength, int channelIndex) {
        this.laserWavelength = laserWavelength;
        if (this.spectrometer.getChannels() != null && this.spectrometer.getChannels()[channelIndex].getSpectrometerChannelInfo() != null) {
            this.spectrometer.getChannels()[channelIndex].setSpectrometerChannelInfoCoefficients(this.spectrometer.getChannels()[channelIndex].getCoefficients());
        }
    }

    public void setLaserWavelengthForAllChannels(float laserWavelength) {
        this.laserWavelength = laserWavelength;
        SpectrometerChannel[] channels = this.spectrometer.getChannels();
        for (int i = 0; i < channels.length; ++i) {
            SpectrometerChannel channel = channels[i];
            if (channel == null || channel.getSpectrometerChannelInfo() == null) continue;
            channel.setSpectrometerChannelInfoCoefficients(channel.getCoefficients());
        }
    }

    public boolean isSafetyKeyOn() {
        return this.safetyKeyOn;
    }

    public void setSafetyKeyOn(boolean safetyKeyOn) {
        this.safetyKeyOn = safetyKeyOn;
    }

    public boolean isLaserPresent() {
        return this.laserPresent;
    }

    public void setLaserPresent(boolean laserPresent) {
        this.laserPresent = laserPresent;
    }

    public boolean isLaserFault() {
        return this.laserFault;
    }

    public void setLaserFault(boolean laserFault) {
        this.laserFault = laserFault;
    }

    public boolean isLaserTemperatureLock() {
        return this.laserTemperatureLock;
    }

    public void setLaserTemperatureLock(boolean laserTemperatureLock) {
        this.laserTemperatureLock = laserTemperatureLock;
    }

    public boolean isLaserPowered() {
        return this.laserPowered;
    }

    public void setLaserPowered(boolean laserPowered) {
        this.laserPowered = laserPowered;
    }

    public String toString() {
        String s = "\nLaser:";
        s = s + "\n\tLaser Index: " + this.laserIndex + "\n\tLaser Wavelength: " + this.laserWavelength + "\n\tRemote Enabled: " + this.remoteEnabled + "\n\tSaftey Key On: " + this.safetyKeyOn + "\n\tLaser Present: " + this.laserPresent + "\n\tLaser Fault: " + this.laserFault + "\n\tLaser Temperature Lock: " + this.laserTemperatureLock + "\n\tLaser Powered: " + this.laserPowered;
        return s;
    }
}

