/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.mmsraman.ramanspectrometer;

import com.oceanoptics.omnidriver.features.exposureimage.ExposureImageGUIProvider;
import com.oceanoptics.omnidriver.features.exposureimage.ExposureImageImpl;
import com.oceanoptics.omnidriver.features.exposureimage.ExposureListener;
import com.oceanoptics.omnidriver.features.masterclockrate.MasterClockRate;
import com.oceanoptics.omnidriver.features.masterclockrate.MasterClockRateImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationGUIProvider;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationProvider;
import com.oceanoptics.omnidriver.interfaces.ExposureImageable;
import com.oceanoptics.omnidriver.interfaces.GUIProvider;
import com.oceanoptics.omnidriver.interfaces.IntegrationTimeChangeListener;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectra.SpectrometerExposure;
import com.oceanoptics.omnidriver.spectra.SpectrometerReconstruction;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.Configuration;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.features.calibration.CalibrationGUIProvider;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.features.calibration.CalibrationImpl;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.features.ccdshutter.CCDShutter;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.features.ccdshutter.CCDShutterGUIProvider;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.features.ccdshutter.CCDShutterImpl;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.features.ccdtemperature.CCDTemperature;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.features.ccdtemperature.CCDTemperatureGUIProvider;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.features.ccdtemperature.CCDTemperatureImpl;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.features.firmware.Firmware;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.features.firmware.FirmwareGUIProvider;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.features.firmware.FirmwareImpl;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.features.laser.LaserGUIProvider;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.features.laser.LaserProvider;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.features.laser.LaserProviderImpl;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.features.masterclockrate.MasterClockRateImpl_MMSRaman;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.features.status.Status;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.features.status.StatusGUIProvider;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.features.status.StatusImpl;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.features.wavelengthcalibration.WavelengthCalibrationImpl_MMSRaman;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.ramanspectrometer.Laser;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.ramanspectrometer.MMSRamanCalibration;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.ramanspectrometer.MMSRamanChannel;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.ramanspectrometer.MMSRamanSpectrometer;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;

public class MMSRaman
extends MMSRamanSpectrometer
implements CCDTemperature,
CCDShutter,
LaserProvider,
Firmware,
WavelengthCalibrationProvider,
MasterClockRate,
Status,
ExposureImageable {
    protected int ccdWidth;
    protected int ccdHeight;
    protected int ccdBitsPerPixel;
    protected boolean shutterSupport = false;
    protected int ccdType;
    protected boolean calibrationSupport = false;
    protected boolean spectraReconstruction = false;
    protected boolean temperatureRegulation = false;
    protected byte numberGeneralIOLines;
    protected byte numberAccessoryIOLines;
    protected short adClockFrequency;
    protected int pixelBinningMode = 0;
    protected String strPixelBinningMode = "N/A";
    private boolean interlock = true;
    private byte reconstructionType = 1;
    private CalibrationGUIProvider calibration;
    private CCDTemperatureGUIProvider ccdTemperature;
    private CCDShutterGUIProvider ccdShutter;
    private LaserGUIProvider laserProvider;
    private ExposureImageGUIProvider exposureImage;
    private WavelengthCalibrationGUIProvider wavelength;
    private FirmwareGUIProvider firmware;
    private MasterClockRate masterClockRate;
    private StatusGUIProvider status;
    static Spectrometer[] scoreboard = new Spectrometer[64];
    private boolean exposureInProgress;
    SpectrometerExposure lastExposure;
    SpectrometerExposure lightExposure;
    SpectrometerExposure darkExposure;
    SpectrometerExposure referenceExposure;
    SpectrometerReconstruction reconstruction = new SpectrometerReconstruction();
    private transient ArrayList exposureListenerList;
    private Vector integrationTimeChangeListeners = new Vector();
    private static String __extern__ = "__extern__\n<init>,()V\n<init>,(I)V\nopenSpectrometer,(I)V\ngetGUIFeatures,()[Lcom/oceanoptics/omnidriver/interfaces/GUIProvider;\ngetSerialNumber,()Ljava/lang/String;\ngetModelNumber,()Ljava/lang/String;\ngetSpectrometerInfo,()V\ngetIntegrationTime,()F\nsetIntegrationTime,(I)V\ngetSpectrometerExposure,(BB)Lcom/oceanoptics/omnidriver/spectra/SpectrometerExposure;\nstartExposure,(BB)V\nqueryExposure,()Z\ngetExposure,()Lcom/oceanoptics/omnidriver/spectra/SpectrometerExposure;\nendExposure,()V\nendExposure,(B)V\ngetReconstruction,(B)Lcom/oceanoptics/omnidriver/spectra/SpectrometerReconstruction;\nreset,()V\ngetReconstructionType,()B\nsetReconstructionType,(B)V\ngetSpectrum,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)Lcom/oceanoptics/omnidriver/spectra/Spectrum;\ngetDarkExposure,()V\ngetLightExposure,()V\ngetCcdWidth,()I\ngetCcdHeight,()I\nisExposureInProgress,()Z\nsetStrobeEnable,(Z)V\nreadCalibrationFromSpectrometer,()V\nwriteCalibrationToSpectrometer,(Lcom/oceanoptics/omnidriver/spectrometer/mmsraman/ramanspectrometer/MMSRamanCalibration;)V\ngetCalibration,()Lcom/oceanoptics/omnidriver/spectrometer/mmsraman/ramanspectrometer/MMSRamanCalibration;\ngetLaser,(I)Lcom/oceanoptics/omnidriver/spectrometer/mmsraman/ramanspectrometer/Laser;\ngetLasers,()[Lcom/oceanoptics/omnidriver/spectrometer/mmsraman/ramanspectrometer/Laser;\nsetLasers,([Lcom/oceanoptics/omnidriver/spectrometer/mmsraman/ramanspectrometer/Laser;)V\ngetNumberOfEnabledLasers,()I\nsetLaserInfo,(I)V\ngetLaserInfo,(I)V\ngetNumberOfSupportedLasers,()I\nsetNumberOfSupportedLasers,(I)V\nsetDefaultLaser,(I)V\ngetDefaultLaser,()I\nisLaserTemperatureRegulation,()Z\nsetLaserTemperatureRegulation,(Z)V\ngetLaserTemperatureInfo,()V\nsetLaserTemperatureInfo,()V\ngetMinimumLaserSetpoint,()I\nsetMinimumLaserSetpoint,(I)V\ngetMaximumLaserSetpoint,()I\nsetMaximumLaserSetpoint,(I)V\nsetLaserPowerInfo,(I)V\ngetLaserPowerInfo,()I\nisLaserPowerRegulation,()Z\nsetLaserPowerRegulation,(Z)V\ngetMinimumLaserPowerSetpoint,()I\nsetMinimumLaserPowerSetpoint,(I)V\ngetMaximumLaserPowerSetpoint,()I\nsetMaximumLaserPowerSetpoint,(I)V\ngetCCDTemperatureInfo,()V\nsetCCDTemperatureInfo,(ZF)V\nisTemperatureRegulation,()Z\nsetTemperatureRegulation,(Z)V\ngetCCDSetpoint,()F\nsetCCDSetpoint,(F)V\ngetMinimumCCDSetpoint,()I\nsetMinimumCCDSetpoint,(I)V\ngetMaximumCCDSetpoint,()I\nsetMaximumCCDSetpoint,(I)V\ngetThermistor,()F\nisThermFault,()Z\nisTempLock,()Z\ngetShutterState,()B\nisShutterOpen,()Z\nopenShutter,()V\ncloseShutter,()V\nreadWavelengthCalibrationCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteWavelengthCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengthCalibrationCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetWavelengthCalibrationCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengths,(I)[D\nsetWavelengths,([DI)V\nupdateFX2,(Ljava/io/File;J)V\nupdateDSP,(Ljava/io/File;J)V\nupdateFPGA,(Ljava/io/File;J)V\ngetFirmwareVersion,()Ljava/lang/String;\nsetDSPFirmwareVersion,(Ljava/lang/String;)V\ngetDSPFirmwareVersion,()Ljava/lang/String;\nsetFPGAFirmwareVersion,(Ljava/lang/String;)V\ngetFPGAFirmwareVersion,()Ljava/lang/String;\nsetUSBFirmwareVersion,(Ljava/lang/String;)V\ngetUSBFirmwareVersion,()Ljava/lang/String;\ngetSpectrometer,()Lcom/oceanoptics/omnidriver/spectrometer/mmsraman/ramanspectrometer/MMSRaman;\nsetMasterClock,(I)V\ngetLEDFlashCodes,()[Ljava/lang/String;\ntoString,()Ljava/lang/String;\ngetConfiguration,()Lcom/oceanoptics/omnidriver/spectrometer/Configuration;\naddExposureListener,(Lcom/oceanoptics/omnidriver/features/exposureimage/ExposureListener;)V\nremoveExposureListener,(Lcom/oceanoptics/omnidriver/features/exposureimage/ExposureListener;)V\ngetLastExposure,()Lcom/oceanoptics/omnidriver/spectra/SpectrometerExposure;\nhas1DMode,()Z\nset2DMode,(I)V\nset1DMode,(I)V\nis2DMode,()Z\nis1DMode,()Z\nget2DintegrationTime,()I\naddIntegrationTimeChangeListener,(Lcom/oceanoptics/omnidriver/interfaces/IntegrationTimeChangeListener;)V\nremoveIntegrationTimeChangeListener,(Lcom/oceanoptics/omnidriver/interfaces/IntegrationTimeChangeListener;)V\nfireIntegrationTimeChanged,(I)V\n";

    public MMSRaman() throws IOException {
        try {
            this.setEndpoints();
            this.openNextUnclaimedUSB();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Spectrometer[] getScoreboard() {
        return scoreboard;
    }

    public MMSRaman(int i) throws IOException {
        this.setEndpoints();
        this.openSpectrometer(i);
    }

    public void openSpectrometer(int index) throws IOException {
        this.integrationTimeIncrement = 1000;
        this.integrationTimeBase = 1000000;
        this.stabilityScan = false;
        this.vendorID = 6220;
        this.productID = 0;
        this.usb.openDevice(this.vendorID, this.productID, index);
        this.deviceIndex = index;
        this.integrationTime = Float.floatToIntBits(this.getIntegrationTime());
        this.initFeatures(this.usb);
        this.getSpectrometerInfo();
        this.discoverLasers();
        this.numberOfCCDPixels = this.ccdWidth;
        this.numberOfDarkCCDPixels = this.calibration.getCalibration().getNumberOfDeadPixelColumnsLeft() + this.calibration.getCalibration().getNumberOfDeadPixelColumnsRight();
        this.maxIntensity = ((1 << this.ccdBitsPerPixel) - 1) * 4 * 24;
        this.channels = new MMSRamanChannel[1];
        this.channels[this.channelIndex] = new MMSRamanChannel(this, new Coefficients(), this.channelIndex);
        this.channels[0].setLaserWavelength(new Float(this.getLaser(this.getDefaultLaser()).getLaserWavelength()).doubleValue());
        this.channels[0].setInterlock(this.getLaser(this.getDefaultLaser()).isSafetyKeyOn());
        this.logger.fine("MMSRaman has been opened at index " + index);
        this.finishConstruction();
    }

    private void initFeatures(USBInterface usb) throws IOException {
        this.calibration = new CalibrationImpl(usb, this);
        this.ccdTemperature = new CCDTemperatureImpl(usb, this);
        this.ccdShutter = new CCDShutterImpl(usb, this);
        this.laserProvider = new LaserProviderImpl(usb, this);
        this.exposureImage = new ExposureImageImpl(this);
        this.firmware = new FirmwareImpl(usb, this);
        this.wavelength = new WavelengthCalibrationImpl_MMSRaman(usb, this);
        this.masterClockRate = new MasterClockRateImpl_MMSRaman(usb, this);
        this.status = new StatusImpl();
        this.featureMap.put(CalibrationImpl.class, (CalibrationImpl)this.calibration);
        this.featureMap.put(CCDTemperatureImpl.class, (CCDTemperatureImpl)this.ccdTemperature);
        this.featureMap.put(CCDShutterImpl.class, (CCDShutterImpl)this.ccdShutter);
        this.featureMap.put(LaserProviderImpl.class, (LaserProviderImpl)this.laserProvider);
        this.featureMap.put(ExposureImageImpl.class, (ExposureImageImpl)this.exposureImage);
        this.featureMap.put(FirmwareImpl.class, (FirmwareImpl)this.firmware);
        this.featureMap.put(WavelengthCalibrationImpl.class, (WavelengthCalibrationImpl)this.wavelength);
        this.featureMap.put(MasterClockRateImpl.class, (MasterClockRateImpl)this.masterClockRate);
    }

    protected Spectrum formatData(byte[] data, Spectrum spectrum) throws IOException {
        return spectrum;
    }

    public GUIProvider[] getGUIFeatures() {
        Vector<GUIProvider> features = new Vector<GUIProvider>();
        features.add(this.exposureImage);
        features.add(this.laserProvider);
        features.add(this.wavelength);
        features.add(this.firmware);
        if (this.temperatureRegulation) {
            features.add(this.ccdTemperature);
        }
        if (this.shutterSupport) {
            features.add(this.ccdShutter);
        }
        if (this.firmwareVersionNumber >= 3030) {
            features.add(this.status);
        }
        return features.toArray(new GUIProvider[0]);
    }

    private void discoverLasers() throws IOException {
        int i;
        Laser[] lasers = new Laser[this.getNumberOfSupportedLasers()];
        for (i = 0; i < lasers.length; ++i) {
            lasers[i] = new Laser(this, i);
        }
        this.setLasers(lasers);
        for (i = 0; i < lasers.length; ++i) {
            this.getLaserInfo(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSerialNumber() throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.process((byte)20);
                int snSize = ByteRoutines.makeWordLE((byte)this.in[7], (byte)this.in[8]);
                int position = 9;
                String sn = "";
                for (int i = 0; i < snSize; ++i) {
                    sn = sn + (char)this.in[position++];
                }
                sn = super.trimTrailingNulls(sn);
                this.logger.finer("Serial number: " + sn);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return sn;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getModelNumber() throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.process((byte)18);
                int mnSize = ByteRoutines.makeWordLE((byte)this.in[7], (byte)this.in[8]);
                int position = 9;
                String mn = "";
                for (int i = 0; i < mnSize; ++i) {
                    mn = mn + (char)this.in[position++];
                }
                mn = this.trimTrailingNulls(mn);
                this.logger.finer("Serial number: " + mn);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return mn;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSpectrometerInfo() throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.process((byte)22);
                this.logger.fine("\nSuccess reading in Spectrometer Info.");
                int position = 7;
                this.ccdWidth = ByteRoutines.makeWordLE((byte)this.in[position], (byte)this.in[position + 1]);
                position = 9;
                this.ccdHeight = ByteRoutines.makeWordLE((byte)this.in[position], (byte)this.in[position + 1]);
                position = 11;
                this.ccdBitsPerPixel = ByteRoutines.byteToShort((byte)this.in[position]);
                position = 12;
                this.ccdType = ByteRoutines.byteToShort((byte)this.in[position]);
                position = 13;
                this.shutterSupport = this.in[position] == 1;
                position = 14;
                this.integrationTimeMinimum = ByteRoutines.makeDWordLE((byte)this.in[position], (byte)this.in[position + 1], (byte)this.in[position + 2], (byte)this.in[position + 3]) * 1000;
                position = 18;
                this.integrationTimeMaximum = ByteRoutines.makeDWordLE((byte)this.in[position], (byte)this.in[position + 1], (byte)this.in[position + 2], (byte)this.in[position + 3]) * 1000;
                position = 22;
                this.calibrationSupport = this.in[position] == 1;
                position = 23;
                this.spectraReconstruction = this.in[position] == 1;
                position = 24;
                this.temperatureRegulation = this.in[position] == 1;
                position = 25;
                this.setMinimumCCDSetpoint(ByteRoutines.makeWordLE((byte)this.in[position], (byte)this.in[position + 1]));
                position = 27;
                this.setMaximumCCDSetpoint(ByteRoutines.makeWordLE((byte)this.in[position], (byte)this.in[position + 1]));
                position = 29;
                this.setNumberOfSupportedLasers(ByteRoutines.byteToShort((byte)this.in[position]));
                position = 30;
                this.setLaserTemperatureRegulation(this.in[position] == 1);
                if (this.isLaserTemperatureRegulation()) {
                    position = 31;
                    this.setMinimumLaserSetpoint(ByteRoutines.makeWordLE((byte)this.in[position], (byte)this.in[position + 1]));
                    position = 33;
                    this.setMaximumLaserSetpoint(ByteRoutines.makeWordLE((byte)this.in[position], (byte)this.in[position + 1]));
                }
                this.setLaserPowerRegulation(this.in[position = 35] == 1);
                if (this.isLaserPowerRegulation()) {
                    position = 36;
                    this.setMinimumLaserPowerSetpoint(ByteRoutines.makeWordLE((byte)this.in[position], (byte)this.in[position + 1]));
                    position = 38;
                    this.setMaximumLaserPowerSetpoint(ByteRoutines.makeWordLE((byte)this.in[position], (byte)this.in[position + 1]));
                }
                position = 40;
                this.setDSPFirmwareVersion(this.in[position + 3] + "." + this.in[position + 2] + "." + this.in[position + 1] + "." + this.in[position]);
                String temp = this.in[position + 3] + "" + this.in[position + 2] + "" + this.in[position + 1] + "" + this.in[position];
                this.firmwareVersionNumber = Integer.parseInt(temp);
                position = 44;
                this.setFPGAFirmwareVersion(this.in[position + 3] + "." + this.in[position + 2] + "." + this.in[position + 1] + "." + this.in[position]);
                position = 48;
                this.setUSBFirmwareVersion(this.in[position + 3] + "." + this.in[position + 2] + "." + this.in[position + 1] + "." + this.in[position]);
                position = 52;
                this.numberGeneralIOLines = this.in[position];
                position = 53;
                this.numberAccessoryIOLines = this.in[position];
                position = 54;
                this.adClockFrequency = ByteRoutines.makeWordLE((byte)this.in[position], (byte)this.in[position + 1]);
                position = 56;
                this.pixelBinningMode = ByteRoutines.makeWordLE((byte)this.in[position], (byte)this.in[position + 1]);
                switch (this.pixelBinningMode) {
                    case 0: {
                        this.strPixelBinningMode = "N/A";
                        break;
                    }
                    case 1: {
                        this.strPixelBinningMode = "Full Well";
                        break;
                    }
                    case 2: {
                        this.strPixelBinningMode = "Dark Current";
                        break;
                    }
                    case 3: {
                        this.strPixelBinningMode = "Line Binning";
                        break;
                    }
                    default: {
                        this.strPixelBinningMode = "N/A";
                    }
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getIntegrationTime() throws IOException {
        float expsoureTime = Float.intBitsToFloat(this.integrationTime);
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.process((byte)9);
                int position = 7;
                this.integrationTime = ByteRoutines.makeDWordLE((byte)this.in[position], (byte)this.in[position + 1], (byte)this.in[position + 2], (byte)this.in[position + 3]);
                expsoureTime = Float.intBitsToFloat(this.integrationTime);
                this.logger.finest("\nIntegration time: " + expsoureTime);
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            return expsoureTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIntegrationTime(int intTime) throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                intTime = Math.min(intTime, this.getIntegrationTimeMaximum());
                intTime = Math.max(intTime, this.getIntegrationTimeMinimum());
                if (this.integrationTime == intTime) {
                    this.logger.finest("Desired integration time already set, not pushing to spectrometer");
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                float sec = (float)intTime / 1000000.0f;
                this.out[6] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)Float.floatToIntBits(sec)));
                this.out[7] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)Float.floatToIntBits(sec)));
                this.out[8] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)Float.floatToIntBits(sec)));
                this.out[9] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)Float.floatToIntBits(sec)));
                this.process((byte)10, 10);
                this.integrationTime = intTime;
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            return;
        }
    }

    public SpectrometerExposure getSpectrometerExposure(byte shutter, byte type) throws IOException {
        float iTime = this.getIntegrationTime();
        this.logger.finer("Starting exposure.");
        this.startExposure(shutter, type);
        try {
            Thread.sleep((long)(iTime * 1000.0f));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.logger.finer("Querying exposure.");
        for (int tries = 0; !this.queryExposure() && tries == 10; ++tries) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.getExposure();
        this.endExposure((byte)0);
        return this.lastExposure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startExposure(byte shutter, byte type) throws IOException {
        if (null == this.lastExposure) {
            this.lastExposure = new SpectrometerExposure(this);
        }
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.out[6] = shutter;
                this.out[7] = type;
                this.process((byte)11, 8);
                this.lastExposure.setExposureType(type);
                this.lastExposure.setShutterState(shutter);
                this.exposureInProgress = true;
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queryExposure() throws IOException {
        int responseSize = 64;
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.process((byte)12);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.in[7] == 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpectrometerExposure getExposure() throws IOException {
        if (!this.exposureInProgress) {
            throw new IllegalStateException("No exposure in progress.");
        }
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.process((byte)14, 6, (byte)1, (byte)1, this.highSpeedInEndPoint, this.dataOutEndPoint);
                byte type = this.in[7];
                if (this.lastExposure.getExposureType() != type) {
                    throw new IOException("Mismatch between type of exposure requested and returned\n  Requested: " + this.lastExposure.getExposureType() + ", returned: " + type);
                }
                if (ByteRoutines.makeDWordLE((byte)this.in[8], (byte)this.in[9], (byte)this.in[10], (byte)this.in[11]) / (this.ccdBitsPerPixel >> 3) != this.ccdHeight * this.ccdWidth) {
                    throw new IOException("Exposure image size returned from spectrometer did not match that from Get Spectrometer Info.");
                }
                int position = 64;
                int[][] imageData = new int[this.ccdHeight][this.ccdWidth];
                this.lastExposure.setBitsPerPixel(this.ccdBitsPerPixel);
                switch (this.ccdBitsPerPixel) {
                    case 8: {
                        for (int i = 0; i < this.ccdHeight; ++i) {
                            for (int j = 0; j < this.ccdWidth; ++j) {
                                imageData[i][j] = this.in[position++] & 0xFF;
                            }
                        }
                        break;
                    }
                    case 16: {
                        for (int i = 0; i < this.ccdHeight; ++i) {
                            for (int j = 0; j < this.ccdWidth; ++j) {
                                imageData[i][j] = ByteRoutines.makeWordLE((byte)this.in[position++], (byte)this.in[position++]);
                            }
                        }
                        break;
                    }
                    case 24: {
                        for (int i = 0; i < this.ccdHeight; ++i) {
                            for (int j = 0; j < this.ccdWidth; ++j) {
                                imageData[i][j] = ByteRoutines.makeDWordLE((byte)0, (byte)this.in[position++], (byte)this.in[position++], (byte)this.in[position++]);
                            }
                        }
                        break;
                    }
                    case 32: {
                        for (int i = 0; i < this.ccdHeight; ++i) {
                            for (int j = 0; j < this.ccdWidth; ++j) {
                                imageData[i][j] = ByteRoutines.makeDWordLE((byte)this.in[position++], (byte)this.in[position++], (byte)this.in[position++], (byte)this.in[position++]);
                            }
                        }
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Not implemented for " + this.ccdBitsPerPixel + " bits per pixel.");
                    }
                }
                this.lastExposure.setImageData(imageData);
                this.lastExposure.setExposureTime((int)this.getIntegrationTime());
                this.fireExposureListenerNewSpectrometerExposure(this.lastExposure);
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
            {
                switch (this.lastExposure.getExposureType()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.lightExposure = this.lastExposure;
                        this.logger.fine("Light exposure taken.");
                        break;
                    }
                    case 2: {
                        this.darkExposure = this.lastExposure;
                        this.logger.fine("Dark exposure taken.");
                        break;
                    }
                    case 3: {
                        this.referenceExposure = this.lastExposure;
                        this.logger.fine("Reference exposure taken.");
                        break;
                    }
                    default: {
                        throw new IOException("Spectrometer returned unknown exposure type: " + this.lastExposure.getExposureType());
                    }
                }
                return this.lastExposure;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endExposure() throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.out[6] = 0;
                this.process((byte)13, 7);
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
            {
                this.exposureInProgress = false;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endExposure(byte shutterState) throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.out[6] = shutterState;
                this.process((byte)13, 7);
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            {
                this.exposureInProgress = false;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpectrometerReconstruction getReconstruction(byte type) throws IOException {
        if (this.exposureInProgress) {
            throw new IllegalStateException("Cannot reconstruct while exposure in progress.");
        }
        switch (type) {
            case 1: {
                if (this.lightExposure != null && this.darkExposure != null) break;
                throw new IllegalStateException("Reconstruction requires light and dark exposures.");
            }
            case 2: {
                if (this.darkExposure != null) break;
                throw new IllegalStateException("Reconstruction requires dark exposure.");
            }
            default: {
                throw new IllegalArgumentException("type " + type + " not recognized.");
            }
        }
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.out[6] = type;
                this.process((byte)15, 7);
                this.reconstruction.setAlgorithm(this.in[7]);
                byte responseType = this.in[8];
                this.reconstruction.setReconstructionType(type);
                if (this.reconstruction.getReconstructionType() != type) {
                    throw new IOException("Mismatch between type of reconstruction requested and returned.");
                }
                this.reconstruction.setSaturated(this.in[9] == 1);
                int dataCount = ByteRoutines.makeWordLE((byte)this.in[10], (byte)this.in[11]);
                float[] intensities = new float[dataCount];
                int position = 64;
                for (int i = 0; i < dataCount; ++i) {
                    intensities[i] = Float.intBitsToFloat(ByteRoutines.makeDWordLE((byte)this.in[position], (byte)this.in[position + 1], (byte)this.in[position + 2], (byte)this.in[position + 3]));
                    position += 4;
                }
                this.reconstruction.setIntensities(intensities);
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            return this.reconstruction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                System.out.println("Resetting. Please wait...");
                this.logger.severe("Resetting. Please wait...");
                this.process((byte)31);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return;
        }
    }

    public byte getReconstructionType() {
        return this.reconstructionType;
    }

    public void setReconstructionType(byte reconstructionType) {
        this.reconstructionType = reconstructionType;
    }

    public Spectrum getSpectrum(Spectrum spectrum) throws IOException {
        this.timeoutOccurredFlag = false;
        try {
            if (this.reconstructionType == 2) {
                this.getDarkExposure();
            } else if (this.reconstructionType == 1) {
                this.getLightExposure();
            } else {
                throw new IllegalArgumentException("Currently can only support a light and dark reconstruction.");
            }
            this.getReconstruction(this.reconstructionType);
            float[] intensities = this.reconstruction.getIntensities();
            if (spectrum == null) {
                spectrum = new Spectrum(new double[intensities.length], null);
            } else if (spectrum.getSpectrum().length != intensities.length) {
                spectrum.setSpectrum(new double[intensities.length]);
            }
            double[] pixels = spectrum.getSpectrum();
            for (int i = 0; i < intensities.length; ++i) {
                pixels[i] = intensities[i];
            }
        }
        catch (IOException exception) {
            this.timeoutOccurredFlag = this.determineWhetherTimeoutOccurred(exception);
            throw exception;
        }
        return spectrum;
    }

    public void getDarkExposure() throws IOException {
        this.getSpectrometerExposure((byte)0, (byte)2);
    }

    public void getLightExposure() throws IOException {
        if (this.darkExposure == null || this.darkExposure.getExposureTime() != this.integrationTime / 1000000) {
            this.getDarkExposure();
        }
        this.getSpectrometerExposure((byte)1, (byte)1);
    }

    public int getCcdWidth() {
        return this.ccdWidth;
    }

    public int getCcdHeight() {
        return this.ccdHeight;
    }

    public boolean isExposureInProgress() {
        return this.exposureInProgress;
    }

    public void setStrobeEnable(boolean laserOn) throws IOException {
    }

    public void readCalibrationFromSpectrometer() throws IOException {
        this.calibration.readCalibrationFromSpectrometer();
    }

    public void writeCalibrationToSpectrometer(MMSRamanCalibration cal) throws IOException {
        this.calibration.writeCalibrationToSpectrometer(cal);
    }

    public MMSRamanCalibration getCalibration() {
        return this.calibration.getCalibration();
    }

    public Laser getLaser(int laserIndex) {
        return this.laserProvider.getLaser(laserIndex);
    }

    public Laser[] getLasers() {
        return this.laserProvider.getLasers();
    }

    public void setLasers(Laser[] lasers) {
        this.laserProvider.setLasers(lasers);
    }

    public int getNumberOfEnabledLasers() {
        return this.laserProvider.getNumberOfEnabledLasers();
    }

    public void setLaserInfo(int laserIndex) throws IOException {
        this.laserProvider.setLaserInfo(laserIndex);
    }

    public void getLaserInfo(int laserIndex) throws IOException {
        this.laserProvider.getLaserInfo(laserIndex);
    }

    public int getNumberOfSupportedLasers() {
        return this.laserProvider.getNumberOfSupportedLasers();
    }

    public void setNumberOfSupportedLasers(int numberOfSupportedLasers) {
        this.laserProvider.setNumberOfSupportedLasers(numberOfSupportedLasers);
    }

    public void setDefaultLaser(int laserIndex) {
        this.laserProvider.setDefaultLaser(laserIndex);
    }

    public int getDefaultLaser() {
        return this.laserProvider.getDefaultLaser();
    }

    public boolean isLaserTemperatureRegulation() {
        return this.laserProvider.isLaserTemperatureRegulation();
    }

    public void setLaserTemperatureRegulation(boolean laserTemperatureRegulation) {
        this.laserProvider.setLaserTemperatureRegulation(laserTemperatureRegulation);
    }

    public void getLaserTemperatureInfo() {
        this.laserProvider.getLaserTemperatureInfo();
    }

    public void setLaserTemperatureInfo() {
        this.laserProvider.setLaserTemperatureInfo();
    }

    public int getMinimumLaserSetpoint() {
        return this.laserProvider.getMinimumLaserSetpoint();
    }

    public void setMinimumLaserSetpoint(int minimumLaserSetpoint) {
        this.laserProvider.setMinimumLaserSetpoint(minimumLaserSetpoint);
    }

    public int getMaximumLaserSetpoint() {
        return this.laserProvider.getMaximumLaserSetpoint();
    }

    public void setMaximumLaserSetpoint(int maximumLaserSetpoint) {
        this.laserProvider.setMaximumLaserSetpoint(maximumLaserSetpoint);
    }

    public void setLaserPowerInfo(int power) {
        this.laserProvider.setLaserPowerInfo(power);
    }

    public int getLaserPowerInfo() {
        return this.laserProvider.getLaserPowerInfo();
    }

    public boolean isLaserPowerRegulation() {
        return this.laserProvider.isLaserPowerRegulation();
    }

    public void setLaserPowerRegulation(boolean laserPowerRegulation) {
        this.laserProvider.setLaserPowerRegulation(laserPowerRegulation);
    }

    public int getMinimumLaserPowerSetpoint() {
        return this.laserProvider.getMinimumLaserPowerSetpoint();
    }

    public void setMinimumLaserPowerSetpoint(int minimumLaserPowerSetpoint) {
        this.laserProvider.setMinimumLaserPowerSetpoint(minimumLaserPowerSetpoint);
    }

    public int getMaximumLaserPowerSetpoint() {
        return this.laserProvider.getMaximumLaserPowerSetpoint();
    }

    public void setMaximumLaserPowerSetpoint(int maximumLaserPowerSetpoint) {
        this.laserProvider.setMaximumLaserPowerSetpoint(maximumLaserPowerSetpoint);
    }

    public void getCCDTemperatureInfo() throws IOException {
        this.ccdTemperature.getCCDTemperatureInfo();
    }

    public void setCCDTemperatureInfo(boolean regulation, float setpoint) throws IOException {
        this.ccdTemperature.setCCDTemperatureInfo(regulation, setpoint);
    }

    public boolean isTemperatureRegulation() {
        return this.ccdTemperature.isTemperatureRegulation();
    }

    public void setTemperatureRegulation(boolean temperatureRegulation) {
        this.ccdTemperature.setTemperatureRegulation(temperatureRegulation);
    }

    public float getCCDSetpoint() {
        return this.ccdTemperature.getCCDSetpoint();
    }

    public void setCCDSetpoint(float setpoint) {
        this.ccdTemperature.setCCDSetpoint(setpoint);
    }

    public int getMinimumCCDSetpoint() {
        return this.ccdTemperature.getMinimumCCDSetpoint();
    }

    public void setMinimumCCDSetpoint(int min) {
        this.ccdTemperature.setMinimumCCDSetpoint(min);
    }

    public int getMaximumCCDSetpoint() {
        return this.ccdTemperature.getMaximumCCDSetpoint();
    }

    public void setMaximumCCDSetpoint(int max) {
        this.ccdTemperature.setMaximumCCDSetpoint(max);
    }

    public float getThermistor() {
        return this.ccdTemperature.getThermistor();
    }

    public boolean isThermFault() {
        return this.ccdTemperature.isThermFault();
    }

    public boolean isTempLock() {
        return this.ccdTemperature.isTempLock();
    }

    public byte getShutterState() {
        return this.ccdShutter.getShutterState();
    }

    public boolean isShutterOpen() {
        return this.ccdShutter.isShutterOpen();
    }

    public void openShutter() throws IOException {
        this.ccdShutter.openShutter();
    }

    public void closeShutter() throws IOException {
        this.ccdShutter.closeShutter();
    }

    public Coefficients[] readWavelengthCalibrationCoefficientsFromSpectrometer() {
        return this.wavelength.readWavelengthCalibrationCoefficientsFromSpectrometer();
    }

    public void writeWavelengthCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.wavelength.writeWavelengthCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getWavelengthCalibrationCoefficients() {
        return this.wavelength.getWavelengthCalibrationCoefficients();
    }

    public void setWavelengthCalibrationCoefficients(Coefficients[] coefficients) {
        this.wavelength.setWavelengthCalibrationCoefficients(coefficients);
    }

    public double[] getWavelengths(int index) {
        return this.wavelength.getWavelengths(index);
    }

    public void setWavelengths(double[] wl, int index) {
        this.wavelength.setWavelengths(wl, index);
    }

    public void updateFX2(File file, long fileSize) throws IOException {
        this.firmware.updateFX2(file, fileSize);
    }

    public void updateDSP(File file, long fileSize) throws IOException {
        this.firmware.updateDSP(file, fileSize);
    }

    public void updateFPGA(File file, long fileSize) throws IOException {
        this.firmware.updateFPGA(file, fileSize);
    }

    public String getFirmwareVersion() throws IOException {
        return this.firmware.getFirmwareVersion();
    }

    public void setDSPFirmwareVersion(String dsp) {
        this.firmware.setDSPFirmwareVersion(dsp);
    }

    public String getDSPFirmwareVersion() {
        return this.firmware.getDSPFirmwareVersion();
    }

    public void setFPGAFirmwareVersion(String fpga) {
        this.firmware.setFPGAFirmwareVersion(fpga);
    }

    public String getFPGAFirmwareVersion() {
        return this.firmware.getFPGAFirmwareVersion();
    }

    public void setUSBFirmwareVersion(String usb) {
        this.firmware.setUSBFirmwareVersion(usb);
    }

    public String getUSBFirmwareVersion() {
        return this.firmware.getUSBFirmwareVersion();
    }

    public MMSRaman getSpectrometer() {
        return this;
    }

    public void setMasterClock(int rate) throws IOException {
        this.masterClockRate.setMasterClock(rate);
    }

    public String[] getLEDFlashCodes() {
        return this.status.getLEDFlashCodes();
    }

    public String toString() {
        String s = "\nSpectrometer Information\n\tCCD Pixel Width: " + this.ccdWidth + "\n\tCCD Pixel Height: " + this.ccdHeight + "\n\tCCD Bits per Pixel: " + this.ccdBitsPerPixel + "\n\tCCD Type: " + this.ccdType + "\n\tShutter support: " + this.shutterSupport + "\n\tMinimum exposure time: " + this.integrationTimeMinimum + "\n\tMaximum exposure time: " + this.integrationTimeMaximum + "\n\tCalibration support: " + this.calibrationSupport + "\n\tSpectra Reconstruction support: " + this.spectraReconstruction + "\n\tCCD Temperature Regulation: " + this.temperatureRegulation + "\n\tMinimum CCD Setpoint: " + this.getMinimumCCDSetpoint() + "\n\tMaximum CCD Setpoint: " + this.getMaximumCCDSetpoint() + "\n\tNumber of supported lasers: " + this.getNumberOfSupportedLasers() + "\n\tLaser Temperature Regulation supported: " + this.isLaserTemperatureRegulation() + "\n\tMinimum Laser Setpoint: " + this.getMinimumLaserSetpoint() + "\n\tMaximum Laser Setpoint: " + this.getMaximumLaserSetpoint() + "\n\tLaser Power Regulation supported: " + this.isLaserPowerRegulation() + "\n\tMinimum Laser Power Setpoint: " + this.getMinimumLaserPowerSetpoint() + "\n\tMaximum Laser Power Setpoint: " + this.getMaximumLaserPowerSetpoint() + "\n\tDSP Firmware: " + this.firmware.getDSPFirmwareVersion() + "\n\tFPGA Firmware: " + this.firmware.getFPGAFirmwareVersion() + "\n\tUSB Firmware: " + this.firmware.getUSBFirmwareVersion() + "\n\tNumber of General I/O Lines: " + this.numberGeneralIOLines + "\n\tNumber of Accessory I/O Lines: " + this.numberAccessoryIOLines + "\n\tA/D Clock Frequency: " + this.adClockFrequency + "\n\tPixel Binning Mode: " + this.pixelBinningMode + ": " + this.strPixelBinningMode;
        return s;
    }

    public Configuration getConfiguration() throws IOException {
        return new Configuration(this);
    }

    public synchronized void addExposureListener(ExposureListener listener) {
        if (this.exposureListenerList == null) {
            this.exposureListenerList = new ArrayList();
        }
        this.exposureListenerList.add(listener);
    }

    public synchronized void removeExposureListener(ExposureListener listener) {
        if (this.exposureListenerList != null) {
            this.exposureListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireExposureListenerNewSpectrometerExposure(SpectrometerExposure event) {
        ArrayList list;
        MMSRaman mMSRaman = this;
        synchronized (mMSRaman) {
            if (this.exposureListenerList == null) {
                return;
            }
            list = (ArrayList)this.exposureListenerList.clone();
        }
        for (int i = 0; i < list.size(); ++i) {
            ((ExposureListener)list.get(i)).newSpectrometerExposure(event);
        }
    }

    public SpectrometerExposure getLastExposure() {
        return this.lastExposure;
    }

    public boolean has1DMode() {
        return false;
    }

    public void set2DMode(int channel) {
    }

    public void set1DMode(int channel) {
    }

    public boolean is2DMode() {
        return true;
    }

    public boolean is1DMode() {
        return false;
    }

    public int get2DintegrationTime() {
        return this.integrationTime;
    }

    public void addIntegrationTimeChangeListener(IntegrationTimeChangeListener listener) {
        this.integrationTimeChangeListeners.add(listener);
    }

    public void removeIntegrationTimeChangeListener(IntegrationTimeChangeListener listener) {
        this.integrationTimeChangeListeners.remove(listener);
    }

    public void fireIntegrationTimeChanged(int time) {
        IntegrationTimeChangeListener[] l = this.integrationTimeChangeListeners.toArray(new IntegrationTimeChangeListener[this.integrationTimeChangeListeners.size()]);
        for (int i = 0; i < l.length; ++i) {
            l[i].integrationTimeChanged(time);
        }
    }
}

