/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.mmsraman.ramanspectrometer;

import com.oceanoptics.omnidriver.spectra.SpectrometerChannelInfo;
import com.oceanoptics.omnidriver.spectra.SpectrometerInfo;
import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerChannel;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.ramanspectrometer.MMSRaman;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.ramanspectrometer.MMSRamanCalibration;
import com.oceanoptics.spam.numericalmethods.LinearRegression;
import com.oceanoptics.spam.numericalmethods.NonInvertibleMatrixException;
import java.io.IOException;

public class MMSRamanChannel
extends SpectrometerChannel {
    protected MMSRaman spectrometer;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/spectrometer/mmsraman/ramanspectrometer/MMSRaman;Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;I)V\ngenerateMetadata,(Lcom/oceanoptics/omnidriver/spectra/SpectrometerInfo;I)V\ngetCoefficientsFromSpectrometer,()V\n";

    public MMSRamanChannel(MMSRaman spectrometer, Coefficients coefficients, int channel) throws IOException {
        super(spectrometer, coefficients, channel);
        this.spectrometer = spectrometer;
        this.numberOfPixels = spectrometer.getNumberOfCCDPixels();
        this.numberOfDarkPixels = spectrometer.getNumberOfDarkCCDPixels();
    }

    public void generateMetadata(SpectrometerInfo sb, int index) {
        double[] wl = this.getAllWavelengths();
        this.spectrometerChannelInfo = new SpectrometerChannelInfo(sb, wl, index, false, this.getCoefficients(), this.getLaserWavelength(), this.isInterlock(), this.numberOfPixels, this.numberOfDarkPixels);
    }

    public void getCoefficientsFromSpectrometer() throws IOException {
        Coefficients newCoefficients = null;
        try {
            newCoefficients = this.calculateWavelengths(this.spectrometer.getCalibration());
        }
        catch (NonInvertibleMatrixException ex) {
            ex.printStackTrace();
        }
        this.coefficients.setWlCoefficients(newCoefficients.getWlCoefficients());
    }

    protected Coefficients calculateWavelengths(MMSRamanCalibration calibration) throws NonInvertibleMatrixException {
        int i;
        float[] fPixels = calibration.getObservedPixels();
        float[] fWavelengths = calibration.getActualWavelengths();
        double[] dPixels = new double[fPixels.length];
        double[] dWavelengths = new double[fWavelengths.length];
        for (i = 0; i < fPixels.length; ++i) {
            dPixels[i] = fPixels[i];
        }
        for (i = 0; i < fWavelengths.length; ++i) {
            dWavelengths[i] = fWavelengths[i];
        }
        double[] coefficientArray = LinearRegression.computeLinearRegression((double[])dPixels, (double[])dWavelengths, (int)3);
        Coefficients coefficients = new Coefficients();
        coefficients.setWlIntercept(coefficientArray[0]);
        coefficients.setWlFirst(coefficientArray[1]);
        coefficients.setWlSecond(coefficientArray[2]);
        coefficients.setWlThird(coefficientArray[3]);
        return coefficients;
    }
}

