/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.mmsraman.ramanspectrometer;

import com.oceanoptics.omnidriver.spectrometer.USBSpectrometer;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.ramanspectrometer.Laser;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;
import java.util.ResourceBundle;

public abstract class MMSRamanSpectrometer
extends USBSpectrometer {
    private byte[] packetBuffer = new byte[64];
    protected byte[] out;
    protected byte[] in;
    private static final short DATA_OUT = 4;
    private static final short HIGH_SPEED_DATA_IN = 134;
    private static final short DATA_IN = 136;
    protected USBEndpointDescriptor dataOutEndPoint = null;
    protected USBEndpointDescriptor highSpeedInEndPoint = null;
    protected USBEndpointDescriptor lowSpeedInEndPoint = null;
    private static final short MAX_PACKET_SIZE = 64;
    private static String __extern__;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MMSRamanSpectrometer() throws IOException {
        this.setEndpoints();
        this.in = this.usb.getInputBuffer();
        this.out = this.usb.getOutputBuffer();
    }

    public void setEndpoints() {
        this.dataOutEndPoint = new USBEndpointDescriptor(7, 5, 4, 2, 64, 0);
        this.highSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 134, 2, 64, 0);
        this.lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 136, 2, 64, 0);
    }

    public USBEndpointDescriptor getEndpoint(int endPoint) throws IllegalArgumentException {
        switch (endPoint) {
            case 1: {
                return this.dataOutEndPoint;
            }
            case 2: {
                return this.highSpeedInEndPoint;
            }
            case 3: {
                return this.lowSpeedInEndPoint;
            }
        }
        throw new IllegalArgumentException("End Point number invalid.");
    }

    public abstract Laser getLaser(int var1);

    public byte[] process(byte opCode) throws IOException {
        return this.process(opCode, 6, (byte)1, (byte)1, this.lowSpeedInEndPoint, this.dataOutEndPoint);
    }

    public byte[] process(byte opCode, byte schemaOut, byte schemaIn) throws IOException {
        return this.process(opCode, 6, schemaOut, schemaIn, this.lowSpeedInEndPoint, this.dataOutEndPoint);
    }

    public byte[] process(byte opCode, int size) throws IOException {
        return this.process(opCode, size, (byte)1, (byte)1, this.lowSpeedInEndPoint, this.dataOutEndPoint);
    }

    public byte[] process(byte opCode, int size, byte schemaOut, byte schemaIn) throws IOException {
        return this.process(opCode, size, schemaOut, schemaIn, this.lowSpeedInEndPoint, this.dataOutEndPoint);
    }

    public byte[] process(byte opCode, int size, byte[] data, byte schemaOut, byte schemaIn) throws IOException {
        if (this.out.length < size) {
            this.logger.fine("Out buffer too small; reallocating.");
            byte[] temp = this.out;
            this.usb.increaseOutputBufferSize(size);
            this.out = this.usb.getOutputBuffer();
            System.arraycopy(temp, 0, this.out, 0, 64);
        }
        System.arraycopy(data, 0, this.out, 64, data.length);
        return this.process(opCode, size, schemaOut, schemaIn, this.lowSpeedInEndPoint, this.dataOutEndPoint);
    }

    public byte[] process(byte opCode, int size, byte schemaOut, byte schemaIn, USBEndpointDescriptor inEndPoint, USBEndpointDescriptor outEndPoint) throws IOException {
        int bytesToTransfer;
        int bytesToGo;
        if (!$assertionsDisabled && this.out.length < size) {
            throw new AssertionError();
        }
        this.out[0] = opCode;
        this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)size));
        this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)size));
        this.out[3] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)size));
        this.out[4] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)size));
        this.out[5] = schemaOut;
        if (size > 64) {
            bytesToGo = size;
            int numPackets = 0;
            int position = 0;
            byte[] temp = new byte[64];
            while (bytesToGo > 0) {
                if (64 < bytesToGo) {
                    bytesToTransfer = 64;
                    position = 64 * numPackets;
                } else {
                    bytesToTransfer = bytesToGo;
                    position = 64 * numPackets;
                    for (int i = bytesToTransfer; i < 64; ++i) {
                        temp[i] = 0;
                    }
                }
                System.arraycopy(this.out, position, temp, 0, bytesToTransfer);
                this.usb.bulkOut(outEndPoint, temp, bytesToTransfer);
                bytesToGo -= bytesToTransfer;
                ++numPackets;
            }
        } else {
            this.usb.bulkOut(outEndPoint, this.out, 64);
        }
        this.usb.bulkIn(inEndPoint, this.in, 64);
        byte responseOpCode = this.in[0];
        int responseSize = ByteRoutines.makeDWordLE((byte)this.in[1], (byte)this.in[2], (byte)this.in[3], (byte)this.in[4]);
        if (responseSize <= 0) {
            if (!$assertionsDisabled && this.in[6] == 1) {
                throw new AssertionError();
            }
            responseSize = 64;
        }
        byte responseSchema = this.in[5];
        if (this.in.length < responseSize) {
            this.logger.fine("In buffer too small; reallocating.");
            byte[] temp = this.in;
            this.usb.increaseInputBufferSize(responseSize);
            this.in = this.usb.getInputBuffer();
            System.arraycopy(temp, 0, this.in, 0, 64);
        }
        bytesToGo = responseSize - 64;
        int pos = 64;
        while (bytesToGo > 0) {
            bytesToTransfer = Math.min(64, bytesToGo);
            this.usb.bulkIn(inEndPoint, this.packetBuffer, 64);
            System.arraycopy(this.packetBuffer, 0, this.in, pos, bytesToTransfer);
            bytesToGo -= bytesToTransfer;
            pos += 64;
        }
        if (this.in[6] != 1) {
            Error error = this.getLastError();
            throw new IOException("Read returned failure/error\n  last error: " + error.toString());
        }
        if (responseOpCode != opCode) {
            throw new IOException("Command and response opcodes did not match");
        }
        if (responseSchema != schemaIn) {
            throw new IOException("Invalid response schema.");
        }
        return this.in;
    }

    public String trimTrailingNulls(String toTrim) {
        int firstNull = toTrim.indexOf(0);
        if (firstNull < 0) {
            return toTrim;
        }
        return toTrim.substring(0, firstNull);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Error getLastError() throws IOException {
        int commandSize = 6;
        int responseSize = 64;
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.process((byte)17);
                short code = ByteRoutines.makeWordLE((byte)this.in[7], (byte)this.in[8]);
                short type = ByteRoutines.makeWordLE((byte)this.in[9], (byte)this.in[10]);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return new Error(type, code);
            }
        }
    }

    static {
        $assertionsDisabled = !MMSRamanSpectrometer.class.desiredAssertionStatus();
        __extern__ = "__extern__\n<init>,()V\nsetEndpoints,()V\ngetEndpoint,(I)Lcom/oceanoptics/uniusb/USBEndpointDescriptor;\ngetLaser,(I)Lcom/oceanoptics/omnidriver/spectrometer/mmsraman/ramanspectrometer/Laser;\nprocess,(B)[B\nprocess,(BBB)[B\nprocess,(BI)[B\nprocess,(BIBB)[B\nprocess,(BI[BBB)[B\nprocess,(BIBBLcom/oceanoptics/uniusb/USBEndpointDescriptor;Lcom/oceanoptics/uniusb/USBEndpointDescriptor;)[B\ntrimTrailingNulls,(Ljava/lang/String;)Ljava/lang/String;\ngetLastError,()Lcom/oceanoptics/omnidriver/spectrometer/mmsraman/ramanspectrometer/MMSRamanSpectrometer$Error;\n";
    }

    public class Error {
        short type;
        short code;

        public Error(short type, short code) {
            this.type = type;
            this.code = code;
        }

        public String toString() {
            String errorCode = null;
            String errorType = null;
            switch (this.code) {
                case 0: {
                    errorCode = ResourceBundle.getBundle("com.oceanoptics.omnidriver.spectrometer.mmsraman.constants.Bundle").getString("ERROR_CODE_none");
                    break;
                }
                case 1: {
                    errorCode = ResourceBundle.getBundle("com.oceanoptics.omnidriver.spectrometer.mmsraman.constants.Bundle").getString("ERROR_CODE_memory");
                    break;
                }
                case 2: {
                    errorCode = ResourceBundle.getBundle("com.oceanoptics.omnidriver.spectrometer.mmsraman.constants.Bundle").getString("ERROR_CODE_io");
                    break;
                }
                case 3: {
                    errorCode = ResourceBundle.getBundle("com.oceanoptics.omnidriver.spectrometer.mmsraman.constants.Bundle").getString("ERROR_CODE_interrupt");
                    break;
                }
                case 4: {
                    errorCode = ResourceBundle.getBundle("com.oceanoptics.omnidriver.spectrometer.mmsraman.constants.Bundle").getString("ERROR_CODE_timer");
                    break;
                }
                case 5: {
                    errorCode = ResourceBundle.getBundle("com.oceanoptics.omnidriver.spectrometer.mmsraman.constants.Bundle").getString("ERROR_CODE_i2c");
                    break;
                }
                case 6: {
                    errorCode = ResourceBundle.getBundle("com.oceanoptics.omnidriver.spectrometer.mmsraman.constants.Bundle").getString("ERROR_CODE_adc");
                    break;
                }
                case 7: {
                    errorCode = ResourceBundle.getBundle("com.oceanoptics.omnidriver.spectrometer.mmsraman.constants.Bundle").getString("ERROR_CODE_afe");
                    break;
                }
                case 8: {
                    errorCode = ResourceBundle.getBundle("com.oceanoptics.omnidriver.spectrometer.mmsraman.constants.Bundle").getString("ERROR_CODE_eeprom_dsp");
                    break;
                }
                case 9: {
                    errorCode = ResourceBundle.getBundle("com.oceanoptics.omnidriver.spectrometer.mmsraman.constants.Bundle").getString("ERROR_CODE_eeprom_usb");
                    break;
                }
                case 10: {
                    errorCode = ResourceBundle.getBundle("com.oceanoptics.omnidriver.spectrometer.mmsraman.constants.Bundle").getString("ERROR_CODE_usb_controller");
                    break;
                }
                case 11: {
                    errorCode = ResourceBundle.getBundle("com.oceanoptics.omnidriver.spectrometer.mmsraman.constants.Bundle").getString("ERROR_CODE_voltage");
                    break;
                }
                case 12: {
                    errorCode = ResourceBundle.getBundle("com.oceanoptics.omnidriver.spectrometer.mmsraman.constants.Bundle").getString("ERROR_CODE_usb_command");
                    break;
                }
                case 13: {
                    errorCode = ResourceBundle.getBundle("com.oceanoptics.omnidriver.spectrometer.mmsraman.constants.Bundle").getString("ERROR_CODE_non_specific");
                    break;
                }
                case 14: {
                    errorCode = ResourceBundle.getBundle("com.oceanoptics.omnidriver.spectrometer.mmsraman.constants.Bundle").getString("ERROR_CODE_calibration");
                    break;
                }
                case 15: {
                    errorCode = ResourceBundle.getBundle("com.oceanoptics.omnidriver.spectrometer.mmsraman.constants.Bundle").getString("ERROR_CODE_fpga");
                    break;
                }
                default: {
                    errorCode = ResourceBundle.getBundle("com.oceanoptics.omnidriver.spectrometer.mmsraman.constants.Bundle").getString("ERROR_CODE_non_specific");
                }
            }
            switch (this.type) {
                case 0: {
                    errorType = ResourceBundle.getBundle("com.oceanoptics.omnidriver.spectrometer.mmsraman.constants.Bundle").getString("ERROR_TYPE_none");
                    break;
                }
                case 1: {
                    errorType = ResourceBundle.getBundle("com.oceanoptics.omnidriver.spectrometer.mmsraman.constants.Bundle").getString("ERROR_TYPE_read_write_failure");
                    break;
                }
                case 2: {
                    errorType = ResourceBundle.getBundle("com.oceanoptics.omnidriver.spectrometer.mmsraman.constants.Bundle").getString("ERROR_TYPE_invalid_address");
                    break;
                }
                case 4: {
                    errorType = ResourceBundle.getBundle("com.oceanoptics.omnidriver.spectrometer.mmsraman.constants.Bundle").getString("ERROR_TYPE_invalid_parameter");
                    break;
                }
                case 8: {
                    errorType = ResourceBundle.getBundle("com.oceanoptics.omnidriver.spectrometer.mmsraman.constants.Bundle").getString("ERROR_TYPE_invalid_state");
                    break;
                }
                case 16: {
                    errorType = ResourceBundle.getBundle("com.oceanoptics.omnidriver.spectrometer.mmsraman.constants.Bundle").getString("ERROR_TYPE_allocation");
                    break;
                }
                case 32: {
                    errorType = ResourceBundle.getBundle("com.oceanoptics.omnidriver.spectrometer.mmsraman.constants.Bundle").getString("ERROR_TYPE_limit");
                    break;
                }
                case 64: {
                    errorType = ResourceBundle.getBundle("com.oceanoptics.omnidriver.spectrometer.mmsraman.constants.Bundle").getString("ERROR_TYPE_test_failure");
                    break;
                }
                case 128: {
                    errorType = ResourceBundle.getBundle("com.oceanoptics.omnidriver.spectrometer.mmsraman.constants.Bundle").getString("ERROR_TYPE_non_specific");
                    break;
                }
                default: {
                    errorType = ResourceBundle.getBundle("com.oceanoptics.omnidriver.spectrometer.mmsraman.constants.Bundle").getString("ERROR_TYPE_non_specific");
                }
            }
            return "Error (type " + this.type + ": " + errorType + ", code " + this.code + ": " + errorCode;
        }
    }
}

