/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.mmsraman.test;

import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.ramanspectrometer.Laser;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.ramanspectrometer.MMSRaman;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MMSRamanTest {
    MMSRaman spectrometer;
    Spectrometer[] spectrometers;
    private static String __extern__ = "__extern__\n<init>,()V\nmain,([Ljava/lang/String;)V\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MMSRamanTest() {
        Logger logger = Logger.getLogger("com.oceanoptics");
        logger.setLevel(Level.FINEST);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.FINEST);
        logger.addHandler(consoleHandler);
        try {
            this.spectrometer = new MMSRaman();
            System.out.println(this.spectrometer);
            System.out.println(this.spectrometer.getCalibration().toString());
            this.spectrometer.setIntegrationTime(1000000);
            Laser laser = this.spectrometer.getLaser(this.spectrometer.getDefaultLaser());
            System.out.println(laser);
            if (laser.isSafetyKeyOn()) {
                laser.setRemoteEnabled(true);
                this.spectrometer.setLaserInfo(laser.getLaserIndex());
            } else {
                System.out.println("A light reconstruction cannot be taken as the safety key is off.");
            }
            Spectrum spectrum = this.spectrometer.getSpectrum(null);
            double[] pixels = spectrum.getSpectrum();
            System.out.println("Pixel values:");
            for (int i = 0; i < pixels.length; ++i) {
                System.out.println(pixels[i]);
            }
            double[] w = this.spectrometer.getChannels()[0].getAllWavelengths();
            System.out.println("\nWavelengths:");
            for (int j = 0; j < w.length; ++j) {
                System.out.println("\t" + j + ": " + w[j]);
            }
            this.spectrometer.reset();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("An exception occured.");
        }
        finally {
            try {
                this.spectrometer.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void main(String[] args) throws IOException {
        MMSRamanTest t = new MMSRamanTest();
        System.out.println("\nEnd.");
    }
}

