/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.nir;

import com.oceanoptics.omnidriver.constants.ExternalTriggerMode;
import com.oceanoptics.omnidriver.features.advancedversion.AdvancedVersion;
import com.oceanoptics.omnidriver.features.badpixelremoval.BadPixelRemoval;
import com.oceanoptics.omnidriver.features.badpixelremoval.BadPixelRemovalGUIProvider;
import com.oceanoptics.omnidriver.features.badpixelremoval.BadPixelRemovalImpl;
import com.oceanoptics.omnidriver.features.badpixelremoval.BadPixelRemovalImpl_NIR;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTrigger;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTriggerImpl;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTriggerImplNonFPGA;
import com.oceanoptics.omnidriver.features.highgainmode.HighGainMode;
import com.oceanoptics.omnidriver.features.highgainmode.HighGainModeGUIProvider;
import com.oceanoptics.omnidriver.features.highgainmode.HighGainModeImpl;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionImpl;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionProvider;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrection;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionImpl;
import com.oceanoptics.omnidriver.features.thermoelectric.ThermoElectric;
import com.oceanoptics.omnidriver.features.thermoelectric.ThermoElectricGUIProvider;
import com.oceanoptics.omnidriver.features.thermoelectric.ThermoElectricImpl;
import com.oceanoptics.omnidriver.features.thermoelectric.ThermoElectricImpl_NIR;
import com.oceanoptics.omnidriver.features.version.Version;
import com.oceanoptics.omnidriver.features.version.VersionGUIProvider;
import com.oceanoptics.omnidriver.features.version.VersionImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationGUIProvider;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationProvider;
import com.oceanoptics.omnidriver.interfaces.AcquisitionListener;
import com.oceanoptics.omnidriver.interfaces.GUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBEndpointDevice;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerStatus;
import com.oceanoptics.omnidriver.spectrometer.USBSpectrometer;
import com.oceanoptics.omnidriver.spectrometer.nir.NIRStatus;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.File;
import java.io.IOException;

public abstract class NIR
extends USBSpectrometer
implements HardwareTrigger,
ThermoElectric,
NonlinearityCorrectionProvider,
WavelengthCalibrationProvider,
StrayLightCorrection,
BadPixelRemoval,
Version,
HighGainMode,
USBEndpointDevice {
    protected HardwareTriggerImpl hardwareTrigger = null;
    protected ThermoElectricGUIProvider tec = null;
    protected NonlinearityCorrectionGUIProvider nonlinearity = null;
    protected WavelengthCalibrationGUIProvider wavelength = null;
    protected StrayLightCorrectionGUIProvider straylight = null;
    protected BadPixelRemovalGUIProvider badPixelRemoval = null;
    protected HighGainModeGUIProvider highGainMode = null;
    protected VersionGUIProvider version = null;
    private static final short DATA_OUT = 2;
    private static final short HIGH_SPEED_DATA_IN = 130;
    private static final short UNUSED_DATA_OUT = 7;
    private static final short LOW_SPEED_DATA_IN = 135;
    private static final short MAX_PACKET_SIZE = 64;
    private static String __extern__ = "__extern__\ngetSaturationIntensity,()I\nsetSaturationIntensity,(ILjava/lang/String;)Z\nsetEndpoints,()V\ngetEndpoint,(I)Lcom/oceanoptics/uniusb/USBEndpointDescriptor;\n<init>,()V\ngetGUIFeatures,()[Lcom/oceanoptics/omnidriver/interfaces/GUIProvider;\nreadStatus,()Lcom/oceanoptics/omnidriver/spectrometer/SpectrometerStatus;\nreadIntegrationTime,()I\nsetIntegrationTime,(I)V\ntoString,()Ljava/lang/String;\nsetHighGain,(Z)V\nsetHighGainDefault,(Z)V\ngetHighGainDefault,()Z\nhasHighGainDefault,()Z\nsetExternalTriggerMode,(I)V\ngetExternalTriggerModes,()[Lcom/oceanoptics/omnidriver/constants/ExternalTriggerMode;\ngetExternalTriggerMode,()Ljava/lang/Integer;\ngetTECEnable,()Ljava/lang/Boolean;\nsetTECEnable,(Z)V\ngetFanEnable,()Ljava/lang/Boolean;\nsetFanEnable,(Z)V\ngetDetectorTemperatureCelsius,()D\ngetDetectorTemperatureSetPointCelsius,()D\ngetDetectorSetPointCelsius,()Ljava/lang/Double;\nsetDetectorSetPointCelsius,(D)V\ngetSetPointMinimumCelsius,()D\ngetSetPointMaximumCelsius,()D\ngetSetPointIncrementCelsius,()D\nisSaveTECStateEnabled,()Z\nsaveTECState,()V\nreadNonlinearityCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteNonlinearityCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetNonlinearityCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficientsSingleChannel,(I)[D\nsetNonlinearityCoefficientsSingleChannel,([DI)V\nreadWavelengthCalibrationCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteWavelengthCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengthCalibrationCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetWavelengthCalibrationCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengths,(I)[D\nsetWavelengths,([DI)V\nreadStrayLightCorrectionCoefficientFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteStrayLightCoefficientToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\nsetStrayLightCorrectionCoefficient,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetStrayLightCorrectionCoefficient,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetStrayLight,(DI)V\ngetStrayLight,(I)D\ngetBadPixels,()[I\nsetBadPixels,([I)V\nremoveBadPixels,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)Lcom/oceanoptics/omnidriver/spectra/Spectrum;\ngetNumberOfBadPixels,()I\ngetAllPixels,()[I\nsetBadPixelsToSpectrometer,()V\ngetBadPixelsFromSpectrometer,()[I\nisAdvancedVersion,()Z\nuploadFirmware,(Ljava/io/File;J)V\nuploadFPGA,(Ljava/io/File;J)V\naddAcquisitionListener,(Lcom/oceanoptics/omnidriver/interfaces/AcquisitionListener;)V\nremoveAcquisitionListener,(Lcom/oceanoptics/omnidriver/interfaces/AcquisitionListener;)V\n";

    public int getSaturationIntensity() {
        return -1;
    }

    public boolean setSaturationIntensity(int saturationIntensity, String key) {
        return false;
    }

    public void setEndpoints() {
        this.dataOutEndPoint = new USBEndpointDescriptor(7, 5, 2, 2, 64, 0);
        this.highSpeedInEndPoint1 = new USBEndpointDescriptor(7, 5, 130, 2, 64, 0);
        this.highSpeedInEndPoint2 = new USBEndpointDescriptor(7, 5, 7, 2, 64, 0);
        this.lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 135, 2, 64, 0);
    }

    public USBEndpointDescriptor getEndpoint(int endPoint) throws IllegalArgumentException {
        switch (endPoint) {
            case 0: {
                return this.dataOutEndPoint;
            }
            case 1: {
                return this.highSpeedInEndPoint1;
            }
            case 2: {
                return this.highSpeedInEndPoint2;
            }
            case 3: {
                return this.lowSpeedInEndPoint;
            }
        }
        throw new IllegalArgumentException("End Point number invalid.");
    }

    protected void initFeatures(USBInterface usb) throws IOException {
        this.hardwareTrigger = new HardwareTriggerImplNonFPGA(usb, new ExternalTriggerMode[]{new ExternalTriggerMode(0), new ExternalTriggerMode(1), new ExternalTriggerMode(3)});
        this.tec = new ThermoElectricImpl_NIR(usb);
        this.nonlinearity = new NonlinearityCorrectionImpl(usb, this);
        this.wavelength = new WavelengthCalibrationImpl(usb, this);
        this.straylight = new StrayLightCorrectionImpl(usb, this);
        this.badPixelRemoval = new BadPixelRemovalImpl_NIR(usb, this.numberOfCCDPixels);
        this.highGainMode = new HighGainModeImpl(usb, this);
        this.version = new VersionImpl(usb, this);
        this.featureMap.put(HardwareTriggerImpl.class, this.hardwareTrigger);
        this.featureMap.put(ThermoElectricImpl.class, (ThermoElectricImpl)this.tec);
        this.featureMap.put(NonlinearityCorrectionImpl.class, (NonlinearityCorrectionImpl)this.nonlinearity);
        this.featureMap.put(WavelengthCalibrationImpl.class, (WavelengthCalibrationImpl)this.wavelength);
        this.featureMap.put(StrayLightCorrectionImpl.class, (StrayLightCorrectionImpl)this.straylight);
        this.featureMap.put(BadPixelRemovalImpl.class, (BadPixelRemovalImpl)this.badPixelRemoval);
        this.featureMap.put(HighGainModeImpl.class, (HighGainModeImpl)this.highGainMode);
        this.featureMap.put(VersionImpl.class, (VersionImpl)this.version);
    }

    public GUIProvider[] getGUIFeatures() {
        return new GUIProvider[]{this.wavelength, this.straylight, this.nonlinearity, this.tec, this.badPixelRemoval, this.highGainMode, this.version};
    }

    protected Spectrum formatData(byte[] data, Spectrum doubleSpectrum) throws IOException {
        int packetCount = 0;
        byte zero = 0;
        int packetSize = 64;
        double[] spectrum = doubleSpectrum.getSpectrum();
        this.logger.finest("Formatting data");
        if (this.rawData[this.numberOfCCDPixels * 2] != 105) {
            this.logger.severe("Lost synchroniztion");
            throw new IOException("Lost synchronization");
        }
        switch (this.channels[0].getNumberOfPixels()) {
            case 256: {
                packetCount = 4;
                break;
            }
            case 512: {
                packetCount = 8;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected number of NIR pixels: " + this.channels[0].getNumberOfPixels());
            }
        }
        int count = 0;
        int i = 0;
        int offset = 0;
        while (count < packetCount) {
            int element = 0;
            while (element < packetSize) {
                byte MSB = data[element + packetSize + offset];
                byte LSB = data[element + offset];
                int pixel = ByteRoutines.makeDWord((byte)zero, (byte)zero, (byte)MSB, (byte)LSB) ^ 0x8000;
                if (pixel > this.maxIntensity) {
                    doubleSpectrum.setSaturated(true);
                }
                spectrum[i] = pixel;
                ++element;
                ++i;
            }
            ++count;
            offset += 2 * packetSize;
        }
        spectrum[0] = 0.0;
        this.badPixelRemoval.removeBadPixels(doubleSpectrum);
        return doubleSpectrum;
    }

    public SpectrometerStatus readStatus() throws IOException {
        byte[] sb = super.getStatusArray();
        NIRStatus stat = new NIRStatus();
        this.logger.finest("NIR Status.");
        stat.numPixels = ByteRoutines.makeWord((byte)sb[0], (byte)sb[1]);
        stat.integrationTime = ByteRoutines.makeDWord((byte)0, (byte)0, (byte)sb[2], (byte)sb[3]);
        stat.lampEnabled = sb[4] != 0;
        stat.externalTriggerMode = sb[5];
        stat.takingScan = sb[6] != 0;
        stat.dataReady = sb[8] != 0;
        stat.external5VActive = sb[10] != 0;
        stat.packetCount = sb[11];
        stat.highGainModeActive = sb[12] != 0;
        stat.tecActive = (sb[13] & 1) != 0;
        stat.fanActive = (sb[13] & 2) != 0;
        return stat;
    }

    public int readIntegrationTime() throws IOException {
        NIRStatus stat = (NIRStatus)this.readStatus();
        return stat.integrationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIntegrationTime(int intTime) throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            boolean needStabilityScan;
            boolean bl = needStabilityScan = this.integrationTime != intTime;
            if (!needStabilityScan) {
                this.logger.fine("Desired integration time already set, not pushing to spectrometer");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int maxTime = this.getIntegrationTimeMaximum();
            int minTime = this.getIntegrationTimeMinimum();
            if (intTime < minTime) {
                intTime = minTime;
            }
            if (intTime > maxTime) {
                intTime = maxTime;
            }
            this.integrationTime = intTime;
            this.out[0] = 2;
            this.out[1] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)(intTime /= this.getIntegrationTimeBase())));
            this.out[2] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)intTime));
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 3);
            if (needStabilityScan && this.isStabilityScan()) {
                this.doStabilityScan(1);
            }
            this.logger.fine("Integration time set to: " + intTime);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setGain(int data) throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.out[0] = 12;
            this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)data));
            this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)data));
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 3);
            this.logger.fine("InGaAs detector gain mode set to (0:Low, 1:High): " + data);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public String toString() {
        try {
            return super.toString() + "\n" + this.readStatus();
        }
        catch (IOException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public void setHighGain(boolean gain) throws IOException {
        this.highGainMode.setHighGain(gain);
    }

    public void setHighGainDefault(boolean gain) throws IOException {
        this.highGainMode.setHighGainDefault(gain);
    }

    public boolean getHighGainDefault() throws IOException {
        return this.highGainMode.getHighGainDefault();
    }

    public boolean hasHighGainDefault() {
        return this.highGainMode.hasHighGainDefault();
    }

    public void setExternalTriggerMode(int mode) throws IOException {
        this.hardwareTrigger.setExternalTriggerMode(mode);
    }

    public ExternalTriggerMode[] getExternalTriggerModes() {
        return this.hardwareTrigger.getExternalTriggerModes();
    }

    public Integer getExternalTriggerMode() {
        return this.hardwareTrigger.getExternalTriggerMode();
    }

    public Boolean getTECEnable() {
        return this.tec.getTECEnable();
    }

    public void setTECEnable(boolean enable) throws IOException {
        this.tec.setTECEnable(enable);
    }

    public Boolean getFanEnable() {
        return this.tec.getFanEnable();
    }

    public void setFanEnable(boolean enable) throws IOException {
        this.tec.setFanEnable(enable);
    }

    public double getDetectorTemperatureCelsius() throws IOException {
        return this.tec.getDetectorTemperatureCelsius();
    }

    public double getDetectorTemperatureSetPointCelsius() throws IOException {
        return this.tec.getDetectorTemperatureSetPointCelsius();
    }

    public Double getDetectorSetPointCelsius() {
        return this.tec.getDetectorSetPointCelsius();
    }

    public void setDetectorSetPointCelsius(double point) throws IOException {
        this.tec.setDetectorSetPointCelsius(point);
    }

    public double getSetPointMinimumCelsius() {
        return this.tec.getSetPointMinimumCelsius();
    }

    public double getSetPointMaximumCelsius() {
        return this.tec.getSetPointMaximumCelsius();
    }

    public double getSetPointIncrementCelsius() {
        return this.tec.getSetPointIncrementCelsius();
    }

    public boolean isSaveTECStateEnabled() {
        return this.tec.isSaveTECStateEnabled();
    }

    public void saveTECState() throws IOException {
        this.tec.saveTECState();
    }

    public Coefficients[] readNonlinearityCoefficientsFromSpectrometer() {
        return this.nonlinearity.readNonlinearityCoefficientsFromSpectrometer();
    }

    public void writeNonlinearityCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.nonlinearity.writeNonlinearityCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getNonlinearityCoefficients() {
        return this.nonlinearity.getNonlinearityCoefficients();
    }

    public void setNonlinearityCoefficients(Coefficients[] coefficients) {
        this.nonlinearity.setNonlinearityCoefficients(coefficients);
    }

    public double[] getNonlinearityCoefficientsSingleChannel(int index) {
        return this.nonlinearity.getNonlinearityCoefficientsSingleChannel(index);
    }

    public void setNonlinearityCoefficientsSingleChannel(double[] nl, int index) {
        this.nonlinearity.setNonlinearityCoefficientsSingleChannel(nl, index);
    }

    public Coefficients[] readWavelengthCalibrationCoefficientsFromSpectrometer() {
        return this.wavelength.readWavelengthCalibrationCoefficientsFromSpectrometer();
    }

    public void writeWavelengthCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.wavelength.writeWavelengthCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getWavelengthCalibrationCoefficients() {
        return this.wavelength.getWavelengthCalibrationCoefficients();
    }

    public void setWavelengthCalibrationCoefficients(Coefficients[] coefficients) {
        this.wavelength.setWavelengthCalibrationCoefficients(coefficients);
    }

    public double[] getWavelengths(int index) {
        return this.wavelength.getWavelengths(index);
    }

    public void setWavelengths(double[] wl, int index) {
        this.wavelength.setWavelengths(wl, index);
    }

    public Coefficients[] readStrayLightCorrectionCoefficientFromSpectrometer() {
        return this.straylight.readStrayLightCorrectionCoefficientFromSpectrometer();
    }

    public void writeStrayLightCoefficientToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.straylight.writeStrayLightCoefficientToSpectrometer(coefficients);
    }

    public void setStrayLightCorrectionCoefficient(Coefficients[] coefficients) {
        this.straylight.setStrayLightCorrectionCoefficient(coefficients);
    }

    public Coefficients[] getStrayLightCorrectionCoefficient() {
        return this.straylight.getStrayLightCorrectionCoefficient();
    }

    public void setStrayLight(double strayLight, int index) {
        this.straylight.setStrayLight(strayLight, index);
    }

    public double getStrayLight(int index) {
        return this.straylight.getStrayLight(index);
    }

    public int[] getBadPixels() throws IOException {
        return this.badPixelRemoval.getBadPixels();
    }

    public void setBadPixels(int[] pixels) throws IOException {
        this.badPixelRemoval.setBadPixels(pixels);
    }

    public Spectrum removeBadPixels(Spectrum spectrum) throws IOException {
        return this.badPixelRemoval.removeBadPixels(spectrum);
    }

    public int getNumberOfBadPixels() {
        return this.badPixelRemoval.getNumberOfBadPixels();
    }

    public int[] getAllPixels() {
        return this.badPixelRemoval.getAllPixels();
    }

    public void setBadPixelsToSpectrometer() throws IOException {
        this.badPixelRemoval.setBadPixelsToSpectrometer();
    }

    public int[] getBadPixelsFromSpectrometer() throws IOException {
        return this.badPixelRemoval.getBadPixelsFromSpectrometer();
    }

    public boolean isAdvancedVersion() {
        return this instanceof AdvancedVersion;
    }

    public void uploadFirmware(File file, long fileSize) throws IOException {
        this.version.uploadFirmware(file, fileSize);
    }

    public void uploadFPGA(File file, long fileSize) throws IOException {
        this.version.uploadFPGA(file, fileSize);
    }

    public void addAcquisitionListener(AcquisitionListener listener) {
        this.version.addAcquisitionListener(listener);
    }

    public void removeAcquisitionListener(AcquisitionListener listener) {
        this.version.removeAcquisitionListener(listener);
    }
}

