/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.nir.nir512;

import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.Configuration;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerChannel;
import com.oceanoptics.omnidriver.spectrometer.nir.NIR;
import java.io.IOException;

public class NIR512
extends NIR {
    static Spectrometer[] scoreboard = new Spectrometer[64];
    private static String __extern__ = "__extern__\n<init>,()V\n<init>,(I)V\nopenSpectrometer,(I)V\n";

    public NIR512() throws IOException {
        try {
            this.setEndpoints();
            this.openNextUnclaimedUSB();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public NIR512(int i) throws IOException {
        this.setEndpoints();
        this.openSpectrometer(i);
    }

    protected Spectrometer[] getScoreboard() {
        return scoreboard;
    }

    public void openSpectrometer(int index) throws IOException {
        this.integrationTimeMinimum = 1000;
        this.integrationTimeMaximum = 65535000;
        this.integrationTimeIncrement = 1000;
        this.integrationTimeBase = 1000;
        this.numberOfCCDPixels = 512;
        this.numberOfDarkCCDPixels = 0;
        this.maxIntensity = 65535;
        this.pipeSize = this.numberOfCCDPixels * 2 + 1;
        this.rawData = new byte[this.pipeSize];
        this.benchSlot = 15;
        this.detectorSerialNumberSlot = 16;
        this.productID = 4108;
        this.usb.openDevice(this.vendorID, this.productID, index);
        this.deviceIndex = index;
        this.initialize();
        this.getFirmwareVersion();
        this.channels = new SpectrometerChannel[1];
        this.channels[this.channelIndex] = new SpectrometerChannel(this, new Coefficients(), this.channelIndex);
        this.logger.fine("NIR512 has been opened at index " + index);
        this.initFeatures(this.usb);
        this.setHighGain(this.getHighGainDefault());
        this.finishConstruction();
        this.configuration = new Configuration(this);
    }
}

