/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.remora;

import com.oceanoptics.omnidriver.features.networksource.NetworkSourceGUIProvider;
import com.oceanoptics.omnidriver.features.networksource.NetworkSourceImpl;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionImpl;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionProvider;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrection;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionImpl;
import com.oceanoptics.omnidriver.features.thermoelectric.ThermoElectric;
import com.oceanoptics.omnidriver.features.thermoelectric.ThermoElectricGUIProvider;
import com.oceanoptics.omnidriver.features.thermoelectric.ThermoElectricImpl_Remora;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationGUIProvider;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationProvider;
import com.oceanoptics.omnidriver.interfaces.GUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectra.SpectrometerInfo;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.Configuration;
import com.oceanoptics.omnidriver.spectrometer.NetworkSpectrometer;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerChannel;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;
import java.net.Socket;
import java.util.Vector;

public class Remora
extends NetworkSpectrometer
implements WavelengthCalibrationProvider,
StrayLightCorrection,
NonlinearityCorrectionProvider,
ThermoElectric {
    static Spectrometer[] scoreboard = new Spectrometer[64];
    private NetworkSourceGUIProvider network;
    private WavelengthCalibrationGUIProvider wavelength;
    private StrayLightCorrectionGUIProvider straylight;
    private NonlinearityCorrectionGUIProvider nonlinearity;
    private ThermoElectricGUIProvider tec;
    private Socket dataSocket = new Socket();
    private byte[] out = new byte[100];
    private String serialNumber = new String();
    private Configuration[] configurations = null;
    private int spectrometerType = 0;
    private static String __extern__ = "__extern__\n<init>,(I)V\n<init>,(Ljava/net/Socket;)V\nopenSpectrometer,(I)V\ngetGUIFeatures,()[Lcom/oceanoptics/omnidriver/interfaces/GUIProvider;\ngetSerialNumber,()Ljava/lang/String;\ngetFirmwareVersion,()Ljava/lang/String;\ngetSaturationIntensity,()I\nsetSaturationIntensity,(ILjava/lang/String;)Z\ncloseSpectrometer,()V\ngetInfo,(I)Ljava/lang/String;\ngetInfoBytes,(I)[B\nconnectToSource,(Ljava/lang/String;I)V\nisConnected,()Z\ngetName,()Ljava/lang/String;\ndisconnect,()V\nsetStrobeEnable,(Z)V\nsetIntegrationTime,(I)V\ngetSpectrum,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)Lcom/oceanoptics/omnidriver/spectra/Spectrum;\nreconnect,()V\nreadWavelengthCalibrationCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteWavelengthCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengthCalibrationCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetWavelengthCalibrationCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengths,(I)[D\nsetWavelengths,([DI)V\nsetTECEnable,(Z)V\ngetTECEnable,()Ljava/lang/Boolean;\nsetFanEnable,(Z)V\ngetFanEnable,()Ljava/lang/Boolean;\ngetDetectorTemperatureCelsius,()D\ngetDetectorTemperatureSetPointCelsius,()D\nsetDetectorSetPointCelsius,(D)V\ngetDetectorSetPointCelsius,()Ljava/lang/Double;\ngetSetPointMinimumCelsius,()D\ngetSetPointMaximumCelsius,()D\ngetSetPointIncrementCelsius,()D\nisSaveTECStateEnabled,()Z\nsaveTECState,()V\nwriteStrayLightCoefficientToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\nreadStrayLightCorrectionCoefficientFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetStrayLightCorrectionCoefficient,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetStrayLightCorrectionCoefficient,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\ngetStrayLight,(I)D\nsetStrayLight,(DI)V\nwriteNonlinearityCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\nreadNonlinearityCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetNonlinearityCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\ngetNonlinearityCoefficientsSingleChannel,(I)[D\nsetNonlinearityCoefficientsSingleChannel,([DI)V\n";

    public Remora(int i) throws IOException {
        this.openSpectrometer(i);
    }

    public Remora(Socket socket) throws IOException {
        if (!socket.isConnected()) {
            throw new IOException("Socket is not connected.");
        }
        this.dataSocket = socket;
        this.address = socket.getInetAddress().toString().substring(1);
        this.port = socket.getPort();
        this.openSpectrometer(0);
    }

    protected Spectrometer[] getScoreboard() {
        return scoreboard;
    }

    public void openSpectrometer(int index) throws IOException {
        String specType = this.getInfo(25);
        if (specType.equals("NONE") || specType.equals("")) {
            this.logger.severe("ERROR! No Hardware was found attached to the Remora!");
            throw new IOException("No Hardware Found!");
        }
        if (specType.equals("SIMULATION")) {
            this.spectrometerType = 0;
        } else if (specType.equals("HR2000")) {
            this.spectrometerType = 4106;
        } else if (specType.equals("HR2000PLUS")) {
            this.spectrometerType = 4118;
        } else if (specType.equals("HR4000")) {
            this.spectrometerType = 4114;
        } else if (specType.equals("MAYA2000")) {
            this.spectrometerType = 4140;
        } else if (specType.equals("MAYAPRO2000")) {
            this.spectrometerType = 4138;
        } else if (specType.equals("NIRQUEST256")) {
            this.spectrometerType = 4136;
        } else if (specType.equals("NIRQUEST512")) {
            this.spectrometerType = 4134;
        } else if (specType.equals("QE65000")) {
            this.spectrometerType = 4120;
        }
        this.initFeatures(this.usb);
        this.initInfo();
        this.channelIndex = 0;
        this.channels = new SpectrometerChannel[1];
        this.channels[this.channelIndex] = new SpectrometerChannel(this, this.wavelength.readWavelengthCalibrationCoefficientsFromSpectrometer()[0], this.channelIndex);
        this.spectrumBase = new SpectrometerInfo(this.getSerialNumber(), this.getFirmwareVersion(), this.getClass(), null, this.numChannels, this.numberOfPixels, this.numberOfDarkCCDPixels, this.maxIntensity, this.integrationTimeMinimum, this.integrationTimeMaximum, this.integrationTimeIncrement, this.integrationTimeBase);
        this.channels[this.channelIndex].generateMetadata(this.spectrumBase, this.channelIndex);
        this.finishConstruction();
        this.logger.fine("Remora network spectrometer has been opened at index " + index);
    }

    protected void initInfo() {
        switch (this.spectrometerType) {
            case 0: {
                this.integrationTimeMinimum = 3000;
                this.integrationTimeMaximum = 65535000;
                this.integrationTimeIncrement = 1000;
                this.integrationTimeBase = 1;
                this.numberOfCCDPixels = 2048;
                this.numberOfDarkCCDPixels = 24;
                this.maxIntensity = 65535;
                this.rawData = new byte[this.numberOfCCDPixels * 2 + 1];
                break;
            }
            case 4106: {
                this.integrationTimeMinimum = 3000;
                this.integrationTimeMaximum = 65535000;
                this.integrationTimeIncrement = 1000;
                this.integrationTimeBase = 1;
                this.numberOfCCDPixels = 2048;
                this.numberOfDarkCCDPixels = 24;
                this.maxIntensity = 4095;
                this.rawData = new byte[this.numberOfCCDPixels * 2 + 1];
                this.benchSlot = 15;
                this.spectrometerConfigSlot = 16;
                break;
            }
            case 4118: {
                this.integrationTimeMinimum = 1000;
                this.integrationTimeMaximum = 65535000;
                this.integrationTimeIncrement = 10;
                this.integrationTimeBase = 1;
                this.numberOfCCDPixels = 2048;
                this.numberOfDarkCCDPixels = 24;
                this.maxIntensity = 16383;
                this.rawData = new byte[this.numberOfCCDPixels * 2 + 1];
                this.benchSlot = 15;
                this.spectrometerConfigSlot = 16;
                break;
            }
            case 4114: {
                this.integrationTimeMinimum = 10;
                this.integrationTimeMaximum = 65535000;
                this.integrationTimeIncrement = 10;
                this.integrationTimeBase = 1;
                this.numberOfCCDPixels = 3648;
                this.numberOfDarkCCDPixels = 13;
                this.maxIntensity = 16383;
                this.rawData = new byte[7681];
                this.benchSlot = 15;
                this.spectrometerConfigSlot = 16;
                break;
            }
            case 4140: {
                this.integrationTimeMinimum = 15000;
                this.integrationTimeMaximum = 1600000000;
                this.integrationTimeIncrement = 1000;
                this.integrationTimeBase = 1;
                this.numberOfCCDPixels = 2080;
                this.numberOfDarkCCDPixels = 16;
                this.maxIntensity = 65535;
                this.rawData = new byte[4609];
                this.benchSlot = 15;
                this.spectrometerConfigSlot = 16;
                break;
            }
            case 4138: {
                this.integrationTimeMinimum = 13000;
                this.integrationTimeMaximum = 1600000000;
                this.integrationTimeIncrement = 1000;
                this.integrationTimeBase = 1;
                this.numberOfCCDPixels = 2068;
                this.numberOfDarkCCDPixels = 8;
                this.maxIntensity = 65535;
                this.rawData = new byte[4609];
                this.benchSlot = 15;
                this.spectrometerConfigSlot = 16;
                break;
            }
            case 4120: {
                this.integrationTimeMinimum = 8000;
                this.integrationTimeMaximum = 1600000000;
                this.integrationTimeIncrement = 1000;
                this.integrationTimeBase = 1;
                this.numberOfCCDPixels = 1044;
                this.numberOfDarkCCDPixels = 3;
                this.maxIntensity = 65535;
                this.rawData = new byte[2561];
                this.benchSlot = 15;
                this.spectrometerConfigSlot = 16;
                break;
            }
            case 4136: {
                this.integrationTimeMinimum = 1000;
                this.integrationTimeMaximum = 1600000000;
                this.integrationTimeIncrement = 1000;
                this.integrationTimeBase = 1;
                this.numberOfCCDPixels = 256;
                this.numberOfDarkCCDPixels = 0;
                this.maxIntensity = 65535;
                this.rawData = new byte[this.numberOfCCDPixels * 2 + 1];
                this.benchSlot = 15;
                this.spectrometerConfigSlot = 16;
                break;
            }
            case 4134: {
                this.integrationTimeMinimum = 1000;
                this.integrationTimeMaximum = 1600000000;
                this.integrationTimeIncrement = 1000;
                this.integrationTimeBase = 1;
                this.numberOfCCDPixels = 512;
                this.numberOfDarkCCDPixels = 0;
                this.maxIntensity = 65535;
                this.rawData = new byte[this.numberOfCCDPixels * 2 + 1];
                this.benchSlot = 15;
                this.spectrometerConfigSlot = 16;
                break;
            }
            default: {
                this.logger.severe("ERROR! Unknown Spectrometer Type!");
            }
        }
    }

    protected void initFeatures(USBInterface usb) throws IOException {
        this.network = new NetworkSourceImpl(usb, this);
        this.reInitFeatures(usb);
    }

    protected void reInitFeatures(USBInterface usb) throws IOException {
        this.wavelength = new WavelengthCalibrationImpl(this.usb, this);
        this.straylight = new StrayLightCorrectionImpl(this.usb, this);
        this.nonlinearity = new NonlinearityCorrectionImpl(this.usb, this);
        switch (this.spectrometerType) {
            case 0: {
                break;
            }
            case 4106: {
                break;
            }
            case 4118: {
                break;
            }
            case 4114: {
                break;
            }
            case 4140: {
                break;
            }
            case 4138: {
                break;
            }
            case 4120: {
                this.tec = new ThermoElectricImpl_Remora(this.usb, this.dataSocket, this.productID);
                break;
            }
            case 4136: {
                this.tec = new ThermoElectricImpl_Remora(this.usb, this.dataSocket, this.productID);
                break;
            }
            case 4134: {
                this.tec = new ThermoElectricImpl_Remora(this.usb, this.dataSocket, this.productID);
                break;
            }
        }
    }

    protected void finishConstruction() throws IOException {
        this.numberOfPixels = this.numberOfCCDPixels;
        this.numberOfDarkPixels = this.numberOfDarkCCDPixels;
        this.benchSlot = 15;
        this.spectrometerConfigSlot = 16;
        this.spectrumBase = new SpectrometerInfo(this.getSerialNumber(), this.getFirmwareVersion(), this.getClass(), null, 1, this.getNumberOfCCDPixels(), this.getNumberOfDarkCCDPixels(), this.getMaxIntensity(), this.getIntegrationTimeMinimum(), this.getIntegrationTimeMaximum(), this.getIntegrationTimeIncrement(), this.getIntegrationTimeBase());
        this.reInitFeatures(this.usb);
    }

    public GUIProvider[] getGUIFeatures() {
        Vector<GUIProvider> features = new Vector<GUIProvider>();
        features.add(this.network);
        features.add(this.wavelength);
        features.add(this.straylight);
        features.add(this.nonlinearity);
        switch (this.spectrometerType) {
            case 4106: {
                break;
            }
            case 4118: {
                break;
            }
            case 4114: {
                break;
            }
            case 4140: {
                break;
            }
            case 4138: {
                break;
            }
            case 4120: {
                features.add(this.tec);
                break;
            }
            case 4136: {
                features.add(this.tec);
                break;
            }
            case 4134: {
                features.add(this.tec);
                break;
            }
        }
        return features.toArray(new GUIProvider[0]);
    }

    public String getSerialNumber() throws IOException {
        if (this.dataSocket.isConnected()) {
            this.serialNumber = this.getInfo(0);
        }
        return this.serialNumber;
    }

    public String getFirmwareVersion() throws IOException {
        this.firmwareVersion = "Unknown";
        return this.firmwareVersion;
    }

    protected void doStabilityScan(int numScans) throws IOException {
    }

    public int getSaturationIntensity() {
        return -1;
    }

    public boolean setSaturationIntensity(int saturationIntensity, String key) {
        return false;
    }

    public void closeSpectrometer() throws IOException {
        this.disconnect();
    }

    protected void finalize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInfo(int slot) throws IOException {
        if (this.dataSocket.isClosed() || !this.dataSocket.isConnected()) {
            throw new IOException("Cannot read info when socket is closed");
        }
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                int i;
                this.out[0] = 5;
                this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)slot));
                String strRet = "";
                try {
                    this.dataSocket.getOutputStream().write(this.out, 0, 2);
                }
                catch (Exception e) {
                    this.reconnect();
                    throw new IOException("Failed to write to device, attempting to reconnect");
                }
                int len = 0;
                try {
                    len = this.dataSocket.getInputStream().read(this.in, 0, 17);
                }
                catch (Exception e) {
                    this.reconnect();
                    throw new IOException("Failed to read from device, attempting to reconnect");
                }
                for (i = 2; this.in[i] != 0 && i < 17; ++i) {
                    strRet = strRet + (char)this.in[i];
                }
                if (5 == slot && i < 16 && this.in[i] == 0 && this.in[i + 1] != 0) {
                    ++i;
                    strRet = strRet + " ";
                    while (this.in[i] != 0 && i < 17) {
                        strRet = strRet + (char)this.in[i];
                        ++i;
                    }
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return strRet;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getInfoBytes(int slot) throws IOException {
        if (this.dataSocket.isClosed() || !this.dataSocket.isConnected()) {
            throw new IOException("Cannot read info when socket is closed");
        }
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                byte[] byteArray = new byte[15];
                this.out[0] = 5;
                this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)slot));
                String strRet = "";
                try {
                    this.dataSocket.getOutputStream().write(this.out, 0, 2);
                }
                catch (Exception e) {
                    this.reconnect();
                    throw new IOException("Failed to write to device, attempting to reconnect");
                }
                int len = 0;
                try {
                    len = this.dataSocket.getInputStream().read(this.in, 0, 17);
                }
                catch (Exception e) {
                    this.reconnect();
                    throw new IOException("Failed to read from device, attempting to reconnect");
                }
                for (int i = 0; i < 15; ++i) {
                    byteArray[i] = this.in[i + 2];
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return byteArray;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectToSource(String address, int port) {
        Remora remora = this;
        synchronized (remora) {
            try {
                if (this.dataSocket.isConnected()) {
                    this.dataSocket.close();
                }
                this.dataSocket = new Socket(address, port);
                this.dataSocket.setSoTimeout(0);
                this.dataSocket.setSoLinger(false, 1);
                this.finishConstruction();
            }
            catch (Exception e) {
                this.dataSocket = new Socket();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Remora remora = this;
        synchronized (remora) {
            return this.dataSocket.isConnected();
        }
    }

    public String getName() {
        return "Remora";
    }

    public void disconnect() {
        try {
            this.dataSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dataSocket = new Socket();
    }

    protected Spectrum formatData(byte[] data, Spectrum doubleSpectrum) throws IOException {
        byte zero = 0;
        double[] spectrum = doubleSpectrum.getSpectrum();
        this.logger.finest("Formatting data");
        doubleSpectrum.setSaturated(false);
        if (data[data.length - 1] != 105) {
            this.logger.severe("Lost Synchronization with the spectrometer!");
        }
        if (this.spectrometerType == 0) {
            for (int i = 0; i < this.numberOfCCDPixels; ++i) {
                byte MSB = data[2 * i + 1];
                byte LSB = data[2 * i];
                int pixel = ByteRoutines.makeDWord((byte)zero, (byte)zero, (byte)MSB, (byte)LSB);
                if (pixel >= this.maxIntensity) {
                    doubleSpectrum.setSaturated(true);
                }
                spectrum[i] = pixel;
            }
        } else if (this.spectrometerType == 4106) {
            for (int i = spectrum.length - 1; i >= 0; --i) {
                int LSBPacket = i >> 6;
                int MSBPacket = LSBPacket + 1;
                byte MSB = data[(MSBPacket << 6) + i];
                byte LSB = data[(LSBPacket << 6) + i];
                int pixel = ByteRoutines.makeDWord((byte)zero, (byte)zero, (byte)MSB, (byte)LSB) & 0xFFF;
                if (pixel >= this.maxIntensity) {
                    doubleSpectrum.setSaturated(true);
                }
                spectrum[i] = pixel;
            }
        } else if (this.spectrometerType == 4118 || this.spectrometerType == 4114) {
            for (int i = 0; i < this.numberOfCCDPixels; ++i) {
                byte MSB = data[2 * i + 1];
                byte LSB = data[2 * i];
                int pixel = ByteRoutines.makeDWord((byte)zero, (byte)zero, (byte)MSB, (byte)LSB) ^ 0x2000;
                if (pixel >= this.maxIntensity) {
                    doubleSpectrum.setSaturated(true);
                }
                spectrum[i] = pixel;
            }
        } else if (this.spectrometerType == 4120 || this.spectrometerType == 4136 || this.spectrometerType == 4134) {
            for (int i = 0; i < this.numberOfCCDPixels; ++i) {
                byte MSB = data[i * 2 + 1];
                byte LSB = data[i * 2];
                int pixel = ByteRoutines.makeDWord((byte)zero, (byte)zero, (byte)MSB, (byte)LSB) ^ 0x8000;
                if (pixel >= this.maxIntensity) {
                    doubleSpectrum.setSaturated(true);
                }
                spectrum[i] = pixel;
            }
        } else if (this.spectrometerType == 4140 || this.spectrometerType == 4138) {
            for (int i = 0; i < this.numberOfCCDPixels; ++i) {
                byte MSB = data[i * 2 + 1];
                byte LSB = data[i * 2];
                int pixel = ByteRoutines.makeDWord((byte)zero, (byte)zero, (byte)MSB, (byte)LSB);
                if (pixel >= this.maxIntensity) {
                    doubleSpectrum.setSaturated(true);
                }
                spectrum[i] = pixel;
            }
        } else {
            throw new IllegalStateException("Unknown Spectrometer Type; Cannot format spectrum!");
        }
        return doubleSpectrum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrobeEnable(boolean strobe) throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            if (this.dataSocket.isClosed() || !this.dataSocket.isConnected()) {
                throw new IOException("Cannot control strobe when socket is closed");
            }
            if (this.strobeOn == null) {
                this.strobeOn = new Boolean(strobe);
            } else if (this.strobeOn == strobe) {
                this.logger.fine("Desired strobe enable state already set, not pushing to spectrometer");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int on = !strobe ? 0 : 1;
            this.out[0] = 3;
            this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)on));
            this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)on));
            try {
                this.dataSocket.getOutputStream().write(this.out, 0, 3);
            }
            catch (Exception e) {
                this.reconnect();
                throw new IOException("Failed to write to device, attempting to reconnect");
            }
            if (strobe != this.strobeOn && this.isStabilityScan()) {
                this.doStabilityScan(1);
            }
            this.strobeOn = strobe ? Boolean.TRUE : Boolean.FALSE;
            this.logger.fine("Strobe enabled: " + strobe);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIntegrationTime(int intTime) throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            boolean needStabilityScan;
            if (this.dataSocket.isClosed() || !this.dataSocket.isConnected()) {
                throw new IOException("Cannot set integration time when socket is closed");
            }
            boolean bl = needStabilityScan = this.integrationTime != intTime;
            if (!needStabilityScan) {
                this.logger.fine("Desired integration time already set, not pushing to spectrometer");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int maxTime = this.getIntegrationTimeMaximum();
            int minTime = this.getIntegrationTimeMinimum();
            if (intTime < minTime) {
                intTime = minTime;
            } else if (intTime > maxTime) {
                intTime = maxTime;
            }
            this.integrationTime = intTime;
            this.out[0] = 2;
            this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)(intTime /= this.getIntegrationTimeBase())));
            this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)intTime));
            this.out[3] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)intTime));
            this.out[4] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)intTime));
            try {
                this.dataSocket.getOutputStream().write(this.out, 0, 5);
            }
            catch (Exception e) {
                this.reconnect();
                throw new IOException("Failed to write to device, attempting to reconnect");
            }
            this.logger.fine("Integration time set to: " + intTime);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Spectrum getSpectrum(Spectrum spectrum) throws IOException {
        this.logger.finest("Getting spectrum...");
        this.timeoutOccurredFlag = false;
        if (!this.dataSocket.isConnected()) {
            throw new IOException("Network spectrometer not connected!");
        }
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                if (this.dataSocket.isConnected()) {
                    this.requestSpectrum();
                    this.readSpectrum();
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            {
                spectrum.setSaturated(false);
                this.formatData(this.rawData, spectrum);
                return spectrum;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestSpectrum() throws IOException {
        if (this.dataSocket.isClosed() || !this.dataSocket.isConnected()) {
            throw new IOException("Cannot request spectrum when socket is closed");
        }
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.logger.finer("Spectrum requested.");
            this.out[0] = 9;
            try {
                this.dataSocket.getOutputStream().write(this.out, 0, 1);
            }
            catch (Exception e) {
                this.reconnect();
                throw new IOException("Failed to write to device, attempting to reconnect");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readSpectrum() throws IOException {
        if (this.dataSocket.isClosed() || !this.dataSocket.isConnected()) {
            throw new IOException("Cannot read spectrum when socket is closed");
        }
        byte[] byArray = this.rawData;
        synchronized (this.rawData) {
            int len;
            try {
                for (len = 0; len < this.rawData.length; len += this.dataSocket.getInputStream().read(this.rawData, len, this.rawData.length - len)) {
                }
            }
            catch (Exception e) {
                this.reconnect();
                throw new IOException("Failed to read from device, attempting to reconnect");
            }
            if (len < this.getNumberOfPixels() * 2 + 1) {
                throw new IOException("Got a short read (" + len + " bytes)");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void reconnect() {
        this.network.reconnect();
    }

    public Coefficients[] readWavelengthCalibrationCoefficientsFromSpectrometer() {
        return this.wavelength.readWavelengthCalibrationCoefficientsFromSpectrometer();
    }

    public void writeWavelengthCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.wavelength.writeWavelengthCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getWavelengthCalibrationCoefficients() {
        return this.wavelength.getWavelengthCalibrationCoefficients();
    }

    public void setWavelengthCalibrationCoefficients(Coefficients[] coefficients) {
        this.wavelength.setWavelengthCalibrationCoefficients(coefficients);
    }

    public double[] getWavelengths(int index) {
        return this.wavelength.getWavelengths(index);
    }

    public void setWavelengths(double[] wl, int index) {
        this.wavelength.setWavelengths(wl, index);
    }

    public void setTECEnable(boolean enable) throws IOException {
        this.tec.setTECEnable(enable);
    }

    public Boolean getTECEnable() {
        return this.tec.getTECEnable();
    }

    public void setFanEnable(boolean enable) throws IOException {
        this.tec.setFanEnable(enable);
    }

    public Boolean getFanEnable() {
        return this.tec.getFanEnable();
    }

    public double getDetectorTemperatureCelsius() throws IOException {
        return this.tec.getDetectorTemperatureCelsius();
    }

    public double getDetectorTemperatureSetPointCelsius() throws IOException {
        return this.tec.getDetectorTemperatureSetPointCelsius();
    }

    public void setDetectorSetPointCelsius(double point) throws IOException {
        this.tec.setDetectorSetPointCelsius(point);
    }

    public Double getDetectorSetPointCelsius() {
        return this.tec.getDetectorSetPointCelsius();
    }

    public double getSetPointMinimumCelsius() {
        return this.tec.getSetPointMinimumCelsius();
    }

    public double getSetPointMaximumCelsius() {
        return this.tec.getSetPointMaximumCelsius();
    }

    public double getSetPointIncrementCelsius() {
        return this.tec.getSetPointIncrementCelsius();
    }

    public boolean isSaveTECStateEnabled() {
        if (this.productID == 4120) {
            return this.tec.isSaveTECStateEnabled();
        }
        return false;
    }

    public void saveTECState() throws IOException {
        if (this.productID != 4120) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.tec.saveTECState();
    }

    public void writeStrayLightCoefficientToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.straylight.writeStrayLightCoefficientToSpectrometer(coefficients);
    }

    public Coefficients[] readStrayLightCorrectionCoefficientFromSpectrometer() {
        return this.straylight.readStrayLightCorrectionCoefficientFromSpectrometer();
    }

    public void setStrayLightCorrectionCoefficient(Coefficients[] coefficients) {
        this.straylight.setStrayLightCorrectionCoefficient(coefficients);
    }

    public Coefficients[] getStrayLightCorrectionCoefficient() {
        return this.straylight.getStrayLightCorrectionCoefficient();
    }

    public double getStrayLight(int index) {
        return this.straylight.getStrayLight(index);
    }

    public void setStrayLight(double strayLight, int index) {
        this.straylight.setStrayLight(strayLight, index);
    }

    public void writeNonlinearityCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.nonlinearity.writeNonlinearityCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] readNonlinearityCoefficientsFromSpectrometer() {
        return this.nonlinearity.readNonlinearityCoefficientsFromSpectrometer();
    }

    public void setNonlinearityCoefficients(Coefficients[] coefficients) {
        this.nonlinearity.setNonlinearityCoefficients(coefficients);
    }

    public Coefficients[] getNonlinearityCoefficients() {
        return this.nonlinearity.getNonlinearityCoefficients();
    }

    public double[] getNonlinearityCoefficientsSingleChannel(int channelIndex) {
        return this.nonlinearity.getNonlinearityCoefficientsSingleChannel(channelIndex);
    }

    public void setNonlinearityCoefficientsSingleChannel(double[] nonlinearities, int channelIndex) {
        this.nonlinearity.setNonlinearityCoefficientsSingleChannel(nonlinearities, channelIndex);
    }
}

