/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.sha;

import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerChannel;
import com.oceanoptics.omnidriver.spectrometer.hr2000.HR2000;
import com.oceanoptics.omnidriver.spectrometer.hr4000.HR4000;
import com.oceanoptics.omnidriver.spectrometer.sha.SHACoefficients;
import com.oceanoptics.omnidriver.spectrometer.usb2000.USB2000;
import com.oceanoptics.omnidriver.spectrometer.usb4000.USB4000;
import com.oceanoptics.spam.numericalmethods.NumericalMethods;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Random;

public class SHAChannel
extends SpectrometerChannel {
    SHACoefficients shaCoefficients = new SHACoefficients();
    boolean sat = false;
    static final Random RANDOM = new Random();
    double[][] rawData;
    public double[][] adjustedData;
    int[] scanPeaksWL;
    int[] scanPeaksVoltage;
    double[] amplitudes;
    double[] interpolatedIntensities;
    double[] interpolatedWavelengths;
    protected double[] processedData;
    protected double[] processedWL;
    double voltageStart = 0.0;
    double voltageEnd = 5.0;
    public int numberVoltageSteps = 101;
    double voltageStep = (this.voltageEnd - this.voltageStart) / ((double)this.numberVoltageSteps - 1.0);
    int numberOfSpectrometerPixels = -1;
    private NumericalMethods nm = new NumericalMethods();
    public String serialNumber = "04125004";
    private String firmwareVersion = "1.01.00";
    double[] interpolatedWL;
    int size;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/spectrometer/Spectrometer;Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;I)V\ngetSpectrum,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)Lcom/oceanoptics/omnidriver/spectra/Spectrum;\ngetSpectrum,()Lcom/oceanoptics/omnidriver/spectra/Spectrum;\ngetScans,(ILcom/oceanoptics/omnidriver/spectra/Spectrum;)[[D\nfindPeak,([DI)D\nsortPeaks,(I)V\ngetLength,(D)D\ngetPhase,(D)D\ngetMaxNumberOfCounts,()I\ngetSHACoefficientsFromDevice,()V\ngetConstant,(I)Ljava/lang/String;\nsaveSHACoefficients,()V\nsaveConstant,(ILjava/lang/String;)I\ngetPixel,(D)I\ncalcPixel,(D)I\ngetWavelength,(I)D\ngetWavelength,(D)D\ngetAllWavelengths,()[D\ngetSHACoefficients,()Lcom/oceanoptics/omnidriver/spectrometer/sha/SHACoefficients;\ngetNumberOfVoltageSteps,()I\ngetNumberOfSpectrometerPixels,()I\ngetSHASerialNumber,()Ljava/lang/String;\ngetSHAFirmwareVersion,()Ljava/lang/String;\ngetCalibrationConstants,([[D)D\n";

    public SHAChannel(Spectrometer spectrometer, Coefficients coefficients, int index) throws IOException {
        super(spectrometer, coefficients, index);
        this.setSource(spectrometer);
        this.numberOfSpectrometerPixels = this.numberOfPixels;
        this.numberOfPixels = 300000;
        this.getSHACoefficientsFromDevice();
        this.logger.fine("Version: " + this.firmwareVersion);
        if (this.firmwareVersion.equalsIgnoreCase("1.01.00")) {
            this.getPhaseData();
        }
        ((HR4000)spectrometer).setHyperAdapterDAC(0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Spectrum getSpectrum(Spectrum spectrum) throws IOException {
        Spectrometer spectrometer = this.spectrometer;
        synchronized (spectrometer) {
            this.getScans(this.numberVoltageSteps, spectrum);
            return this.interpolateSpectrum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Spectrum getSpectrum() throws IOException {
        Spectrometer spectrometer = this.spectrometer;
        synchronized (spectrometer) {
            this.getScans(this.numberVoltageSteps, null);
            return this.interpolateSpectrum();
        }
    }

    public double[][] getScans(int numVoltageSteps, Spectrum spectrum) throws IOException {
        if (spectrum == null) {
            spectrum = this.spectrometer.getUnfilledSpectrum();
        }
        this.rawData = new double[numVoltageSteps][this.numberOfSpectrometerPixels];
        double voltage = this.voltageStart;
        ((HR4000)this.spectrometer).setHyperAdapterDAC(this.voltageStart);
        for (int i = 0; i < numVoltageSteps; ++i) {
            spectrum = this.spectrometer.getSpectrum(spectrum);
            ((HR4000)this.spectrometer).setHyperAdapterDAC(voltage += this.voltageStep);
            System.arraycopy(spectrum.getSpectrum(), 0, this.rawData[i], 0, this.numberOfSpectrometerPixels);
        }
        ((HR4000)this.spectrometer).setHyperAdapterDAC(this.voltageStart);
        return this.rawData;
    }

    protected Spectrum interpolateSpectrum() {
        this.generateHighResSpectrum();
        this.interpolatedIntensities = NumericalMethods.linearSpline((double[])this.processedWL, (double[])this.processedData, (double[])this.wavelengths);
        Spectrum processedSpectrum = new Spectrum(this.interpolatedIntensities.length, 0);
        processedSpectrum.setSpectrum(this.interpolatedIntensities);
        return processedSpectrum;
    }

    private void generatePaddedSpectrum() {
        for (int i = this.size; i < this.processedData.length; ++i) {
            this.processedData[i] = this.processedData[this.size - 1];
            this.processedWL[i] = this.processedWL[this.size - 1];
        }
        this.interpolatedIntensities = this.processedData;
        this.wavelengths = this.processedWL;
        this.getSpectrometerChannelInfo().setChannelWavelengths(this.processedWL);
    }

    protected void generateHighResSpectrum() {
        int i;
        double d_start;
        double voltage;
        int peaks;
        int maxCounts = this.getMaxNumberOfCounts();
        int satCount = (int)(0.95 * (double)maxCounts);
        int pixels = this.numberOfSpectrometerPixels;
        int darkPixels = this.numberOfDarkPixels;
        double startWL = this.getWavelength(0);
        double endWL = this.getWavelength(pixels - 1);
        this.shaCoefficients.setIntercept(this.shaCoefficients.getLenIntercept());
        this.shaCoefficients.setFirst(this.shaCoefficients.getLenFirst());
        this.shaCoefficients.setSecond(this.shaCoefficients.getLenSecond());
        double maxDark = 0.0;
        double avgDark = 0.0;
        for (int i2 = 0; i2 < this.numberVoltageSteps; ++i2) {
            if (this.rawData[i2][darkPixels - 2] > maxDark) {
                maxDark = this.rawData[i2][darkPixels - 1];
            }
            if (this.rawData[i2][darkPixels - 3] > maxDark) {
                maxDark = this.rawData[i2][darkPixels - 2];
            }
            avgDark += this.rawData[i2][darkPixels - 1] + this.rawData[i2][darkPixels - 2];
        }
        double avgDarkD = avgDark / (2.0 * (double)this.numberVoltageSteps);
        this.adjustedData = new double[this.numberVoltageSteps][pixels];
        for (int i3 = 0; i3 < this.numberVoltageSteps; ++i3) {
            for (int j = 0; j < pixels; ++j) {
                this.adjustedData[i3][j] = this.rawData[i3][j] - avgDarkD;
            }
        }
        int nStart = (int)Math.ceil(2000.0 * this.getLength(0.0) / startWL - this.getPhase(startWL) / Math.PI);
        int nEnd = (int)Math.ceil(2000.0 * this.getLength(0.0) / endWL - this.getPhase(startWL) / Math.PI);
        int maxPoints = (nStart - nEnd) * this.numberVoltageSteps;
        int numPeaks = 0;
        this.scanPeaksWL = new int[maxPoints / 5];
        this.scanPeaksVoltage = new int[maxPoints / 5];
        this.amplitudes = new double[maxPoints / 5];
        for (int i4 = 1; i4 < this.numberVoltageSteps - 1; ++i4) {
            for (int j = darkPixels + 1; j < pixels - 1; ++j) {
                if (!(this.adjustedData[i4][j] > maxDark * 1.5) || numPeaks >= maxPoints / 5 || !(this.adjustedData[i4][j] > this.adjustedData[i4][j + 1]) || !(this.adjustedData[i4][j] > this.adjustedData[i4][j - 1]) || !(this.adjustedData[i4][j] > this.adjustedData[i4 - 1][j]) || !(this.adjustedData[i4][j] > this.adjustedData[i4 + 1][j])) continue;
                boolean foundPeak = false;
                if (numPeaks == 0 || this.scanPeaksVoltage[numPeaks - 1] != i4) {
                    foundPeak = true;
                } else {
                    double currentWL = this.getWavelength(j);
                    double wlSpacing = currentWL * currentWL / 2.0 / this.shaCoefficients.getIntercept() / 1000.0;
                    int spacing = (int)(wlSpacing / (currentWL - this.getWavelength(j - 1)));
                    if (j - this.scanPeaksWL[numPeaks - 1] > (spacing -= 2)) {
                        foundPeak = true;
                    } else if (this.adjustedData[i4][j] > this.amplitudes[numPeaks - 1]) {
                        --numPeaks;
                        foundPeak = true;
                    }
                }
                if (!foundPeak) continue;
                this.scanPeaksWL[numPeaks] = j;
                this.scanPeaksVoltage[numPeaks] = i4;
                this.amplitudes[numPeaks] = this.adjustedData[i4][j];
                ++numPeaks;
            }
        }
        this.sortPeaks(numPeaks);
        this.sat = this.amplitudes[0] > (double)satCount;
        double threshold = 0.1 * ((double)maxCounts - maxDark);
        for (peaks = 0; peaks < numPeaks && this.amplitudes[peaks] > threshold; ++peaks) {
        }
        if (peaks < 4) {
            if (peaks > 0) {
                while (peaks < numPeaks && peaks < 6 && this.amplitudes[peaks] > threshold / 3.0) {
                    ++peaks;
                }
            } else {
                while (peaks < numPeaks && peaks < 10 && this.amplitudes[peaks] > threshold / 6.0) {
                    ++peaks;
                }
            }
        }
        if (peaks == 0 && numPeaks > 0) {
            peaks = 1;
        }
        this.interpolatedWL = new double[peaks];
        for (int i5 = 0; i5 < peaks; ++i5) {
            this.interpolatedWL[i5] = this.getWavelength(this.findPeak(this.adjustedData[this.scanPeaksVoltage[i5]], this.scanPeaksWL[i5]));
        }
        if (peaks > 2) {
            double n_err;
            double avg_wl = 0.0;
            double n_err_avg = 0.0;
            double n_err_sq = 0.0;
            double n_err_avg_plus = 0.0;
            double n_err_sq_plus = 0.0;
            for (int i6 = 0; i6 < peaks; ++i6) {
                avg_wl += this.interpolatedWL[i6];
                n_err = 2000.0 * this.getLength((double)this.scanPeaksVoltage[i6] * this.voltageStep) / this.interpolatedWL[i6] - this.getPhase(this.interpolatedWL[i6]) / Math.PI;
                double n_err_plus = n_err + 0.5;
                n_err -= (double)Math.round(n_err);
                n_err_plus -= (double)Math.round(n_err_plus);
                n_err_avg += n_err;
                n_err_avg_plus += n_err_plus;
                n_err_sq += n_err * n_err;
                n_err_sq_plus += n_err_plus * n_err_plus;
            }
            avg_wl /= (double)peaks;
            n_err_avg /= (double)peaks;
            double std_err_plus = Math.sqrt((n_err_sq_plus - (n_err_avg_plus /= (double)peaks) * n_err_avg_plus * (double)peaks) / (double)peaks);
            double std_err = Math.sqrt((n_err_sq - n_err_avg * n_err_avg * (double)peaks) / (double)peaks);
            if (std_err <= std_err_plus) {
                this.shaCoefficients.setIntercept(this.shaCoefficients.getLenIntercept() - avg_wl / 2000.0 * n_err_avg);
            } else {
                this.shaCoefficients.setIntercept(this.shaCoefficients.getLenIntercept() - avg_wl / 2000.0 * (0.5 + n_err_avg_plus));
            }
            double min_err = 0.5;
            double min_err_mean = 0.0;
            int min_err_i = 0;
            int min_err_j = 0;
            double dd = this.shaCoefficients.getIntercept();
            for (int i7 = 0; i7 < 11; ++i7) {
                for (int j = 0; j < 11; ++j) {
                    n_err_avg = 0.0;
                    n_err_sq = 0.0;
                    this.shaCoefficients.setIntercept(dd + (double)(i7 - 5) * avg_wl / 2000.0);
                    this.shaCoefficients.setFirst(this.shaCoefficients.getLenFirst() * (1.0 + (double)(j - 5) * 0.02));
                    for (int k = 0; k < peaks; ++k) {
                        n_err = 2000.0 * this.getLength((double)this.scanPeaksVoltage[k] * this.voltageStep) / this.interpolatedWL[k] - this.getPhase(this.interpolatedWL[k]) / Math.PI;
                        n_err -= (double)Math.round(n_err);
                        n_err_avg += n_err;
                        n_err_sq += n_err * n_err;
                    }
                    if (!((std_err = Math.sqrt((n_err_sq - (n_err_avg /= (double)peaks) * n_err_avg * (double)peaks) / (double)peaks)) < min_err)) continue;
                    min_err = std_err;
                    min_err_mean = n_err_avg;
                    min_err_i = i7;
                    min_err_j = j;
                }
            }
            if (!(min_err > 0.28) || !this.sat) {
                // empty if block
            }
            if (!(min_err > 0.14) || !this.sat) {
                // empty if block
            }
            this.shaCoefficients.setFirst(this.shaCoefficients.getLenFirst() * (1.0 + (double)(min_err_j - 5) * 0.02));
            this.shaCoefficients.setIntercept(dd - avg_wl / 2000.0 * min_err_mean + (double)(min_err_i - 5) * avg_wl / 2000.0);
        } else if (peaks == 2) {
            double n_err = 2000.0 * this.getLength((double)this.scanPeaksVoltage[0] * this.voltageStep) / this.interpolatedWL[0] - this.getPhase(this.interpolatedWL[0]) / Math.PI;
            n_err += 2.0 * this.getLength((double)this.scanPeaksVoltage[1] * this.voltageStep) / this.interpolatedWL[1] - this.getPhase(this.interpolatedWL[1]) / Math.PI;
            n_err = n_err / 2.0 - (double)Math.round(n_err / 2.0);
            this.shaCoefficients.setIntercept(this.shaCoefficients.getIntercept() - (this.interpolatedWL[0] + this.interpolatedWL[1]) / 4000.0 * n_err);
            double dd = this.shaCoefficients.getIntercept();
        } else if (peaks == 1) {
            double n_err = 2000.0 * this.getLength((double)this.scanPeaksVoltage[0] * this.voltageStep) / this.interpolatedWL[0] - this.getPhase(this.interpolatedWL[0]) / Math.PI;
            n_err -= (double)Math.round(n_err);
            this.shaCoefficients.setIntercept(this.shaCoefficients.getIntercept() - this.interpolatedWL[0] / 2000.0 * n_err);
        }
        int n0 = (int)Math.floor(2000.0 * this.getLength(this.voltageEnd) / startWL - this.getPhase(startWL) / Math.PI);
        if (this.shaCoefficients.getScanDirection() == 2) {
            n0 = (int)Math.ceil(2000.0 * this.getLength(this.voltageEnd) / startWL - this.getPhase(startWL) / Math.PI);
        }
        if ((voltage = this.getVoltage(d_start = ((double)n0 + this.getPhase(startWL) / Math.PI) * startWL / 2000.0)) < 0.0) {
            voltage = 0.0;
        }
        long dstep = (long)Math.ceil(voltage / this.voltageStep);
        if (this.shaCoefficients.getScanDirection() == 2) {
            dstep = (long)Math.floor(voltage / this.voltageStep);
        }
        double dd = this.getLength((double)dstep * this.voltageStep);
        double wl = this.getEtalonPeakWl(n0, 1000.0 * dd, startWL);
        double[][] data = new double[(int)Math.ceil((double)(nStart - nEnd) * 1.1) + 1][101];
        double[][] hWL = new double[(int)Math.ceil((double)(nStart - nEnd) * 1.1) + 1][101];
        int order = 0;
        int point = 0;
        int totalPoints = 0;
        int[] stepsInOrder = new int[(int)Math.ceil((double)(nStart - nEnd) * 1.1) + 1];
        double wlstart = this.getEtalonPeakWl(n0 - 1, 1000.0 * this.getLength(this.voltageEnd), wl);
        double dstart = ((double)n0 + this.getPhase(wlstart) / Math.PI) * wlstart / 2000.0;
        int stepstart = (int)Math.ceil(this.getVoltage(dstart) / this.voltageStep);
        int step = (int)dstep;
        while (wl < endWL) {
            double tempMax;
            double peakPix = this.calcPixel(wl);
            if (peakPix < 0.0) {
                peakPix = 0.0;
            }
            int peak = 0;
            double peakInterp = 0.0;
            double fsrPixel = wl * wl / 2000.0 / dd;
            fsrPixel = this.calcPixel(wl + fsrPixel) - this.calcPixel(wl);
            double range = fsrPixel / 2.0 * 1.0;
            int startPixel = (int)Math.round(peakPix - range);
            int endPixel = (int)Math.round(peakPix + range);
            if (startPixel < 1) {
                startPixel = 1;
            }
            if (endPixel > pixels - 2) {
                endPixel = pixels - 2;
            }
            for (i = startPixel; i <= endPixel; ++i) {
                double peakTemp;
                if (!(this.adjustedData[step][i] >= this.adjustedData[step][i + 1]) || !(this.adjustedData[step][i] > this.adjustedData[step][i - 1]) || !(Math.abs((peakTemp = this.findPeak(this.adjustedData[step], i)) - peakPix) < range)) continue;
                if (peak > 0) {
                    if (this.adjustedData[step][i] > 2.0 * (maxDark - avgDarkD)) {
                        if (!(this.adjustedData[step][i] > this.adjustedData[step][peak])) continue;
                        peakInterp = peakTemp;
                        peak = i;
                        continue;
                    }
                    if (!(Math.abs(peakTemp - peakPix) < Math.abs(peakInterp - peakPix))) continue;
                    peakInterp = peakTemp;
                    peak = i;
                    continue;
                }
                peakInterp = peakTemp;
                peak = i;
            }
            if (peak == 0) {
                peak = (int)Math.round(peakPix);
                peakInterp = peak;
                tempMax = this.adjustedData[step][peak];
            } else {
                double offset = peakInterp - (double)Math.round(peakInterp - 1.0E-4);
                tempMax = offset >= 0.0 ? 0.56 * (this.adjustedData[step][peak] + this.adjustedData[step][peak + 1]) : 0.56 * (this.adjustedData[step][peak] + this.adjustedData[step][peak - 1]);
            }
            data[order][point] = tempMax;
            hWL[order][point] = wl;
            step = this.shaCoefficients.getScanDirection() == 2 ? --step : ++step;
            ++point;
            ++totalPoints;
            if (this.shaCoefficients.getScanDirection() == 2) {
                if (step <= stepstart) {
                    --n0;
                    stepsInOrder[order] = point;
                    ++order;
                    voltage = this.voltageEnd;
                    step = (int)Math.round(voltage / this.voltageStep);
                    point = 0;
                    wlstart = this.getEtalonPeakWl(n0 - 1, 1000.0 * this.getLength(this.voltageEnd), wl);
                    dstart = ((double)n0 + this.getPhase(wlstart) / Math.PI) * wlstart / 2000.0;
                    stepstart = (int)Math.ceil(this.getVoltage(dstart) / this.voltageStep);
                }
            } else if (step >= this.numberVoltageSteps) {
                --n0;
                stepsInOrder[order] = point;
                ++order;
                dd = ((double)n0 + this.getPhase(wl) / Math.PI) * wl / 2000.0;
                voltage = this.getVoltage(dd);
                if (voltage < 0.0) {
                    voltage = 0.0;
                }
                if (voltage > 5.0) {
                    voltage = 5.0;
                }
                step = (int)Math.ceil(voltage / this.voltageStep);
                point = 0;
            }
            dd = this.getLength((double)step * this.voltageStep);
            wl = this.getEtalonPeakWl(n0, dd * 1000.0, wl);
        }
        stepsInOrder[order] = point;
        ++order;
        point = 0;
        this.size = totalPoints;
        if (this.size > this.numberOfPixels) {
            this.numberOfPixels = this.size;
        }
        this.processedData = new double[totalPoints];
        this.processedWL = new double[totalPoints];
        for (i = 0; i < order; ++i) {
            for (int j = 0; j < stepsInOrder[i]; ++j) {
                this.processedData[point] = data[i][j];
                this.processedWL[point] = hWL[i][j];
                ++point;
            }
        }
    }

    public double findPeak(double[] data, int pos) {
        double v0 = data[pos - 1];
        double v1 = data[pos];
        double v2 = data[pos + 1];
        if (v0 < 0.0 || v1 < 0.0 || v2 < 0.0) {
            return pos;
        }
        double l10 = Math.log(v1 / v0);
        double l12 = Math.log(v1 / v2);
        double d = (double)pos + 0.5 * (2.0 * l10 / (l10 + l12) - 1.0);
        return d;
    }

    private void swap(int i, int j) {
        double temp = this.amplitudes[i];
        this.amplitudes[i] = this.amplitudes[j];
        this.amplitudes[j] = temp;
        int tempi = this.scanPeaksWL[i];
        this.scanPeaksWL[i] = this.scanPeaksWL[j];
        this.scanPeaksWL[j] = tempi;
        tempi = this.scanPeaksVoltage[i];
        this.scanPeaksVoltage[i] = this.scanPeaksVoltage[j];
        this.scanPeaksVoltage[j] = tempi;
    }

    private int partition(int begin, int end) {
        int index = begin + RANDOM.nextInt(end - begin + 1);
        double pivot = this.amplitudes[index];
        this.swap(index, end);
        for (int i = index = begin; i < end; ++i) {
            if (!(this.amplitudes[i] >= pivot)) continue;
            this.swap(index++, i);
        }
        this.swap(index, end);
        return index;
    }

    private void qSort(int begin, int end) {
        if (end > begin) {
            int index = this.partition(begin, end);
            this.qSort(begin, index - 1);
            this.qSort(index + 1, end);
        }
    }

    public void sortPeaks(int length) {
        this.qSort(0, length - 1);
    }

    public double getLength(double voltage) {
        double length = this.shaCoefficients.getIntercept() + voltage * this.shaCoefficients.getFirst() + voltage * voltage * this.shaCoefficients.getSecond();
        return length;
    }

    private double getVoltage(double length) {
        double voltage = this.shaCoefficients.getScanDirection() == 2 ? (-this.shaCoefficients.getFirst() - Math.sqrt(4.0 * this.shaCoefficients.getSecond() * (length - this.shaCoefficients.getIntercept()) + this.shaCoefficients.getFirst() * this.shaCoefficients.getFirst())) / 2.0 / this.shaCoefficients.getSecond() : (-this.shaCoefficients.getFirst() - Math.sqrt(4.0 * this.shaCoefficients.getSecond() * (length - this.shaCoefficients.getIntercept()) + this.shaCoefficients.getFirst() * this.shaCoefficients.getFirst())) / 2.0 / this.shaCoefficients.getSecond();
        if (voltage < 0.0) {
            voltage = 0.0;
        }
        if (voltage > 5.0) {
            voltage = 5.0;
        }
        return voltage;
    }

    protected void getPhaseData() {
        String curDir = System.getProperty("user.dir");
        try {
            File infilef = new File(curDir + "/config/phaseHR4000.txt");
            System.out.println("file path: " + infilef.getAbsolutePath());
            this.logger.fine("file path: " + infilef.getAbsolutePath());
            FileReader in = new FileReader(infilef);
            String num = null;
            BufferedReader br = new BufferedReader(in);
            int i = 0;
            double[] phasePoints = this.shaCoefficients.getPhasePoints();
            while ((num = br.readLine()) != null) {
                phasePoints[i] = Double.parseDouble(num);
                ++i;
            }
            in.close();
        }
        catch (IOException e) {
            System.out.println("Unable to load adapter phase data.\nMake sure that phaseHR4000.txt file is in the program directory.");
            this.logger.severe("Unable to load adapter phase data.\nMake sure that phaseHR4000.txt file is in the program directory.");
        }
    }

    private double getEtalonPeakWl(int order, double d, double swl) {
        double tolerance = 0.2;
        double wl = 2.0 * d / ((double)order + this.getPhase(swl) / Math.PI);
        for (int i = 0; Math.abs(wl - swl) > tolerance && i < 10; ++i) {
            swl = wl;
            wl = 2.0 * d / ((double)order + this.getPhase(swl) / Math.PI);
        }
        return wl;
    }

    public double getPhase(double wl) {
        double[] phasePoints = this.shaCoefficients.getPhasePoints();
        if (wl <= this.shaCoefficients.getPhaseStart()) {
            return this.shaCoefficients.getPhasePoints()[0];
        }
        if (wl >= this.shaCoefficients.getPhaseEnd()) {
            return phasePoints[this.shaCoefficients.getNumberOfPhasePoints() - 1];
        }
        double index = (wl - this.shaCoefficients.getPhaseStart()) / this.shaCoefficients.getPhaseStep();
        int ind1 = (int)index;
        double ind2 = index - Math.floor(index);
        double d = (1.0 - ind2) * phasePoints[ind1] + phasePoints[ind1 + 1] * ind2;
        return d;
    }

    public int getMaxNumberOfCounts() {
        int counts = 0;
        if (this.spectrometer instanceof HR4000 || this.spectrometer instanceof USB4000) {
            counts = 16384;
        } else if (this.spectrometer instanceof HR2000 || this.spectrometer instanceof USB2000) {
            counts = 4096;
        }
        return counts;
    }

    public void getSHACoefficientsFromDevice() {
        try {
            this.serialNumber = this.getConstant(0);
            this.firmwareVersion = this.getConstant(1);
            this.shaCoefficients.setLenIntercept(Double.parseDouble(this.getConstant(2)));
            this.shaCoefficients.setLenFirst(Double.parseDouble(this.getConstant(3)));
            this.shaCoefficients.setLenSecond(Double.parseDouble(this.getConstant(4)));
            this.shaCoefficients.setPhaseIntercept(Double.parseDouble(this.getConstant(5)));
            this.shaCoefficients.setPhaseFirst(Double.parseDouble(this.getConstant(6)));
            this.shaCoefficients.setPhaseSecond(Double.parseDouble(this.getConstant(7)));
            this.shaCoefficients.setPivotWavelength(Double.parseDouble(this.getConstant(8)));
            this.shaCoefficients.setPhaseRangeStart(Double.parseDouble(this.getConstant(9)));
            this.shaCoefficients.setPhaseRangeEnd(Double.parseDouble(this.getConstant(10)));
            if (this.firmwareVersion.equals("1.01.00")) {
                this.shaCoefficients.setDefaultIntercept(Double.parseDouble(this.getConstant(12)));
                this.shaCoefficients.setDefaultFirst(Double.parseDouble(this.getConstant(13)));
                this.shaCoefficients.setDefaultSecond(Double.parseDouble(this.getConstant(14)));
                this.shaCoefficients.setPhaseStep(Double.parseDouble(this.getConstant(15)));
                this.shaCoefficients.setPhaseStart(Double.parseDouble(this.getConstant(16)));
                this.shaCoefficients.setPhaseEnd(Double.parseDouble(this.getConstant(17)));
                String direction = this.getConstant(11);
                if (direction.equals("negative")) {
                    this.shaCoefficients.setScanDirection(2);
                } else {
                    this.shaCoefficients.setScanDirection(1);
                }
                this.shaCoefficients.setNumberOfPhasePoints(1 + (int)Math.round((this.shaCoefficients.getPhaseEnd() - this.shaCoefficients.getPhaseStart()) / this.shaCoefficients.getPhaseStep()));
            }
            this.shaCoefficients.setIntercept(this.shaCoefficients.getLenIntercept());
            this.shaCoefficients.setFirst(this.shaCoefficients.getLenFirst());
            this.shaCoefficients.setSecond(this.shaCoefficients.getLenSecond());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            System.out.println("Unable to read Adapter Parameters.");
            this.logger.warning("Unable to read Adapter Parameters.");
        }
    }

    public String getConstant(int slot) {
        String str = "";
        byte[] data = new byte[16];
        ((HR4000)this.spectrometer).readHyperAdapterEEPROM(data, slot * 16, 16);
        for (int i = 0; i < 16 && data[i] != 0; ++i) {
            str = str + (char)data[i];
        }
        return str;
    }

    public void saveSHACoefficients() {
        this.saveConstant(0, this.serialNumber);
        this.saveConstant(1, this.firmwareVersion);
        this.saveConstant(2, Double.toString(this.shaCoefficients.getLenIntercept()));
        this.saveConstant(3, Double.toString(this.shaCoefficients.getLenFirst()));
        this.saveConstant(4, Double.toString(this.shaCoefficients.getLenSecond()));
        this.saveConstant(5, Double.toString(this.shaCoefficients.getPhaseIntercept()));
        this.saveConstant(6, Double.toString(this.shaCoefficients.getPhaseFirst()));
        this.saveConstant(7, Double.toString(this.shaCoefficients.getPhaseSecond()));
        this.saveConstant(8, Double.toString(this.shaCoefficients.getPivotWavelength()));
        this.saveConstant(9, Double.toString(this.shaCoefficients.getPhaseRangeStart()));
        this.saveConstant(10, Double.toString(this.shaCoefficients.getPhaseRangeEnd()));
    }

    public int saveConstant(int slot, String str) {
        int i;
        byte[] dataOut = new byte[16];
        for (i = 0; i < 16; ++i) {
            dataOut[i] = 0;
        }
        try {
            byte[] data = str.getBytes("US-ASCII");
            for (i = 0; i < data.length; ++i) {
                dataOut[i] = data[i];
            }
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return ((HR4000)this.spectrometer).writeHyperAdapterEEPROM(dataOut, slot * 16, 16);
    }

    protected void fixNumberOfPixels() {
        int pix = this.processedData.length;
        int dark = this.numberOfDarkPixels;
        if (pix > this.numberOfPixels || dark != this.numberOfDarkPixels) {
            this.numberOfPixels = pix;
            this.numberOfDarkPixels = dark;
            this.logger.finer("Resizing Spectrum");
            this.wavelengths = this.getAllWavelengths();
            this.spectrometerChannelInfo.setChannelWavelengths(this.wavelengths);
        }
    }

    public int getPixel(double wl) {
        int i;
        for (i = 0; this.getWavelength(i) < wl && i < this.numberOfSpectrometerPixels; ++i) {
        }
        return i;
    }

    public int calcPixel(double wl) {
        double pix = (-this.coefficients.getWlFirst() + Math.sqrt(4.0 * this.coefficients.getWlSecond() * (wl - this.coefficients.getWlIntercept()) + this.coefficients.getWlFirst() * this.coefficients.getWlFirst())) / 2.0 / this.coefficients.getWlSecond();
        return (int)pix;
    }

    public double getWavelength(int pixel) {
        double dp = pixel;
        return this.coefficients.getWlIntercept() + dp * this.coefficients.getWlFirst() + dp * dp * this.coefficients.getWlSecond() + dp * dp * dp * this.coefficients.getWlThird();
    }

    public double getWavelength(double pixel) {
        double dp = pixel;
        return this.coefficients.getWlIntercept() + dp * this.coefficients.getWlFirst() + dp * dp * this.coefficients.getWlSecond() + dp * dp * dp * this.coefficients.getWlThird();
    }

    public double[] getAllWavelengths() {
        this.wavelengths = new double[this.numberOfPixels];
        this.wavelengths[0] = this.getStartingWavelength();
        this.wavelengths[this.numberOfPixels - 1] = this.getWavelength(this.numberOfSpectrometerPixels - 1);
        double step = (this.wavelengths[this.numberOfPixels - 1] - this.wavelengths[0]) / (double)this.numberOfPixels;
        for (int i = 1; i < this.wavelengths.length; ++i) {
            this.wavelengths[i] = this.wavelengths[i - 1] + step;
        }
        return this.wavelengths;
    }

    private double[] getWavelengths(int pixels) {
        double[] wl = new double[pixels];
        for (int i = 0; i < pixels; ++i) {
            wl[i] = this.getWavelength(i);
        }
        return wl;
    }

    public SHACoefficients getSHACoefficients() {
        return this.shaCoefficients;
    }

    public int getNumberOfVoltageSteps() {
        return this.numberVoltageSteps;
    }

    protected double getSHAWavelength(int pixel) {
        return this.processedWL[pixel];
    }

    public int getNumberOfSpectrometerPixels() {
        return this.numberOfSpectrometerPixels;
    }

    public String getSHASerialNumber() {
        return this.serialNumber;
    }

    public String getSHAFirmwareVersion() {
        return this.firmwareVersion;
    }

    public double getCalibrationConstants(double[][] rawData) {
        double n_err;
        int maxCounts = this.getMaxNumberOfCounts();
        int satCount = (int)(0.95 * (double)maxCounts);
        int pixels = this.getNumberOfSpectrometerPixels();
        int darkPixels = this.numberOfDarkPixels;
        double[] wl = this.getWavelengths(pixels);
        double startWL = wl[0];
        double endWL = wl[pixels - 1];
        this.shaCoefficients.setIntercept(this.shaCoefficients.getLenIntercept());
        this.shaCoefficients.setFirst(this.shaCoefficients.getLenFirst());
        this.shaCoefficients.setSecond(this.shaCoefficients.getLenSecond());
        double maxDark = 0.0;
        double avgDark = 0.0;
        for (int i = 0; i < this.numberVoltageSteps; ++i) {
            if (rawData[i][darkPixels - 1] > maxDark) {
                maxDark = rawData[i][darkPixels - 2];
            }
            if (rawData[i][darkPixels - 2] > maxDark) {
                maxDark = rawData[i][darkPixels - 3];
            }
            avgDark += rawData[i][darkPixels - 1] + rawData[i][darkPixels - 2];
        }
        double avgDarkD = avgDark / (2.0 * (double)this.numberVoltageSteps);
        this.adjustedData = new double[this.numberVoltageSteps][pixels];
        for (int i = 0; i < this.numberVoltageSteps; ++i) {
            for (int j = 0; j < pixels; ++j) {
                this.adjustedData[i][j] = rawData[i][j] - avgDarkD;
            }
        }
        int nStart = (int)Math.ceil(2000.0 * this.getLength(0.0) / startWL - this.getPhase(startWL) / Math.PI);
        int nEnd = (int)Math.ceil(2000.0 * this.getLength(0.0) / endWL - this.getPhase(endWL) / Math.PI);
        int maxPoints = (nStart - nEnd) * this.numberVoltageSteps;
        int numPeaks = 0;
        this.scanPeaksWL = new int[maxPoints / 5];
        this.scanPeaksVoltage = new int[maxPoints / 5];
        this.amplitudes = new double[maxPoints / 5];
        for (int i = 1; i < this.numberVoltageSteps - 1; ++i) {
            for (int j = darkPixels + 1; j < pixels - 1; ++j) {
                if (!(this.adjustedData[i][j] > maxDark * 1.5) || numPeaks >= maxPoints / 5 || !(this.adjustedData[i][j] > this.adjustedData[i][j + 1]) || !(this.adjustedData[i][j] > this.adjustedData[i][j - 1]) || !(this.adjustedData[i][j] > this.adjustedData[i - 1][j]) || !(this.adjustedData[i][j] > this.adjustedData[i + 1][j])) continue;
                boolean foundPeak = false;
                double currentWL = wl[j];
                double wlSpacing = currentWL * currentWL / 2.0 / this.shaCoefficients.getIntercept() / 1000.0;
                int spacing = (int)(wlSpacing / (currentWL - wl[j - 1]));
                if (j - spacing / 2 < 1) {
                    spacing = j * 2 - 1;
                }
                if (this.getLargestPeak(this.adjustedData[i], j - 1, j - spacing / 2) < this.adjustedData[i][j]) {
                    foundPeak = true;
                    if (numPeaks > 0 && this.scanPeaksVoltage[numPeaks - 1] == i && j - spacing + 2 < this.scanPeaksWL[numPeaks - 1]) {
                        --numPeaks;
                    }
                }
                if (!foundPeak) continue;
                this.scanPeaksWL[numPeaks] = j;
                this.scanPeaksVoltage[numPeaks] = i;
                this.amplitudes[numPeaks] = this.adjustedData[i][j];
                ++numPeaks;
            }
        }
        this.sortPeaks(numPeaks);
        this.sat = this.amplitudes[0] > (double)satCount;
        int peaks = 0;
        double threshold = 0.1 * this.amplitudes[0];
        if (threshold < 0.0) {
            threshold = 0.0;
        }
        while (peaks < numPeaks && this.amplitudes[peaks] > threshold) {
            ++peaks;
        }
        if (peaks < 100) {
            return -1.0;
        }
        this.interpolatedWL = new double[peaks];
        for (int i = 0; i < peaks; ++i) {
            this.interpolatedWL[i] = wl[(int)this.findPeak(this.adjustedData[this.scanPeaksVoltage[i]], this.scanPeaksWL[i])];
        }
        double avg_wl = 0.0;
        double n_err_avg = 0.0;
        double n_err_sq = 0.0;
        double n_err_avg_plus = 0.0;
        double n_err_sq_plus = 0.0;
        for (int i = 0; i < peaks; ++i) {
            avg_wl += this.interpolatedWL[i];
            n_err = 2000.0 * this.getLength((double)this.scanPeaksVoltage[i] * this.voltageStep) / this.interpolatedWL[i] - this.getPhase(this.interpolatedWL[i]) / Math.PI;
            double n_err_plus = n_err + 0.5;
            n_err -= (double)Math.round(n_err);
            n_err_plus -= (double)Math.round(n_err_plus);
            n_err_avg += n_err;
            n_err_avg_plus += n_err_plus;
            n_err_sq += n_err * n_err;
            n_err_sq_plus += n_err_plus * n_err_plus;
        }
        avg_wl /= (double)peaks;
        n_err_avg /= (double)peaks;
        double std_err_plus = Math.sqrt((n_err_sq_plus - (n_err_avg_plus /= (double)peaks) * n_err_avg_plus * (double)peaks) / (double)peaks);
        double std_err = Math.sqrt((n_err_sq - n_err_avg * n_err_avg * (double)peaks) / (double)peaks);
        if (std_err <= std_err_plus) {
            this.shaCoefficients.setIntercept(this.shaCoefficients.getLenIntercept() - avg_wl / 2000.0 * n_err_avg);
        } else {
            this.shaCoefficients.setIntercept(this.shaCoefficients.getLenIntercept() - avg_wl / 2000.0 * (0.5 + n_err_avg_plus));
        }
        boolean atMin = false;
        int ioffset = 0;
        int joffset = 0;
        int poffset = 0;
        int count = 0;
        double min_err = 0.0;
        double dd = 0.0;
        int min_err_i = 0;
        int min_err_j = 0;
        int min_err_p = 0;
        while (!atMin && count < 100) {
            min_err = 0.5;
            double min_err_mean = 0.0;
            min_err_i = 0;
            min_err_j = 0;
            min_err_p = 0;
            dd = this.shaCoefficients.getIntercept();
            for (int i = 0; i < 11; ++i) {
                for (int j = 0; j < 11; ++j) {
                    for (int p = 0; p < 11; ++p) {
                        n_err_avg = 0.0;
                        n_err_sq = 0.0;
                        this.shaCoefficients.setIntercept(dd + (double)(i + ioffset - 5) * avg_wl / 2000.0);
                        this.shaCoefficients.setFirst(this.shaCoefficients.getLenFirst() * (1.0 + (double)(j + joffset - 5) * 0.01));
                        this.shaCoefficients.setSecond(this.shaCoefficients.getLenSecond() * (1.0 + (double)(p + poffset - 5) * 0.01));
                        for (int k = 0; k < peaks; ++k) {
                            n_err = 2000.0 * this.getLength((double)this.scanPeaksVoltage[k] * this.voltageStep) / this.interpolatedWL[k] - this.getPhase(this.interpolatedWL[k]) / Math.PI;
                            n_err -= (double)Math.round(n_err);
                            n_err_avg += n_err;
                            n_err_sq += n_err * n_err;
                        }
                        if (!((std_err = Math.sqrt((n_err_sq - (n_err_avg /= (double)peaks) * n_err_avg * (double)peaks) / (double)peaks)) < min_err)) continue;
                        min_err = std_err;
                        min_err_mean = n_err_avg;
                        min_err_i = i;
                        min_err_j = j;
                        min_err_p = p;
                    }
                }
            }
            if (min_err_i == 0 || min_err_j == 0 || min_err_i == 11 || min_err_j == 10 || min_err_p == 10 || min_err_p == 10) {
                ioffset += min_err_i - 5;
                joffset += min_err_j - 5;
                poffset += min_err_p - 5;
                ++count;
            } else {
                atMin = true;
            }
            dd -= avg_wl / 2000.0 * min_err_mean;
        }
        this.shaCoefficients.setSecond(this.shaCoefficients.getLenSecond() * (1.0 + (double)(min_err_p + poffset - 5) * 0.01));
        this.shaCoefficients.setFirst(this.shaCoefficients.getLenFirst() * (1.0 + (double)(min_err_j + joffset - 5) * 0.01));
        this.shaCoefficients.setIntercept(dd + (double)(min_err_i + ioffset - 5) * avg_wl / 2000.0);
        if (!atMin) {
            return -1.0;
        }
        return min_err;
    }

    private double getLargestPeak(double[] data, int end, int start) {
        if (start > end) {
            return 0.0;
        }
        double peakval = 0.0;
        double prev = 0.0;
        double curr = data[start - 1];
        double next = data[start];
        for (int j = start; j <= end; ++j) {
            prev = curr;
            curr = next;
            next = data[j + 1];
            if (!(curr > prev) || !(curr >= next) || !(data[j] > peakval)) continue;
            peakval = data[j];
        }
        return peakval;
    }
}

