/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.sts;

import com.oceanoptics.omnidriver.spectrometer.Configuration;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.sts.STS;
import com.oceanoptics.omnidriver.spectrometer.sts.STSBench;
import java.io.IOException;

public class STSConfiguration
extends Configuration {
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/spectrometer/Spectrometer;)V\ngetConfigurationFromSpectrometer,()V\nsetConfigurationToSpectrometer,()V\nisBenchDefined,()Z\nisCPLDVersionDefined,()Z\nisDetectorSerialNumberDefined,()Z\nisSpectrometerConfigurationDefined,()Z\n";

    public STSConfiguration(Spectrometer spec) throws IOException {
        super(spec);
    }

    public void getConfigurationFromSpectrometer() throws IOException {
        this.bench = new STSBench();
        STSBench _bench = (STSBench)this.bench;
        _bench.setSlitSize(this.readBenchSlitWidth());
        _bench.setFiberDiameter(this.readBenchFiberDiameter());
        _bench.setFilterWavelength(this.readBenchFilter());
        _bench.setGrating(this.readBenchGrating());
        _bench.setID(this.readBenchID());
        this.detector.setArrayCoatingMfg(this.readDetectorCoating());
        this.detector.setSerialNumber(this.readBenchSerialNumber());
    }

    public void setConfigurationToSpectrometer() throws IOException {
        this.writeBenchSlitWidth();
        this.writeBenchFiberDiameter();
        this.writeBenchFilter();
        this.writeBenchGrating();
        this.writeBenchID();
        this.writeBenchSerialNumber();
        this.writeDetectorCoating();
    }

    private String readBenchID() throws IOException {
        if (this.spectrometer instanceof STS) {
            byte[] benchID = ((STS)this.spectrometer).readBenchID();
            if (benchID == null) {
                return "";
            }
            String retval = new String();
            for (int i = 0; i < benchID.length; ++i) {
                retval = retval + (char)benchID[i];
            }
            return retval;
        }
        return null;
    }

    private void writeBenchID() throws IOException {
        String id;
        STSBench _bench = (STSBench)this.bench;
        if (this.spectrometer instanceof STS && null != (id = _bench.getID())) {
            byte[] bytes = id.getBytes("US-ASCII");
            ((STS)this.spectrometer).writeBenchID(bytes);
        }
    }

    private String readBenchSerialNumber() throws IOException {
        if (this.spectrometer instanceof STS) {
            byte[] sn = ((STS)this.spectrometer).readBenchSerialNumber();
            if (sn == null) {
                return "";
            }
            String retval = new String();
            for (int i = 0; i < sn.length; ++i) {
                retval = retval + (char)sn[i];
            }
            return retval;
        }
        return null;
    }

    private void writeBenchSerialNumber() throws IOException {
        String sn;
        if (this.spectrometer instanceof STS && null != (sn = this.detector.getSerialNumber())) {
            byte[] bytes = sn.getBytes("US-ASCII");
            ((STS)this.spectrometer).writeBenchSerialNumber(bytes);
        }
    }

    private String readBenchSlitWidth() throws IOException {
        if (this.spectrometer instanceof STS) {
            Integer width = ((STS)this.spectrometer).readSlitWidthMicrons();
            if (null == width) {
                return null;
            }
            return width.toString();
        }
        return null;
    }

    private void writeBenchSlitWidth() throws IOException {
        String slit;
        STSBench _bench = (STSBench)this.bench;
        if (this.spectrometer instanceof STS && null != (slit = _bench.getSlitSize())) {
            try {
                short value = Short.parseShort(slit);
                ((STS)this.spectrometer).writeSlitWidthMicrons(value);
            }
            catch (NumberFormatException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private String readBenchFiberDiameter() throws IOException {
        if (this.spectrometer instanceof STS) {
            Integer dia = ((STS)this.spectrometer).readFiberDiameterMicrons();
            if (null == dia) {
                return null;
            }
            return dia.toString();
        }
        return null;
    }

    private void writeBenchFiberDiameter() throws IOException {
        String dia;
        STSBench _bench = (STSBench)this.bench;
        if (this.spectrometer instanceof STS && null != (dia = _bench.getFiberDiameter())) {
            try {
                short value = Short.parseShort(dia);
                ((STS)this.spectrometer).writeFiberDiameterMicrons(value);
            }
            catch (NumberFormatException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private String readBenchFilter() throws IOException {
        if (this.spectrometer instanceof STS) {
            byte[] filter = ((STS)this.spectrometer).readFilter();
            if (filter == null) {
                return "";
            }
            String retval = new String();
            for (int i = 0; i < filter.length; ++i) {
                retval = retval + (char)filter[i];
            }
            return retval;
        }
        return null;
    }

    private void writeBenchFilter() throws IOException {
        String filter;
        STSBench _bench = (STSBench)this.bench;
        if (this.spectrometer instanceof STS && null != (filter = _bench.getFilterWavelength())) {
            byte[] bytes = filter.getBytes("US-ASCII");
            ((STS)this.spectrometer).writeFilter(bytes);
        }
    }

    private String readBenchGrating() throws IOException {
        if (this.spectrometer instanceof STS) {
            byte[] grating = ((STS)this.spectrometer).readGrating();
            if (grating == null) {
                return "";
            }
            String retval = new String();
            for (int i = 0; i < grating.length; ++i) {
                retval = retval + (char)grating[i];
            }
            return retval;
        }
        return null;
    }

    private void writeBenchGrating() throws IOException {
        String grating;
        STSBench _bench = (STSBench)this.bench;
        if (this.spectrometer instanceof STS && null != (grating = _bench.getGrating())) {
            byte[] bytes = grating.getBytes("US-ASCII");
            ((STS)this.spectrometer).writeGrating(bytes);
        }
    }

    private String readDetectorCoating() throws IOException {
        if (this.spectrometer instanceof STS) {
            byte[] coating = ((STS)this.spectrometer).readCoating();
            if (coating == null) {
                return "";
            }
            String retval = new String();
            for (int i = 0; i < coating.length; ++i) {
                retval = retval + (char)coating[i];
            }
            return retval;
        }
        return null;
    }

    private void writeDetectorCoating() throws IOException {
        String coating;
        STSBench _bench = (STSBench)this.bench;
        if (this.spectrometer instanceof STS && null != (coating = this.detector.getArrayCoatingMfg())) {
            byte[] bytes = coating.getBytes("US-ASCII");
            ((STS)this.spectrometer).writeCoating(bytes);
        }
    }

    public boolean isBenchDefined() {
        return true;
    }

    public boolean isCPLDVersionDefined() {
        return false;
    }

    public boolean isDetectorSerialNumberDefined() {
        return false;
    }

    public boolean isSpectrometerConfigurationDefined() {
        return true;
    }
}

