/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.usb2kp;

import com.oceanoptics.omnidriver.constants.ExternalTriggerMode;
import com.oceanoptics.omnidriver.features.advancedintegrationclock.AdvancedIntegrationClock;
import com.oceanoptics.omnidriver.features.advancedintegrationclock.AdvancedIntegrationClockImpl;
import com.oceanoptics.omnidriver.features.advancedversion.AdvancedVersion;
import com.oceanoptics.omnidriver.features.advancedversion.AdvancedVersionImpl;
import com.oceanoptics.omnidriver.features.autonulling.Autonulling;
import com.oceanoptics.omnidriver.features.autonulling.AutonullingConfiguration;
import com.oceanoptics.omnidriver.features.autonulling.AutonullingGUIProvider;
import com.oceanoptics.omnidriver.features.autonulling.AutonullingImpl;
import com.oceanoptics.omnidriver.features.boardtemperature.BoardTemperature;
import com.oceanoptics.omnidriver.features.boardtemperature.BoardTemperatureGUIProvider;
import com.oceanoptics.omnidriver.features.boardtemperature.BoardTemperatureImpl;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobe;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobeGUIProvider;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobeImpl;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobeImpl_FPGA;
import com.oceanoptics.omnidriver.features.externaltriggerdelay.ExternalTriggerDelay;
import com.oceanoptics.omnidriver.features.externaltriggerdelay.ExternalTriggerDelayGUIProvider;
import com.oceanoptics.omnidriver.features.externaltriggerdelay.ExternalTriggerDelayImpl;
import com.oceanoptics.omnidriver.features.gpio.GPIO;
import com.oceanoptics.omnidriver.features.gpio.GPIOGUIProvider;
import com.oceanoptics.omnidriver.features.gpio.GPIOImpl;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTrigger;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTriggerImpl;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTriggerImplFPGA;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBus;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBusGUIProvider;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBusImpl;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBusImplFPGA;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactor;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactorGUIProvider;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactorImpl;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactorImplFPGA;
import com.oceanoptics.omnidriver.features.masterclockdivisor.MasterClockDivisor;
import com.oceanoptics.omnidriver.features.masterclockdivisor.MasterClockDivisorImpl;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionImpl;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionProvider;
import com.oceanoptics.omnidriver.features.pluginprovider.PlugInProvider;
import com.oceanoptics.omnidriver.features.pluginprovider.PlugInProviderImpl;
import com.oceanoptics.omnidriver.features.pluginprovider.PlugInProviderImplFPGA;
import com.oceanoptics.omnidriver.features.shutterclock.ShutterClock;
import com.oceanoptics.omnidriver.features.shutterclock.ShutterClockImpl;
import com.oceanoptics.omnidriver.features.singlestrobe.SingleStrobe;
import com.oceanoptics.omnidriver.features.singlestrobe.SingleStrobeGUIProvider;
import com.oceanoptics.omnidriver.features.singlestrobe.SingleStrobeImpl;
import com.oceanoptics.omnidriver.features.spibus.SPIBus;
import com.oceanoptics.omnidriver.features.spibus.SPIBusGUIProvider;
import com.oceanoptics.omnidriver.features.spibus.SPIBusImpl;
import com.oceanoptics.omnidriver.features.spibus.SPIBusImplFPGA;
import com.oceanoptics.omnidriver.features.statusprovider.StatusProvider;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrection;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionImpl;
import com.oceanoptics.omnidriver.features.version.Version;
import com.oceanoptics.omnidriver.features.version.VersionGUIProvider;
import com.oceanoptics.omnidriver.features.version.VersionImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationGUIProvider;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationProvider;
import com.oceanoptics.omnidriver.interfaces.AcquisitionListener;
import com.oceanoptics.omnidriver.interfaces.GUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBEndpointDevice;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.plugin.SpectrometerPlugIn;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerStatus;
import com.oceanoptics.omnidriver.spectrometer.USBSpectrometer;
import com.oceanoptics.omnidriver.spectrometer.usb2000plus.USB2000PlusStatus;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;

public abstract class USB2kp
extends USBSpectrometer
implements PlugInProvider,
I2CBus,
SPIBus,
AdvancedVersion,
StatusProvider,
ContinuousStrobe,
AdvancedIntegrationClock,
HardwareTrigger,
ShutterClock,
SingleStrobe,
GPIO,
BoardTemperature,
IrradianceCalibrationFactor,
MasterClockDivisor,
ExternalTriggerDelay,
NonlinearityCorrectionProvider,
WavelengthCalibrationProvider,
StrayLightCorrection,
Autonulling,
Version,
USBEndpointDevice {
    private PlugInProvider plugInProvider;
    private AdvancedVersion advancedVersion;
    private AdvancedIntegrationClock advancedIntegrationClock;
    private ShutterClock shutterClock;
    private MasterClockDivisor masterClockDivisor;
    private I2CBusGUIProvider i2cBus;
    private SPIBusGUIProvider spiBus;
    private GPIOGUIProvider gpio;
    private SingleStrobeGUIProvider singleStrobe;
    private HardwareTriggerImpl hardwareTrigger;
    private ContinuousStrobeGUIProvider continuousStrobe;
    private BoardTemperatureGUIProvider boardTemperature;
    private IrradianceCalibrationFactorGUIProvider irradianceCalibrationFactor;
    private ExternalTriggerDelayGUIProvider triggerDelay;
    private NonlinearityCorrectionGUIProvider nonlinearity;
    private WavelengthCalibrationGUIProvider wavelength;
    private StrayLightCorrectionGUIProvider straylight;
    private AutonullingGUIProvider autonulling;
    private AutonullingConfiguration autonullingConfiguration;
    private VersionGUIProvider version;
    private int NUMBER_GPIO_PINS = 8;
    private static final short DATA_OUT = 1;
    private static final short HIGH_SPEED_DATA_IN_1 = 130;
    private static final short HIGH_SPEED_DATA_IN_2 = 134;
    private static final short LOW_SPEED_DATA_IN = 129;
    private static final short MAX_PACKET_SIZE = 512;
    private static String __extern__ = "__extern__\nsetEndpoints,()V\ngetEndpoint,(I)Lcom/oceanoptics/uniusb/USBEndpointDescriptor;\nallowWriteToEEPROM,(II)Z\nopenSpectrometer,(I)V\ngetGUIFeatures,()[Lcom/oceanoptics/omnidriver/interfaces/GUIProvider;\ngetStatus,()Lcom/oceanoptics/omnidriver/spectrometer/SpectrometerStatus;\nreadIntegrationTime,()I\nsetStrobeDelay,(I)V\ntoString,()Ljava/lang/String;\ngetPlugIns,()[Lcom/oceanoptics/omnidriver/plugin/SpectrometerPlugIn;\ngetNumberOfPlugIns,()I\nisPlugInDetected,(I)Z\ninitializePlugIns,()[B\ndetectPlugIns,()V\nsetI2CBytes,(BB[B)I\ngetI2CBytes,(BB)[B\ngetSPIBytes,([BI)[B\ngetPSOCVersion,()Ljava/lang/String;\ngetFPGAFirmwareVersion,()Ljava/lang/String;\ncontinuousStrobeCountsToMicros,(I)D\nsetContinuousStrobeDelay,(I)V\ngetContinuousStrobeDelay,()Ljava/lang/Integer;\ngetContinuousStrobeDelayMinimum,()I\ngetContinuousStrobeDelayMaximum,()I\ngetContinuousStrobeDelayIncrement,(I)I\nsetAdvancedIntegrationTime,(J)V\ngetIntegrationTimeBaseClock,()I\ngetIntegrationClockTimer,()I\ngetAdvancedIntegrationTimeMinimum,()J\ngetAdvancedIntegrationTimeMaximum,()J\ngetAdvancedIntegrationTimeIncrement,()J\nsetExternalTriggerMode,(I)V\ngetExternalTriggerModes,()[Lcom/oceanoptics/omnidriver/constants/ExternalTriggerMode;\ngetExternalTriggerMode,()Ljava/lang/Integer;\nsetShutterClock,(I)V\ngetShutterClock,()I\nsetSingleStrobeLow,(I)V\nsetSingleStrobeHigh,(I)V\ngetSingleStrobeCountsToMicros,(I)D\ngetSingleStrobeLow,()I\ngetSingleStrobeHigh,()I\ngetSingleStrobeMinimum,()I\ngetSingleStrobeMaximum,()I\ngetSingleStrobeIncrement,()I\nsetDirectionAllBits,(Ljava/util/BitSet;)V\nsetMuxAllBits,(Ljava/util/BitSet;)V\nsetValueAllBits,(Ljava/util/BitSet;)V\nsetDirectionBitmask,(S)V\nsetMuxBitmask,(S)V\nsetValueBitmask,(S)V\nsetDirectionBit,(IZ)V\nsetMuxBit,(IZ)V\nsetValueBit,(IZ)V\ngetTotalGPIOBits,()I\ngetDirectionBits,()Ljava/util/BitSet;\ngetMuxBits,()Ljava/util/BitSet;\ngetValueBit,(I)I\ngetValueBits,()Ljava/util/BitSet;\ngetNumberOfPins,()I\ngetBoardTemperatureCelsius,()D\ngetIrradianceCalibrationFactors,()[D\nsetIrradianceCalibrationFactors,([D)V\ngetCollectionArea,()D\nhasCollectionArea,()Z\nsetCollectionArea,(D)V\nsetMasterClockDivisor,(I)V\ngetMasterClockDivisor,()I\nsetExternalTriggerDelay,(I)V\ntriggerDelayCountsToMicroseconds,(I)D\ngetExternalTriggerDelay,()Ljava/lang/Integer;\ngetExternalTriggerDelayMinimum,()I\ngetExternalTriggerDelayMaximum,()I\ngetExternalTriggerDelayIncrement,()I\nreadNonlinearityCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteNonlinearityCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetNonlinearityCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficientsSingleChannel,(I)[D\nsetNonlinearityCoefficientsSingleChannel,([DI)V\nreadWavelengthCalibrationCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteWavelengthCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengthCalibrationCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetWavelengthCalibrationCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengths,(I)[D\nsetWavelengths,([DI)V\nreadStrayLightCorrectionCoefficientFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteStrayLightCoefficientToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\nsetStrayLightCorrectionCoefficient,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetStrayLightCorrectionCoefficient,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetStrayLight,(DI)V\ngetStrayLight,(I)D\ngetAutonullingScanStatus,()I\ngetAutonullingScanValue,()I\nsetAutonullingScanStatus,(I)V\nsetAutonullingScanValue,(I)V\ngetAutonullingConfiguration,()Lcom/oceanoptics/omnidriver/features/autonulling/AutonullingConfiguration;\nsetAutonullingConfiguration,(Lcom/oceanoptics/omnidriver/features/autonulling/AutonullingConfiguration;)V\nwriteAutonullingConfigurationToSpectrometer,()V\nreadAutonullingConfigurationFromSpectrometer,()Lcom/oceanoptics/omnidriver/features/autonulling/AutonullingConfiguration;\nisAdvancedVersion,()Z\nuploadFirmware,(Ljava/io/File;J)V\nuploadFPGA,(Ljava/io/File;J)V\naddAcquisitionListener,(Lcom/oceanoptics/omnidriver/interfaces/AcquisitionListener;)V\nremoveAcquisitionListener,(Lcom/oceanoptics/omnidriver/interfaces/AcquisitionListener;)V\n";

    protected USB2kp() throws IOException {
    }

    protected USB2kp(int i) throws IOException {
    }

    public void setEndpoints() {
        this.dataOutEndPoint = new USBEndpointDescriptor(7, 5, 1, 2, 512, 0);
        this.highSpeedInEndPoint1 = new USBEndpointDescriptor(7, 5, 130, 2, 512, 0);
        this.highSpeedInEndPoint2 = new USBEndpointDescriptor(7, 5, 134, 2, 512, 0);
        this.lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 129, 2, 512, 0);
    }

    public USBEndpointDescriptor getEndpoint(int endPoint) throws IllegalArgumentException {
        switch (endPoint) {
            case 0: {
                return this.dataOutEndPoint;
            }
            case 1: {
                return this.highSpeedInEndPoint1;
            }
            case 2: {
                return this.highSpeedInEndPoint2;
            }
            case 3: {
                return this.lowSpeedInEndPoint;
            }
        }
        throw new IllegalArgumentException("End Point number invalid.");
    }

    public boolean allowWriteToEEPROM(int privilegeLevel, int slot) {
        if (slot < 0) {
            return false;
        }
        if (privilegeLevel == 0) {
            return true;
        }
        if (privilegeLevel == 1) {
            if (slot == 0) {
                return false;
            }
            if (slot == 17 || slot == 18 || slot == 19) {
                return true;
            }
            return slot <= 14;
        }
        return false;
    }

    public void openSpectrometer(int index) throws IOException {
        this.integrationTimeMinimum = 1000;
        this.integrationTimeMaximum = 65535000;
        this.integrationTimeIncrement = 10;
        this.integrationTimeBase = 1;
        this.numberOfCCDPixels = 2048;
        this.numberOfDarkCCDPixels = 24;
        this.maxIntensity = 65535;
        this.pipeSize = this.numberOfCCDPixels * 2 + 1;
        this.rawData = new byte[this.pipeSize];
        this.benchSlot = 15;
        this.spectrometerConfigSlot = 16;
    }

    protected void initFeatures(USBInterface usb) throws IOException {
        this.plugInProvider = new PlugInProviderImplFPGA(usb, this);
        this.advancedVersion = new AdvancedVersionImpl(usb);
        this.advancedIntegrationClock = new AdvancedIntegrationClockImpl(usb);
        this.shutterClock = new ShutterClockImpl(usb);
        this.masterClockDivisor = new MasterClockDivisorImpl(usb);
        this.i2cBus = new I2CBusImplFPGA(usb);
        this.spiBus = new SPIBusImplFPGA(usb);
        this.gpio = new GPIOImpl(usb, this.NUMBER_GPIO_PINS);
        this.singleStrobe = new SingleStrobeImpl(usb);
        try {
            String testString = "";
            testString = this.firmwareVersion.indexOf(32) == this.firmwareVersion.lastIndexOf(32) ? this.firmwareVersion.substring(this.firmwareVersion.indexOf(32) + 1) : this.firmwareVersion.substring(this.firmwareVersion.indexOf(32) + 1, this.firmwareVersion.lastIndexOf(32));
            int firstNumber = new Integer(testString.substring(0, testString.indexOf(46)));
            int secondNumber = new Integer(testString.substring(testString.indexOf(46) + 1, testString.lastIndexOf(46)));
            int thirdNumber = new Integer(testString.substring(testString.lastIndexOf(46) + 1, testString.lastIndexOf("")));
            this.hardwareTrigger = firstNumber >= 1 && secondNumber >= 2 && thirdNumber >= 5 ? new HardwareTriggerImplFPGA(usb, new ExternalTriggerMode[]{new ExternalTriggerMode(0), new ExternalTriggerMode(1), new ExternalTriggerMode(2), new ExternalTriggerMode(3), new ExternalTriggerMode(128), new ExternalTriggerMode(129), new ExternalTriggerMode(130), new ExternalTriggerMode(131)}) : new HardwareTriggerImplFPGA(usb, new ExternalTriggerMode[]{new ExternalTriggerMode(0), new ExternalTriggerMode(1), new ExternalTriggerMode(2), new ExternalTriggerMode(3)});
        }
        catch (Exception e) {
            System.out.println("Error in parsing firmware version string, disabling extra trigger modes.");
            e.printStackTrace();
            this.hardwareTrigger = new HardwareTriggerImplFPGA(usb, new ExternalTriggerMode[]{new ExternalTriggerMode(0), new ExternalTriggerMode(1), new ExternalTriggerMode(2), new ExternalTriggerMode(3)});
        }
        this.continuousStrobe = new ContinuousStrobeImpl_FPGA(usb);
        this.boardTemperature = new BoardTemperatureImpl(usb);
        this.irradianceCalibrationFactor = new IrradianceCalibrationFactorImplFPGA(usb, this.numberOfCCDPixels);
        this.triggerDelay = new ExternalTriggerDelayImpl(usb);
        this.nonlinearity = new NonlinearityCorrectionImpl(usb, this);
        this.wavelength = new WavelengthCalibrationImpl(usb, this);
        this.straylight = new StrayLightCorrectionImpl(usb, this);
        this.autonulling = new AutonullingImpl(usb);
        this.autonullingConfiguration = this.readAutonullingConfigurationFromSpectrometer();
        this.version = new VersionImpl(usb, this);
        this.featureMap.put(PlugInProviderImpl.class, (PlugInProviderImpl)this.plugInProvider);
        this.featureMap.put(AdvancedVersionImpl.class, (AdvancedVersionImpl)this.advancedVersion);
        this.featureMap.put(AdvancedIntegrationClockImpl.class, (AdvancedIntegrationClockImpl)this.advancedIntegrationClock);
        this.featureMap.put(ShutterClockImpl.class, (ShutterClockImpl)this.shutterClock);
        this.featureMap.put(MasterClockDivisorImpl.class, (MasterClockDivisorImpl)this.masterClockDivisor);
        this.featureMap.put(I2CBusImpl.class, (I2CBusImpl)this.i2cBus);
        this.featureMap.put(SPIBusImpl.class, (SPIBusImpl)this.spiBus);
        this.featureMap.put(GPIOImpl.class, (GPIOImpl)this.gpio);
        this.featureMap.put(SingleStrobeImpl.class, (SingleStrobeImpl)this.singleStrobe);
        this.featureMap.put(HardwareTriggerImpl.class, this.hardwareTrigger);
        this.featureMap.put(ContinuousStrobeImpl.class, (ContinuousStrobeImpl)this.continuousStrobe);
        this.featureMap.put(BoardTemperatureImpl.class, (BoardTemperatureImpl)this.boardTemperature);
        this.featureMap.put(IrradianceCalibrationFactorImpl.class, (IrradianceCalibrationFactorImpl)this.irradianceCalibrationFactor);
        this.featureMap.put(ExternalTriggerDelayImpl.class, (ExternalTriggerDelayImpl)this.triggerDelay);
        this.featureMap.put(NonlinearityCorrectionImpl.class, (NonlinearityCorrectionImpl)this.nonlinearity);
        this.featureMap.put(WavelengthCalibrationImpl.class, (WavelengthCalibrationImpl)this.wavelength);
        this.featureMap.put(StrayLightCorrectionImpl.class, (StrayLightCorrectionImpl)this.straylight);
        this.featureMap.put(AutonullingImpl.class, (AutonullingImpl)this.autonulling);
        this.featureMap.put(AutonullingConfiguration.class, this.autonullingConfiguration);
        this.featureMap.put(VersionImpl.class, (VersionImpl)this.version);
    }

    public GUIProvider[] getGUIFeatures() {
        return new GUIProvider[]{this.wavelength, this.straylight, this.nonlinearity, this.singleStrobe, this.continuousStrobe, this.triggerDelay, this.i2cBus, this.spiBus, this.gpio, this.boardTemperature, this.irradianceCalibrationFactor, this.autonulling, this.version};
    }

    protected Spectrum formatData(byte[] data, Spectrum doubleSpectrum) throws IOException {
        byte zero = 0;
        double[] spectrum = doubleSpectrum.getSpectrum();
        double saturationValue = this.autonullingConfiguration.getSaturationValue();
        this.logger.finest("Formatting data");
        doubleSpectrum.setSaturated(false);
        if (data[this.numberOfCCDPixels * 2] != 105) {
            this.logger.severe("Lost synchroniztion");
            throw new IOException("Lost synchronization");
        }
        for (int i = 0; i < this.numberOfCCDPixels; ++i) {
            byte MSB = data[2 * i + 1];
            byte LSB = data[2 * i];
            int pixel = ByteRoutines.makeDWord((byte)zero, (byte)zero, (byte)MSB, (byte)LSB);
            if ((double)pixel >= saturationValue) {
                doubleSpectrum.setSaturated(true);
            }
            spectrum[i] = (double)pixel * 65535.0 / saturationValue;
        }
        this.autonulling.setAutonullingScanStatus((int)spectrum[0]);
        this.autonulling.setAutonullingScanValue((int)spectrum[1]);
        spectrum[0] = spectrum[2];
        spectrum[1] = spectrum[2];
        return doubleSpectrum;
    }

    public SpectrometerStatus getStatus() throws IOException {
        this.logger.finest("USB2000+ Status.");
        byte[] sb = super.getStatusArray();
        USB2000PlusStatus stat = new USB2000PlusStatus();
        stat.numPixels = ByteRoutines.makeWord((byte)sb[1], (byte)sb[0]);
        stat.integrationTime = ByteRoutines.makeDWord((byte)sb[5], (byte)sb[4], (byte)sb[3], (byte)sb[2]);
        stat.lampEnabled = sb[6] != 0;
        stat.externalTriggerMode = sb[7];
        stat.takingScan = sb[8] != 0;
        stat.numPacketsInSpectra = sb[9];
        stat.powerDownFlag = sb[10];
        stat.packetCount = sb[11];
        if (Math.abs(sb[14]) == 128) {
            stat.usbSpeed = 480;
        } else if (Math.abs(sb[14]) == 0) {
            stat.usbSpeed = 12;
        } else {
            stat.usbSpeed = 0;
            this.logger.severe("Error determining USB Communication Speed.");
            throw new IOException("Error determining USB Communication Speed.");
        }
        return stat;
    }

    public int readIntegrationTime() throws IOException {
        USB2000PlusStatus stat = (USB2000PlusStatus)this.getStatus();
        return stat.integrationTime;
    }

    public void setStrobeDelay(int delay) throws IOException {
        this.setContinuousStrobeDelay(delay);
    }

    public String toString() {
        try {
            return super.toString() + "\n" + this.getStatus();
        }
        catch (IOException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public SpectrometerPlugIn[] getPlugIns() throws IOException {
        return this.plugInProvider.getPlugIns();
    }

    public int getNumberOfPlugIns() throws IOException {
        return this.plugInProvider.getNumberOfPlugIns();
    }

    public boolean isPlugInDetected(int id) throws IOException {
        return this.plugInProvider.isPlugInDetected(id);
    }

    public byte[] initializePlugIns() throws IOException {
        return this.plugInProvider.initializePlugIns();
    }

    public void detectPlugIns() throws IOException {
        this.plugInProvider.detectPlugIns();
    }

    public int setI2CBytes(byte address, byte numBytes, byte[] i2C) throws IOException {
        return this.i2cBus.setI2CBytes(address, numBytes, i2C);
    }

    public byte[] getI2CBytes(byte address, byte numBytes) throws IOException {
        return this.i2cBus.getI2CBytes(address, numBytes);
    }

    public byte[] getSPIBytes(byte[] message, int length) throws IOException {
        return this.spiBus.getSPIBytes(message, length);
    }

    public String getPSOCVersion() throws IOException {
        return this.advancedVersion.getPSOCVersion();
    }

    public String getFPGAFirmwareVersion() throws IOException {
        return this.advancedVersion.getFPGAFirmwareVersion();
    }

    public double continuousStrobeCountsToMicros(int counts) {
        return this.continuousStrobe.continuousStrobeCountsToMicros(counts);
    }

    public void setContinuousStrobeDelay(int delayMicros) throws IOException {
        this.continuousStrobe.setContinuousStrobeDelay(delayMicros);
    }

    public Integer getContinuousStrobeDelay() {
        return this.continuousStrobe.getContinuousStrobeDelay();
    }

    public int getContinuousStrobeDelayMinimum() {
        return this.continuousStrobe.getContinuousStrobeDelayMinimum();
    }

    public int getContinuousStrobeDelayMaximum() {
        return this.continuousStrobe.getContinuousStrobeDelayMaximum();
    }

    public int getContinuousStrobeDelayIncrement(int magnitude) {
        return this.continuousStrobe.getContinuousStrobeDelayIncrement(magnitude);
    }

    public void setAdvancedIntegrationTime(long delayMicros) throws IOException {
        this.advancedIntegrationClock.setAdvancedIntegrationTime(delayMicros);
    }

    public int getIntegrationTimeBaseClock() throws IOException {
        return this.advancedIntegrationClock.getIntegrationTimeBaseClock();
    }

    public int getIntegrationClockTimer() throws IOException {
        return this.advancedIntegrationClock.getIntegrationClockTimer();
    }

    public long getAdvancedIntegrationTimeMinimum() {
        return this.advancedIntegrationClock.getAdvancedIntegrationTimeMinimum();
    }

    public long getAdvancedIntegrationTimeMaximum() {
        return this.advancedIntegrationClock.getAdvancedIntegrationTimeMaximum();
    }

    public long getAdvancedIntegrationTimeIncrement() {
        return this.advancedIntegrationClock.getAdvancedIntegrationTimeIncrement();
    }

    public void setExternalTriggerMode(int mode) throws IOException {
        this.hardwareTrigger.setExternalTriggerMode(mode);
    }

    public ExternalTriggerMode[] getExternalTriggerModes() {
        return this.hardwareTrigger.getExternalTriggerModes();
    }

    public Integer getExternalTriggerMode() {
        return this.hardwareTrigger.getExternalTriggerMode();
    }

    public void setShutterClock(int value) throws IOException {
        this.shutterClock.setShutterClock(value);
    }

    public int getShutterClock() throws IOException {
        return this.shutterClock.getShutterClock();
    }

    public void setSingleStrobeLow(int value) throws IOException {
        this.singleStrobe.setSingleStrobeLow(value);
    }

    public void setSingleStrobeHigh(int value) throws IOException {
        this.singleStrobe.setSingleStrobeHigh(value);
    }

    public double getSingleStrobeCountsToMicros(int counts) {
        return this.singleStrobe.getSingleStrobeCountsToMicros(counts);
    }

    public int getSingleStrobeLow() throws IOException {
        return this.singleStrobe.getSingleStrobeLow();
    }

    public int getSingleStrobeHigh() throws IOException {
        return this.singleStrobe.getSingleStrobeHigh();
    }

    public int getSingleStrobeMinimum() {
        return this.singleStrobe.getSingleStrobeMinimum();
    }

    public int getSingleStrobeMaximum() {
        return this.singleStrobe.getSingleStrobeMaximum();
    }

    public int getSingleStrobeIncrement() {
        return this.singleStrobe.getSingleStrobeIncrement();
    }

    public void setDirectionAllBits(BitSet bitSet) throws IOException {
        this.gpio.setDirectionAllBits(bitSet);
    }

    public void setMuxAllBits(BitSet bitSet) throws IOException {
        this.gpio.setMuxAllBits(bitSet);
    }

    public void setValueAllBits(BitSet bitSet) throws IOException {
        this.gpio.setValueAllBits(bitSet);
    }

    public void setDirectionBitmask(short bitmask) throws IOException {
        this.gpio.setDirectionBitmask(bitmask);
    }

    public void setMuxBitmask(short bitmask) throws IOException {
        this.gpio.setMuxBitmask(bitmask);
    }

    public void setValueBitmask(short bitmask) throws IOException {
        this.gpio.setValueBitmask(bitmask);
    }

    public void setDirectionBit(int bit, boolean value) throws IOException {
        this.gpio.setDirectionBit(bit, value);
    }

    public void setMuxBit(int bit, boolean value) throws IOException {
        this.gpio.setMuxBit(bit, value);
    }

    public void setValueBit(int bit, boolean value) throws IOException {
        this.gpio.setValueBit(bit, value);
    }

    public int getTotalGPIOBits() {
        return this.gpio.getTotalGPIOBits();
    }

    public BitSet getDirectionBits() throws IOException {
        return this.gpio.getDirectionBits();
    }

    public BitSet getMuxBits() throws IOException {
        return this.gpio.getMuxBits();
    }

    public int getValueBit(int bitNumber) throws IOException {
        return this.gpio.getValueBit(bitNumber);
    }

    public BitSet getValueBits() throws IOException {
        return this.gpio.getValueBits();
    }

    public int getNumberOfPins() {
        return this.gpio.getNumberOfPins();
    }

    public double getBoardTemperatureCelsius() throws IOException {
        return this.boardTemperature.getBoardTemperatureCelsius();
    }

    public double[] getIrradianceCalibrationFactors() throws IOException {
        return this.irradianceCalibrationFactor.getIrradianceCalibrationFactors();
    }

    public void setIrradianceCalibrationFactors(double[] data) throws IOException {
        this.irradianceCalibrationFactor.setIrradianceCalibrationFactors(data);
    }

    public double getCollectionArea() throws IOException {
        return this.irradianceCalibrationFactor.getCollectionArea();
    }

    public boolean hasCollectionArea() {
        return this.irradianceCalibrationFactor.hasCollectionArea();
    }

    public void setCollectionArea(double area) throws IOException {
        this.irradianceCalibrationFactor.setCollectionArea(area);
    }

    public void setMasterClockDivisor(int value) throws IOException {
        this.masterClockDivisor.setMasterClockDivisor(value);
    }

    public int getMasterClockDivisor() throws IOException {
        return this.masterClockDivisor.getMasterClockDivisor();
    }

    public void setExternalTriggerDelay(int counts) throws IOException {
        this.triggerDelay.setExternalTriggerDelay(counts);
    }

    public double triggerDelayCountsToMicroseconds(int counts) {
        return this.triggerDelay.triggerDelayCountsToMicroseconds(counts);
    }

    public Integer getExternalTriggerDelay() {
        return this.triggerDelay.getExternalTriggerDelay();
    }

    public int getExternalTriggerDelayMinimum() {
        return this.triggerDelay.getExternalTriggerDelayMinimum();
    }

    public int getExternalTriggerDelayMaximum() {
        return this.triggerDelay.getExternalTriggerDelayMaximum();
    }

    public int getExternalTriggerDelayIncrement() {
        return this.triggerDelay.getExternalTriggerDelayIncrement();
    }

    public Coefficients[] readNonlinearityCoefficientsFromSpectrometer() {
        return this.nonlinearity.readNonlinearityCoefficientsFromSpectrometer();
    }

    public void writeNonlinearityCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.nonlinearity.writeNonlinearityCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getNonlinearityCoefficients() {
        return this.nonlinearity.getNonlinearityCoefficients();
    }

    public void setNonlinearityCoefficients(Coefficients[] coefficients) {
        this.nonlinearity.setNonlinearityCoefficients(coefficients);
    }

    public double[] getNonlinearityCoefficientsSingleChannel(int index) {
        return this.nonlinearity.getNonlinearityCoefficientsSingleChannel(index);
    }

    public void setNonlinearityCoefficientsSingleChannel(double[] nl, int index) {
        this.nonlinearity.setNonlinearityCoefficientsSingleChannel(nl, index);
    }

    public Coefficients[] readWavelengthCalibrationCoefficientsFromSpectrometer() {
        return this.wavelength.readWavelengthCalibrationCoefficientsFromSpectrometer();
    }

    public void writeWavelengthCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.wavelength.writeWavelengthCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getWavelengthCalibrationCoefficients() {
        return this.wavelength.getWavelengthCalibrationCoefficients();
    }

    public void setWavelengthCalibrationCoefficients(Coefficients[] coefficients) {
        this.wavelength.setWavelengthCalibrationCoefficients(coefficients);
    }

    public double[] getWavelengths(int index) {
        return this.wavelength.getWavelengths(index);
    }

    public void setWavelengths(double[] wl, int index) {
        this.wavelength.setWavelengths(wl, index);
    }

    public Coefficients[] readStrayLightCorrectionCoefficientFromSpectrometer() {
        return this.straylight.readStrayLightCorrectionCoefficientFromSpectrometer();
    }

    public void writeStrayLightCoefficientToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.straylight.writeStrayLightCoefficientToSpectrometer(coefficients);
    }

    public void setStrayLightCorrectionCoefficient(Coefficients[] coefficients) {
        this.straylight.setStrayLightCorrectionCoefficient(coefficients);
    }

    public Coefficients[] getStrayLightCorrectionCoefficient() {
        return this.straylight.getStrayLightCorrectionCoefficient();
    }

    public void setStrayLight(double strayLight, int index) {
        this.straylight.setStrayLight(strayLight, index);
    }

    public double getStrayLight(int index) {
        return this.straylight.getStrayLight(index);
    }

    public int getAutonullingScanStatus() {
        return this.autonulling.getAutonullingScanStatus();
    }

    public int getAutonullingScanValue() {
        return this.autonulling.getAutonullingScanValue();
    }

    public void setAutonullingScanStatus(int value) {
        this.autonulling.setAutonullingScanStatus(value);
    }

    public void setAutonullingScanValue(int value) {
        this.autonulling.setAutonullingScanValue(value);
    }

    public AutonullingConfiguration getAutonullingConfiguration() {
        return this.autonulling.getAutonullingConfiguration();
    }

    public void setAutonullingConfiguration(AutonullingConfiguration cfg) {
        this.autonulling.setAutonullingConfiguration(cfg);
    }

    public void writeAutonullingConfigurationToSpectrometer() throws IOException {
        this.autonulling.writeAutonullingConfigurationToSpectrometer();
    }

    public AutonullingConfiguration readAutonullingConfigurationFromSpectrometer() throws IOException {
        return this.autonulling.readAutonullingConfigurationFromSpectrometer();
    }

    public boolean isAdvancedVersion() {
        return this instanceof AdvancedVersion;
    }

    public void uploadFirmware(File file, long fileSize) throws IOException {
        this.version.uploadFirmware(file, fileSize);
    }

    public void uploadFPGA(File file, long fileSize) throws IOException {
        this.version.uploadFPGA(file, fileSize);
    }

    public void addAcquisitionListener(AcquisitionListener listener) {
        this.version.addAcquisitionListener(listener);
    }

    public void removeAcquisitionListener(AcquisitionListener listener) {
        this.version.removeAcquisitionListener(listener);
    }
}

