/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.tests;

import com.oceanoptics.omnidriver.features.pluginprovider.PlugInProvider;
import com.oceanoptics.omnidriver.interfaces.SpectrumListener;
import com.oceanoptics.omnidriver.plugin.SpectrometerPlugIn;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerChannel;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerFactory;
import com.oceanoptics.spectralprocessing.SpectralProcessor;
import java.io.IOException;

public class ThreadingTest {
    private boolean stop;
    private Spectrometer[] spectrometers;
    private SpectrometerChannel[] channels;
    private SpectralProcessor[] processors;
    private int totalNumberOfChannels;
    private int totalAcquired;
    public static long startTime;
    private static String __extern__;

    public ThreadingTest() {
        try {
            Spectrometer spectrometer;
            int i;
            this.spectrometers = SpectrometerFactory.getAllSpectrometers();
            if (this.spectrometers == null || this.spectrometers.length == 0) {
                System.out.println("No spectrometers found.");
                return;
            }
            for (i = 0; i < this.spectrometers.length; ++i) {
                spectrometer = this.spectrometers[i];
                System.out.println(spectrometer);
                SpectrometerPlugIn[] plugIns = null;
                if (spectrometer instanceof PlugInProvider) {
                    PlugInProvider pip = (PlugInProvider)((Object)spectrometer);
                    plugIns = pip.getPlugIns();
                }
                if (plugIns != null) {
                    System.out.print("\n" + plugIns.length + " plugin(s):");
                    for (int j = 0; j < plugIns.length; ++j) {
                        System.out.println(" " + plugIns[j]);
                    }
                    System.out.println("");
                }
                this.totalNumberOfChannels += spectrometer.getChannels().length;
                System.out.println("________________________________________________________________________________\n");
                System.out.flush();
            }
            this.channels = new SpectrometerChannel[this.totalNumberOfChannels];
            this.processors = new SpectralProcessor[this.totalNumberOfChannels];
            this.totalNumberOfChannels = 0;
            for (i = 0; i < this.spectrometers.length; ++i) {
                spectrometer = this.spectrometers[i];
                SpectrometerChannel[] spectrometerChannels = spectrometer.getChannels();
                for (int j = 0; j < spectrometerChannels.length; ++j) {
                    if (spectrometerChannels[j] == null) continue;
                    this.channels[this.totalNumberOfChannels] = spectrometerChannels[j];
                    this.processors[this.totalNumberOfChannels] = new SpectralProcessor(spectrometerChannels[j], true);
                    ++this.totalNumberOfChannels;
                }
            }
            for (int i2 = 0; i2 < this.channels.length; ++i2) {
                SpectrometerChannel channel = this.channels[i2];
                SpectralProcessor processor = this.processors[i2];
                if (channel == null) continue;
                processor.setScansToAverage(1);
                processor.setCorrectForElectricalDark(false);
                processor.setCorrectForDetectorNonlinearity(false);
                processor.setCorrectForStrayLight(false);
                processor.setSmoothingWindowSize(1);
                SpecListener listener = new SpecListener(i2);
                processor.addSpectrumListener(listener);
                channel.setPollingInterval(100L);
                startTime = System.currentTimeMillis();
                channel.setPolling(true);
            }
        }
        catch (IOException e) {
            System.out.println("An Exception occurred");
            e.printStackTrace();
        }
    }

    public void stop() throws IOException {
        this.stop = true;
        try {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.processors != null) {
            for (int i = 0; i < this.processors.length; ++i) {
                if (this.processors[i] == null) continue;
                this.processors[i].stop();
            }
        }
        if (this.spectrometers != null) {
            for (int i = 0; i < this.spectrometers.length; ++i) {
                this.spectrometers[i].close();
            }
        }
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws IOException {
        ThreadingTest t = new ThreadingTest();
        try {
            Thread.currentThread();
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        long endTime = System.currentTimeMillis();
        t.stop();
        System.out.println("\n\nTime to acquire " + t.totalAcquired + " spectra: " + (endTime - startTime) + "ms");
        System.out.println("\nend.");
    }

    static {
        __extern__ = "__extern__\n<init>,()V\nstop,()V\nmain,([Ljava/lang/String;)V\n";
    }

    private class SpecListener
    implements SpectrumListener {
        private int channelIndex;

        SpecListener(int channel) {
            this.channelIndex = channel;
        }

        public void newSpectrum(Spectrum spectrum) {
            double[] s = spectrum.getSpectrum();
            System.out.print(this.channelIndex);
            System.out.flush();
            ThreadingTest.this.totalAcquired++;
        }
    }
}

