/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.highrestiming;

import com.oceanoptics.highrestiming.HighResTiming;
import java.text.DateFormat;
import java.util.Date;

public class HighResTimeStamp {
    private static HighResTiming highResTiming = new HighResTiming();
    private long milliTime;
    private double nanoTime;
    private static String __extern__ = "__extern__\n<init>,()V\n<init>,(Lcom/oceanoptics/highrestiming/HighResTimeStamp;)V\n<init>,(JD)V\n<init>,(Lcom/oceanoptics/highrestiming/HighResTimeStamp;D)V\ngetTimeMillis,()J\ngetNanoTimeDeltaSince,(Lcom/oceanoptics/highrestiming/HighResTimeStamp;)D\ngetMicroTimeDeltaSince,(Lcom/oceanoptics/highrestiming/HighResTimeStamp;)D\ngetMilliTimeDeltaSince,(Lcom/oceanoptics/highrestiming/HighResTimeStamp;)D\ngetSecondsTimeDeltaSince,(Lcom/oceanoptics/highrestiming/HighResTimeStamp;)D\ngetNanoTimeDelta,(Lcom/oceanoptics/highrestiming/HighResTimeStamp;Lcom/oceanoptics/highrestiming/HighResTimeStamp;)D\ngetMicroTimeDelta,(Lcom/oceanoptics/highrestiming/HighResTimeStamp;Lcom/oceanoptics/highrestiming/HighResTimeStamp;)D\ngetMilliTimeDelta,(Lcom/oceanoptics/highrestiming/HighResTimeStamp;Lcom/oceanoptics/highrestiming/HighResTimeStamp;)D\ngetSecondsTimeDelta,(Lcom/oceanoptics/highrestiming/HighResTimeStamp;Lcom/oceanoptics/highrestiming/HighResTimeStamp;)D\ntoString,()Ljava/lang/String;\n";

    public HighResTimeStamp() {
        this.milliTime = System.currentTimeMillis();
        this.nanoTime = highResTiming.getTimeInNanoSeconds();
    }

    public HighResTimeStamp(HighResTimeStamp that) {
        this.milliTime = that.milliTime;
        this.nanoTime = that.nanoTime;
    }

    public HighResTimeStamp(long millis, double nanos) {
        this.milliTime = millis;
        this.nanoTime = nanos;
    }

    public HighResTimeStamp(HighResTimeStamp that, double nanosIntoFuture) {
        this.milliTime = that.milliTime + (long)(nanosIntoFuture / 1000000.0);
        this.nanoTime = that.nanoTime + nanosIntoFuture;
    }

    public long getTimeMillis() {
        return this.milliTime;
    }

    public double getNanoTimeDeltaSince(HighResTimeStamp then) {
        return this.nanoTime - then.nanoTime;
    }

    public double getMicroTimeDeltaSince(HighResTimeStamp then) {
        return this.getNanoTimeDeltaSince(then) / 1000.0;
    }

    public double getMilliTimeDeltaSince(HighResTimeStamp then) {
        return this.getNanoTimeDeltaSince(then) / 1000000.0;
    }

    public double getSecondsTimeDeltaSince(HighResTimeStamp then) {
        return this.getNanoTimeDeltaSince(then) / 1.0E9;
    }

    public static double getNanoTimeDelta(HighResTimeStamp before, HighResTimeStamp after) {
        return after.nanoTime - before.nanoTime;
    }

    public static double getMicroTimeDelta(HighResTimeStamp before, HighResTimeStamp after) {
        return HighResTimeStamp.getNanoTimeDelta(before, after) / 1000.0;
    }

    public static double getMilliTimeDelta(HighResTimeStamp before, HighResTimeStamp after) {
        return HighResTimeStamp.getNanoTimeDelta(before, after) / 1000000.0;
    }

    public static double getSecondsTimeDelta(HighResTimeStamp before, HighResTimeStamp after) {
        return HighResTimeStamp.getNanoTimeDelta(before, after) / 1.0E9;
    }

    public String toString() {
        String retval = new String();
        Date date = new Date(this.milliTime);
        DateFormat formatter = DateFormat.getDateTimeInstance(3, 0);
        retval = retval + formatter.format(date) + " (ns: " + this.nanoTime + ")";
        return retval;
    }
}

