/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.api.wrapper;

import com.oceanoptics.omnidriver.api.wrapper.Wrapper;
import com.oceanoptics.omnidriver.features.badpixelremoval.BadPixelRemoval;
import com.oceanoptics.omnidriver.features.badpixelremoval.BadPixelRemovalImpl;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBus;
import com.oceanoptics.omnidriver.features.saturationthreshold.SaturationThreshold;
import com.oceanoptics.omnidriver.features.thermoelectric.ThermoElectric;
import com.oceanoptics.omnidriver.spectrometer.NetworkSpectrometer;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerAssembly;
import com.oceanoptics.omnidriver.spectrometer.USBSpectrometer;
import com.oceanoptics.omnidriver.spectrometer.arcoptix.ArcoptixTransport;
import com.oceanoptics.omnidriver.spectrometer.jaz.JazNetwork;
import com.oceanoptics.omnidriver.spectrometer.mayapro2000.MayaPro2000;
import com.oceanoptics.omnidriver.spectrometer.nirquest.NIRQuest;
import com.oceanoptics.omnidriver.spectrometer.remora.Remora;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;

public class WrapperExtensions {
    private Wrapper _wrapper = null;
    private static String __extern__ = "__extern__\n<init>,()V\ngetI2CBytes,(Lcom/oceanoptics/omnidriver/features/i2cbus/I2CBus;BB)[B\nsetI2CBytes,(Lcom/oceanoptics/omnidriver/features/i2cbus/I2CBus;BB[B)I\nisSpectrumValid,(I)Z\nisSpectrumValid,(II)Z\ngetBadPixels,(I)[S\nsetBadPixels,(I[S)Z\ngetNumberOfChannels,(I)I\ngetNumberOfEnabledChannels,(I)I\nisChannelEnabled,(II)Z\ngetSaturationIntensity,(I)I\nsetSaturationIntensity,(II)Z\nenableRawSpectrumMode,()Z\ndemonstrateArcoptixSpectrometer,()V\ndisableRawSpectrumMode,()V\nopenRemoteSpectrometer,(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I\n";

    void setWrapper(Wrapper parentWrapper) {
        this._wrapper = parentWrapper;
    }

    public byte[] getI2CBytes(I2CBus i2cbus, byte address, byte numBytes) {
        this._wrapper.lastException = null;
        try {
            return i2cbus.getI2CBytes(address, numBytes);
        }
        catch (Exception exception) {
            this._wrapper.lastException = exception;
            byte[] errorResult = new byte[]{-1};
            return errorResult;
        }
    }

    public int setI2CBytes(I2CBus i2cbus, byte address, byte numBytes, byte[] i2C) {
        this._wrapper.lastException = null;
        try {
            i2cbus.setI2CBytes(address, numBytes, i2C);
            return 1;
        }
        catch (Exception exception) {
            this._wrapper.lastException = exception;
            return 0;
        }
    }

    public boolean isSpectrumValid(int spectrometerIndex) {
        return this.isSpectrumValid(spectrometerIndex, 0);
    }

    public boolean isSpectrumValid(int spectrometerIndex, int channelIndex) {
        return ((SpectrometerAssembly)this._wrapper.spectrometerAssemblyCollection.get(spectrometerIndex)).isSpectrumValid(channelIndex);
    }

    public short[] getBadPixels(int spectrometerIndex) {
        this._wrapper.lastException = null;
        if (!this._wrapper.keyIsInserted || this._wrapper.privilegeLevel != 0) {
            this._wrapper.lastException = new Exception("key not inserted");
            return new short[0];
        }
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this._wrapper.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        BadPixelRemoval badPixelRemoval = (BadPixelRemoval)((Object)usbSpectrometer.getFeatureController(BadPixelRemovalImpl.class));
        if (badPixelRemoval == null) {
            this._wrapper.lastException = new Exception("bad pixels not supported by this spectrometer");
            return new short[0];
        }
        try {
            int[] badPixelArray_int = badPixelRemoval.getBadPixelsFromSpectrometer();
            if (badPixelArray_int == null) {
                return new short[0];
            }
            short[] badPixelArray_short = new short[badPixelArray_int.length];
            for (int index = 0; index < badPixelArray_short.length; ++index) {
                badPixelArray_short[index] = (short)badPixelArray_int[index];
            }
            return badPixelArray_short;
        }
        catch (IOException exception) {
            this._wrapper.lastException = exception;
            return new short[0];
        }
    }

    public boolean setBadPixels(int spectrometerIndex, short[] badPixelArray) {
        this._wrapper.lastException = null;
        if (!this._wrapper.keyIsInserted || this._wrapper.privilegeLevel != 0) {
            return false;
        }
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this._wrapper.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        BadPixelRemoval badPixelRemoval = (BadPixelRemoval)((Object)usbSpectrometer.getFeatureController(BadPixelRemovalImpl.class));
        if (badPixelRemoval == null) {
            return false;
        }
        try {
            int[] integerBadPixelArray = new int[badPixelArray.length];
            for (int jj = 0; jj < badPixelArray.length; ++jj) {
                integerBadPixelArray[jj] = badPixelArray[jj];
            }
            badPixelRemoval.setBadPixels(integerBadPixelArray);
            badPixelRemoval.setBadPixelsToSpectrometer();
        }
        catch (IOException exception) {
            this._wrapper.lastException = exception;
            return false;
        }
        return true;
    }

    public int getNumberOfChannels(int spectrometerIndex) {
        return ((SpectrometerAssembly)this._wrapper.spectrometerAssemblyCollection.get(spectrometerIndex)).getNumberOfChannels();
    }

    public int getNumberOfEnabledChannels(int spectrometerIndex) {
        return ((SpectrometerAssembly)this._wrapper.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer().getNumberOfEnabledChannels();
    }

    public boolean isChannelEnabled(int spectrometerIndex, int channelIndex) {
        return ((SpectrometerAssembly)this._wrapper.spectrometerAssemblyCollection.get(spectrometerIndex)).isChannelEnabled(channelIndex);
    }

    public int getSaturationIntensity(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this._wrapper.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        if (usbSpectrometer instanceof NIRQuest) {
            if (!this._wrapper.isFeatureSupportedThermoElectric(spectrometerIndex)) {
                return -1;
            }
            ThermoElectric thermoElectricFeature = this._wrapper.getFeatureControllerThermoElectric(spectrometerIndex);
            return thermoElectricFeature.getSaturationIntensity();
        }
        if (usbSpectrometer instanceof MayaPro2000) {
            if (!this._wrapper.isFeatureSupportedSaturationThreshold(spectrometerIndex)) {
                return -1;
            }
            SaturationThreshold saturationThresholdFeature = this._wrapper.getFeatureControllerSaturationThreshold(spectrometerIndex);
            return saturationThresholdFeature.getSaturationThreshold();
        }
        return -1;
    }

    public boolean setSaturationIntensity(int spectrometerIndex, int saturationIntensity) {
        if (!this._wrapper.keyIsInserted) {
            return false;
        }
        if (this._wrapper.privilegeLevel != 0) {
            return false;
        }
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this._wrapper.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        if (usbSpectrometer instanceof NIRQuest) {
            if (!this._wrapper.isFeatureSupportedThermoElectric(spectrometerIndex)) {
                return false;
            }
            ThermoElectric thermoElectricFeature = this._wrapper.getFeatureControllerThermoElectric(spectrometerIndex);
            return thermoElectricFeature.setSaturationIntensity(saturationIntensity, "wpT379hLw");
        }
        if (usbSpectrometer instanceof MayaPro2000) {
            if (!this._wrapper.isFeatureSupportedSaturationThreshold(spectrometerIndex)) {
                return false;
            }
        } else {
            return false;
        }
        SaturationThreshold saturationThresholdFeature = this._wrapper.getFeatureControllerSaturationThreshold(spectrometerIndex);
        saturationThresholdFeature.setSaturationThreshold(saturationIntensity, "wpT379hLw");
        return true;
    }

    public boolean enableRawSpectrumMode() {
        if (!this._wrapper.keyIsInserted) {
            return false;
        }
        if (this._wrapper.privilegeLevel != 0) {
            return false;
        }
        this._wrapper.rawSpectrumMode = true;
        return true;
    }

    public void demonstrateArcoptixSpectrometer() {
        ArcoptixTransport anir = new ArcoptixTransport();
        boolean success = anir.connectToHub("10.120.19.134", 7654);
        if (!success) {
            System.out.println("ERROR: unable to connect to the ARCOhub");
            return;
        }
        System.out.println("We successfully connected to the ARCOhub");
        anir.nop();
        int numberOfDiscoveredSpectrometers = anir.getNumberOfDiscoveredSpectrometers();
        if (numberOfDiscoveredSpectrometers == 0) {
            System.out.println("No spectrometers were discovered, exiting.");
            anir.disconnect();
        }
        System.out.println("number of discovered spectrometers = " + numberOfDiscoveredSpectrometers);
        String serialNumber = anir.getSerialNumber(0);
        success = anir.claimSpectrometer(serialNumber);
        if (!success) {
            System.out.println("claimSpectrometer() failed");
            anir.disconnect();
            return;
        }
        System.out.println("claimSpectrometer() was successful");
        anir.setGain(0);
        System.out.println("gain initially set to " + anir.getGain());
        anir.setGain(3);
        System.out.println("gain now set to " + anir.getGain());
        double[] spectrumPixelArray = anir.getSpectrum();
        if (spectrumPixelArray == null) {
            System.out.println("ERROR: returned spectrum array is null");
        } else {
            System.out.println("number of pixels = " + spectrumPixelArray.length);
            System.out.println("saturation = " + anir.getSaturationRatio());
            for (int index = 0; index < 10; ++index) {
                System.out.println("pixel[" + index + "] = " + spectrumPixelArray[index]);
            }
        }
        System.out.println("Hit <cr> to exit");
        try {
            System.in.read();
        }
        catch (IOException ex) {
            // empty catch block
        }
        System.out.println("Now exiting");
        anir.disconnect();
    }

    public void disableRawSpectrumMode() {
        this._wrapper.rawSpectrumMode = false;
    }

    public int openRemoteSpectrometer(String deviceAddress, String deviceType, String busType) {
        Socket socket;
        this._wrapper.lastException = null;
        if (busType.compareToIgnoreCase("internet") != 0) {
            return -1;
        }
        if (deviceType.compareToIgnoreCase("Jaz-(Network)") != 0 && deviceType.compareToIgnoreCase("remora") != 0) {
            return -1;
        }
        for (int index = 0; index < this._wrapper.spectrometerAssemblyCollection.size(); ++index) {
            Spectrometer spectrometer = ((SpectrometerAssembly)this._wrapper.spectrometerAssemblyCollection.get(index)).getSpectrometer();
            if (!(spectrometer instanceof NetworkSpectrometer) || deviceAddress.compareTo(((NetworkSpectrometer)spectrometer).getAddress()) != 0) continue;
            return index;
        }
        try {
            socket = new Socket(deviceAddress, 7654);
        }
        catch (UnknownHostException exception) {
            this._wrapper.lastException = exception;
            return -1;
        }
        catch (IOException exception) {
            this._wrapper.lastException = exception;
            return -1;
        }
        try {
            NetworkSpectrometer networkSpectrometer;
            socket.setSoTimeout(0);
            socket.setSoLinger(false, 1);
            if (deviceType.compareToIgnoreCase("Jaz-(Network)") == 0) {
                networkSpectrometer = new JazNetwork(socket);
            } else if (deviceType.compareToIgnoreCase("remora") == 0) {
                networkSpectrometer = new Remora(socket);
            } else {
                return -1;
            }
            this._wrapper.spectrometerAssemblyCollection.add(new SpectrometerAssembly(networkSpectrometer));
        }
        catch (Exception exception) {
            this._wrapper.lastException = exception;
            try {
                if (socket.isConnected()) {
                    socket.close();
                }
            }
            catch (Exception exceptionToBeIgnored) {
                // empty catch block
            }
            return -1;
        }
        return this._wrapper.spectrometerAssemblyCollection.size() - 1;
    }
}

