/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.api.wrapper;

import com.oceanoptics.highrestiming.HighResTimeStamp;
import com.oceanoptics.omnidriver.api.wrapper.WrapperExtensions;
import com.oceanoptics.omnidriver.constants.USBProductInfo;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerAssembly;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerFactory;
import com.oceanoptics.omnidriver.spectrometer.USBSpectrometer;
import com.oceanoptics.omnidriver.spectrometer.hr4000.HR4000;
import java.io.IOException;
import java.util.ArrayList;

public class WrapperLinux64 {
    private static final String API_VERSION = "1.65";
    private static final int BUILD_NUMBER = 1650;
    int numberOfSpectraAcquired = 0;
    boolean stopCollectingSpectra;
    private Spectrum[] spectrumBuffer = null;
    private boolean[] isSaturatedBuffer = null;
    HighResTimeStamp[] timeStampBuffer = null;
    boolean keyIsInserted = false;
    public Exception lastException = null;
    int privilegeLevel = 0;
    boolean dragonIsAccessible = false;
    boolean rawSpectrumMode = false;
    ArrayList spectrometerAssemblyCollection = new ArrayList();
    private WrapperExtensions wrapperExtensions;
    private static String __extern__ = "__extern__\n<init>,()V\ntest1,()V\ntest2,(I)V\ntest3,(Ljava/lang/String;)V\ntest4,()Ljava/lang/String;\ntest5,()I\ntest6,()V\ntest7,()V\ntest8,()V\nopenAllSpectrometers,()I\ngetSerialNumber,(I)Ljava/lang/String;\nsetIntegrationTime,(II)V\nsetIntegrationTime,(III)V\ngetSpectrum,(I)[D\ngetSpectrum,(II)[D\n";

    public void test1() {
        System.out.println("test1 was invoked");
    }

    public void test2(int var) {
        int jj = var;
        System.out.println("var = " + var);
    }

    public void test3(String mystr) {
        System.out.println("mystr = " + mystr);
    }

    public String test4() {
        String mystr = "abc";
        System.out.println("test 4 was invoked.  returning string \"abc\"");
        return mystr;
    }

    public int test5() {
        return 137;
    }

    public void test6() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            System.out.println("test6: Security Manager gotten successfully");
        }
    }

    public void test7() {
        Class<?> clazz = null;
        USBSpectrometer s = null;
        USBProductInfo[] products = USBProductInfo.products.values().toArray(new USBProductInfo[0]);
        try {
            clazz = Class.forName(products[0].className);
            s = (USBSpectrometer)clazz.newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void test8() {
        try {
            int jj = 1;
            System.out.println("test8: about to instantiate HR4000");
            HR4000 hr4000 = new HR4000();
            System.out.println("test8: HR4000 has been instantiated successfully");
            ++jj;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public int openAllSpectrometers() {
        try {
            int index;
            for (index = 0; index < this.spectrometerAssemblyCollection.size(); ++index) {
                SpectrometerAssembly spectrometerAssembly = (SpectrometerAssembly)this.spectrometerAssemblyCollection.get(index);
                Spectrometer spectrometer = spectrometerAssembly.getSpectrometer();
                if (spectrometer.isNetworkSpectrometer()) continue;
                return this.spectrometerAssemblyCollection.size();
            }
            System.out.println("WrapperLinux64.openAllSpectrometers: about to call SpectrometerFactory.getAllSpectrometersLinux64()");
            Spectrometer[] spectrometerArray = SpectrometerFactory.getAllSpectrometersLinux64();
            for (index = 0; index < spectrometerArray.length; ++index) {
                this.spectrometerAssemblyCollection.add(new SpectrometerAssembly(spectrometerArray[index]));
            }
            return this.spectrometerAssemblyCollection.size();
        }
        catch (Exception ee) {
            this.lastException = ee;
            return -1;
        }
    }

    public String getSerialNumber(int spectrometerIndex) {
        String str;
        USBSpectrometer usb = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        try {
            str = usb.getSerialNumber();
        }
        catch (Exception ee) {
            this.lastException = ee;
            str = "Not Found";
        }
        return str;
    }

    public void setIntegrationTime(int spectrometerIndex, int usec) {
        this.setIntegrationTime(spectrometerIndex, 0, usec);
    }

    public void setIntegrationTime(int spectrometerIndex, int channelIndex, int usec) {
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectralProcessor(channelIndex).setIntegrationTime(usec);
    }

    public double[] getSpectrum(int spectrometerIndex) {
        return this.getSpectrum(spectrometerIndex, 0);
    }

    public double[] getSpectrum(int spectrometerIndex, int channelIndex) {
        if (this.rawSpectrumMode) {
            return this.getSpectrumRaw(spectrometerIndex, channelIndex);
        }
        int numberOfPixels = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer().getNumberOfPixels();
        int numberOfDarkPixels = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer().getNumberOfDarkPixels();
        Spectrum ds = new Spectrum(numberOfPixels, numberOfDarkPixels);
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setSaturationState(channelIndex, false);
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setTimeoutState(channelIndex, false);
        try {
            ds = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectralProcessor(channelIndex).getSpectrum(ds);
        }
        catch (Exception ee) {
            this.lastException = ee;
            boolean timeoutOccurred = false;
            Spectrometer temporarySpectrometerReference = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
            if (temporarySpectrometerReference instanceof USBSpectrometer) {
                timeoutOccurred = ((USBSpectrometer)temporarySpectrometerReference).isTimeout();
            }
            ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setTimeoutState(channelIndex, timeoutOccurred);
            ds = new Spectrum(numberOfPixels, numberOfDarkPixels);
            double[] pixels = ds.getSpectrum();
            for (int index = 0; index < numberOfPixels; ++index) {
                pixels[index] = 0.0;
            }
            ds.setSpectrum(pixels);
            ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setSaturationState(channelIndex, false);
            ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setSpectrumValidity(channelIndex, false);
            return ds.getSpectrum();
        }
        boolean timeoutOccurred = false;
        Spectrometer temporarySpectrometerReference = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        if (temporarySpectrometerReference instanceof USBSpectrometer) {
            timeoutOccurred = ((USBSpectrometer)temporarySpectrometerReference).isTimeout();
        }
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setTimeoutState(channelIndex, timeoutOccurred);
        if (ds == null || timeoutOccurred) {
            ds = new Spectrum(numberOfPixels, numberOfDarkPixels);
            double[] pixels = ds.getSpectrum();
            for (int index = 0; index < numberOfPixels; ++index) {
                pixels[index] = 0.0;
            }
            ds.setSpectrum(pixels);
            ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setSaturationState(channelIndex, false);
            ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setSpectrumValidity(channelIndex, false);
            return ds.getSpectrum();
        }
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setSaturationState(channelIndex, ds.isSaturated());
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setSpectrumValidity(channelIndex, true);
        return ds.getSpectrum();
    }

    private double[] getSpectrumRaw(int spectrometerIndex, int channelIndex) {
        int numberOfPixels = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer().getNumberOfRawPixels();
        int numberOfDarkPixels = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer().getNumberOfDarkPixels();
        Spectrum ds = new Spectrum(numberOfPixels, numberOfDarkPixels);
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setSaturationState(channelIndex, false);
        try {
            ds = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectralProcessor(channelIndex).getSpectrumRaw(ds);
        }
        catch (Exception ee) {
            this.lastException = ee;
            ds = new Spectrum(numberOfPixels, numberOfDarkPixels);
            double[] pixels = ds.getSpectrum();
            for (int index = 0; index < numberOfPixels; ++index) {
                pixels[index] = 0.0;
            }
            ds.setSpectrum(pixels);
            ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setSaturationState(channelIndex, false);
            ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setSpectrumValidity(channelIndex, false);
            return ds.getSpectrum();
        }
        if (ds == null) {
            ds = new Spectrum(numberOfPixels, numberOfDarkPixels);
            double[] pixels = ds.getSpectrum();
            for (int index = 0; index < numberOfPixels; ++index) {
                pixels[index] = 0.0;
            }
            ds.setSpectrum(pixels);
            ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setSaturationState(channelIndex, false);
            ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setSpectrumValidity(channelIndex, false);
            return ds.getSpectrum();
        }
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setSaturationState(channelIndex, ds.isSaturated());
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setSpectrumValidity(channelIndex, true);
        return ds.getSpectrum();
    }
}

