/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.badpixelremoval;

import com.oceanoptics.omnidriver.features.USBFeature;
import com.oceanoptics.omnidriver.features.badpixelremoval.BadPixelRemovalGUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;

public abstract class BadPixelRemovalImpl
extends USBFeature
implements BadPixelRemovalGUIProvider {
    protected int[] badPixels = null;
    protected int numberOfBadPixels;
    protected int numberOfPixels;
    protected int[] allPixels;
    protected static final int NUM_BAD_PIXELS_SLOT = 18;
    protected static final int BAD_PIXELS_SLOT = 19;
    public USBEndpointDescriptor dataOutEndPoint = null;
    public USBEndpointDescriptor lowSpeedInEndPoint = null;
    protected String featurePath = "badpixelremoval.BadPixelPanel";
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;I)V\nsetBadPixelsToSpectrometer,()V\ngetBadPixelsFromSpectrometer,()[I\ngetBadPixels,()[I\nsetBadPixels,([I)V\nremoveBadPixels,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)Lcom/oceanoptics/omnidriver/spectra/Spectrum;\ngetNumberOfBadPixels,()I\nsetNumberOfBadPixels,(I)V\ngetAllPixels,()[I\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public BadPixelRemovalImpl(USBInterface usbInt, int numPixels) {
        super(usbInt);
        this.numberOfPixels = numPixels;
        this.allPixels = new int[this.numberOfPixels];
        for (int i = 0; i < this.numberOfPixels; ++i) {
            this.allPixels[i] = i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBadPixelsToSpectrometer() throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            byte[] fullArray = new byte[30];
            fullArray[0] = ByteRoutines.getLowByte((short)((short)this.numberOfBadPixels));
            for (int i = 0; i < this.numberOfBadPixels; ++i) {
                fullArray[1 + i * 2] = ByteRoutines.getLowByte((short)((short)this.badPixels[i]));
                fullArray[1 + i * 2 + 1] = ByteRoutines.getHighByte((short)((short)this.badPixels[i]));
            }
            this.out[0] = 6;
            this.out[1] = 18;
            System.arraycopy(fullArray, 0, this.out, 2, 15);
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 17);
            this.out[1] = 19;
            System.arraycopy(fullArray, 15, this.out, 2, 15);
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 17);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getBadPixelsFromSpectrometer() throws IOException {
        byte[] fullArray = new byte[30];
        byte[] tempArray = new byte[15];
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                int i;
                byte[] byteArray = new byte[15];
                this.out[0] = 5;
                this.out[1] = 18;
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 2);
                this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 17);
                for (i = 0; i < 15; ++i) {
                    fullArray[i] = this.in[i + 2];
                }
                this.out[1] = 19;
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 2);
                this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 17);
                for (i = 0; i < 15; ++i) {
                    fullArray[i + 15] = this.in[i + 2];
                }
                this.numberOfBadPixels = ByteRoutines.makeWord((byte)0, (byte)fullArray[0]);
                if (this.numberOfBadPixels > 14 || this.numberOfBadPixels == -1) {
                    this.badPixels = null;
                    this.numberOfBadPixels = 0;
                    System.err.println("Invalid number of pixels.");
                    this.logger.finest("Invalid number of pixels.");
                } else if (this.numberOfBadPixels == 0) {
                    this.badPixels = null;
                    this.numberOfBadPixels = 0;
                } else {
                    this.badPixels = new int[this.numberOfBadPixels];
                    for (i = 0; i < this.numberOfBadPixels; ++i) {
                        this.badPixels[i] = ByteRoutines.makeWord((byte)fullArray[i * 2 + 2], (byte)fullArray[i * 2 + 1]);
                    }
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
            return this.badPixels;
        }
    }

    public int[] getBadPixels() throws IOException {
        return this.badPixels;
    }

    public void setBadPixels(int[] pixels) throws IOException {
        this.badPixels = pixels;
        this.numberOfBadPixels = pixels.length;
    }

    public Spectrum removeBadPixels(Spectrum spectrum) throws IOException {
        double[] spec = spectrum.getSpectrum();
        for (int i = 0; i < this.numberOfBadPixels; ++i) {
            spec[this.badPixels[i]] = this.badPixels[i] == spec.length - 1 ? spec[this.badPixels[i] - 1] : (this.badPixels[i] == 0 ? spec[this.badPixels[i] + 1] : (spec[this.badPixels[i] - 1] + spec[this.badPixels[i] + 1]) / 2.0);
        }
        spectrum.setSpectrum(spec);
        return spectrum;
    }

    public int getNumberOfBadPixels() {
        return this.numberOfBadPixels;
    }

    public void setNumberOfBadPixels(int num) {
        this.numberOfBadPixels = num;
    }

    public int[] getAllPixels() {
        return this.allPixels;
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }
}

