/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.continuousstrobe;

import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobeImpl;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;

public class ContinuousStrobeImpl_ADC1000
extends ContinuousStrobeImpl {
    private double countsPerMicros = 0.001;
    private Integer currentDelay = null;
    private int DELAY_MIN = 0;
    private int DELAY_MAX = 255000;
    private int DELAY_STEP = 1000;
    protected String featurePath = "continuousstrobe.ContinuousStrobePanel";
    private static final short DATA_OUT = 1;
    private static final short LOW_SPEED_DATA_IN = 129;
    private static final short MAX_PACKET_SIZE = 512;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;)V\ncontinuousStrobeCountsToMicros,(I)D\nsetContinuousStrobeDelay,(I)V\ngetContinuousStrobeDelay,()Ljava/lang/Integer;\ngetContinuousStrobeDelayMinimum,()I\ngetContinuousStrobeDelayMaximum,()I\ngetContinuousStrobeDelayIncrement,(I)I\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public ContinuousStrobeImpl_ADC1000(USBInterface usbInt) {
        super(usbInt);
        this.dataOutEndPoint = new USBEndpointDescriptor(7, 5, 1, 2, 512, 0);
        this.lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 129, 2, 512, 0);
    }

    public double continuousStrobeCountsToMicros(int counts) {
        return (double)counts / this.countsPerMicros;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContinuousStrobeDelay(int delayMicros) throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            int delay = delayMicros / 1000;
            if (delay > 255 || delay < 0) {
                throw new IllegalArgumentException("Delay is out of allowed range (0 - 255000)");
            }
            this.out[0] = 12;
            this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)delay));
            this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)delay));
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 3);
            this.logger.fine("The continuos strobe delay on the ADC1000-USB has been set to: " + delay);
            this.currentDelay = new Integer(delayMicros);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public Integer getContinuousStrobeDelay() {
        return this.currentDelay;
    }

    public int getContinuousStrobeDelayMinimum() {
        return this.DELAY_MIN;
    }

    public int getContinuousStrobeDelayMaximum() {
        return this.DELAY_MAX;
    }

    public int getContinuousStrobeDelayIncrement(int magnitude) {
        return this.DELAY_STEP;
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }
}

