/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.continuousstrobe;

import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobeGUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;
import java.net.Socket;

public abstract class ContinuousStrobeImpl_Jaz
implements ContinuousStrobeGUIProvider {
    private static double countsToMicros = 12.0;
    private static final int CONTINUOUS_STROBE_MIN = 0;
    private static final int CONTINUOUS_STROBE_MAX = 0x15555555;
    private static final int CONTINUOUS_STROBE_STEP = 1;
    private Integer strobeDelay = null;
    protected byte[] in;
    protected byte[] out;
    protected String featurePath = "continuousstrobe.ContinuousStrobePanel";
    protected String panelPath = "com.oceanoptics.omnidriver.guisupport.features";
    private static String __extern__ = "__extern__\n<init>,()V\nsetContinuousStrobeDelay,(I)V\ngetContinuousStrobeDelay,()Ljava/lang/Integer;\ngetContinuousStrobeDelayMinimum,()I\ngetContinuousStrobeDelayMaximum,()I\ngetContinuousStrobeDelayIncrement,(I)I\ncontinuousStrobeCountsToMicros,(I)D\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public void setContinuousStrobeDelay(int delayMicros) throws IOException {
        this.strobeDelay = new Integer(delayMicros);
    }

    public Integer getContinuousStrobeDelay() {
        return this.strobeDelay;
    }

    public int getContinuousStrobeDelayMinimum() {
        return 0;
    }

    public int getContinuousStrobeDelayMaximum() {
        return 0x15555555;
    }

    public int getContinuousStrobeDelayIncrement(int magnitude) {
        return 1;
    }

    public double continuousStrobeCountsToMicros(int counts) {
        return (double)counts / countsToMicros;
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }

    protected int setupSetDelayMessage(int delayMicros) {
        for (int i = 0; i < this.out.length; ++i) {
            this.out[i] = 0;
        }
        int counts = (int)Math.rint((double)delayMicros * countsToMicros);
        this.out[0] = -57;
        this.out[1] = 102;
        this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)counts));
        this.out[3] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)counts));
        this.out[4] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)counts));
        this.out[5] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)counts));
        return 17;
    }

    public static class Network
    extends ContinuousStrobeImpl_Jaz {
        private Socket socket;

        public Network(Socket sock, byte[] inputBuffer, byte[] outputBuffer) {
            this.socket = sock;
            this.in = inputBuffer;
            this.out = outputBuffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setContinuousStrobeDelay(int delayMicros) throws IOException {
            super.setContinuousStrobeDelay(delayMicros);
            byte[] byArray = this.out;
            synchronized (this.out) {
                int length = this.setupSetDelayMessage(delayMicros);
                this.socket.getOutputStream().write(this.out, 0, length);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }

    public static class USB
    extends ContinuousStrobeImpl_Jaz {
        private USBInterface usb;
        private static final short DATA_OUT = 1;
        private static final short LOW_SPEED_DATA_IN = 129;
        private static final short MAX_PACKET_SIZE = 512;
        private USBEndpointDescriptor dataOutEndPoint = new USBEndpointDescriptor(7, 5, 1, 2, 512, 0);
        private USBEndpointDescriptor lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 129, 2, 512, 0);

        public USB(USBInterface usbInt) {
            this.usb = usbInt;
            this.in = this.usb.getInputBuffer();
            this.out = this.usb.getOutputBuffer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setContinuousStrobeDelay(int delayMicros) throws IOException {
            super.setContinuousStrobeDelay(delayMicros);
            byte[] byArray = this.out;
            synchronized (this.out) {
                int length = this.setupSetDelayMessage(delayMicros);
                this.usb.bulkOut(this.dataOutEndPoint, this.out, length);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }
}

