/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.continuousstrobe;

import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobeImpl;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectrometer.sts.STS;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;

public class ContinuousStrobeImpl_STS
extends ContinuousStrobeImpl {
    private Integer period_usec;
    public static final int PERIOD_MINIMUM_USEC = 50;
    public static final int PERIOD_MAXIMUM_USEC = 5000000;
    public static final int PERIOD_INCREMENT_USEC = 1;
    public static final int COUNTS_PER_USEC = 1;
    protected STS spectrometer;
    protected String featurePath = "continuousstrobe.ContinuousStrobePanel";
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/spectrometer/sts/STS;Lcom/oceanoptics/omnidriver/interfaces/USBInterface;)V\nsetContinuousStrobeDelay,(I)V\ngetContinuousStrobeDelay,()Ljava/lang/Integer;\ngetContinuousStrobeDelayMinimum,()I\ngetContinuousStrobeDelayMaximum,()I\ngetContinuousStrobeDelayIncrement,(I)I\ncontinuousStrobeCountsToMicros,(I)D\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public ContinuousStrobeImpl_STS(STS sts, USBInterface usbInt) {
        super(usbInt);
        this.spectrometer = sts;
    }

    public void setContinuousStrobeDelay(int usec) throws IOException {
        this.period_usec = new Integer(usec);
        byte[] data = new byte[]{ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)usec)), ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)usec)), ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)usec)), ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)usec))};
        boolean success = this.spectrometer.sendCommandToDevice(0x310010, data);
        if (!success) {
            throw new IOException("Failed to set continuous strobe delay.");
        }
    }

    public Integer getContinuousStrobeDelay() {
        return this.period_usec;
    }

    public int getContinuousStrobeDelayMinimum() {
        return 50;
    }

    public int getContinuousStrobeDelayMaximum() {
        return 5000000;
    }

    public int getContinuousStrobeDelayIncrement(int magnitude) {
        return 1;
    }

    public double continuousStrobeCountsToMicros(int counts) {
        return counts / 1;
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }
}

