/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.externaltriggerdelay;

import com.oceanoptics.omnidriver.features.externaltriggerdelay.ExternalTriggerDelayGUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;
import java.net.Socket;

public abstract class ExternalTriggerDelayImpl_Jaz
implements ExternalTriggerDelayGUIProvider {
    private Integer triggerDelay = null;
    private final int MIN_TRIGGER_DELAY = 0;
    private final int MAX_TRIGGER_DELAY = 65535;
    private final int TRIGGER_DELAY_INCREMENT = 1;
    private double countsPerMicros = 2.0;
    protected String featurePath = "externaltriggerdelay.ExternalTriggerDelayPanel";
    protected String panelPath = "com.oceanoptics.omnidriver.guisupport.features";
    private static String __extern__ = "__extern__\ntriggerDelayCountsToMicroseconds,(I)D\nsetExternalTriggerDelay,(I)V\ngetFeatureGUIClassnames,()[Ljava/lang/String;\ngetExternalTriggerDelayMinimum,()I\ngetExternalTriggerDelayMaximum,()I\ngetExternalTriggerDelayIncrement,()I\ngetExternalTriggerDelay,()Ljava/lang/Integer;\n";

    private ExternalTriggerDelayImpl_Jaz() {
    }

    public double triggerDelayCountsToMicroseconds(int counts) {
        return (double)counts / this.countsPerMicros;
    }

    public void setExternalTriggerDelay(int counts) throws IOException {
        if (counts > 65535 || counts < 0) {
            throw new IllegalArgumentException("Hardware trigger delay must be between 0-65535");
        }
        this.triggerDelay = new Integer(counts);
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }

    public int getExternalTriggerDelayMinimum() {
        return this.MIN_TRIGGER_DELAY;
    }

    public int getExternalTriggerDelayMaximum() {
        return this.MAX_TRIGGER_DELAY;
    }

    public int getExternalTriggerDelayIncrement() {
        return this.TRIGGER_DELAY_INCREMENT;
    }

    public Integer getExternalTriggerDelay() {
        return this.triggerDelay;
    }

    protected byte[] getControlString(int counts) {
        byte[] retval = new byte[]{106, 52, ByteRoutines.getLowByte((short)((short)counts)), ByteRoutines.getHighByte((short)((short)counts))};
        return retval;
    }

    public static class Network
    extends ExternalTriggerDelayImpl_Jaz {
        private Socket socket = null;
        private byte[] out;

        public Network(Socket sock, byte[] outBuffer) {
            this.socket = sock;
            this.out = outBuffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setExternalTriggerDelay(int counts) throws IOException {
            super.setExternalTriggerDelay(counts);
            byte[] cmd = this.getControlString(counts);
            byte[] byArray = this.out;
            synchronized (this.out) {
                this.socket.getOutputStream().write(cmd, 0, 4);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
    }

    public static class USB
    extends ExternalTriggerDelayImpl_Jaz {
        private USBInterface usb = null;
        private static final short DATA_OUT = 1;
        private static final short LOW_SPEED_DATA_IN = 129;
        private static final short MAX_PACKET_SIZE = 512;
        private USBEndpointDescriptor dataOutEndPoint = new USBEndpointDescriptor(7, 5, 1, 2, 512, 0);

        public USB(USBInterface usbInt) {
            this.usb = usbInt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setExternalTriggerDelay(int counts) throws IOException {
            byte[] out;
            super.setExternalTriggerDelay(counts);
            byte[] cmd = this.getControlString(counts);
            byte[] byArray = out = this.usb.getOutputBuffer();
            synchronized (out) {
                this.usb.bulkOut(this.dataOutEndPoint, cmd, 4);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        }
    }
}

