/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.i2cbus;

import com.oceanoptics.omnidriver.features.USBFeature;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBusGUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import java.io.IOException;

public abstract class I2CBusImpl
extends USBFeature
implements I2CBusGUIProvider {
    private static final int SUCCESS = 8;
    protected String featurePath = "i2cbus.I2CPanel";
    public USBEndpointDescriptor dataOutEndPoint = null;
    public USBEndpointDescriptor lowSpeedInEndPoint = null;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;)V\ngetI2CBytes,(BB)[B\nsetI2CBytes,(BB[B)I\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public I2CBusImpl(USBInterface usbInt) {
        super(usbInt);
    }

    public byte[] getI2CBytes(byte address, byte numBytes) throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                byte[] i2C = new byte[numBytes];
                String result = "";
                this.out[0] = 96;
                this.out[1] = address;
                this.out[2] = numBytes;
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 3);
                this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, numBytes + 3);
                result = this.getResult(this.in[0]);
                if (this.in[0] == 8) {
                    for (int i = 0; i < numBytes; ++i) {
                        i2C[i] = this.in[i + 3];
                    }
                    this.logger.fine("Performed a read on the I2C pins.");
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return i2C;
                }
                this.logger.warning(result);
                throw new IOException(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setI2CBytes(byte address, byte numBytes, byte[] i2C) throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                String result = "";
                this.out[0] = 97;
                this.out[1] = address;
                this.out[2] = numBytes;
                for (int i = 0; i < numBytes; ++i) {
                    this.out[i + 3] = i2C[i];
                }
                this.usb.bulkOut(this.dataOutEndPoint, this.out, numBytes + 3);
                this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 1);
                result = this.getResult(this.in[0]);
                if (this.in[0] != 8) {
                    throw new IOException(result);
                }
                this.logger.fine("Set I2C: " + result);
                // ** MonitorExit[var5_5] (shouldn't be in output)
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return this.in[0];
            }
        }
    }

    private String getResult(int result) {
        switch (result) {
            case 0: {
                return "I2C bus idle";
            }
            case 1: {
                return "I2C bus Sending Data";
            }
            case 2: {
                return "I2C bus Receiving Data";
            }
            case 3: {
                return "I2C bus Receiving first byte of string";
            }
            case 5: {
                return "I2C bus in waiting for STOP condition";
            }
            case 6: {
                return "I2C experienced Bit Error";
            }
            case 7: {
                return "I2C experienced a Not Acknowledge (NAK) Condition";
            }
            case 8: {
                return "I2C experienced successful transfer";
            }
            case 9: {
                return "I2C bus timed out";
            }
        }
        return "Error in writing to the I2C bus";
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }
}

