/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.indy;

import com.oceanoptics.omnidriver.spectrometer.jaz.DispatchProtocolMessage;
import com.oceanoptics.utilities.ByteRoutines;

public class IndyGPIOSetValueRequest
extends DispatchProtocolMessage {
    private static String __extern__ = "__extern__\n<init>,()V\ngetModuleIndex,()I\ngetMask,()I\ngetOutputValueVector,()I\nsetModuleIndex,(I)V\nsetMask,(I)V\nsetOutputValueVector,(I)V\n";

    public IndyGPIOSetValueRequest() {
        this.setMessageType(5011L);
        this.setPayload(new byte[44]);
    }

    public int getModuleIndex() {
        return this.payload[0];
    }

    public int getMask() {
        return ByteRoutines.makeDWord((byte)this.payload[7], (byte)this.payload[6], (byte)this.payload[5], (byte)this.payload[4]);
    }

    public int getOutputValueVector() {
        return ByteRoutines.makeDWord((byte)this.payload[11], (byte)this.payload[10], (byte)this.payload[9], (byte)this.payload[8]);
    }

    public void setModuleIndex(int moduleIndex) {
        this.payload[0] = (byte)moduleIndex;
    }

    public void setMask(int mask) {
        this.payload[4] = (byte)(mask & 0xFF);
        this.payload[5] = (byte)(mask >> 8 & 0xFF);
        this.payload[6] = (byte)(mask >> 16 & 0xFF);
        this.payload[7] = (byte)(mask >> 24 & 0xFF);
    }

    public void setOutputValueVector(int outputValueVector) {
        this.payload[8] = (byte)(outputValueVector & 0xFF);
        this.payload[9] = (byte)(outputValueVector >> 8 & 0xFF);
        this.payload[10] = (byte)(outputValueVector >> 16 & 0xFF);
        this.payload[11] = (byte)(outputValueVector >> 24 & 0xFF);
    }
}

