/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.indy;

import com.oceanoptics.omnidriver.spectrometer.jaz.DispatchProtocolMessage;
import com.oceanoptics.utilities.ByteRoutines;

public class IndySetVOutVoltsRequest
extends DispatchProtocolMessage {
    private static String __extern__ = "__extern__\n<init>,()V\ngetModuleIndex,()I\ngetChannel,()I\ngetVolts,()F\nsetModuleIndex,(I)V\nsetChannel,(I)V\nsetVolts,(F)V\n";

    public IndySetVOutVoltsRequest() {
        this.setPayload(new byte[72]);
        this.setMessageType(5022L);
    }

    public int getModuleIndex() {
        return this.payload[0];
    }

    public int getChannel() {
        return this.payload[1];
    }

    public float getVolts() {
        int temp = ByteRoutines.makeDWord((byte)this.payload[7], (byte)this.payload[6], (byte)this.payload[5], (byte)this.payload[4]);
        float retval = Float.intBitsToFloat(temp);
        return retval;
    }

    public void setModuleIndex(int moduleIndex) {
        this.payload[0] = (byte)moduleIndex;
    }

    public void setChannel(int channel) {
        this.payload[1] = (byte)channel;
    }

    public void setVolts(float volts) {
        int temp = Float.floatToRawIntBits(volts);
        this.payload[4] = (byte)(temp & 0xFF);
        this.payload[5] = (byte)(temp >> 8 & 0xFF);
        this.payload[6] = (byte)(temp >> 16 & 0xFF);
        this.payload[7] = (byte)(temp >> 24 & 0xFF);
    }
}

