/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.irradiancecalibrationfactor;

import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactorGUIProvider;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactorImpl;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectrometer.sts.STS;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;

public class IrradianceCalibrationFactorImpl_STS
extends IrradianceCalibrationFactorImpl
implements IrradianceCalibrationFactorGUIProvider {
    protected STS spectrometer;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/spectrometer/sts/STS;Lcom/oceanoptics/omnidriver/interfaces/USBInterface;)V\ngetIrradianceCalibrationFactors,()[D\nsetIrradianceCalibrationFactors,([D)V\ngetCollectionArea,()D\nsetCollectionArea,(D)V\nhasCollectionArea,()Z\n";

    public IrradianceCalibrationFactorImpl_STS(STS spec, USBInterface usb) {
        super(usb, spec.getNumberOfCCDPixels());
        this.spectrometer = spec;
    }

    public double[] getIrradianceCalibrationFactors() throws IOException {
        byte[] data = this.spectrometer.queryDevice(1581057, null);
        if (null == data) {
            return null;
        }
        double[] retval = new double[data.length / 4];
        for (int i = 0; i < retval.length; ++i) {
            int temp = ByteRoutines.makeDWord((byte)data[i * 4 + 3], (byte)data[i * 4 + 2], (byte)data[i * 4 + 1], (byte)data[i * 4]);
            retval[i] = Float.intBitsToFloat(temp);
        }
        return retval;
    }

    public void setIrradianceCalibrationFactors(double[] data) throws IOException {
        if (null == data) {
            return;
        }
        byte[] packed = new byte[data.length * 4];
        for (int i = 0; i < data.length; ++i) {
            int temp = Float.floatToIntBits((float)data[i]);
            packed[i * 4] = (byte)(temp & 0xFF);
            packed[i * 4 + 1] = (byte)(temp >> 8 & 0xFF);
            packed[i * 4 + 2] = (byte)(temp >> 16 & 0xFF);
            packed[i * 4 + 3] = (byte)(temp >> 24 & 0xFF);
        }
        boolean flag = this.spectrometer.sendCommandToDevice(1581073, packed);
        if (!flag) {
            throw new IOException("Failed to write irradiance calibration.");
        }
    }

    public double getCollectionArea() throws IOException {
        byte[] data = this.spectrometer.queryDevice(1581059, null);
        if (null == data || data.length < 4) {
            throw new IOException("Collection area not available or is badly formed");
        }
        int temp = ByteRoutines.makeDWord((byte)data[3], (byte)data[2], (byte)data[1], (byte)data[0]);
        return Float.intBitsToFloat(temp);
    }

    public void setCollectionArea(double area) throws IOException {
        byte[] packed = new byte[4];
        int temp = Float.floatToIntBits((float)area);
        packed[0] = (byte)(temp & 0xFF);
        packed[1] = (byte)(temp >> 8 & 0xFF);
        packed[2] = (byte)(temp >> 16 & 0xFF);
        packed[3] = (byte)(temp >> 24 & 0xFF);
        boolean flag = this.spectrometer.sendCommandToDevice(1581075, packed);
        if (!flag) {
            throw new IOException("Failed to write collection area.");
        }
    }

    public boolean hasCollectionArea() {
        try {
            byte[] data = this.spectrometer.queryDevice(1581059, null);
            return null != data && data.length >= 4;
        }
        catch (IOException ioe) {
            return false;
        }
    }
}

