/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.multichannelprovider;

import com.oceanoptics.omnidriver.features.USBFeature;
import com.oceanoptics.omnidriver.features.multichannelprovider.MultiChannelGUIProvider;
import com.oceanoptics.omnidriver.features.multichannelprovider.MultiChannelListener;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerChannel;
import com.oceanoptics.omnidriver.spectrometer.adc1000usb.ADC1000Channel;
import com.oceanoptics.omnidriver.spectrometer.adc1000usb.ADC1000USB;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;
import java.util.ArrayList;

public class MultiChannelImpl
extends USBFeature
implements MultiChannelGUIProvider {
    protected String featurePath = "multichannelprovider.MultiChannelPanel";
    private ADC1000USB spectrometer;
    private final int CHANNELS_ENABLED = 1;
    private final int DW_INFO_SLOT = 42;
    private boolean rotatorEnabled = false;
    private boolean interpolationEnabled = false;
    private boolean[] channelsPresent;
    private int numberOfEnabledChannels = 0;
    private SpectrometerChannel[] multiChannels;
    private int numberOfChannels = 0;
    private boolean deepWell;
    protected transient ArrayList channelListenerList;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;Lcom/oceanoptics/omnidriver/spectrometer/adc1000usb/ADC1000USB;I)V\ngetNumberOfChannels,()I\nsetChannels,([Lcom/oceanoptics/omnidriver/spectrometer/SpectrometerChannel;)V\ngetChannelsPresent,()[Z\nsetChannelStatus,(IZ)V\nisChannelPresent,(I)Z\ngetNumberOfEnabledChannels,()I\nsetChannelMux,(I)V\nsetChannelPresent,(IZ)V\nsetDeepWellStatus,(Z)V\ngetChannelIndices,()[I\nisDeepWell,()Z\nisRotatorEnabled,()Z\nsetRotatorEnabled,(Z)V\nisInterpolationEnabled,()Z\nsetInterpolationEnabled,(Z)V\ngetFeatureGUIClassnames,()[Ljava/lang/String;\naddChannelListener,(Lcom/oceanoptics/omnidriver/features/multichannelprovider/MultiChannelListener;)V\nremoveChannelListener,(Lcom/oceanoptics/omnidriver/features/multichannelprovider/MultiChannelListener;)V\n";

    public MultiChannelImpl(USBInterface usbInt, ADC1000USB s, int numChans) {
        super(usbInt);
        this.spectrometer = s;
        this.numberOfChannels = numChans;
        this.channelsPresent = new boolean[this.numberOfChannels];
        this.multiChannels = new ADC1000Channel[this.numberOfChannels];
    }

    public int getNumberOfChannels() {
        return this.numberOfChannels;
    }

    public void setChannels(SpectrometerChannel[] chans) {
        if (this.multiChannels.length != this.numberOfChannels) {
            this.multiChannels = new ADC1000Channel[this.numberOfChannels];
        }
        if (chans.length != this.numberOfChannels) {
            System.out.println("Something is wrong here...");
            chans = new ADC1000Channel[this.numberOfChannels];
        }
        for (int i = 0; i < this.numberOfChannels; ++i) {
            this.multiChannels[i] = chans[i];
        }
        this.deepWell = this.spectrometer.isDeepWell();
    }

    public boolean[] getChannelsPresent() {
        return this.channelsPresent;
    }

    public void setChannelStatus(int index, boolean status) {
        this.channelsPresent[index] = status;
    }

    public boolean isChannelPresent(int index) {
        if (this.isChannelValid(index)) {
            return this.channelsPresent[index];
        }
        return false;
    }

    public int getNumberOfEnabledChannels() {
        this.setChannelsEnabled();
        return this.numberOfEnabledChannels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChannelMux(int index) throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            if (this.isChannelValid(index)) {
                int bitVector = index;
                this.out[0] = 11;
                this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)bitVector));
                this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)bitVector));
                this.usb.bulkOut(this.spectrometer.getEndpoint(0), this.out, 3);
                if (this.rotatorEnabled) {
                    this.rotatorEnabled = false;
                    this.fixNumberOfPixels();
                }
                this.logger.fine("Channel set to: " + index);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setChannelPresent(int index, boolean present) throws IOException {
        if (this.isChannelValid(index)) {
            if (this.channelsPresent[index] == present) {
                this.logger.warning("Channel " + index + " is already present.");
                return;
            }
            int channelVector = Integer.parseInt(this.spectrometer.getInfo(1));
            if (present) {
                this.addChannel(index, channelVector);
                this.fireChannelListenerAddChannel(index);
            } else {
                this.removeChannel(index, channelVector);
                this.fireChannelListenerRemoveChannel(index);
            }
        } else {
            this.logger.warning("Channel is not valid.");
        }
    }

    private void addChannel(int index, int channelVector) throws IOException {
        this.channelsPresent[index] = true;
        this.spectrometer.setInfo(1, Integer.toString(channelVector |= 1 << index));
        this.spectrometer.channels[index] = new ADC1000Channel(this.spectrometer, this.spectrometer.getNewCoefficients(index), index);
        ADC1000Channel c = (ADC1000Channel)this.spectrometer.channels[index];
        this.multiChannels[index] = c;
        c.getCoefficients();
        c.generateMetadata(this.spectrometer.getSpectrumBase(), index);
        c.setEnabled(true);
    }

    private void addMasterChannel() throws IOException {
        ++this.numberOfEnabledChannels;
        this.channelsPresent[0] = true;
        ADC1000Channel c = new ADC1000Channel(this.spectrometer, this.spectrometer.getNewCoefficients(0), 0);
        c.getCoefficients();
        c.setEnabled(true);
    }

    private void removeChannel(int index, int channelVector) throws IOException {
        this.channelsPresent[index] = false;
        channelVector &= ~(1 << index);
        this.spectrometer.setInfo(1, Integer.toString(channelVector &= 0xFF));
        this.spectrometer.channels[index] = null;
    }

    public void setDeepWellStatus(boolean present) throws IOException {
        if (present) {
            this.spectrometer.setInfo(42, Integer.toString(255));
        } else {
            this.spectrometer.setInfo(42, Integer.toString(0));
        }
        this.spectrometer.setDeepWell(present);
        SpectrometerChannel[] c = this.spectrometer.getChannels();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == null) continue;
            c[i].generateMetadata(this.spectrometer.getSpectrumBase(), i);
        }
    }

    public int[] getChannelIndices() {
        int numIndicies = this.numberOfEnabledChannels;
        if (numIndicies < 1) {
            numIndicies = 1;
        }
        int[] indices = new int[numIndicies];
        boolean[] b = this.getChannelsPresent();
        int j = 0;
        for (int i = 0; i < this.numberOfChannels; ++i) {
            if (!b[i]) continue;
            indices[j] = i;
            ++j;
        }
        return indices;
    }

    private void setChannelsEnabled() {
        this.numberOfEnabledChannels = 0;
        for (int i = 0; i < this.numberOfChannels; ++i) {
            ADC1000Channel c;
            if (this.multiChannels == null || (c = (ADC1000Channel)this.multiChannels[i]) == null || !c.isEnabled()) continue;
            ++this.numberOfEnabledChannels;
        }
        if (this.rotatorEnabled) {
            this.fixNumberOfPixels();
        }
    }

    public boolean isDeepWell() {
        return this.deepWell;
    }

    public boolean isRotatorEnabled() {
        return this.rotatorEnabled;
    }

    public void setRotatorEnabled(boolean rotatorEnabled) {
        if (this.rotatorEnabled == rotatorEnabled) {
            return;
        }
        this.rotatorEnabled = rotatorEnabled;
        this.fixNumberOfPixels();
    }

    public boolean isInterpolationEnabled() {
        return this.interpolationEnabled;
    }

    public void setInterpolationEnabled(boolean interpolationEnabled) {
        if (this.interpolationEnabled == interpolationEnabled) {
            return;
        }
        this.interpolationEnabled = interpolationEnabled;
        this.fixNumberOfPixels();
    }

    protected void fixNumberOfPixels() {
        if (this.rotatorEnabled) {
            int bitVector = 128;
            for (int i = 0; i < this.numberOfChannels; ++i) {
                ADC1000Channel c = (ADC1000Channel)this.multiChannels[i];
                if (c == null || !c.isEnabled()) continue;
                bitVector |= 1 << i;
                ADC1000Channel channel = (ADC1000Channel)this.multiChannels[i];
                channel.fixNumberOfPixels();
            }
        } else {
            for (int i = 0; i < this.numberOfChannels; ++i) {
                ADC1000Channel c = (ADC1000Channel)this.multiChannels[i];
                if (c == null || !c.isEnabled()) continue;
                ADC1000Channel channel = (ADC1000Channel)this.multiChannels[i];
                channel.fixNumberOfPixels();
            }
        }
    }

    private boolean isChannelValid(int channel) {
        return channel >= 0 && channel <= 7;
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }

    public synchronized void addChannelListener(MultiChannelListener listener) {
        if (this.channelListenerList == null) {
            this.channelListenerList = new ArrayList();
        }
        this.channelListenerList.add(listener);
    }

    public synchronized void removeChannelListener(MultiChannelListener listener) {
        if (this.channelListenerList != null) {
            this.channelListenerList.remove(listener);
        }
    }

    protected synchronized void fireChannelListenerAddChannel(int event) throws IOException {
        if (this.channelListenerList != null) {
            for (int i = 0; i < this.channelListenerList.size(); ++i) {
                ((MultiChannelListener)this.channelListenerList.get(i)).addChannel(event);
            }
        }
    }

    protected synchronized void fireChannelListenerRemoveChannel(int event) throws IOException {
        if (this.channelListenerList != null) {
            for (int i = 0; i < this.channelListenerList.size(); ++i) {
                ((MultiChannelListener)this.channelListenerList.get(i)).removeChannel(event);
            }
        }
    }
}

